/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Other licenses:
 * -----------------------------------------------------------------------------
 * Commercial licenses for this work are available. These replace the above
 * Apache-2.0 license and offer limited warranties, support, maintenance, and
 * commercial database integrations.
 *
 * For more information, please visit: http://www.jooq.org/licenses
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package org.jooq.meta;

import org.jetbrains.annotations.NotNull;

/**
 * A definition representing an XML namespace.
 *
 * @author Lukas Eder
 */
public interface XMLTypeDefinition extends Definition {

    /**
     * Get the namespace to which this type belongs.
     */
    @NotNull
    XMLNamespaceDefinition getNamespace();

    /**
     * Whether this type can be used as a root element.
     */
    boolean isRootElementType();

    /**
     * Get the number of root elements this type is available from.
     */
    int getRootElementCount();
}
