/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.meta.AbstractElementContainerDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DefaultEmbeddableColumnDefinition;
import org.jooq.meta.EmbeddableColumnDefinition;
import org.jooq.meta.EmbeddableDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.tools.JooqLogger;

public class DefaultEmbeddableDefinition
extends AbstractElementContainerDefinition<EmbeddableColumnDefinition>
implements EmbeddableDefinition {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultEmbeddableDefinition.class);
    private final TableDefinition definingTable;
    private final List<String> definingColumnNames;
    private final String referencingName;
    private final String referencingComment;
    private final TableDefinition referencingTable;
    private final List<EmbeddableColumnDefinition> embeddableColumns;
    private final boolean replacesFields;

    public DefaultEmbeddableDefinition(SchemaDefinition definingSchema, String definingName, String definingComment, TableDefinition definingTable, List<String> definingColumnNames, String referencingName, String referencingComment, TableDefinition referencingTable, List<ColumnDefinition> referencingColumns, boolean replacesFields) {
        super(definingSchema, definingName, definingComment);
        this.definingColumnNames = definingColumnNames;
        this.definingTable = definingTable;
        this.referencingName = referencingName;
        this.referencingComment = referencingComment;
        this.referencingTable = referencingTable;
        this.embeddableColumns = new ArrayList<EmbeddableColumnDefinition>();
        if (replacesFields) {
            log.info((Object)"Commercial feature", (Object)"Embeddables replacing fields is a commercial only feature. Please upgrade to the jOOQ Professional Edition");
            replacesFields = false;
        }
        this.replacesFields = replacesFields;
        for (int i = 0; i < referencingColumns.size(); ++i) {
            this.embeddableColumns.add(new DefaultEmbeddableColumnDefinition(this, definingColumnNames.get(i), referencingColumns.get(i), i + 1));
        }
    }

    @Override
    public final TableDefinition getTable() {
        return this.getDefiningTable();
    }

    @Override
    public final TableDefinition getDefiningTable() {
        return this.definingTable;
    }

    @Override
    public final String getReferencingComment() {
        return this.referencingComment;
    }

    @Override
    public final String getReferencingName() {
        return this.getReferencingInputName();
    }

    @Override
    public final String getReferencingInputName() {
        return this.referencingName;
    }

    @Override
    public final String getReferencingOutputName() {
        return this.referencingName;
    }

    @Override
    public final TableDefinition getReferencingTable() {
        return this.referencingTable;
    }

    @Override
    protected final List<EmbeddableColumnDefinition> getElements0() throws SQLException {
        return this.embeddableColumns;
    }

    @Override
    public final List<EmbeddableColumnDefinition> getColumns() {
        return this.getElements();
    }

    @Override
    public final EmbeddableColumnDefinition getColumn(String columnName) {
        return (EmbeddableColumnDefinition)this.getElement(columnName);
    }

    @Override
    public final EmbeddableColumnDefinition getColumn(String columnName, boolean ignoreCase) {
        return (EmbeddableColumnDefinition)this.getElement(columnName, ignoreCase);
    }

    @Override
    public final EmbeddableColumnDefinition getColumn(int columnIndex) {
        return (EmbeddableColumnDefinition)this.getElement(columnIndex);
    }

    @Override
    public final EmbeddableColumnDefinition getReferencingColumn(String columnName) {
        return this.getReferencingColumn(columnName, false);
    }

    @Override
    public final EmbeddableColumnDefinition getReferencingColumn(String columnName, boolean ignoreCase) {
        if (columnName == null) {
            return null;
        }
        for (EmbeddableColumnDefinition column : this.getColumns()) {
            if ((!ignoreCase || !column.getReferencingColumn().getName().equalsIgnoreCase(columnName)) && (ignoreCase || !column.getReferencingColumn().getName().equals(columnName))) continue;
            return column;
        }
        return null;
    }

    @Override
    public final boolean replacesFields() {
        return this.replacesFields;
    }

    @Override
    public String toString() {
        return super.toString() + " (referenced by " + String.valueOf(this.getReferencingTable()) + " " + String.valueOf(this.getColumns()) + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof EmbeddableDefinition)) {
            return false;
        }
        EmbeddableDefinition other = (EmbeddableDefinition)obj;
        return this.getReferencingTable().equals(other.getReferencingTable()) && this.getColumns().equals(other.getColumns());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

