/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.QOM;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultJavaTypeResolver;
import org.jooq.meta.JavaTypeResolver;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.XMLTypeDefinition;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

public class DefaultDataTypeDefinition
implements DataTypeDefinition {
    private static final Pattern P_UNSIGNED = Pattern.compile("(?i:\\s*unsigned)");
    private final Database database;
    private final SchemaDefinition schema;
    private final String type;
    private Name userType;
    private final String javaType;
    private String generator;
    private final String converter;
    private final String binding;
    private final boolean nullable;
    private boolean readonly;
    private String generatedAlwaysAs;
    private QOM.GenerationOption generationOption;
    private XMLTypeDefinition xmlTypeDefinition;
    private boolean identity;
    private final String defaultValue;
    private final int length;
    private final int precision;
    private final int scale;
    private static final JooqLogger logGeneratedAlwaysAs = JooqLogger.getLogger(DefaultDataTypeDefinition.class, (String)"generateAlwaysAs", (int)1);
    private static final JooqLogger logGenerator = JooqLogger.getLogger(DefaultDataTypeDefinition.class, (String)"logGenerator", (int)1);
    private List<String> matchNames;

    private static final String defaultValue(Boolean defaultable) {
        return defaultable != null && defaultable != false ? "NULL" : null;
    }

    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName) {
        this(database, schema, typeName, null, null, null, null, (String)null, (Name)null);
    }

    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultValue, typeName, null);
    }

    @Deprecated
    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue, String userType) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultValue, DSL.name((String)userType));
    }

    @Deprecated
    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, Boolean defaultValue, Name userType) {
        this(database, schema, typeName, length, precision, scale, nullable, DefaultDataTypeDefinition.defaultValue(defaultValue), userType);
    }

    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue, Name userType) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultValue, userType, null);
    }

    @Deprecated
    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue, String userType, String converter) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultValue, DSL.name((String)userType), converter);
    }

    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue, Name userType, String converter) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultValue, userType, converter, null);
    }

    @Deprecated
    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue, String userType, String converter, String binding) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultValue, DSL.name((String)userType), converter, binding, null);
    }

    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue, Name userType, String converter, String binding) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultValue, userType, converter, binding, null);
    }

    @Deprecated
    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue, String userType, String converter, String binding, String javaType) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultValue, DSL.name((String)userType), converter, binding, javaType);
    }

    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue, Name userType, String converter, String binding, String javaType) {
        this(database, schema, typeName, length, precision, scale, nullable, defaultValue, false, userType, converter, binding, javaType);
    }

    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, String defaultValue, boolean isIdentity, Name userType, String converter, String binding, String javaType) {
        this(database, schema, typeName, length, precision, scale, nullable, false, null, defaultValue, isIdentity, userType, converter, binding, javaType);
    }

    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, boolean readonly, String generatedAlwaysAs, String defaultValue, boolean identity, Name userType, String converter, String binding, String javaType) {
        this(database, schema, typeName, length, precision, scale, nullable, readonly, generatedAlwaysAs, defaultValue, identity, userType, null, converter, binding, javaType);
    }

    public DefaultDataTypeDefinition(Database database, SchemaDefinition schema, String typeName, Number length, Number precision, Number scale, Boolean nullable, boolean readonly, String generatedAlwaysAs, String defaultValue, boolean identity, Name userType, String generator, String converter, String binding, String javaType) {
        this.database = database;
        this.schema = schema;
        if (!database.supportsUnsignedTypes() && typeName.toLowerCase().endsWith("unsigned")) {
            typeName = P_UNSIGNED.matcher(typeName).replaceFirst("");
        }
        this.type = typeName == null ? "OTHER" : typeName;
        this.userType = userType;
        this.javaType = javaType;
        this.generator = generator;
        this.converter = converter;
        this.binding = binding;
        if (length != null && precision != null && length.intValue() != 0 && precision.intValue() != 0) {
            if (this.type.toLowerCase().matches(".*?(char|text|lob|xml|graphic|string).*?")) {
                precision = null;
                scale = null;
            } else {
                length = null;
            }
        }
        this.length = length == null ? 0 : length.intValue();
        this.precision = precision == null ? 0 : precision.intValue();
        this.scale = scale == null ? 0 : scale.intValue();
        this.nullable = nullable == null ? true : nullable;
        this.readonly = readonly;
        this.generatedAlwaysAs = generatedAlwaysAs;
        this.defaultValue = defaultValue;
        this.identity = identity;
        if (generator != null) {
            database.create().configuration().commercial(() -> "Client side computed columns are a commercial only feature. Please consider upgrading to the jOOQ Professional Edition or jOOQ Enterprise Edition.");
        }
    }

    @Override
    public final Database getDatabase() {
        return this.database;
    }

    @Override
    public final SchemaDefinition getSchema() {
        return this.schema;
    }

    private final SQLDialect getDialect() {
        return this.getDatabase().getDialect();
    }

    @Override
    public final boolean isNullable() {
        return this.nullable;
    }

    public final DefaultDataTypeDefinition readonly(boolean r) {
        this.readonly = r;
        return this;
    }

    @Override
    public final boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public final boolean isComputed() {
        return this.getGeneratedAlwaysAs() != null;
    }

    @Override
    public final String getGeneratedAlwaysAs() {
        return this.generatedAlwaysAs;
    }

    public final DefaultDataTypeDefinition generatedAlwaysAs(String g) {
        if (g != null && !this.database.create().configuration().commercial()) {
            logGeneratedAlwaysAs.info((Object)"Computed columns", (Object)"Computed columns are a commercial only jOOQ feature. If you wish to profit from this feature, please upgrade to the jOOQ Professional Edition");
        }
        this.generatedAlwaysAs = g;
        return this;
    }

    @Override
    public QOM.GenerationOption getGenerationOption() {
        return this.generationOption;
    }

    @Override
    public XMLTypeDefinition getXMLTypeDefinition() {
        return this.xmlTypeDefinition;
    }

    @Override
    public QOM.GenerationLocation getGenerationLocation() {
        return this.generator == null ? QOM.GenerationLocation.SERVER : QOM.GenerationLocation.CLIENT;
    }

    public final DefaultDataTypeDefinition generator(String g) {
        if (g != null && !this.database.create().configuration().commercial()) {
            logGenerator.info((Object)"Computed columns", (Object)"Client side computed columns are a commercial only jOOQ feature. If you wish to profit from this feature, please upgrade to the jOOQ Professional Edition");
        }
        this.generator = g;
        return this;
    }

    public final DefaultDataTypeDefinition generationOption(QOM.GenerationOption go) {
        this.generationOption = go;
        return this;
    }

    public final DefaultDataTypeDefinition xmlTypeDefinition(XMLTypeDefinition x) {
        this.xmlTypeDefinition = x;
        return this;
    }

    public final DefaultDataTypeDefinition identity(boolean i) {
        this.identity = i;
        return this;
    }

    @Override
    public final boolean isIdentity() {
        return this.identity;
    }

    @Override
    public final boolean isDefaulted() {
        return this.getDefaultValue() != null;
    }

    @Override
    public final String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public final boolean isUDT() {
        if (this.userType == null) {
            return false;
        }
        return this.getDatabase().getUDT(this.schema, this.userType) != null;
    }

    @Override
    public final boolean isArray() {
        if (this.userType == null) {
            return false;
        }
        return this.getDatabase().getArray(this.schema, this.userType) != null;
    }

    @Override
    public final boolean isUDTArray() {
        return this.isArray() && this.getDatabase().getArray(this.schema, this.userType).getElementType(new DefaultJavaTypeResolver()).isUDT();
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public final String getGenerator() {
        return this.generator;
    }

    @Override
    public final String getConverter() {
        return this.converter;
    }

    @Override
    public final String getBinding() {
        return this.binding;
    }

    @Override
    public final int getLength() {
        return this.length;
    }

    @Override
    public final int getPrecision() {
        return this.precision;
    }

    @Override
    public final int getScale() {
        return this.scale;
    }

    @Override
    public final String getUserType() {
        return this.userType != null ? this.userType.last() : null;
    }

    @Override
    public final Name getQualifiedUserType() {
        return this.userType;
    }

    public DefaultDataTypeDefinition qualifiedUserType(Name name) {
        this.userType = name;
        return this;
    }

    @Override
    public final String getJavaType() {
        return this.javaType;
    }

    @Override
    public final String getJavaType(JavaTypeResolver resolver) {
        if (resolver == null) {
            return this.getJavaType();
        }
        return resolver.resolve(this);
    }

    @Override
    public final boolean isGenericNumberType() {
        return false;
    }

    @Override
    public List<String> getMatchNames() {
        if (this.matchNames == null) {
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            result.add(this.getType());
            if (this.getLength() != 0) {
                result.add(this.getType() + "(" + this.getLength() + ")");
            }
            if (this.getScale() == 0) {
                result.add(this.getType() + "(" + this.getPrecision() + ")");
            }
            result.add(this.getType() + "(" + this.getPrecision() + "," + this.getScale() + ")");
            result.add(this.getType() + "(" + this.getPrecision() + ", " + this.getScale() + ")");
            if (this.getDatabase().isArrayType(this.getType())) {
                switch (this.getDialect().family()) {
                    case POSTGRES: 
                    case YUGABYTEDB: {
                        if (this.getType().startsWith("_")) {
                            result.add(this.getType().substring(1) + " array");
                            break;
                        }
                        if (!this.getType().toUpperCase().endsWith(" ARRAY")) break;
                        result.add("_" + this.getType().replaceFirst("(?i: ARRAY)", ""));
                    }
                }
            } else if (!StringUtils.isBlank((String)this.getUserType())) {
                result.add(this.getUserType());
                result.add(this.getQualifiedUserType().unquotedName().toString());
            }
            this.matchNames = new ArrayList<String>(result);
        }
        return this.matchNames;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.userType == null ? 0 : this.userType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultDataTypeDefinition) {
            DefaultDataTypeDefinition other = (DefaultDataTypeDefinition)obj;
            if (!DefaultDataType.normalise((String)this.type).equals(DefaultDataType.normalise((String)other.type))) {
                return false;
            }
            if (this.userType == null && other.userType == null) {
                return true;
            }
            if (this.userType == null || other.userType == null) {
                return false;
            }
            return DefaultDataType.normalise((String)this.userType.last()).equals(DefaultDataType.normalise((String)other.userType.last()));
        }
        return false;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DataType [ t=");
        sb.append(this.type);
        sb.append("; p=");
        sb.append(this.precision);
        sb.append("; s=");
        sb.append(this.scale);
        sb.append("; u=");
        sb.append(this.userType);
        sb.append("; j=");
        sb.append(this.javaType);
        sb.append(" ]");
        return sb.toString();
    }
}

