/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.postgres;

import java.sql.SQLException;
import java.util.Arrays;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.WindowFinalStep;
import org.jooq.WindowSpecification;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractRoutineDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultParameterDefinition;
import org.jooq.meta.InOutDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.postgres.PostgresDatabase;
import org.jooq.meta.postgres.information_schema.Tables;
import org.jooq.meta.postgres.information_schema.tables.Parameters;
import org.jooq.tools.StringUtils;

public class PostgresRoutineDefinition
extends AbstractRoutineDefinition {
    private final String specificName;
    private final boolean isProcedure;

    public PostgresRoutineDefinition(Database database, Record record) {
        super(database.getSchema((String)record.get(Tables.ROUTINES.ROUTINE_SCHEMA)), null, (String)record.get(Tables.ROUTINES.ROUTINE_NAME), null, (String)record.get("overload", String.class), (Boolean)record.get("is_agg", Boolean.TYPE));
        String dataType = (String)record.get("data_type", String.class);
        if (dataType != null && !Arrays.asList("void").contains(dataType)) {
            SchemaDefinition typeSchema = null;
            String schemaName = (String)record.get(Tables.ROUTINES.TYPE_UDT_SCHEMA);
            if (schemaName != null) {
                typeSchema = this.getDatabase().getSchema(schemaName);
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), typeSchema == null ? database.getSchema((String)record.get(Tables.ROUTINES.ROUTINE_SCHEMA)) : typeSchema, dataType, (Number)record.get(Tables.ROUTINES.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(Tables.ROUTINES.NUMERIC_PRECISION), (Number)record.get(Tables.ROUTINES.NUMERIC_SCALE), null, (String)null, DSL.name((String[])new String[]{(String)record.get(Tables.ROUTINES.TYPE_UDT_SCHEMA), (String)record.get(Tables.ROUTINES.TYPE_UDT_NAME)}));
            this.returnValue = new DefaultParameterDefinition(this, "RETURN_VALUE", -1, type);
        }
        this.specificName = (String)record.get(Tables.ROUTINES.SPECIFIC_NAME);
        this.isProcedure = "PROCEDURE".equalsIgnoreCase((String)record.get(Tables.ROUTINES.ROUTINE_TYPE));
    }

    PostgresRoutineDefinition(Database database, String schema, String name, String specificName) {
        super(database.getSchema(schema), null, name, null, null);
        this.specificName = specificName;
        this.isProcedure = false;
    }

    @Override
    protected void init0() throws SQLException {
        Parameters p = Tables.PARAMETERS.as("p");
        WindowFinalStep count = DSL.count().filterWhere(p.PARAMETER_NAME.ne((Field)DSL.inline((String)""))).over((WindowSpecification)DSL.partitionBy((GroupField[])new GroupField[]{p.SPECIFIC_NAME, p.PARAMETER_NAME}));
        Field c = count.as("c");
        for (Record record : this.create().select(p.PARAMETER_NAME, (SelectField)DSL.when((Condition)p.DATA_TYPE.eq((Field)DSL.inline((String)"USER-DEFINED")).and(p.UDT_NAME.eq((Field)DSL.inline((String)"geometry"))), (Field)DSL.inline((String)"geometry")).when(p.DATA_TYPE.eq((Field)DSL.inline((String)"ARRAY")), DSL.substring(p.UDT_NAME, (Field)DSL.inline((int)2)).concat(new Field[]{DSL.inline((String)" ARRAY")})).else_(p.DATA_TYPE).as(p.DATA_TYPE), p.CHARACTER_MAXIMUM_LENGTH, (SelectField)PostgresRoutineDefinition.pNumericPrecision(p).as(p.NUMERIC_PRECISION), p.NUMERIC_SCALE, p.UDT_SCHEMA, (SelectField)DSL.when((Condition)p.DATA_TYPE.eq((Field)DSL.inline((String)"ARRAY")), (Field)DSL.substring(p.UDT_NAME, (Field)DSL.inline((int)2))).else_(p.UDT_NAME).as(p.UDT_NAME), p.ORDINAL_POSITION, p.PARAMETER_MODE, ((PostgresDatabase)this.getDatabase()).is94() ? p.PARAMETER_DEFAULT : DSL.inline((String)null).as(p.PARAMETER_DEFAULT), (SelectField)c).from((TableLike)p).where(p.SPECIFIC_SCHEMA.equal((Object)this.getSchema().getName())).and(p.SPECIFIC_NAME.equal((Object)this.specificName)).orderBy((OrderField)p.ORDINAL_POSITION.asc())) {
            String parameterName = (String)record.get(p.PARAMETER_NAME);
            String inOut = (String)record.get(p.PARAMETER_MODE);
            SchemaDefinition typeSchema = null;
            String schemaName = (String)record.get(p.UDT_SCHEMA);
            if (schemaName != null) {
                typeSchema = this.getDatabase().getSchema(schemaName);
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), typeSchema, (String)record.get(p.DATA_TYPE), (Number)record.get(p.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(p.NUMERIC_PRECISION), (Number)record.get(p.NUMERIC_SCALE), null, (String)record.get(p.PARAMETER_DEFAULT), DSL.name((String[])new String[]{(String)record.get(p.UDT_SCHEMA), (String)record.get(p.UDT_NAME)}));
            DefaultParameterDefinition parameter = new DefaultParameterDefinition(this, parameterName, (Integer)record.get(p.ORDINAL_POSITION), type, record.get(p.PARAMETER_DEFAULT) != null, StringUtils.isBlank((String)parameterName), "", (Integer)record.get(c) > 1 ? (String)record.get(p.ORDINAL_POSITION, String.class) : null);
            this.addParameter(InOutDefinition.getFromString(inOut), parameter);
        }
    }

    static Field<Integer> pNumericPrecision(Parameters p) {
        return DSL.when((Condition)p.NUMERIC_PRECISION.isNull().and(p.DATA_TYPE.in(new Field[]{DSL.inline((String)"time"), DSL.inline((String)"timetz"), DSL.inline((String)"time without time zone"), DSL.inline((String)"time with time zone"), DSL.inline((String)"timestamp"), DSL.inline((String)"timestamptz"), DSL.inline((String)"timestamp without time zone"), DSL.inline((String)"timestamp with time zone")})), (Field)DSL.inline((int)6)).else_(p.NUMERIC_PRECISION);
    }

    public boolean isProcedure() {
        return this.isProcedure;
    }
}

