/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.postgres;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Record4;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.AbstractDefinition;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultCheckConstraintDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultEnumDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.postgres.PostgresRoutineDefinition;
import org.jooq.util.postgres.PostgresTableDefinition;
import org.jooq.util.postgres.PostgresUDTDefinition;
import org.jooq.util.postgres.information_schema.tables.CheckConstraints;
import org.jooq.util.postgres.information_schema.tables.Routines;
import org.jooq.util.postgres.information_schema.tables.TableConstraints;
import org.jooq.util.postgres.pg_catalog.Tables;

public class PostgresDatabase
extends AbstractDatabase {
    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("PRIMARY KEY")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("UNIQUE")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    private Result<Record4<String, String, String, String>> fetchKeys(String constraintType) {
        return this.create().select(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME, org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA, org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_NAME, org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.COLUMN_NAME).from(new TableLike[]{org.jooq.util.postgres.information_schema.Tables.TABLE_CONSTRAINTS}).join((TableLike)org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE).on(new Condition[]{org.jooq.util.postgres.information_schema.Tables.TABLE_CONSTRAINTS.CONSTRAINT_SCHEMA.equal(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_SCHEMA)}).and(org.jooq.util.postgres.information_schema.Tables.TABLE_CONSTRAINTS.CONSTRAINT_NAME.equal(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME)).where(new Condition[]{org.jooq.util.postgres.information_schema.Tables.TABLE_CONSTRAINTS.CONSTRAINT_TYPE.equal((Object)constraintType)}).and(org.jooq.util.postgres.information_schema.Tables.TABLE_CONSTRAINTS.TABLE_SCHEMA.in(this.getInputSchemata())).orderBy(new SortField[]{org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA.asc(), org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_NAME.asc(), org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME.asc(), org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.ORDINAL_POSITION.asc()}).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        Result result = this.create().select(org.jooq.util.postgres.information_schema.Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_NAME, org.jooq.util.postgres.information_schema.Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_SCHEMA, org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME, org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA, org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_NAME, org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.COLUMN_NAME).from(new TableLike[]{org.jooq.util.postgres.information_schema.Tables.REFERENTIAL_CONSTRAINTS}).join((TableLike)org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE).on(new Condition[]{org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_SCHEMA.equal(org.jooq.util.postgres.information_schema.Tables.REFERENTIAL_CONSTRAINTS.CONSTRAINT_SCHEMA)}).and(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME.equal(org.jooq.util.postgres.information_schema.Tables.REFERENTIAL_CONSTRAINTS.CONSTRAINT_NAME)).where(new Condition[]{org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA.in(this.getInputSchemata())}).orderBy(new SortField[]{org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA.asc(), org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_NAME.asc(), org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME.asc(), org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.ORDINAL_POSITION.asc()}).fetch();
        for (Record record : result) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.getValue(org.jooq.util.postgres.information_schema.Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_SCHEMA));
            String foreignKey = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String foreignKeyTable = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String foreignKeyColumn = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            String uniqueKey = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_NAME);
            TableDefinition referencingTable = this.getTable(foreignKeySchema, foreignKeyTable);
            if (referencingTable == null) continue;
            ColumnDefinition referencingColumn = referencingTable.getColumn(foreignKeyColumn);
            relations2.addForeignKey(foreignKeyTable + "__" + foreignKey, uniqueKey, referencingColumn, uniqueKeySchema);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        TableConstraints tc = org.jooq.util.postgres.information_schema.Tables.TABLE_CONSTRAINTS.as("tc");
        CheckConstraints cc = org.jooq.util.postgres.information_schema.Tables.CHECK_CONSTRAINTS.as("cc");
        for (Record record : this.create().select(tc.TABLE_SCHEMA, tc.TABLE_NAME, cc.CONSTRAINT_NAME, cc.CHECK_CLAUSE).from(new TableLike[]{tc}).join((TableLike)cc).using(new Field[]{tc.CONSTRAINT_CATALOG, tc.CONSTRAINT_SCHEMA, tc.CONSTRAINT_NAME}).where(new Condition[]{tc.TABLE_SCHEMA.in(this.getInputSchemata())}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(tc.TABLE_SCHEMA));
            TableDefinition table = this.getTable(schema, (String)record.getValue(tc.TABLE_NAME));
            if (table == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.getValue(cc.CONSTRAINT_NAME), (String)record.getValue(cc.CHECK_CLAUSE)));
        }
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(org.jooq.util.postgres.information_schema.Tables.TABLES.TABLE_SCHEMA, org.jooq.util.postgres.information_schema.Tables.TABLES.TABLE_NAME).from(new TableLike[]{org.jooq.util.postgres.information_schema.Tables.TABLES}).where(new Condition[]{org.jooq.util.postgres.information_schema.Tables.TABLES.TABLE_SCHEMA.in(this.getInputSchemata())}).orderBy(new Field[]{org.jooq.util.postgres.information_schema.Tables.TABLES.TABLE_SCHEMA, org.jooq.util.postgres.information_schema.Tables.TABLES.TABLE_NAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(org.jooq.util.postgres.information_schema.Tables.TABLES.TABLE_SCHEMA));
            String name = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.TABLES.TABLE_NAME);
            String comment = "";
            result.add(new PostgresTableDefinition(schema, name, comment));
        }
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (String name : this.create().select(Tables.PG_NAMESPACE.NSPNAME).from(new TableLike[]{Tables.PG_NAMESPACE}).fetch(Tables.PG_NAMESPACE.NSPNAME)) {
            result.add(new SchemaDefinition((Database)this, name, ""));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(org.jooq.util.postgres.information_schema.Tables.SEQUENCES.SEQUENCE_SCHEMA, org.jooq.util.postgres.information_schema.Tables.SEQUENCES.SEQUENCE_NAME, org.jooq.util.postgres.information_schema.Tables.SEQUENCES.DATA_TYPE, org.jooq.util.postgres.information_schema.Tables.SEQUENCES.NUMERIC_PRECISION, org.jooq.util.postgres.information_schema.Tables.SEQUENCES.NUMERIC_SCALE).from(new TableLike[]{org.jooq.util.postgres.information_schema.Tables.SEQUENCES}).where(new Condition[]{org.jooq.util.postgres.information_schema.Tables.SEQUENCES.SEQUENCE_SCHEMA.in(this.getInputSchemata())}).orderBy(new Field[]{org.jooq.util.postgres.information_schema.Tables.SEQUENCES.SEQUENCE_SCHEMA, org.jooq.util.postgres.information_schema.Tables.SEQUENCES.SEQUENCE_NAME}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(org.jooq.util.postgres.information_schema.Tables.SEQUENCES.SEQUENCE_SCHEMA));
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.SEQUENCES.DATA_TYPE), 0, (Number)record.getValue(org.jooq.util.postgres.information_schema.Tables.SEQUENCES.NUMERIC_PRECISION), (Number)record.getValue(org.jooq.util.postgres.information_schema.Tables.SEQUENCES.NUMERIC_SCALE), false, false);
            result.add(new DefaultSequenceDefinition(schema, (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.SEQUENCES.SEQUENCE_NAME), type));
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        if (this.exists((Table<?>)Tables.PG_ENUM)) {
            Result types = this.create().select(Tables.PG_NAMESPACE.NSPNAME, Tables.PG_TYPE.TYPNAME).from(new TableLike[]{Tables.PG_TYPE}).join((TableLike)Tables.PG_NAMESPACE).on("pg_type.typnamespace = pg_namespace.oid").where(new Condition[]{Tables.PG_NAMESPACE.NSPNAME.in(this.getInputSchemata())}).and(DSL.field((String)"pg_type.oid", Long.class).in((Select)DSL.select(Tables.PG_ENUM.ENUMTYPID).from(new TableLike[]{Tables.PG_ENUM}))).orderBy(new Field[]{Tables.PG_NAMESPACE.NSPNAME, Tables.PG_TYPE.TYPNAME}).fetch();
            for (Record2 type : types) {
                String nspname = (String)type.getValue(Tables.PG_NAMESPACE.NSPNAME);
                String typname = (String)type.getValue(Tables.PG_TYPE.TYPNAME);
                List labels = this.create().select(Tables.PG_ENUM.ENUMLABEL).from(new TableLike[]{Tables.PG_ENUM}).join((TableLike)Tables.PG_TYPE).on("pg_enum.enumtypid = pg_type.oid").join((TableLike)Tables.PG_NAMESPACE).on("pg_type.typnamespace = pg_namespace.oid").where(new Condition[]{Tables.PG_NAMESPACE.NSPNAME.eq((Object)nspname)}).and(Tables.PG_TYPE.TYPNAME.eq((Object)typname)).orderBy(new Field[]{DSL.field((String)"{0}::{1}", (QueryPart[])new QueryPart[]{Tables.PG_ENUM.ENUMLABEL, DSL.name((String[])new String[]{nspname, typname})})}).fetch(Tables.PG_ENUM.ENUMLABEL);
                AbstractDefinition definition = null;
                for (String label : labels) {
                    SchemaDefinition schema = this.getSchema(nspname);
                    String typeName = String.valueOf(typname);
                    if (definition == null || !definition.getName().equals(typeName)) {
                        definition = new DefaultEnumDefinition(schema, typeName, null);
                        result.add((EnumDefinition)((Object)definition));
                    }
                    ((DefaultEnumDefinition)definition).addLiteral(label);
                }
            }
        }
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        if (this.exists((Table<?>)org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES)) {
            for (Record record : this.create().selectDistinct(org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES.UDT_SCHEMA, org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES.UDT_NAME).from(new TableLike[]{org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES}).where(new Condition[]{org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES.UDT_SCHEMA.in(this.getInputSchemata())}).orderBy(new Field[]{org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES.UDT_SCHEMA, org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES.UDT_NAME}).fetch()) {
                SchemaDefinition schema = this.getSchema((String)record.getValue(org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES.UDT_SCHEMA));
                String name = (String)record.getValue(org.jooq.util.postgres.information_schema.Tables.ATTRIBUTES.UDT_NAME);
                result.add(new PostgresUDTDefinition(schema, name, null));
            }
        }
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        Routines r1 = org.jooq.util.postgres.information_schema.Tables.ROUTINES.as("r1");
        Routines r2 = org.jooq.util.postgres.information_schema.Tables.ROUTINES.as("r2");
        for (Record record : this.create().select(r1.ROUTINE_SCHEMA, r1.ROUTINE_NAME, r1.SPECIFIC_NAME, DSL.decode().when(DSL.exists((Select)DSL.selectOne().from(new TableLike[]{org.jooq.util.postgres.information_schema.Tables.PARAMETERS}).where(new Condition[]{org.jooq.util.postgres.information_schema.Tables.PARAMETERS.SPECIFIC_SCHEMA.equal(r1.SPECIFIC_SCHEMA)}).and(org.jooq.util.postgres.information_schema.Tables.PARAMETERS.SPECIFIC_NAME.equal(r1.SPECIFIC_NAME)).and(DSL.upper(org.jooq.util.postgres.information_schema.Tables.PARAMETERS.PARAMETER_MODE).notEqual((Object)"IN"))), (Field)DSL.val((Object)"void")).otherwise(r1.DATA_TYPE).as("data_type"), r1.CHARACTER_MAXIMUM_LENGTH, r1.NUMERIC_PRECISION, r1.NUMERIC_SCALE, r1.TYPE_UDT_NAME, DSL.decode().when(DSL.exists((Select)DSL.selectOne().from(new TableLike[]{r2}).where(new Condition[]{r2.ROUTINE_SCHEMA.in(this.getInputSchemata())}).and(r2.ROUTINE_SCHEMA.equal(r1.ROUTINE_SCHEMA)).and(r2.ROUTINE_NAME.equal(r1.ROUTINE_NAME)).and(r2.SPECIFIC_NAME.notEqual(r1.SPECIFIC_NAME))), DSL.select((Field)DSL.count()).from(new TableLike[]{r2}).where(new Condition[]{r2.ROUTINE_SCHEMA.in(this.getInputSchemata())}).and(r2.ROUTINE_SCHEMA.equal(r1.ROUTINE_SCHEMA)).and(r2.ROUTINE_NAME.equal(r1.ROUTINE_NAME)).and(r2.SPECIFIC_NAME.lessOrEqual(r1.SPECIFIC_NAME)).asField()).as("overload")).from(new TableLike[]{r1}).where(new Condition[]{r1.ROUTINE_SCHEMA.in(this.getInputSchemata())}).orderBy(new SortField[]{r1.ROUTINE_SCHEMA.asc(), r1.ROUTINE_NAME.asc()}).fetch()) {
            result.add(new PostgresRoutineDefinition(this, record));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.POSTGRES);
    }
}

