/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.postgres;

import java.sql.SQLException;
import java.util.Arrays;
import org.jooq.Condition;
import org.jooq.Record;
import org.jooq.SortField;
import org.jooq.TableLike;
import org.jooq.util.AbstractRoutineDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultParameterDefinition;
import org.jooq.util.InOutDefinition;
import org.jooq.util.postgres.information_schema.Tables;

public class PostgresRoutineDefinition
extends AbstractRoutineDefinition {
    private final String specificName;

    public PostgresRoutineDefinition(Database database, Record record) {
        super(database.getSchema((String)record.getValue(Tables.ROUTINES.ROUTINE_SCHEMA)), null, (String)record.getValue(Tables.ROUTINES.ROUTINE_NAME), null, (String)record.getValue("overload", String.class));
        if (!Arrays.asList("void", "record").contains(record.getValue("data_type"))) {
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), database.getSchema((String)record.getValue(Tables.ROUTINES.ROUTINE_SCHEMA)), (String)record.getValue("data_type", String.class), (Number)record.getValue(Tables.ROUTINES.CHARACTER_MAXIMUM_LENGTH), (Number)record.getValue(Tables.ROUTINES.NUMERIC_PRECISION), (Number)record.getValue(Tables.ROUTINES.NUMERIC_SCALE), null, null, (String)record.getValue(Tables.ROUTINES.TYPE_UDT_NAME));
            this.returnValue = new DefaultParameterDefinition(this, "RETURN_VALUE", -1, type);
        }
        this.specificName = (String)record.getValue(Tables.ROUTINES.SPECIFIC_NAME);
    }

    @Override
    protected void init0() throws SQLException {
        for (Record record : this.create().select(Tables.PARAMETERS.PARAMETER_NAME, Tables.PARAMETERS.DATA_TYPE, Tables.PARAMETERS.CHARACTER_MAXIMUM_LENGTH, Tables.PARAMETERS.NUMERIC_PRECISION, Tables.PARAMETERS.NUMERIC_SCALE, Tables.PARAMETERS.UDT_NAME, Tables.PARAMETERS.ORDINAL_POSITION, Tables.PARAMETERS.PARAMETER_MODE).from(new TableLike[]{Tables.PARAMETERS}).where(new Condition[]{Tables.PARAMETERS.SPECIFIC_SCHEMA.equal((Object)this.getSchema().getName())}).and(Tables.PARAMETERS.SPECIFIC_NAME.equal((Object)this.specificName)).orderBy(new SortField[]{Tables.PARAMETERS.ORDINAL_POSITION.asc()}).fetch()) {
            String inOut = (String)record.getValue(Tables.PARAMETERS.PARAMETER_MODE);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), (String)record.getValue(Tables.PARAMETERS.DATA_TYPE), (Number)record.getValue(Tables.PARAMETERS.CHARACTER_MAXIMUM_LENGTH), (Number)record.getValue(Tables.PARAMETERS.NUMERIC_PRECISION), (Number)record.getValue(Tables.PARAMETERS.NUMERIC_SCALE), null, null, (String)record.getValue(Tables.PARAMETERS.UDT_NAME));
            DefaultParameterDefinition parameter = new DefaultParameterDefinition(this, (String)record.getValue(Tables.PARAMETERS.PARAMETER_NAME), (Integer)record.getValue(Tables.PARAMETERS.ORDINAL_POSITION), type);
            this.addParameter(InOutDefinition.getFromString(inOut), parameter);
        }
    }
}

