/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.util.AbstractElementContainerDefinition;
import org.jooq.util.CheckConstraintDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultIdentityDefinition;
import org.jooq.util.ForeignKeyDefinition;
import org.jooq.util.IdentityDefinition;
import org.jooq.util.ParameterDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UniqueKeyDefinition;

public abstract class AbstractTableDefinition
extends AbstractElementContainerDefinition<ColumnDefinition>
implements TableDefinition {
    private List<UniqueKeyDefinition> uniqueKeys;
    private List<ForeignKeyDefinition> foreignKeys;
    private List<CheckConstraintDefinition> checkConstraints;
    private List<ParameterDefinition> parameters;
    private boolean primaryKeyLoaded;
    private UniqueKeyDefinition primaryKey;
    private boolean identityLoaded;
    private IdentityDefinition identity;
    private TableDefinition parentTable = null;
    private List<TableDefinition> childTables = new ArrayList<TableDefinition>();

    public AbstractTableDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema, name, comment);
    }

    @Override
    public final UniqueKeyDefinition getPrimaryKey() {
        if (!this.primaryKeyLoaded) {
            this.primaryKeyLoaded = true;
            for (ColumnDefinition column : this.getColumns()) {
                if (column.getPrimaryKey() == null) continue;
                this.primaryKey = column.getPrimaryKey();
                return this.primaryKey;
            }
        }
        return this.primaryKey;
    }

    @Override
    public final List<UniqueKeyDefinition> getUniqueKeys() {
        if (this.uniqueKeys == null) {
            this.uniqueKeys = this.getDatabase().getRelations().getUniqueKeys(this);
        }
        return this.uniqueKeys;
    }

    @Override
    public final List<ForeignKeyDefinition> getForeignKeys() {
        if (this.foreignKeys == null) {
            this.foreignKeys = this.getDatabase().getRelations().getForeignKeys(this);
        }
        return this.foreignKeys;
    }

    @Override
    public final List<CheckConstraintDefinition> getCheckConstraints() {
        if (this.checkConstraints == null) {
            this.checkConstraints = this.getDatabase().getRelations().getCheckConstraints(this);
        }
        return this.checkConstraints;
    }

    @Override
    public final IdentityDefinition getIdentity() {
        if (!this.identityLoaded) {
            this.identityLoaded = true;
            for (ColumnDefinition column : this.getColumns()) {
                if (!column.isIdentity()) continue;
                this.identity = new DefaultIdentityDefinition(column);
                break;
            }
        }
        return this.identity;
    }

    public final void setParentTable(TableDefinition parentTable) {
        this.parentTable = parentTable;
    }

    @Override
    public final TableDefinition getParentTable() {
        return this.parentTable;
    }

    @Override
    public final List<TableDefinition> getChildTables() {
        return this.childTables;
    }

    @Override
    public final Table<Record> getTable() {
        return DSL.table((String)this.getQualifiedName());
    }

    @Override
    public final List<ColumnDefinition> getColumns() {
        return this.getElements();
    }

    @Override
    public final ColumnDefinition getColumn(String columnName) {
        return (ColumnDefinition)this.getElement(columnName);
    }

    @Override
    public final ColumnDefinition getColumn(String columnName, boolean ignoreCase) {
        return (ColumnDefinition)this.getElement(columnName, ignoreCase);
    }

    @Override
    public final ColumnDefinition getColumn(int columnIndex) {
        return (ColumnDefinition)this.getElement(columnIndex);
    }

    @Override
    public final List<ParameterDefinition> getParameters() {
        if (this.parameters == null) {
            this.parameters = this.getParameters0();
        }
        return this.parameters;
    }

    @Override
    public boolean isTableValuedFunction() {
        return false;
    }

    @Override
    protected List<ColumnDefinition> getElements0() throws SQLException {
        return null;
    }

    protected List<ParameterDefinition> getParameters0() {
        return Collections.emptyList();
    }
}

