/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.sqlite;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Record;
import org.jooq.TableLike;
import org.jooq.util.AbstractTableDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultColumnDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.sqlite.sqlite_master.SQLiteMaster;

public class SQLiteTableDefinition
extends AbstractTableDefinition {
    private static Boolean existsSqliteSequence;

    public SQLiteTableDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema, name, comment);
    }

    @Override
    public List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        int position = 0;
        for (Record record : this.create().fetch("pragma table_info('" + this.getName() + "')")) {
            ++position;
            String name = (String)record.getValue("name", String.class);
            String dataType = ((String)record.getValue("type", String.class)).replaceAll("\\(\\d+(\\s*,\\s*\\d+)?\\)", "");
            Number precision = this.parsePrecision((String)record.getValue("type", String.class));
            Number scale = this.parseScale((String)record.getValue("type", String.class));
            boolean pk = (Boolean)record.getValue("pk", Boolean.class);
            boolean identity = pk && this.existsSqliteSequence() && (Boolean)this.create().fetchOne("select count(*) from sqlite_sequence where name = ?", new Object[]{this.getName()}).getValue(0, Boolean.class) != false;
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), dataType, precision, precision, scale, (Boolean)record.getValue("notnull", Boolean.TYPE) == false, record.getValue("dflt_value") != null);
            DefaultColumnDefinition column = new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), name, position, type, identity, null);
            result.add(column);
        }
        return result;
    }

    private boolean existsSqliteSequence() {
        if (existsSqliteSequence == null) {
            existsSqliteSequence = (Boolean)this.create().selectCount().from(new TableLike[]{SQLiteMaster.SQLITE_MASTER}).where(new Condition[]{SQLiteMaster.NAME.lower().eq((Object)"sqlite_sequence")}).fetchOne(0, Boolean.TYPE);
        }
        return existsSqliteSequence;
    }
}

