/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.xml;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractTableDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultColumnDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.xml.XMLDatabase;
import org.jooq.util.xml.jaxb.Column;
import org.jooq.util.xml.jaxb.InformationSchema;
import org.jooq.util.xml.jaxb.Table;

public class XMLTableDefinition
extends AbstractTableDefinition {
    private final InformationSchema info;
    private final Table table;

    public XMLTableDefinition(SchemaDefinition schema, InformationSchema info, Table table) {
        super(schema, table.getTableName(), "");
        this.info = info;
        this.table = table;
    }

    @Override
    protected List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        for (Column column : this.info.getColumns()) {
            if (!StringUtils.equals((Object)this.table.getTableCatalog(), (Object)column.getTableCatalog()) || !StringUtils.equals((Object)this.table.getTableSchema(), (Object)column.getTableSchema()) || !StringUtils.equals((Object)this.table.getTableName(), (Object)column.getTableName())) continue;
            SchemaDefinition schema = this.getDatabase().getSchema(column.getTableSchema());
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), schema, column.getDataType(), XMLDatabase.unbox(column.getCharacterMaximumLength()), XMLDatabase.unbox(column.getNumericPrecision()), XMLDatabase.unbox(column.getNumericScale()), column.isIsNullable(), column.getColumnDefault() != null);
            result.add(new DefaultColumnDefinition(this, column.getColumnName(), XMLDatabase.unbox(column.getOrdinalPosition()), type, column.getIdentityGeneration() != null, ""));
        }
        return result;
    }
}

