/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.h2;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Record4;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.jooq.util.AbstractDatabase;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultCheckConstraintDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultSequenceDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.h2.H2DataType;
import org.jooq.util.h2.H2RoutineDefinition;
import org.jooq.util.h2.H2TableDefinition;
import org.jooq.util.h2.information_schema.tables.Columns;
import org.jooq.util.h2.information_schema.tables.Constraints;
import org.jooq.util.h2.information_schema.tables.CrossReferences;
import org.jooq.util.h2.information_schema.tables.FunctionAliases;
import org.jooq.util.h2.information_schema.tables.Indexes;
import org.jooq.util.h2.information_schema.tables.Schemata;
import org.jooq.util.h2.information_schema.tables.Sequences;
import org.jooq.util.h2.information_schema.tables.Tables;
import org.jooq.util.h2.information_schema.tables.TypeInfo;

public class H2Database
extends AbstractDatabase {
    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.H2);
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("PRIMARY KEY")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Constraints.TABLE_SCHEMA));
            String tableName = (String)record.getValue(Constraints.TABLE_NAME);
            String primaryKey = (String)record.getValue(Constraints.CONSTRAINT_NAME);
            String columnName = (String)record.getValue(Indexes.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(primaryKey, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("UNIQUE")) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Constraints.TABLE_SCHEMA));
            String tableName = (String)record.getValue(Constraints.TABLE_NAME);
            String primaryKey = (String)record.getValue(Constraints.CONSTRAINT_NAME);
            String columnName = (String)record.getValue(Indexes.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(primaryKey, table.getColumn(columnName));
        }
    }

    private Result<Record4<String, String, String, String>> fetchKeys(String constraintType) {
        return this.create().select(Constraints.TABLE_SCHEMA, Constraints.TABLE_NAME, Constraints.CONSTRAINT_NAME, Indexes.COLUMN_NAME).from((TableLike)Constraints.CONSTRAINTS).join((TableLike)Indexes.INDEXES).on(new Condition[]{Constraints.TABLE_SCHEMA.eq(Indexes.TABLE_SCHEMA)}).and(Constraints.TABLE_NAME.eq(Indexes.TABLE_NAME)).and(Constraints.UNIQUE_INDEX_NAME.eq(Indexes.INDEX_NAME)).where(new Condition[]{Constraints.TABLE_SCHEMA.in(this.getInputSchemata())}).and(Constraints.CONSTRAINT_TYPE.equal((Object)constraintType)).orderBy(Constraints.TABLE_SCHEMA, Constraints.CONSTRAINT_NAME, Indexes.ORDINAL_POSITION).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.create().select(CrossReferences.FK_NAME, CrossReferences.FKTABLE_NAME, CrossReferences.FKTABLE_SCHEMA, CrossReferences.FKCOLUMN_NAME, Constraints.CONSTRAINT_NAME, Constraints.CONSTRAINT_SCHEMA).from((TableLike)CrossReferences.CROSS_REFERENCES).join((TableLike)Constraints.CONSTRAINTS).on(new Condition[]{CrossReferences.PK_NAME.equal(Constraints.UNIQUE_INDEX_NAME)}).and(CrossReferences.PKTABLE_NAME.equal(Constraints.TABLE_NAME)).and(CrossReferences.PKTABLE_SCHEMA.equal(Constraints.TABLE_SCHEMA)).where(new Condition[]{CrossReferences.FKTABLE_SCHEMA.in(this.getInputSchemata())}).and(Constraints.CONSTRAINT_TYPE.in((Object[])new String[]{"PRIMARY KEY", "UNIQUE"})).orderBy(CrossReferences.FKTABLE_SCHEMA.asc(), CrossReferences.FK_NAME.asc(), CrossReferences.ORDINAL_POSITION.asc()).fetch()) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.getValue(CrossReferences.FKTABLE_SCHEMA));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.getValue(Constraints.CONSTRAINT_SCHEMA));
            String foreignKeyTableName = (String)record.getValue(CrossReferences.FKTABLE_NAME);
            String foreignKeyColumn = (String)record.getValue(CrossReferences.FKCOLUMN_NAME);
            String foreignKey = (String)record.getValue(CrossReferences.FK_NAME);
            String uniqueKey = (String)record.getValue(Constraints.CONSTRAINT_NAME);
            TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            if (foreignKeyTable == null) continue;
            ColumnDefinition referencingColumn = foreignKeyTable.getColumn(foreignKeyColumn);
            relations2.addForeignKey(foreignKey, uniqueKey, referencingColumn, uniqueKeySchema);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        for (Record record : this.create().select(Constraints.TABLE_SCHEMA, Constraints.TABLE_NAME, Constraints.CONSTRAINT_NAME, Constraints.CHECK_EXPRESSION).from((TableLike)Constraints.CONSTRAINTS).where(new Condition[]{Constraints.CONSTRAINT_TYPE.eq((Object)"CHECK")}).and(Constraints.TABLE_SCHEMA.in(this.getInputSchemata())).union((Select)DSL.select(Columns.TABLE_SCHEMA, Columns.TABLE_NAME, Columns.CHECK_CONSTRAINT, Columns.CHECK_CONSTRAINT).from((TableLike)Columns.COLUMNS).where(new Condition[]{Columns.CHECK_CONSTRAINT.nvl((Object)"").ne((Object)"")}).and(Columns.TABLE_SCHEMA.in(this.getInputSchemata()))).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Constraints.TABLE_SCHEMA));
            TableDefinition table = this.getTable(schema, (String)record.getValue(Constraints.TABLE_NAME));
            if (table == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.getValue(Constraints.CONSTRAINT_NAME), (String)record.getValue(Constraints.CHECK_EXPRESSION)));
        }
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (Record record : this.create().select(Schemata.SCHEMA_NAME, Schemata.REMARKS).from((TableLike)Schemata.SCHEMATA).fetch()) {
            result.add(new SchemaDefinition((Database)this, (String)record.getValue(Schemata.SCHEMA_NAME), (String)record.getValue(Schemata.REMARKS)));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(Sequences.SEQUENCE_SCHEMA, Sequences.SEQUENCE_NAME).from((TableLike)Sequences.SEQUENCES).where(new Condition[]{Sequences.SEQUENCE_SCHEMA.in(this.getInputSchemata())}).orderBy(Sequences.SEQUENCE_SCHEMA, Sequences.SEQUENCE_NAME).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Sequences.SEQUENCE_SCHEMA));
            String name = (String)record.getValue(Sequences.SEQUENCE_NAME);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, H2DataType.BIGINT.getTypeName());
            result.add(new DefaultSequenceDefinition(schema, name, type));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(Tables.TABLE_SCHEMA, Tables.TABLE_NAME, Tables.REMARKS).from((TableLike)Tables.TABLES).where(new Condition[]{Tables.TABLE_SCHEMA.in(this.getInputSchemata())}).orderBy(Tables.TABLE_SCHEMA, Tables.ID).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(Tables.TABLE_SCHEMA));
            String name = (String)record.getValue(Tables.TABLE_NAME);
            String comment = (String)record.getValue(Tables.REMARKS);
            H2TableDefinition table = new H2TableDefinition(schema, name, comment);
            result.add(table);
        }
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        for (Record record : this.create().select(FunctionAliases.ALIAS_SCHEMA, FunctionAliases.ALIAS_NAME, FunctionAliases.REMARKS, FunctionAliases.DATA_TYPE, FunctionAliases.RETURNS_RESULT, TypeInfo.TYPE_NAME, TypeInfo.PRECISION, TypeInfo.MAXIMUM_SCALE).from((TableLike)FunctionAliases.FUNCTION_ALIASES).leftOuterJoin((TableLike)TypeInfo.TYPE_INFO).on(new Condition[]{FunctionAliases.DATA_TYPE.equal(TypeInfo.DATA_TYPE)}).and(TypeInfo.POS.equal((Object)0)).where(new Condition[]{FunctionAliases.ALIAS_SCHEMA.in(this.getInputSchemata())}).and(FunctionAliases.RETURNS_RESULT.in((Object[])new Short[]{(short)1, (short)2})).orderBy(FunctionAliases.ALIAS_NAME).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.getValue(FunctionAliases.ALIAS_SCHEMA));
            String name = (String)record.getValue(FunctionAliases.ALIAS_NAME);
            String comment = (String)record.getValue(FunctionAliases.REMARKS);
            String typeName = (String)record.getValue(TypeInfo.TYPE_NAME);
            Integer precision = (Integer)record.getValue(TypeInfo.PRECISION);
            Short scale = (Short)record.getValue(TypeInfo.MAXIMUM_SCALE);
            result.add(new H2RoutineDefinition(schema, name, comment, typeName, precision, scale));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }
}

