/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.h2;

import java.sql.SQLException;
import org.jooq.Condition;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractRoutineDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultParameterDefinition;
import org.jooq.util.InOutDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.h2.H2DataType;
import org.jooq.util.h2.information_schema.tables.FunctionColumns;

public class H2RoutineDefinition
extends AbstractRoutineDefinition {
    public H2RoutineDefinition(SchemaDefinition schema, String name, String comment, String typeName, Number precision, Number scale) {
        super(schema, null, name, comment, null);
        if (!StringUtils.isBlank((String)typeName)) {
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), schema, typeName, precision, precision, scale, null, null);
            this.returnValue = new DefaultParameterDefinition(this, "RETURN_VALUE", -1, type);
        }
    }

    @Override
    protected void init0() throws SQLException {
        for (Record record : this.create().select(FunctionColumns.COLUMN_NAME, FunctionColumns.TYPE_NAME, FunctionColumns.PRECISION, FunctionColumns.SCALE, FunctionColumns.POS, FunctionColumns.NULLABLE, (SelectField)FunctionColumns.COLUMN_DEFAULT.nvl2((Object)true, (Object)false).as("default")).from((TableLike)FunctionColumns.FUNCTION_COLUMNS).where(new Condition[]{FunctionColumns.ALIAS_SCHEMA.equal((Object)this.getSchema().getName())}).and(FunctionColumns.ALIAS_NAME.equal((Object)this.getName())).and(FunctionColumns.POS.gt((Object)0)).orderBy(FunctionColumns.POS.asc()).fetch()) {
            String paramName = (String)record.getValue(FunctionColumns.COLUMN_NAME);
            String typeName = (String)record.getValue(FunctionColumns.TYPE_NAME);
            Integer precision = (Integer)record.getValue(FunctionColumns.PRECISION);
            Short scale = (Short)record.getValue(FunctionColumns.SCALE);
            int position = (Integer)record.getValue(FunctionColumns.POS);
            boolean nullable = (Boolean)record.getValue(FunctionColumns.NULLABLE, Boolean.TYPE);
            boolean defaulted = (Boolean)record.getValue("default", Boolean.TYPE);
            if (position == 0 && H2DataType.OTHER.getTypeName().equalsIgnoreCase(typeName)) continue;
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), typeName, precision, precision, scale, nullable, defaulted);
            DefaultParameterDefinition parameter = new DefaultParameterDefinition(this, paramName, position, type);
            this.addParameter(InOutDefinition.IN, parameter);
        }
    }
}

