/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.postgres;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.WindowSpecification;
import org.jooq.impl.DSL;
import org.jooq.tools.StringUtils;
import org.jooq.util.AbstractTableDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DefaultColumnDefinition;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.ParameterDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.postgres.PostgresDSL;
import org.jooq.util.postgres.PostgresRoutineDefinition;
import org.jooq.util.postgres.information_schema.Tables;
import org.jooq.util.postgres.information_schema.tables.Columns;
import org.jooq.util.postgres.information_schema.tables.Parameters;
import org.jooq.util.postgres.information_schema.tables.Routines;
import org.jooq.util.postgres.pg_catalog.tables.PgNamespace;
import org.jooq.util.postgres.pg_catalog.tables.PgProc;

public class PostgresTableValuedFunction
extends AbstractTableDefinition {
    private final PostgresRoutineDefinition routine;
    private final String specificName;

    public PostgresTableValuedFunction(SchemaDefinition schema, String name, String specificName, String comment) {
        super(schema, name, comment);
        this.routine = new PostgresRoutineDefinition(schema.getDatabase(), schema.getInputName(), name, specificName);
        this.specificName = specificName;
    }

    @Override
    public List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        Routines r = Tables.ROUTINES;
        Parameters p = Tables.PARAMETERS;
        PgNamespace pg_n = org.jooq.util.postgres.pg_catalog.Tables.PG_NAMESPACE;
        PgProc pg_p = org.jooq.util.postgres.pg_catalog.Tables.PG_PROC;
        Columns c = Tables.COLUMNS;
        for (Record record : this.create().select(p.PARAMETER_NAME, (SelectField)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((Field[])new Field[]{p.SPECIFIC_NAME}).orderBy(new Field[]{p.ORDINAL_POSITION})).as(p.ORDINAL_POSITION), p.DATA_TYPE, p.CHARACTER_MAXIMUM_LENGTH, p.NUMERIC_PRECISION, p.NUMERIC_SCALE, (SelectField)DSL.inline((CharSequence)"true").as(c.IS_NULLABLE), (SelectField)DSL.inline(null, String.class).as(c.COLUMN_DEFAULT), p.UDT_NAME).from((TableLike)r).join((TableLike)p).on(new Condition[]{DSL.row(r.SPECIFIC_CATALOG, r.SPECIFIC_SCHEMA, r.SPECIFIC_NAME).eq(p.SPECIFIC_CATALOG, p.SPECIFIC_SCHEMA, p.SPECIFIC_NAME)}).join((TableLike)pg_n).on(new Condition[]{r.SPECIFIC_SCHEMA.eq(pg_n.NSPNAME)}).join((TableLike)pg_p).on(new Condition[]{pg_p.PRONAMESPACE.eq(PostgresDSL.oid((Table)pg_n))}).and(pg_p.PRONAME.eq(r.ROUTINE_NAME)).where(new Condition[]{r.SPECIFIC_NAME.eq((Object)this.specificName)}).and(p.PARAMETER_MODE.ne((Object)"IN")).and(pg_p.PRORETSET).unionAll((Select)DSL.select(c.COLUMN_NAME, c.ORDINAL_POSITION, c.DATA_TYPE, c.CHARACTER_MAXIMUM_LENGTH, c.NUMERIC_PRECISION, c.NUMERIC_SCALE, c.IS_NULLABLE, c.COLUMN_DEFAULT, c.UDT_NAME).from((TableLike)r).join((TableLike)c).on(new Condition[]{DSL.row(r.TYPE_UDT_CATALOG, r.TYPE_UDT_SCHEMA, r.TYPE_UDT_NAME).eq(c.TABLE_CATALOG, c.TABLE_SCHEMA, c.TABLE_NAME)}).join((TableLike)pg_n).on(new Condition[]{r.SPECIFIC_SCHEMA.eq(pg_n.NSPNAME)}).join((TableLike)pg_p).on(new Condition[]{pg_p.PRONAMESPACE.eq(PostgresDSL.oid((Table)pg_n))}).and(pg_p.PRONAME.concat(new String[]{"_"}).concat(new Field[]{PostgresDSL.oid((Table)pg_p)}).eq(r.SPECIFIC_NAME)).where(new Condition[]{r.SPECIFIC_NAME.eq((Object)this.specificName)}).and(pg_p.PRORETSET)).orderBy(new int[]{2})) {
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), (String)record.getValue(p.DATA_TYPE), (Number)record.getValue(p.CHARACTER_MAXIMUM_LENGTH), (Number)record.getValue(p.NUMERIC_PRECISION), (Number)record.getValue(p.NUMERIC_SCALE), (Boolean)record.getValue(c.IS_NULLABLE, Boolean.TYPE), record.getValue(c.COLUMN_DEFAULT) != null, (String)record.getValue(p.UDT_NAME));
            DefaultColumnDefinition column = new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), (String)record.getValue(p.PARAMETER_NAME), (Integer)record.getValue(p.ORDINAL_POSITION, Integer.TYPE), type, StringUtils.defaultString((String)((String)record.getValue(c.COLUMN_DEFAULT))).startsWith("nextval"), null);
            result.add(column);
        }
        return result;
    }

    @Override
    protected List<ParameterDefinition> getParameters0() {
        return this.routine.getInParameters();
    }

    @Override
    public boolean isTableValuedFunction() {
        return true;
    }
}

