/*
 * Decompiled with CFR 0.152.
 */
package org.joox;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXB;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.joox.Content;
import org.joox.Context;
import org.joox.Elements;
import org.joox.FastFilter;
import org.joox.Filter;
import org.joox.Impl;
import org.joox.Mapper;
import org.joox.Match;
import org.joox.Util;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JOOX {
    private static final Set<String> TRUE_VALUES = new HashSet<String>();
    private static final Set<String> FALSE_VALUES = new HashSet<String>();
    private static final FastFilter NONE;
    private static final FastFilter ALL;
    private static final FastFilter EVEN;
    private static final FastFilter ODD;

    public static Match $(Object object) {
        Document document = JOOX.builder().newDocument();
        if (object != null) {
            DOMResult result = new DOMResult(document);
            JAXB.marshal((Object)object, (Result)result);
        }
        return JOOX.$(document);
    }

    public static Match $(String name) {
        Document document = JOOX.builder().newDocument();
        DocumentFragment fragment = Util.createContent(document, name);
        if (fragment != null) {
            document.appendChild(fragment);
        } else {
            document.appendChild(document.createElement(name));
        }
        return JOOX.$(document);
    }

    public static Match $(String name, String content) {
        return JOOX.$(name).append(content);
    }

    public static Match $(String name, Element ... content) {
        return JOOX.$(name).append(content);
    }

    public static Match $(String name, Match ... content) {
        return JOOX.$(name).append(content);
    }

    public static Match $(Document document) {
        if (document.getDocumentElement() == null) {
            return new Impl(document);
        }
        return JOOX.$(document.getDocumentElement());
    }

    public static Match $(Element element) {
        return new Impl(element.getOwnerDocument()).addElements(element);
    }

    public static Match $(Node node) {
        if (node instanceof Document) {
            return JOOX.$((Document)node);
        }
        if (node instanceof Element) {
            return JOOX.$((Element)node);
        }
        return JOOX.$(JOOX.builder().newDocument());
    }

    public static Match $(NodeList list) {
        if (list != null && list.getLength() > 0) {
            return new Impl(list.item(0).getOwnerDocument()).addNodeList(list);
        }
        return JOOX.$(JOOX.builder().newDocument());
    }

    public static Match $(Context context) {
        return JOOX.$(context.match());
    }

    public static Match $(File file) throws SAXException, IOException {
        return JOOX.$(JOOX.builder().parse(file));
    }

    public static Match $(InputStream stream) throws SAXException, IOException {
        return JOOX.$(JOOX.builder().parse(stream));
    }

    public static Match $(Reader reader) throws SAXException, IOException {
        return JOOX.$(JOOX.builder().parse(new InputSource(reader)));
    }

    public static Match $(InputSource source) throws SAXException, IOException {
        return JOOX.$(JOOX.builder().parse(source));
    }

    public static FastFilter none() {
        return NONE;
    }

    public static FastFilter all() {
        return ALL;
    }

    public static FastFilter even() {
        return EVEN;
    }

    public static FastFilter odd() {
        return ODD;
    }

    public static FastFilter at(final int ... indexes) {
        return new FastFilter(){

            @Override
            public boolean filter(Context context) {
                for (int i : indexes) {
                    if (i != context.elementIndex()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Filter selector(String selector) {
        return JOOX.tag(selector);
    }

    public static FastFilter tag(final String tagName) {
        if (tagName == null || tagName.equals("")) {
            return JOOX.none();
        }
        return new FastFilter(){

            @Override
            public boolean filter(Context context) {
                return tagName.equals(context.element().getTagName());
            }
        };
    }

    public static Filter and(final Filter ... filters) {
        return new Filter(){

            @Override
            public boolean filter(Context context) {
                for (Filter filter : filters) {
                    if (filter.filter(context)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Filter or(final Filter ... filters) {
        return new Filter(){

            @Override
            public boolean filter(Context context) {
                for (Filter filter : filters) {
                    if (!filter.filter(context)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Filter not(final Filter filter) {
        return new Filter(){

            @Override
            public boolean filter(Context context) {
                return !filter.filter(context);
            }
        };
    }

    public static FastFilter ids(String ... ids) {
        final HashSet<String> set = new HashSet<String>(Arrays.asList(ids));
        return new FastFilter(){

            @Override
            public boolean filter(Context context) {
                return set.contains(context.element().getAttribute("id"));
            }
        };
    }

    public static Content content(final String value) {
        return new Content(){

            @Override
            public String content(Context context) {
                return value;
            }
        };
    }

    public static Mapper<String> ids() {
        return JOOX.attrs("id");
    }

    public static Mapper<String> attrs(final String attributeName) {
        return new Mapper<String>(){

            @Override
            public String map(Context context) {
                return JOOX.$(context.element()).attr(attributeName);
            }
        };
    }

    public static Iterable<Element> iterable(NodeList elements) {
        return new Elements(elements);
    }

    public static Iterator<Element> iterator(NodeList elements) {
        return new Elements(elements).iterator();
    }

    public static List<Element> list(NodeList elements) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (Element element : JOOX.iterable(elements)) {
            list.add(element);
        }
        return list;
    }

    public static DocumentBuilder builder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T convert(String value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type == String.class) {
            return (T)value;
        }
        if (type == Object.class) {
            return (T)value;
        }
        if (type == Byte.class) {
            try {
                return (T)Byte.valueOf(new BigDecimal(value).byteValue());
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == Short.class) {
            try {
                return (T)Short.valueOf(new BigDecimal(value).shortValue());
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == Integer.class) {
            try {
                return (T)Integer.valueOf(new BigDecimal(value).intValue());
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == Long.class) {
            try {
                return (T)Long.valueOf(new BigDecimal(value).longValue());
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == Float.class) {
            try {
                return (T)Float.valueOf(value);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == Double.class) {
            try {
                return (T)Double.valueOf(value);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == BigDecimal.class) {
            try {
                return (T)new BigDecimal(value);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == BigInteger.class) {
            try {
                return (T)new BigDecimal(value).toBigInteger();
            }
            catch (Exception e) {
                return null;
            }
        }
        if (type == Boolean.class) {
            String s = value.toLowerCase();
            if (TRUE_VALUES.contains(s)) {
                return (T)Boolean.TRUE;
            }
            if (FALSE_VALUES.contains(s)) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        return null;
    }

    public static <T> List<T> convert(List<String> values, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        for (String value : values) {
            result.add(JOOX.convert(value, type));
        }
        return result;
    }

    static {
        TRUE_VALUES.add("1");
        TRUE_VALUES.add("y");
        TRUE_VALUES.add("yes");
        TRUE_VALUES.add("true");
        TRUE_VALUES.add("on");
        TRUE_VALUES.add("enabled");
        FALSE_VALUES.add("0");
        FALSE_VALUES.add("n");
        FALSE_VALUES.add("no");
        FALSE_VALUES.add("false");
        FALSE_VALUES.add("off");
        FALSE_VALUES.add("disabled");
        NONE = new FastFilter(){

            @Override
            public boolean filter(Context context) {
                return false;
            }
        };
        ALL = new FastFilter(){

            @Override
            public boolean filter(Context context) {
                return true;
            }
        };
        EVEN = new FastFilter(){

            @Override
            public boolean filter(Context context) {
                return context.elementIndex() % 2 == 0;
            }
        };
        ODD = new FastFilter(){

            @Override
            public boolean filter(Context context) {
                return context.elementIndex() % 2 == 1;
            }
        };
    }
}

