/*
 * Decompiled with CFR 0.152.
 */
package org.jeometry.geom3D.algorithm;

import java.util.Iterator;
import java.util.List;
import org.jeometry.factory.JeometryFactory;
import org.jeometry.geom3D.mesh.indexed.IndexedEdge;
import org.jeometry.geom3D.mesh.indexed.IndexedFace;
import org.jeometry.geom3D.mesh.indexed.IndexedMesh;
import org.jeometry.geom3D.neighbor.MeshNeighborhood;
import org.jeometry.geom3D.point.Point3D;
import org.jeometry.geom3D.point.Point3DContainer;

public class MeshNeighborhoodComputation {
    public static <T extends Point3D> MeshNeighborhood<T> computeNeighborhood(IndexedMesh<T> mesh) {
        Point3DContainer pm;
        MeshNeighborhood neighborhood = null;
        List faces = mesh.getFacesIndexes();
        if (faces != null && mesh.getFacesIndexes().size() > 1 && (pm = mesh.getVerticesSource()) != null) {
            neighborhood = JeometryFactory.createMeshNeighborhood();
            Iterator faceIter = faces.iterator();
            IndexedFace face = null;
            while (faceIter.hasNext()) {
                face = (IndexedFace)faceIter.next();
                for (int i = 0; i < face.getVerticesIndexes().length; ++i) {
                    neighborhood.getIncidences().addIncident(face.getVerticesSource().get(face.getVerticesIndexes()[i]), face);
                }
            }
            faceIter = faces.iterator();
            face = null;
            while (faceIter.hasNext()) {
                face = (IndexedFace)faceIter.next();
                Iterator edgeIter = face.getEdgesIndexed().iterator();
                IndexedEdge edge = null;
                List incidencesEnd1 = null;
                List incidencesEnd2 = null;
                int incidencesEnd1Count = 0;
                int incidencesEnd2Count = 0;
                while (edgeIter.hasNext()) {
                    edge = (IndexedEdge)edgeIter.next();
                    incidencesEnd1 = neighborhood.getIncidences().getIncidences(edge.getEnd1());
                    incidencesEnd2 = neighborhood.getIncidences().getIncidences(edge.getEnd2());
                    if (incidencesEnd1 == null || incidencesEnd2 == null) continue;
                    incidencesEnd1Count = incidencesEnd1.size();
                    incidencesEnd2Count = incidencesEnd2.size();
                    if (incidencesEnd1Count <= 0 || incidencesEnd2Count <= 0) continue;
                    List reference = null;
                    List target = null;
                    if (incidencesEnd1Count < incidencesEnd2Count) {
                        reference = incidencesEnd1;
                        target = incidencesEnd2;
                    } else {
                        reference = incidencesEnd2;
                        target = incidencesEnd1;
                    }
                    Iterator referenceIter = reference.iterator();
                    IndexedFace referenceFace = null;
                    while (referenceIter.hasNext()) {
                        referenceFace = (IndexedFace)referenceIter.next();
                        if (referenceFace == face || !target.contains(referenceFace)) continue;
                        neighborhood.getAdjacencies().addAdjacent(face, referenceFace);
                    }
                }
            }
        }
        return neighborhood;
    }
}

