/*
 * Decompiled with CFR 0.152.
 */
package org.jeometry.geom3D.algorithm.bounds;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.jeometry.Jeometry;
import org.jeometry.factory.JeometryFactory;
import org.jeometry.geom3D.algorithm.convexhull.quickhull.QuickHull;
import org.jeometry.geom3D.mesh.Face;
import org.jeometry.geom3D.mesh.Mesh;
import org.jeometry.geom3D.point.Point3D;
import org.jeometry.geom3D.point.Point3DContainer;
import org.jeometry.math.Matrix;
import org.jeometry.math.Vector;
import org.jeometry.math.solver.Solver;

public class MinimalEnclosingParallelepipede {
    public static double ZERO_LIMIT = 1.0E-6;

    public static Mesh<Point3D> computeMinimalEnclosingParallelepiped(Point3DContainer<Point3D> p3dm) {
        Mesh<Point3D> c = QuickHull.computeConvexHull(p3dm, true);
        if (c == null) {
            return null;
        }
        Point3DContainer[] antipodals = new Point3DContainer[c.getFaces().size()];
        Point3D[] normals = new Point3D[c.getFaces().size()];
        double[] thicknesses = new double[c.getFaces().size()];
        antipodals = MinimalEnclosingParallelepipede.polyhedronAntipodals(c, thicknesses, normals);
        for (int i = 0; i < c.getFaces().size(); ++i) {
            double norme = Math.sqrt(normals[i].getX() * normals[i].getX() + normals[i].getY() * normals[i].getY() + normals[i].getZ() * normals[i].getZ());
            normals[i].setX(normals[i].getX() * (thicknesses[i] / norme));
            normals[i].setY(normals[i].getY() * (thicknesses[i] / norme));
            normals[i].setZ(normals[i].getZ() * (thicknesses[i] / norme));
        }
        int[] triplet_solution = new int[3];
        MinimalEnclosingParallelepipede.minimalEnclosingParallelepiped_bestTriplet(triplet_solution, c, normals);
        return MinimalEnclosingParallelepipede.minimalEnclosingParallelepiped_computeParallelepiped(triplet_solution, c, normals, antipodals);
    }

    private static Point3DContainer<Point3D>[] polyhedronAntipodals(Mesh<?> polyhedron, double[] thicknesses, Point3D[] normals) {
        List faces = polyhedron.getFaces();
        Point3DContainer vertices = polyhedron.getVertices();
        double distance = -1.0;
        double distanceMax = -1.0;
        Point3D v1 = null;
        Point3D v2 = null;
        Point3D normal = null;
        double a = 0.0;
        double b = 0.0;
        double c = 0.0;
        double d = 0.0;
        Point3DContainer[] antipodals = new Point3DContainer[faces.size()];
        Iterator iter = null;
        Face currentFace = null;
        int i = 0;
        iter = faces.iterator();
        i = 0;
        while (iter.hasNext()) {
            distanceMax = -1.0;
            antipodals[i] = JeometryFactory.createPoint3DContainer();
            currentFace = (Face)iter.next();
            v1 = currentFace.getVertices().get(1).minus(currentFace.getVertices().get(0));
            v2 = currentFace.getVertices().get(2).minus(currentFace.getVertices().get(0));
            normals[i] = normal = v1.cross(v2);
            a = normal.getX();
            b = normal.getY();
            c = normal.getZ();
            d = -a * currentFace.getVertices().get(0).getX() - b * currentFace.getVertices().get(0).getY() - c * currentFace.getVertices().get(0).getZ();
            for (int j = 0; j < vertices.size(); ++j) {
                distance = Math.abs((a * vertices.get(j).getX() + b * vertices.get(j).getY() + c * vertices.get(j).getZ() + d) / Math.sqrt(a * a + b * b + c * c));
                if (distance > distanceMax + ZERO_LIMIT) {
                    distanceMax = distance;
                    if (antipodals[i].size() > 0) {
                        antipodals[i].clear();
                    }
                    antipodals[i].add(vertices.get(j));
                    continue;
                }
                if (!(Math.abs(distance - distanceMax) < ZERO_LIMIT)) continue;
                antipodals[i].add(vertices.get(j));
            }
            thicknesses[i] = distanceMax;
            ++i;
        }
        return antipodals;
    }

    private static double minimalEnclosingParallelepiped_bestTriplet(int[] triplet_solution, Mesh<? extends Point3D> polyhedron, Point3D[] normals) {
        int j;
        int i;
        Face[] faces = new Face[polyhedron.getFaces().size()];
        faces = polyhedron.getFaces().toArray(faces);
        double[] thicknesses = new double[faces.length];
        Point3DContainer<Point3D>[] antipodals = MinimalEnclosingParallelepipede.polyhedronAntipodals(polyhedron, thicknesses, normals);
        int _nb_sommets_par_facette = 3;
        int _nb_facettes = polyhedron.getFaces().size();
        Point3D vecteur_temp = null;
        int[] nb_candidats_par_facette = new int[_nb_facettes];
        int[][] candidats_des_facettes = new int[_nb_facettes][100];
        for (int i2 = 0; i2 < _nb_facettes; ++i2) {
            candidats_des_facettes[i2] = null;
        }
        int[] temp_candidats = new int[_nb_facettes];
        int taille = 3;
        for (int i3 = 0; i3 < _nb_facettes; ++i3) {
            int taille_temp = 3 * antipodals[i3].size();
            if (taille_temp <= taille) continue;
            taille = taille_temp;
        }
        Point3D[] vecteurs = new Point3D[taille];
        Point3D[] vecteurs_bis = new Point3D[taille];
        for (i = 0; i < _nb_facettes; ++i) {
            int k;
            nb_candidats_par_facette[i] = 0;
            taille = _nb_sommets_par_facette * antipodals[i].size();
            int compteur = 0;
            for (j = 0; j < faces[i].getVertices().size(); ++j) {
                for (k = 0; k < antipodals[i].size(); ++k) {
                    vecteurs[compteur] = faces[i].getVertices().get(j).minus(antipodals[i].get(k));
                    ++compteur;
                }
            }
            for (j = i + 1; j < faces.length; ++j) {
                if (!MinimalEnclosingParallelepipede.minimalEnclosingParallelepiped_tesCandidat(vecteurs, normals[j])) continue;
                compteur = 0;
                for (k = 0; k < faces[j].getVertices().size(); ++k) {
                    for (int l = 0; l < antipodals[j].size(); ++l) {
                        vecteurs_bis[compteur] = faces[j].getVertices().get(k).minus(antipodals[j].get(l));
                        ++compteur;
                    }
                }
                if (!MinimalEnclosingParallelepipede.minimalEnclosingParallelepiped_tesCandidat(vecteurs_bis, normals[i])) continue;
                temp_candidats[nb_candidats_par_facette[i]] = j;
                int n = i;
                nb_candidats_par_facette[n] = nb_candidats_par_facette[n] + 1;
            }
            candidats_des_facettes[i] = new int[nb_candidats_par_facette[i]];
            for (j = 0; j < nb_candidats_par_facette[i]; ++j) {
                candidats_des_facettes[i][j] = temp_candidats[j];
            }
        }
        double volume_min = -1.0;
        for (i = 0; i < _nb_facettes; ++i) {
            double produit_temp1 = thicknesses[i] * thicknesses[i];
            for (j = 0; j < nb_candidats_par_facette[i]; ++j) {
                int face_2 = candidats_des_facettes[i][j];
                vecteur_temp = normals[i].cross(normals[face_2]);
                double produit_temp2 = thicknesses[face_2] * thicknesses[face_2] * produit_temp1;
                int depart_1 = j + 1;
                int longueur_1 = nb_candidats_par_facette[i];
                int depart_2 = 0;
                int longueur_2 = nb_candidats_par_facette[face_2];
                while (depart_1 < longueur_1 && depart_2 < longueur_2) {
                    while (depart_1 < longueur_1 && depart_2 < longueur_2 && candidats_des_facettes[i][depart_1] != candidats_des_facettes[face_2][depart_2]) {
                        if (candidats_des_facettes[i][depart_1] < candidats_des_facettes[face_2][depart_2]) {
                            ++depart_1;
                            continue;
                        }
                        ++depart_2;
                    }
                    if (depart_1 >= longueur_1 || depart_2 >= longueur_2) continue;
                    int face_3 = candidats_des_facettes[i][depart_1];
                    double scalaire_temp = Math.abs(vecteur_temp.dot(normals[face_3]));
                    if (scalaire_temp > ZERO_LIMIT) {
                        double volume_temporaire = Math.abs(produit_temp2 * thicknesses[face_3] * thicknesses[face_3] / scalaire_temp);
                        if (volume_min < 0.0 || volume_temporaire < volume_min) {
                            volume_min = volume_temporaire;
                            triplet_solution[0] = i;
                            triplet_solution[1] = face_2;
                            triplet_solution[2] = face_3;
                        }
                    }
                    ++depart_1;
                    ++depart_2;
                }
            }
        }
        return volume_min;
    }

    private static Mesh<Point3D> minimalEnclosingParallelepiped_computeParallelepiped(int[] triplet_solution, Mesh<?> polyhedron, Point3D[] normals, Point3DContainer<?>[] antipodals) {
        boolean computationOK;
        double[][] parallelepipedVertices;
        Mesh parallelepiped;
        block42: {
            parallelepiped = null;
            double[] P1 = new double[4];
            double[] P2 = new double[4];
            double[] P3 = new double[4];
            double[] P1prime = new double[4];
            double[] P2prime = new double[4];
            double[] P3prime = new double[4];
            parallelepipedVertices = new double[8][3];
            computationOK = true;
            Point3D point0 = null;
            double[][] coefficientsData = null;
            point0 = antipodals[triplet_solution[0]].get(0);
            P1[0] = normals[triplet_solution[0]].getX();
            P1[1] = normals[triplet_solution[0]].getY();
            P1[2] = normals[triplet_solution[0]].getZ();
            P1[3] = -(point0.getX() * normals[triplet_solution[0]].getX() + point0.getY() * normals[triplet_solution[0]].getY() + point0.getZ() * normals[triplet_solution[0]].getZ());
            P1prime[0] = P1[0];
            P1prime[1] = P1[1];
            P1prime[2] = P1[2];
            P1prime[3] = P1prime[0] * antipodals[triplet_solution[0]].get(0).getX() + P1prime[1] * antipodals[triplet_solution[0]].get(0).getY() + P1prime[2] * antipodals[triplet_solution[0]].get(0).getZ();
            point0 = antipodals[triplet_solution[1]].get(0);
            P2[0] = normals[triplet_solution[1]].getX();
            P2[1] = normals[triplet_solution[1]].getY();
            P2[2] = normals[triplet_solution[1]].getZ();
            P2[3] = -(point0.getX() * normals[triplet_solution[1]].getX() + point0.getY() * normals[triplet_solution[1]].getY() + point0.getZ() * normals[triplet_solution[1]].getZ());
            P2prime[0] = P2[0];
            P2prime[1] = P2[1];
            P2prime[2] = P2[2];
            P2prime[3] = P2prime[0] * antipodals[triplet_solution[1]].get(0).getX() + P2prime[1] * antipodals[triplet_solution[1]].get(0).getY() + P2prime[2] * antipodals[triplet_solution[1]].get(0).getZ();
            point0 = antipodals[triplet_solution[2]].get(0);
            P3[0] = normals[triplet_solution[2]].getX();
            P3[1] = normals[triplet_solution[2]].getY();
            P3[2] = normals[triplet_solution[2]].getZ();
            P3[3] = -(point0.getX() * normals[triplet_solution[2]].getX() + point0.getY() * normals[triplet_solution[2]].getY() + point0.getZ() * normals[triplet_solution[2]].getZ());
            P3prime[0] = P3[0];
            P3prime[1] = P3[1];
            P3prime[2] = P3[2];
            P3prime[3] = P3prime[0] * antipodals[triplet_solution[2]].get(0).getX() + P3prime[1] * antipodals[triplet_solution[2]].get(0).getY() + P3prime[2] * antipodals[triplet_solution[2]].get(0).getZ();
            Solver solver = JeometryFactory.createSolver();
            if (solver != null) {
                coefficientsData = new double[3][3];
                for (int i = 0; i < 3; ++i) {
                    coefficientsData[0][i] = P1[i];
                    coefficientsData[1][i] = P2[i];
                    coefficientsData[2][i] = P3[i];
                }
                Matrix coefficients = JeometryFactory.createMatrix((double[][])coefficientsData);
                Vector constants = JeometryFactory.createVector((double[])new double[]{P1[3], P2[3], P3[3]});
                Vector solution = JeometryFactory.createVector((Vector)constants);
                try {
                    if (solver.solve(coefficients, constants, solution) != null) {
                        parallelepipedVertices[0][0] = solution.getValue(0);
                        parallelepipedVertices[0][1] = solution.getValue(1);
                        parallelepipedVertices[0][3] = solution.getValue(2);
                    } else {
                        Jeometry.logger.log(Level.SEVERE, "Cannot solve linear system");
                        parallelepipedVertices[0] = null;
                        computationOK = false;
                    }
                }
                catch (Exception e) {
                    Jeometry.logger.log(Level.SEVERE, "Cannot solve linear system: " + e.getMessage(), e);
                    parallelepipedVertices[0] = null;
                    computationOK = false;
                }
                for (int i = 0; i < 3; ++i) {
                    coefficientsData[0][i] = P1[i];
                    coefficientsData[1][i] = P2[i];
                    coefficientsData[2][i] = P3prime[i];
                }
                coefficients = JeometryFactory.createMatrix((double[][])coefficientsData);
                constants = JeometryFactory.createVector((double[])new double[]{P1[3], P2[3], P3prime[3]});
                solution = JeometryFactory.createVector((Vector)constants);
                try {
                    if (solver.solve(coefficients, constants, solution) != null) {
                        parallelepipedVertices[1][0] = solution.getValue(0);
                        parallelepipedVertices[1][1] = solution.getValue(1);
                        parallelepipedVertices[1][3] = solution.getValue(2);
                    } else {
                        Jeometry.logger.log(Level.SEVERE, "Cannot solve linear system");
                        parallelepipedVertices[1] = null;
                        computationOK = false;
                    }
                }
                catch (Exception e) {
                    Jeometry.logger.log(Level.SEVERE, "Cannot solve linear system: " + e.getMessage(), e);
                    parallelepipedVertices[1] = null;
                    computationOK = false;
                }
                for (int i = 0; i < 3; ++i) {
                    coefficientsData[0][i] = P1[i];
                    coefficientsData[1][i] = P2prime[i];
                    coefficientsData[2][i] = P3prime[i];
                }
                coefficients = JeometryFactory.createMatrix((double[][])coefficientsData);
                constants = JeometryFactory.createVector((double[])new double[]{P1[3], P2prime[3], P3prime[3]});
                solution = JeometryFactory.createVector((Vector)constants);
                try {
                    if (solver.solve(coefficients, constants, solution) != null) {
                        parallelepipedVertices[2][0] = solution.getValue(0);
                        parallelepipedVertices[2][1] = solution.getValue(1);
                        parallelepipedVertices[2][3] = solution.getValue(2);
                    } else {
                        Jeometry.logger.log(Level.SEVERE, "Cannot solve linear system");
                        parallelepipedVertices[2] = null;
                        computationOK = false;
                    }
                }
                catch (Exception e) {
                    Jeometry.logger.log(Level.SEVERE, "Cannot solve linear system: " + e.getMessage(), e);
                    parallelepipedVertices[2] = null;
                    computationOK = false;
                }
                for (int i = 0; i < 3; ++i) {
                    coefficientsData[0][i] = P1[i];
                    coefficientsData[1][i] = P2prime[i];
                    coefficientsData[2][i] = P3[i];
                }
                coefficients = JeometryFactory.createMatrix((double[][])coefficientsData);
                constants = JeometryFactory.createVector((double[])new double[]{P1[3], P2prime[3], P3[3]});
                solution = JeometryFactory.createVector((Vector)constants);
                try {
                    if (solver.solve(coefficients, constants, solution) != null) {
                        parallelepipedVertices[3][0] = solution.getValue(0);
                        parallelepipedVertices[3][1] = solution.getValue(1);
                        parallelepipedVertices[3][3] = solution.getValue(2);
                    } else {
                        Jeometry.logger.log(Level.SEVERE, "Cannot solve linear system");
                        parallelepipedVertices[3] = null;
                        computationOK = false;
                    }
                }
                catch (Exception e) {
                    Jeometry.logger.log(Level.SEVERE, "Cannot solve linear system: " + e.getMessage(), e);
                    parallelepipedVertices[3] = null;
                    computationOK = false;
                }
                for (int i = 0; i < 3; ++i) {
                    coefficientsData[0][i] = P1prime[i];
                    coefficientsData[1][i] = P2[i];
                    coefficientsData[2][i] = P3[i];
                }
                coefficients = JeometryFactory.createMatrix((double[][])coefficientsData);
                constants = JeometryFactory.createVector((double[])new double[]{P1prime[3], P2[3], P3[3]});
                solution = JeometryFactory.createVector((Vector)constants);
                try {
                    if (solver.solve(coefficients, constants, solution) != null) {
                        parallelepipedVertices[4][0] = solution.getValue(0);
                        parallelepipedVertices[4][1] = solution.getValue(1);
                        parallelepipedVertices[4][3] = solution.getValue(2);
                    } else {
                        Jeometry.logger.log(Level.SEVERE, "Cannot solve linear system");
                        parallelepipedVertices[4] = null;
                        computationOK = false;
                    }
                }
                catch (Exception e) {
                    Jeometry.logger.log(Level.SEVERE, "Cannot solve linear system: " + e.getMessage(), e);
                    parallelepipedVertices[4] = null;
                    computationOK = false;
                }
                for (int i = 0; i < 3; ++i) {
                    coefficientsData[0][i] = P1prime[i];
                    coefficientsData[1][i] = P2[i];
                    coefficientsData[2][i] = P3prime[i];
                }
                coefficients = JeometryFactory.createMatrix((double[][])coefficientsData);
                constants = JeometryFactory.createVector((double[])new double[]{P1prime[3], P2[3], P3prime[3]});
                solution = JeometryFactory.createVector((Vector)constants);
                try {
                    if (solver.solve(coefficients, constants, solution) != null) {
                        parallelepipedVertices[5][0] = solution.getValue(0);
                        parallelepipedVertices[5][1] = solution.getValue(1);
                        parallelepipedVertices[5][3] = solution.getValue(2);
                    } else {
                        Jeometry.logger.log(Level.SEVERE, "Cannot solve linear system");
                        parallelepipedVertices[5] = null;
                        computationOK = false;
                    }
                }
                catch (Exception e) {
                    Jeometry.logger.log(Level.SEVERE, "Cannot solve linear system: " + e.getMessage(), e);
                    parallelepipedVertices[5] = null;
                    computationOK = false;
                }
                for (int i = 0; i < 3; ++i) {
                    coefficientsData[0][i] = P1prime[i];
                    coefficientsData[1][i] = P2prime[i];
                    coefficientsData[2][i] = P3prime[i];
                }
                coefficients = JeometryFactory.createMatrix((double[][])coefficientsData);
                constants = JeometryFactory.createVector((double[])new double[]{P1prime[3], P2prime[3], P3prime[3]});
                solution = JeometryFactory.createVector((Vector)constants);
                try {
                    if (solver.solve(coefficients, constants, solution) != null) {
                        parallelepipedVertices[6][0] = solution.getValue(0);
                        parallelepipedVertices[6][1] = solution.getValue(1);
                        parallelepipedVertices[6][3] = solution.getValue(2);
                    } else {
                        Jeometry.logger.log(Level.SEVERE, "Cannot solve linear system");
                        parallelepipedVertices[6] = null;
                        computationOK = false;
                    }
                }
                catch (Exception e) {
                    Jeometry.logger.log(Level.SEVERE, "Cannot solve linear system: " + e.getMessage(), e);
                    parallelepipedVertices[6] = null;
                    computationOK = false;
                }
                for (int i = 0; i < 3; ++i) {
                    coefficientsData[0][i] = P1prime[i];
                    coefficientsData[1][i] = P2prime[i];
                    coefficientsData[2][i] = P3[i];
                }
                coefficients = JeometryFactory.createMatrix((double[][])coefficientsData);
                constants = JeometryFactory.createVector((double[])new double[]{P1prime[3], P2prime[3], P3[3]});
                solution = JeometryFactory.createVector((Vector)constants);
                try {
                    if (solver.solve(coefficients, constants, solution) != null) {
                        parallelepipedVertices[7][0] = solution.getValue(0);
                        parallelepipedVertices[7][1] = solution.getValue(1);
                        parallelepipedVertices[7][3] = solution.getValue(2);
                        break block42;
                    }
                    Jeometry.logger.log(Level.SEVERE, "Cannot solve linear system");
                    parallelepipedVertices[7] = null;
                    computationOK = false;
                }
                catch (Exception e) {
                    Jeometry.logger.log(Level.SEVERE, "Cannot solve linear system: " + e.getMessage(), e);
                    parallelepipedVertices[7] = null;
                    computationOK = false;
                }
            } else {
                computationOK = false;
            }
        }
        if (computationOK) {
            Point3D pt1 = JeometryFactory.createPoint3D((double)parallelepipedVertices[5][0], (double)parallelepipedVertices[5][1], (double)parallelepipedVertices[5][2]);
            Point3D pt2 = JeometryFactory.createPoint3D((double)parallelepipedVertices[4][0], (double)parallelepipedVertices[4][1], (double)parallelepipedVertices[4][2]);
            Point3D pt3 = JeometryFactory.createPoint3D((double)parallelepipedVertices[0][0], (double)parallelepipedVertices[0][1], (double)parallelepipedVertices[0][2]);
            Point3D pt4 = JeometryFactory.createPoint3D((double)parallelepipedVertices[1][0], (double)parallelepipedVertices[1][1], (double)parallelepipedVertices[1][2]);
            Point3D pt5 = JeometryFactory.createPoint3D((double)parallelepipedVertices[6][0], (double)parallelepipedVertices[6][1], (double)parallelepipedVertices[6][2]);
            Point3D pt6 = JeometryFactory.createPoint3D((double)parallelepipedVertices[7][0], (double)parallelepipedVertices[7][1], (double)parallelepipedVertices[7][2]);
            Point3D pt7 = JeometryFactory.createPoint3D((double)parallelepipedVertices[3][0], (double)parallelepipedVertices[3][1], (double)parallelepipedVertices[3][2]);
            Point3D pt8 = JeometryFactory.createPoint3D((double)parallelepipedVertices[2][0], (double)parallelepipedVertices[2][1], (double)parallelepipedVertices[2][2]);
            parallelepiped = JeometryFactory.createMesh();
            Point3DContainer points = JeometryFactory.createPoint3DContainer((int)4);
            points.add(pt4);
            points.add(pt3);
            points.add(pt2);
            points.add(pt1);
            parallelepiped.addFace(JeometryFactory.createMeshFace((Mesh)parallelepiped, (Point3DContainer)points));
            points = JeometryFactory.createPoint3DContainer((int)4);
            points.add(pt5);
            points.add(pt6);
            points.add(pt7);
            points.add(pt8);
            parallelepiped.addFace(JeometryFactory.createMeshFace((Mesh)parallelepiped, (Point3DContainer)points));
            points = JeometryFactory.createPoint3DContainer((int)4);
            points.add(pt1);
            points.add(pt2);
            points.add(pt6);
            points.add(pt5);
            parallelepiped.addFace(JeometryFactory.createMeshFace((Mesh)parallelepiped, (Point3DContainer)points));
            points = JeometryFactory.createPoint3DContainer((int)4);
            points.add(pt4);
            points.add(pt8);
            points.add(pt7);
            points.add(pt3);
            parallelepiped.addFace(JeometryFactory.createMeshFace((Mesh)parallelepiped, (Point3DContainer)points));
            points = JeometryFactory.createPoint3DContainer((int)4);
            points.add(pt1);
            points.add(pt5);
            points.add(pt8);
            points.add(pt4);
            parallelepiped.addFace(JeometryFactory.createMeshFace((Mesh)parallelepiped, (Point3DContainer)points));
            points = JeometryFactory.createPoint3DContainer((int)4);
            points.add(pt3);
            points.add(pt7);
            points.add(pt6);
            points.add(pt2);
            parallelepiped.addFace(JeometryFactory.createMeshFace((Mesh)parallelepiped, (Point3DContainer)points));
            return parallelepiped;
        }
        return null;
    }

    private static boolean minimalEnclosingParallelepiped_tesCandidat(Point3D[] vecteurs, Point3D normale_facette2) {
        double sign = 0.0;
        double produit_scalaire = 0.0;
        produit_scalaire = vecteurs[0].dot(normale_facette2);
        sign = produit_scalaire < 0.0 ? -1.0 : 1.0;
        for (int i = 1; i < vecteurs.length; ++i) {
            produit_scalaire = 0.0;
            if (vecteurs[i] == null) continue;
            if ((produit_scalaire += vecteurs[i].dot(normale_facette2)) < 0.0 && sign == 1.0) {
                return true;
            }
            if (!(produit_scalaire > 0.0) || sign != -1.0) continue;
            return true;
        }
        return false;
    }
}

