/*
 * Decompiled with CFR 0.152.
 */
package org.jeometry.geom3D.algorithm.convexhull.quickhull;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jeometry.factory.JeometryFactory;
import org.jeometry.geom3D.Geom3D;
import org.jeometry.geom3D.mesh.Edge;
import org.jeometry.geom3D.mesh.Face;
import org.jeometry.geom3D.mesh.Mesh;
import org.jeometry.geom3D.point.Point3D;
import org.jeometry.geom3D.point.Point3DContainer;
import org.jeometry.geom3D.primitive.Polygon3D;
import org.jeometry.geom3D.primitive.Triangle;

public class QuickHull {
    private static int volumeSign(Polygon3D<?> polygon, Point3D p) {
        Point3D v1 = polygon.getVertices().get(0);
        Point3D v2 = polygon.getVertices().get(1);
        Point3D v3 = polygon.getVertices().get(2);
        double ax = v1.getX() - p.getX();
        double ay = v1.getY() - p.getY();
        double az = v1.getZ() - p.getZ();
        double bx = v2.getX() - p.getX();
        double by = v2.getY() - p.getY();
        double bz = v2.getZ() - p.getZ();
        double cx = v3.getX() - p.getX();
        double cy = v3.getY() - p.getY();
        double cz = v3.getZ() - p.getZ();
        double vol = ax * (by * cz - bz * cy) + ay * (bz * cx - bx * cz) + az * (bx * cy - by * cx);
        if (vol > 0.0) {
            return 1;
        }
        if (vol < 0.0) {
            return -1;
        }
        return 0;
    }

    private static <T extends Point3D> Point3DContainer<T> aklToussaintVertices(Point3DContainer<T> points) {
        int i;
        Point3DContainer aklToussaintPoints = null;
        double xmin = 0.0;
        double xmax = 0.0;
        double ymin = 0.0;
        double ymax = 0.0;
        double zmin = 0.0;
        double zmax = 0.0;
        Point3D pt = null;
        if (points == null || points.size() < 1) {
            return null;
        }
        pt = points.get(0);
        xmin = pt.getX();
        xmax = pt.getX();
        ymin = pt.getY();
        ymax = pt.getY();
        zmin = pt.getZ();
        zmax = pt.getZ();
        for (i = 1; i < points.size(); ++i) {
            pt = points.get(i);
            if (pt.getX() < xmin) {
                xmin = pt.getX();
            }
            if (pt.getY() < ymin) {
                ymin = pt.getY();
            }
            if (pt.getZ() < zmin) {
                zmin = pt.getZ();
            }
            if (pt.getX() > xmax) {
                xmax = pt.getX();
            }
            if (pt.getY() > ymax) {
                ymax = pt.getY();
            }
            if (pt.getZ() > zmax) {
                zmax = pt.getZ();
            }
            pt = null;
        }
        aklToussaintPoints = JeometryFactory.createPoint3DContainer();
        for (i = 1; i < points.size(); ++i) {
            pt = points.get(i);
            if (pt.getX() <= xmin) {
                aklToussaintPoints.add(pt);
                continue;
            }
            if (pt.getY() <= ymin) {
                aklToussaintPoints.add(pt);
                continue;
            }
            if (pt.getZ() <= zmin) {
                aklToussaintPoints.add(pt);
                continue;
            }
            if (pt.getX() >= xmax) {
                aklToussaintPoints.add(pt);
                continue;
            }
            if (pt.getY() >= ymax) {
                aklToussaintPoints.add(pt);
                continue;
            }
            if (!(pt.getZ() >= zmax)) continue;
            aklToussaintPoints.add(pt);
        }
        return aklToussaintPoints;
    }

    private static <T extends Point3D> Point3DContainer<T> computeAklToussainPoints(Point3DContainer<T> points) {
        Point3DContainer<T> aklToussaintPoints = null;
        Point3DContainer filteredVertices = null;
        Point3D pt = null;
        Mesh<T> convexHull = null;
        aklToussaintPoints = QuickHull.aklToussaintVertices(points);
        if (aklToussaintPoints != null && (convexHull = QuickHull.computeConvexHull(aklToussaintPoints, false)) != null) {
            filteredVertices = JeometryFactory.createPoint3DContainer();
            for (int i = 0; i < points.size(); ++i) {
                pt = points.get(i);
                if (!Geom3D.contains(convexHull, (Point3D)pt)) {
                    filteredVertices.add(pt);
                }
                pt = null;
            }
        }
        aklToussaintPoints = null;
        convexHull = null;
        return filteredVertices;
    }

    private static <T extends Point3D> void addVertexToConvexHull(Mesh<T> convexHull, T vertex) {
        int i;
        LinkedList<Edge<T>> visEdges = new LinkedList<Edge<T>>();
        LinkedList<Face> visFaces = new LinkedList<Face>();
        Point3DContainer points = JeometryFactory.createPoint3DContainer((int)3);
        for (Face face : convexHull.getFaces()) {
            try {
                if (QuickHull.volumeSign(face, vertex) >= 0) continue;
                visFaces.add(face);
            }
            catch (Exception exception) {}
        }
        for (i = 0; i < visFaces.size(); ++i) {
            Face face = (Face)visFaces.get(i);
            QuickHull.deleteVisibleFace(convexHull, face, visEdges);
        }
        for (i = 0; i < visEdges.size(); ++i) {
            Edge edge = (Edge)visEdges.get(i);
            points.add(edge.getVertices().get(0));
            points.add(edge.getVertices().get(1));
            points.add(vertex);
            convexHull.addFace(JeometryFactory.createMeshFace((Point3DContainer)points));
        }
        visEdges = null;
        visFaces = null;
        points = null;
        Iterator iter = null;
    }

    private static <T extends Point3D> void deleteVisibleFace(Mesh<T> convexHull, Face<T> face, List<Edge<T>> visibleEdges) {
        Point3DContainer p3dm = face.getVertices();
        Point3D v1 = p3dm.get(0);
        Point3D v2 = p3dm.get(1);
        Point3D v3 = p3dm.get(2);
        Edge e1 = JeometryFactory.createMeshEdge(convexHull, (Point3D)v1, (Point3D)v2);
        Edge e2 = JeometryFactory.createMeshEdge(convexHull, (Point3D)v2, (Point3D)v3);
        Edge e3 = JeometryFactory.createMeshEdge(convexHull, (Point3D)v3, (Point3D)v1);
        QuickHull.updateVisibleEdges(e1, visibleEdges);
        QuickHull.updateVisibleEdges(e2, visibleEdges);
        QuickHull.updateVisibleEdges(e3, visibleEdges);
        convexHull.removeFace(face);
    }

    private static <T extends Point3D> void updateVisibleEdges(Edge<T> e, List<Edge<T>> visibleEdges) {
        boolean same = false;
        for (Edge<T> edge : visibleEdges) {
            if (!e.equals(edge)) continue;
            same = true;
            e = edge;
            break;
        }
        if (same) {
            visibleEdges.remove(e);
        } else {
            visibleEdges.add(e);
        }
    }

    public static <T extends Point3D> Mesh<T> computeConvexHull(Point3DContainer<T> points, boolean useAklToussaint) {
        Iterator e;
        Point3DContainer<T> aklToussaintPoints;
        Mesh convexHull = JeometryFactory.createMesh();
        if (points.size() < 4) {
            return null;
        }
        if (useAklToussaint && (aklToussaintPoints = QuickHull.computeAklToussainPoints(points)) != null) {
            points = aklToussaintPoints;
        }
        if ((e = points.iterator()).hasNext()) {
            Point3D v1 = (Point3D)e.next();
            Point3D v2 = null;
            while (e.hasNext() && Geom3D.equals((Point3D)v1, (Point3D)(v2 = (Point3D)e.next()))) {
            }
            Point3D v3 = null;
            Triangle t = null;
            Point3D pt0 = null;
            Point3D pt1 = null;
            Point3D pt2 = null;
            LinkedList<Point3D> coVerts = new LinkedList<Point3D>();
            while (e.hasNext()) {
                v3 = (Point3D)e.next();
                if (Geom3D.collinear((Point3D)v1, (Point3D)v2, (Point3D)v3)) {
                    coVerts.add(v3);
                    continue;
                }
                pt0 = v1;
                pt1 = v2;
                pt2 = v3;
                t = JeometryFactory.createMeshTriangle((Point3D)v1, (Point3D)v2, (Point3D)v3);
                break;
            }
            Point3D v4 = null;
            Point3DContainer pointsFace = null;
            while (e.hasNext()) {
                v4 = (Point3D)e.next();
                int volSign = QuickHull.volumeSign(t, v4);
                if (volSign == 0) {
                    coVerts.add(v4);
                    continue;
                }
                convexHull.addFace((Face)t);
                Point3D tv1 = pt0;
                Point3D tv2 = pt1;
                Point3D tv3 = pt2;
                if (volSign < 0) {
                    t.inverseVerticesOrder();
                    Point3D tv = tv1;
                    tv1 = tv3;
                    tv3 = tv;
                }
                pointsFace = JeometryFactory.createPoint3DContainer((int)3);
                pointsFace.add(tv3);
                pointsFace.add(tv2);
                pointsFace.add(v4);
                convexHull.addFace(JeometryFactory.createMeshFace((Point3DContainer)pointsFace));
                pointsFace = JeometryFactory.createPoint3DContainer((int)3);
                pointsFace.add(tv2);
                pointsFace.add(tv1);
                pointsFace.add(v4);
                convexHull.addFace(JeometryFactory.createMeshFace((Point3DContainer)pointsFace));
                pointsFace = JeometryFactory.createPoint3DContainer((int)3);
                pointsFace.add(tv1);
                pointsFace.add(tv3);
                pointsFace.add(v4);
                convexHull.addFace(JeometryFactory.createMeshFace((Point3DContainer)pointsFace));
                break;
            }
            while (e.hasNext()) {
                QuickHull.addVertexToConvexHull(convexHull, (Point3D)e.next());
            }
            if (convexHull.getFaces().size() > 0) {
                e = coVerts.iterator();
                while (e.hasNext()) {
                    QuickHull.addVertexToConvexHull(convexHull, (Point3D)e.next());
                }
            } else {
                return null;
            }
        }
        return convexHull;
    }
}

