/*
 * Decompiled with CFR 0.152.
 */
package org.jeometry.geom3D.algorithm.delaunay.clarkson;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.jeometry.Jeometry;
import org.jeometry.factory.JeometryFactory;
import org.jeometry.geom3D.algorithm.delaunay.clarkson.DelaunayTetrahedron;
import org.jeometry.geom3D.algorithm.delaunay.clarkson.VoronoiTriangle;
import org.jeometry.geom3D.mesh.indexed.IndexedFace;
import org.jeometry.geom3D.point.Point3D;
import org.jeometry.geom3D.point.Point3DContainer;
import org.jeometry.geom3D.primitive.indexed.IndexedTetrahedron;

public class DelaunayTetrahedralization<T extends Point3D> {
    private Point3DContainer<T> points = null;
    private List<DelaunayTetrahedron<T>> tetrahedra = null;
    private HashMap<Point3D, Collection<DelaunayTetrahedron<T>>> incidentTetrahedra = null;
    private HashMap<Point3D, Collection<IndexedFace<T>>> incidentFaces = null;
    private HashMap<DelaunayTetrahedron<T>, List<DelaunayTetrahedron<T>>> neighbors = null;

    public DelaunayTetrahedralization(Point3DContainer<T> points, int tetrahedraCount) {
        this.points = points;
        this.tetrahedra = new ArrayList<DelaunayTetrahedron<T>>(tetrahedraCount);
    }

    public List<DelaunayTetrahedron<T>> getTetrahedra() {
        return this.tetrahedra;
    }

    public Point3DContainer<T> getPoints() {
        return this.points;
    }

    public DelaunayTetrahedron<T> addTetrahedron(int[] vertexIndices) {
        DelaunayTetrahedron<T> tetrahedron;
        boolean success;
        if (this.tetrahedra == null) {
            this.tetrahedra = new LinkedList<DelaunayTetrahedron<T>>();
        }
        if (success = this.tetrahedra.add(tetrahedron = new DelaunayTetrahedron<T>(vertexIndices[0], vertexIndices[1], vertexIndices[2], vertexIndices[3], true, this.points))) {
            return tetrahedron;
        }
        return null;
    }

    public DelaunayTetrahedron<T> addTetrahedron(DelaunayTetrahedron<T> tetrahedron) {
        boolean success;
        if (this.tetrahedra == null) {
            this.tetrahedra = new LinkedList<DelaunayTetrahedron<T>>();
        }
        if (success = this.tetrahedra.add(tetrahedron)) {
            tetrahedron.setVerticesSource(this.getPoints());
            return tetrahedron;
        }
        return null;
    }

    public Collection<DelaunayTetrahedron<T>> getIncidentTetrahedra(Point3D point) {
        return this.incidentTetrahedra.get(point);
    }

    public Collection<DelaunayTetrahedron<T>> getIncidentTetrahedra(Point3D u, Point3D v) {
        Collection<DelaunayTetrahedron<T>> ic = this.getIncidentTetrahedra(u);
        for (DelaunayTetrahedron<T> c : ic) {
            if (!c.isVertex(v)) continue;
            return this.getIncidentTetrahedra(c, c.getVertexIndex(u), c.getVertexIndex(v));
        }
        return null;
    }

    public Collection<DelaunayTetrahedron<T>> getIncidentTetrahedra(DelaunayTetrahedron<T> c, int i, int j) {
        Point3D u = c.getVertex(i);
        Point3D v = c.getVertex(j);
        LinkedHashSet<DelaunayTetrahedron<T>> res = new LinkedHashSet<DelaunayTetrahedron<T>>();
        DelaunayTetrahedron<T> cstart = c;
        DelaunayTetrahedron<T> cprev = null;
        int k = 0;
        block0: do {
            res.add(c);
            for (k = 0; k < 4; ++k) {
                if (c.getNeighbor(k) == cprev || !c.getNeighbor(k).isVertex(u) || !c.getNeighbor(k).isVertex(v)) continue;
                cprev = c;
                c = c.getNeighbor(k);
                continue block0;
            }
        } while (c != cstart && k < 4);
        return res;
    }

    public boolean addIndicentTetrahedron(Point3D point, DelaunayTetrahedron<T> tetrahedron) {
        if (this.incidentTetrahedra == null) {
            this.incidentTetrahedra = new HashMap();
        }
        if (this.incidentTetrahedra.get(point) == null) {
            this.incidentTetrahedra.put(point, new LinkedList());
        }
        return this.incidentTetrahedra.get(point).add(tetrahedron);
    }

    public void setIncidentTetrahera(Point3D point, int[] incidentTetrahedraIndices) {
        for (int i = 0; i < incidentTetrahedraIndices.length; ++i) {
            if (incidentTetrahedraIndices[i] > -1) {
                this.addIndicentTetrahedron(point, this.tetrahedra.get(incidentTetrahedraIndices[i]));
                continue;
            }
            this.addIndicentTetrahedron(point, (DelaunayTetrahedron)null);
        }
    }

    public Collection<IndexedFace<T>> getIncidentFaces(Point3D point) {
        if (this.incidentFaces != null) {
            return this.incidentFaces.get(point);
        }
        return null;
    }

    public boolean addIndicentTetrahedron(Point3D point, IndexedFace<T> face) {
        if (this.incidentFaces == null) {
            this.incidentFaces = new HashMap();
        }
        if (this.incidentFaces.get(point) == null) {
            this.incidentFaces.put(point, new LinkedList());
        }
        return this.incidentFaces.get(point).add(face);
    }

    public List<DelaunayTetrahedron<T>> getNeighbors(DelaunayTetrahedron<T> tetrahedron) {
        return this.neighbors.get(tetrahedron);
    }

    public void setNeighbors(DelaunayTetrahedron<T> tetrahedron, List<DelaunayTetrahedron<T>> neighbors) {
        if (tetrahedron != null) {
            if (neighbors != null) {
                if (this.neighbors == null) {
                    this.neighbors = new HashMap();
                }
                for (int i = 0; i < 4; ++i) {
                    tetrahedron.setNeighbor(i, neighbors.get(i));
                }
                this.neighbors.put(tetrahedron, neighbors);
            } else {
                Jeometry.logger.warning("Tetrahedron  has no neighbor.");
            }
        } else {
            Jeometry.logger.warning("Cannot add neightbors to null tetrahedron.");
        }
    }

    public String toString() {
        Object str = "";
        int index = 0;
        str = (String)str + "Tetrahedra: ";
        Iterator<DelaunayTetrahedron<T>> tetrahedronIter = this.tetrahedra.iterator();
        Object var4_4 = null;
        while (tetrahedronIter.hasNext()) {
            IndexedTetrahedron indexedTetrahedron = tetrahedronIter.next();
            str = (String)str + "  " + index + ": " + indexedTetrahedron;
            ++index;
        }
        str = (String)str;
        str = (String)str + "Vertex incidences: " + System.getProperty("line.separator");
        Iterator pointIter = this.points.iterator();
        Point3D point = null;
        Collection<DelaunayTetrahedron<T>> indidentTetrahedra = null;
        while (pointIter.hasNext()) {
            point = (Point3D)pointIter.next();
            str = (String)str + "    " + this.points.indexOf(point) + ": " + point + System.getProperty("line.separator");
            indidentTetrahedra = this.getIncidentTetrahedra(point);
            for (IndexedTetrahedron indexedTetrahedron : indidentTetrahedra) {
                str = (String)str + "      " + this.tetrahedra.indexOf(indexedTetrahedron) + ": " + indexedTetrahedron;
            }
        }
        str = (String)str;
        return str;
    }

    public Collection<VoronoiTriangle> dual(Point3D v) {
        VoronoiTriangle triangle = null;
        Collection<DelaunayTetrahedron<T>> ic = this.getIncidentTetrahedra(v);
        HashSet<Point3D[]> ie = new HashSet<Point3D[]>();
        int index = -1;
        for (DelaunayTetrahedron<T> c : ic) {
            index = c.getVertexIndex(v);
            for (int i = 1; i < 4; ++i) {
                ie.add(new Point3D[]{v, c.getVertex(index + i & 3)});
            }
        }
        LinkedList<VoronoiTriangle> res = new LinkedList<VoronoiTriangle>();
        for (Point3D[] e : ie) {
            ic = this.getIncidentTetrahedra(e[0], e[1]);
            if (ic == null || ic.size() < 3) continue;
            Iterator<DelaunayTetrahedron<T>> cit = ic.iterator();
            DelaunayTetrahedron<T> cstart = cit.next();
            DelaunayTetrahedron<T> c = cit.next();
            DelaunayTetrahedron<T> cprev = null;
            do {
                cprev = c;
                c = cit.next();
                triangle = new VoronoiTriangle(this.dual(cstart), this.dual(cprev), this.dual(c));
                res.add(triangle);
            } while (cit.hasNext());
        }
        return res;
    }

    public Point3D dual(DelaunayTetrahedron<T> c) {
        return this.circumCenter(c.getVertex(0), c.getVertex(1), c.getVertex(2), c.getVertex(3));
    }

    private Point3D circumCenter(Point3D p, Point3D q, Point3D r, Point3D s) {
        double qpx = q.getX() - p.getX();
        double qpy = q.getY() - p.getY();
        double qpz = q.getZ() - p.getZ();
        double qp2 = qpx * qpx + qpy * qpy + qpz * qpz;
        double rpx = r.getX() - p.getX();
        double rpy = r.getY() - p.getY();
        double rpz = r.getZ() - p.getZ();
        double rp2 = rpx * rpx + rpy * rpy + rpz * rpz;
        double spx = s.getX() - p.getX();
        double spy = s.getY() - p.getY();
        double spz = s.getZ() - p.getZ();
        double sp2 = spx * spx + spy * spy + spz * spz;
        double num_x = this.det33(qpy, qpz, qp2, rpy, rpz, rp2, spy, spz, sp2);
        double num_y = this.det33(qpx, qpz, qp2, rpx, rpz, rp2, spx, spz, sp2);
        double num_z = this.det33(qpx, qpy, qp2, rpx, rpy, rp2, spx, spy, sp2);
        double den = this.det33(qpx, qpy, qpz, rpx, rpy, rpz, spx, spy, spz);
        double inv = 1.0 / (2.0 * den);
        double x = p.getX() + num_x * inv;
        double y = p.getY() - num_y * inv;
        double z = p.getZ() + num_z * inv;
        return JeometryFactory.createPoint3D((double)x, (double)y, (double)z);
    }

    private double det33(double ... m) {
        double det33 = 0.0;
        det33 += m[0] * (m[4] * m[8] - m[5] * m[7]);
        det33 -= m[1] * (m[3] * m[8] - m[5] * m[6]);
        return det33 += m[2] * (m[3] * m[7] - m[4] * m[6]);
    }
}

