/*
 * Decompiled with CFR 0.152.
 */
package org.jeometry.geom3D.algorithm.delaunay.clarkson;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jeometry.factory.JeometryFactory;
import org.jeometry.geom3D.SpatialLocalization3D;
import org.jeometry.geom3D.algorithm.delaunay.clarkson.DelaunayTetrahedron;
import org.jeometry.geom3D.mesh.indexed.IndexedFace;
import org.jeometry.geom3D.point.Point3D;
import org.jeometry.math.Matrix;
import org.jeometry.math.Vector;

public class DelaunayVertice<T extends Point3D>
implements Point3D {
    Collection<DelaunayTetrahedron<T>> tetrahedrons = null;
    Collection<IndexedFace<T>> faces = null;
    private Point3D point = null;
    private Map<String, Object> userProperties = null;

    public DelaunayVertice() {
        this.point = JeometryFactory.createPoint3D();
    }

    public DelaunayVertice(double x, double y, double z) {
        this.point = JeometryFactory.createPoint3D((double)x, (double)y, (double)z);
    }

    public double getX() {
        return this.point.getX();
    }

    public void setX(double x) {
        this.point.setX(x);
    }

    public double getY() {
        return this.point.getY();
    }

    public void setY(double y) {
        this.point.setY(y);
    }

    public double getZ() {
        return this.point.getZ();
    }

    public void setZ(double z) {
        this.point.setZ(z);
    }

    public double getH() {
        return this.point.getH();
    }

    public void setH(double h) {
        this.point.setH(h);
    }

    public double norm() {
        return this.point.norm();
    }

    public double normSquare() {
        return this.point.normSquare();
    }

    public void normalize() {
        this.point.normalize();
    }

    public int getDimension() {
        return this.point.getDimension();
    }

    public double getValue(int dimension) {
        return this.point.getValue(dimension);
    }

    public void setValue(int dimension, double value) {
        this.point.setValue(dimension, value);
    }

    public Vector multiply(double scalar, Vector result) throws IllegalArgumentException {
        return this.point.multiply(scalar, result);
    }

    public double getXMin() {
        return this.point.getXMin();
    }

    public double getYMin() {
        return this.point.getYMin();
    }

    public double getZMin() {
        return this.point.getZMin();
    }

    public double getXMax() {
        return this.point.getXMax();
    }

    public double getYMax() {
        return this.point.getYMax();
    }

    public double getZMax() {
        return this.point.getZMax();
    }

    public double distance(SpatialLocalization3D spatial) {
        return this.point.distance(spatial);
    }

    public void updateLocalization() {
        this.point.updateLocalization();
    }

    public Point3D orthogonal() {
        return this.point.orthogonal();
    }

    public Point3D orthogonal(Vector result) {
        return this.point.orthogonal(result);
    }

    public Point3D cross(Point3D point) {
        return point.cross(point);
    }

    public Point3D cross(Point3D point, Point3D result) {
        return point.cross(point, result);
    }

    public double dot(Point3D point) {
        return point.dot(point);
    }

    public Point3D plus(Point3D point) {
        return point.plus(point);
    }

    public Point3D plus(Point3D point, Point3D result) {
        return point.plus(point, result);
    }

    public Point3D plus(double scalar) {
        return this.point.plus(scalar);
    }

    public Vector plus(double scalar, Vector result) {
        return this.point.plus(scalar, result);
    }

    public Point3D plus(double scalar, Point3D result) {
        return this.point.plus(scalar, result);
    }

    public Point3D minus(Point3D point) {
        return point.minus(point);
    }

    public Point3D minus(Point3D point, Point3D result) {
        return point.minus(point, result);
    }

    public Point3D minus(double scalar) {
        return this.point.minus(scalar);
    }

    public Vector minus(double scalar, Vector result) {
        return this.point.minus(scalar, result);
    }

    public Point3D minus(double scalar, Point3D result) {
        return this.point.minus(scalar, result);
    }

    public Point3D plusAffect(Point3D point) {
        point.plusAffect(point);
        return this;
    }

    public Point3D plusAffect(double scalar) {
        this.point.plusAffect(scalar);
        return this;
    }

    public Point3D minusAffect(Point3D point) {
        point.minusAffect(point);
        return this;
    }

    public Point3D minusAffect(double scalar) {
        this.point.minusAffect(scalar);
        return this;
    }

    public Point3D multiply(double scalar) {
        return this.point.multiply(scalar);
    }

    public Point3D multiply(double scalar, Point3D result) {
        return this.point.multiply(scalar, result);
    }

    public Point3D multiplyAffect(double scalar) {
        this.point.multiplyAffect(scalar);
        return this;
    }

    public Point3D divide(double scalar) {
        return this.point.divide(scalar);
    }

    public Vector divide(double scalar, Vector result) throws IllegalArgumentException {
        return this.point.divide(scalar, result);
    }

    public Point3D divide(double scalar, Point3D result) {
        return this.point.divide(scalar, result);
    }

    public Point3D divideAffect(double scalar) {
        this.point.divideAffect(scalar);
        return this;
    }

    public void setUserProperty(String key, Object value) {
        if (value != null) {
            if (this.getUserProperties() == null) {
                this.userProperties = new HashMap<String, Object>();
            }
            this.userProperties.put(key, value);
        } else if (this.getUserProperties() != null) {
            this.getUserProperties().put(key, value);
        }
    }

    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    public boolean addTetrahedron(DelaunayTetrahedron<T> tetrahedron) {
        if (this.tetrahedrons == null) {
            this.tetrahedrons = new LinkedList<DelaunayTetrahedron<T>>();
        }
        return this.tetrahedrons.add(tetrahedron);
    }

    public boolean addFace(IndexedFace<T> face) {
        if (this.faces == null) {
            this.faces = new LinkedList<IndexedFace<T>>();
        }
        return this.faces.add(face);
    }

    public void setValues(Vector v) {
        this.point.setValues(v);
    }

    public double[] getValues() {
        return this.point.getValues();
    }

    public double[] getValues(double[] components) {
        return this.point.getValues(components);
    }

    public void setValues(double[] components) {
        this.point.setValues(components);
    }

    public Vector extract(int start, int length) {
        return this.point.extract(start, length);
    }

    public void setValues(double value) {
        this.point.setValues(value);
    }

    public void setValues(Matrix matrix) {
        this.point.setValues(matrix);
    }

    public Vector plus(Vector v) {
        return this.point.plus(v);
    }

    public Vector plus(Vector v, Vector result) {
        return this.point.plus(v, result);
    }

    public DelaunayVertice<T> plusAffect(Vector v) {
        this.point.plusAffect(v);
        return this;
    }

    public Vector minus(Vector v) {
        return this.point.minus(v);
    }

    public Vector minus(Vector v, Vector result) {
        return this.point.minus(v, result);
    }

    public DelaunayVertice<T> minusAffect(Vector v) {
        this.point.minusAffect(v);
        return this;
    }

    public Vector multiply(Vector v) {
        return this.point.multiply(v);
    }

    public Vector multiply(Vector v, Vector result) {
        return this.point.multiply(v, result);
    }

    public Vector multiplyAffect(Vector v) {
        this.point.multiplyAffect(v);
        return this;
    }

    public Vector divide(Vector v) {
        return this.point.divide(v);
    }

    public Vector divide(Vector v, Vector result) {
        return this.point.divide(v);
    }

    public Vector divideAffect(Vector v) {
        this.point.divideAffect(v);
        return this;
    }

    public double dot(Vector v) {
        return this.point.dot(v);
    }

    public void setValues(double x, double y, double z) {
        this.point.setValues(x, y, z);
    }

    public void setValues(Point3D point) {
        point.setValues(point);
    }
}

