/*
 * Decompiled with CFR 0.152.
 */
package org.jeometry.geom3D.algorithm.fitting;

import org.jeometry.factory.JeometryFactory;
import org.jeometry.geom3D.point.Point3D;
import org.jeometry.geom3D.point.Point3DContainer;
import org.jeometry.geom3D.primitive.Plane;
import org.jeometry.math.Matrix;
import org.jeometry.math.Vector;

public class PlaneFitting {
    private static double DistanceSquared(Vector u, Vector v) {
        return (v.getValue(0) - u.getValue(0)) * (v.getValue(0) - u.getValue(0)) + (v.getValue(1) - u.getValue(1)) * (v.getValue(1) - u.getValue(1)) + (v.getValue(2) - u.getValue(2)) * (v.getValue(2) - u.getValue(2));
    }

    private static double FindLargestEntry(Matrix m) {
        double result = 0.0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double entry = Math.abs(m.getValue(i, j));
                result = Math.max(entry, result);
            }
        }
        return result;
    }

    private static Point3D FindEigenVectorAssociatedWithLargestEigenValue(Matrix m, double iterationMax, double limit) {
        Point3D v;
        double scale = PlaneFitting.FindLargestEntry(m);
        Matrix mc = m.multiply(1.0 / scale);
        mc = mc.multiply(mc);
        mc = mc.multiply(mc);
        mc = mc.multiply(mc);
        Point3D lastV = v = JeometryFactory.createPoint3D((double)1.0, (double)1.0, (double)1.0);
        int i = 0;
        while ((double)i < iterationMax) {
            v = mc.multiply((Vector)v);
            v.normalize();
            if (PlaneFitting.DistanceSquared((Vector)v, (Vector)lastV) < limit) break;
            lastV = v;
            ++i;
        }
        return JeometryFactory.createPoint3D((double)v.getValue(0), (double)v.getValue(1), (double)v.getValue(2));
    }

    public static Plane<Point3D> fit(Point3DContainer<?> points, double iterationMax, double limit) {
        Plane plane = null;
        if (points != null && points.size() >= 3) {
            Point3D origin = JeometryFactory.createPoint3D((double)0.0, (double)0.0, (double)0.0);
            Point3D normal = null;
            Point3D sum = JeometryFactory.createPoint3D((double)0.0, (double)0.0, (double)0.0);
            for (int i = 0; i < points.size(); ++i) {
                sum.plusAffect(points.get(i));
            }
            Point3D center = sum.multiply((double)(1.0f / (float)points.size()));
            if (origin != null) {
                origin = center;
            }
            double sumXX = 0.0;
            double sumXY = 0.0;
            double sumXZ = 0.0;
            double sumYY = 0.0;
            double sumYZ = 0.0;
            double sumZZ = 0.0;
            for (int i = 0; i < points.size(); ++i) {
                double diffX = points.get(i).getX() - center.getX();
                double diffY = points.get(i).getY() - center.getY();
                double diffZ = points.get(i).getZ() - center.getZ();
                sumXX += diffX * diffX;
                sumXY += diffX * diffY;
                sumXZ += diffX * diffZ;
                sumYY += diffY * diffY;
                sumYZ += diffY * diffZ;
                sumZZ += diffZ * diffZ;
            }
            Matrix m = JeometryFactory.createMatrix((double[][])new double[][]{{sumXX, sumXY, sumXZ}, {sumXY, sumYY, sumYZ}, {sumXZ, sumYZ, sumZZ}});
            double det = m.determinant();
            if (det == 0.0) {
                return null;
            }
            Matrix mInverse = m.invert();
            normal = PlaneFitting.FindEigenVectorAssociatedWithLargestEigenValue(mInverse, iterationMax, limit);
            plane = JeometryFactory.createPlane((Point3D)origin, (Point3D)normal);
        }
        return plane;
    }
}

