/*
 * ===========================================
 * Java Pdf Extraction Decoding Access Library
 * ===========================================
 *
 * Project Info:  http://www.idrsolutions.com
 * Help section for developers at http://www.idrsolutions.com/support/
 *
 * (C) Copyright 1997-2015 IDRsolutions and Contributors.
 *
 * This file is part of JPedal/JPDF2HTML5
 *
     This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


 *
 * ---------------
 * JpegLUT.java
 * ---------------
 */
package com.idrsolutions.image.jpeg;

/**
 * Class contains look up tables for performing jpeg compression
 */
public class JpegLUT {

//    public static void main(String[] args) {
//        for (int i = 0; i < 64; i++) {
//            System.out.print((int)(DLD100[i]*4096)+",");
//        }
//        System.out.println("\n");
//        for (int i = 0; i < 64; i++) {
//            System.out.print((int)(DCD100[i]*4096)+",");
//        }
//        System.out.println("\n");
//    }
    
    public static final int[] IDLD100 = {
        256, 372, 409, 256, 170, 102, 80, 67, 341, 341, 292, 215, 157, 70, 68, 74, 
        292, 315, 256, 170, 102, 71, 59, 73, 292, 240, 186, 141,  80, 47, 51, 66, 
        227, 186, 110, 73, 60, 37, 39, 53, 170, 117, 74, 64, 50, 39, 36, 44, 83, 
        64, 52, 47, 39, 33, 34, 40, 56, 44, 43, 41, 36, 40, 39, 41
    };

    public static final int[] IDCD100 = {
        240, 227, 170, 87, 41, 41, 41, 41, 227, 195, 157, 62, 41, 41, 41, 41, 170, 
        157, 73, 41, 41, 41, 41, 41, 87, 62, 41, 41, 41, 41, 41, 41, 41, 41, 41, 
        41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41,  41, 41, 41, 41, 41, 41, 41, 
        41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41
    };


    public static final byte[] QL = {
        16, 11, 10, 16, 24, 40, 51, 61,
        12, 12, 14, 19, 26, 58, 60, 55,
        14, 13, 16, 24, 40, 57, 69, 56,
        14, 17, 22, 29, 51, 87, 80, 62,
        18, 22, 37, 56, 68, 109, 103, 77,
        24, 35, 55, 64, 81, 104, 113, 92,
        49, 64, 78, 87, 103, 121, 120, 101,
        72, 92, 95, 98, 112, 100, 103, 99
    };

    public static final byte[] QC = {
        17, 18, 24, 47, 99, 99, 99, 99,
        18, 21, 26, 66, 99, 99, 99, 99,
        24, 26, 56, 99, 99, 99, 99, 99,
        47, 66, 99, 99, 99, 99, 99, 99,
        99, 99, 99, 99, 99, 99, 99, 99,
        99, 99, 99, 99, 99, 99, 99, 99,
        99, 99, 99, 99, 99, 99, 99, 99,
        99, 99, 99, 99, 99, 99, 99, 99
    };

    public static final byte[] ZIGZAGORDER = {
        0, 1, 8, 16, 9, 2, 3, 10,
        17, 24, 32, 25, 18, 11, 4, 5,
        12, 19, 26, 33, 40, 48, 41, 34,
        27, 20, 13, 6, 7, 14, 21, 28,
        35, 42, 49, 56, 57, 50, 43, 36,
        29, 22, 15, 23, 30, 37, 44, 51,
        58, 59, 52, 45, 38, 31, 39, 46,
        53, 60, 61, 54, 47, 55, 62, 63
    };
    
// found another algorithm from ... http://en.wikipedia.org/wiki/YUV do not delete the code below
//     r[cc] = (byte) (((JpegLUT.YCBCR[rr] + JpegLUT.YCBCR[gg + 256] + JpegLUT.YCBCR[bb + 512]) >> 16) - 128);
//                g[cc] = (byte) (((JpegLUT.YCBCR[rr + 768] + JpegLUT.YCBCR[gg + 1024] + JpegLUT.YCBCR[bb + 1280]) >> 16) - 128);
//                b[cc] = (byte) (((JpegLUT.YCBCR[rr + 1280] + JpegLUT.YCBCR[gg + 1536] + JpegLUT.YCBCR[bb + 1792]) >> 16) - 128);
//
//    public static final int[] YCBCR = new int[]{
//        0, 19595, 39190, 58785, 78380, 97975, 117570, 137165, 156760, 176355, 195950, 215545,
//        235140, 254735, 274330, 293925, 313520, 333115, 352710, 372305, 391900, 411495,
//        431090, 450685, 470280, 489875, 509470, 529065, 548660, 568255, 587850, 607445,
//        627040, 646635, 666230, 685825, 705420, 725015, 744610, 764205, 783800, 803395,
//        822990, 842585, 862180, 881775, 901370, 920965, 940560, 960155, 979750, 999345,
//        1018940, 1038535, 1058130, 1077725, 1097320, 1116915, 1136510, 1156105, 1175700,
//        1195295, 1214890, 1234485, 1254080, 1273675, 1293270, 1312865, 1332460, 1352055,
//        1371650, 1391245, 1410840, 1430435, 1450030, 1469625, 1489220, 1508815, 1528410,
//        1548005, 1567600, 1587195, 1606790, 1626385, 1645980, 1665575, 1685170, 1704765,
//        1724360, 1743955, 1763550, 1783145, 1802740, 1822335, 1841930, 1861525, 1881120,
//        1900715, 1920310, 1939905, 1959500, 1979095, 1998690, 2018285, 2037880, 2057475,
//        2077070, 2096665, 2116260, 2135855, 2155450, 2175045, 2194640, 2214235, 2233830,
//        2253425, 2273020, 2292615, 2312210, 2331805, 2351400, 2370995, 2390590, 2410185,
//        2429780, 2449375, 2468970, 2488565, 2508160, 2527755, 2547350, 2566945, 2586540,
//        2606135, 2625730, 2645325, 2664920, 2684515, 2704110, 2723705, 2743300, 2762895,
//        2782490, 2802085, 2821680, 2841275, 2860870, 2880465, 2900060, 2919655, 2939250,
//        2958845, 2978440, 2998035, 3017630, 3037225, 3056820, 3076415, 3096010, 3115605,
//        3135200, 3154795, 3174390, 3193985, 3213580, 3233175, 3252770, 3272365, 3291960,
//        3311555, 3331150, 3350745, 3370340, 3389935, 3409530, 3429125, 3448720, 3468315,
//        3487910, 3507505, 3527100, 3546695, 3566290, 3585885, 3605480, 3625075, 3644670,
//        3664265, 3683860, 3703455, 3723050, 3742645, 3762240, 3781835, 3801430, 3821025,
//        3840620, 3860215, 3879810, 3899405, 3919000, 3938595, 3958190, 3977785, 3997380,
//        4016975, 4036570, 4056165, 4075760, 4095355, 4114950, 4134545, 4154140, 4173735,
//        4193330, 4212925, 4232520, 4252115, 4271710, 4291305, 4310900, 4330495, 4350090,
//        4369685, 4389280, 4408875, 4428470, 4448065, 4467660, 4487255, 4506850, 4526445,
//        4546040, 4565635, 4585230, 4604825, 4624420, 4644015, 4663610, 4683205, 4702800,
//        4722395, 4741990, 4761585, 4781180, 4800775, 4820370, 4839965, 4859560, 4879155,
//        4898750, 4918345, 4937940, 4957535, 4977130, 4996725, 0, 38470, 76940, 115410,
//        153880, 192350, 230820, 269290, 307760, 346230, 384700, 423170, 461640, 500110,
//        538580, 577050, 615520, 653990, 692460, 730930, 769400, 807870, 846340, 884810,
//        923280, 961750, 1000220, 1038690, 1077160, 1115630, 1154100, 1192570, 1231040,
//        1269510, 1307980, 1346450, 1384920, 1423390, 1461860, 1500330, 1538800, 1577270,
//        1615740, 1654210, 1692680, 1731150, 1769620, 1808090, 1846560, 1885030, 1923500,
//        1961970, 2000440, 2038910, 2077380, 2115850, 2154320, 2192790, 2231260, 2269730,
//        2308200, 2346670, 2385140, 2423610, 2462080, 2500550, 2539020, 2577490, 2615960,
//        2654430, 2692900, 2731370, 2769840, 2808310, 2846780, 2885250, 2923720, 2962190,
//        3000660, 3039130, 3077600, 3116070, 3154540, 3193010, 3231480, 3269950, 3308420,
//        3346890, 3385360, 3423830, 3462300, 3500770, 3539240, 3577710, 3616180, 3654650,
//        3693120, 3731590, 3770060, 3808530, 3847000, 3885470, 3923940, 3962410, 4000880,
//        4039350, 4077820, 4116290, 4154760, 4193230, 4231700, 4270170, 4308640, 4347110,
//        4385580, 4424050, 4462520, 4500990, 4539460, 4577930, 4616400, 4654870, 4693340,
//        4731810, 4770280, 4808750, 4847220, 4885690, 4924160, 4962630, 5001100, 5039570,
//        5078040, 5116510, 5154980, 5193450, 5231920, 5270390, 5308860, 5347330, 5385800,
//        5424270, 5462740, 5501210, 5539680, 5578150, 5616620, 5655090, 5693560, 5732030,
//        5770500, 5808970, 5847440, 5885910, 5924380, 5962850, 6001320, 6039790, 6078260,
//        6116730, 6155200, 6193670, 6232140, 6270610, 6309080, 6347550, 6386020, 6424490,
//        6462960, 6501430, 6539900, 6578370, 6616840, 6655310, 6693780, 6732250, 6770720,
//        6809190, 6847660, 6886130, 6924600, 6963070, 7001540, 7040010, 7078480, 7116950,
//        7155420, 7193890, 7232360, 7270830, 7309300, 7347770, 7386240, 7424710, 7463180,
//        7501650, 7540120, 7578590, 7617060, 7655530, 7694000, 7732470, 7770940, 7809410,
//        7847880, 7886350, 7924820, 7963290, 8001760, 8040230, 8078700, 8117170, 8155640,
//        8194110, 8232580, 8271050, 8309520, 8347990, 8386460, 8424930, 8463400, 8501870,
//        8540340, 8578810, 8617280, 8655750, 8694220, 8732690, 8771160, 8809630, 8848100,
//        8886570, 8925040, 8963510, 9001980, 9040450, 9078920, 9117390, 9155860, 9194330,
//        9232800, 9271270, 9309740, 9348210, 9386680, 9425150, 9463620, 9502090, 9540560,
//        9579030, 9617500, 9655970, 9694440, 9732910, 9771380, 9809850, 32768, 40239, 47710,
//        55181, 62652, 70123, 77594, 85065, 92536, 100007, 107478, 114949, 122420, 129891,
//        137362, 144833, 152304, 159775, 167246, 174717, 182188, 189659, 197130, 204601,
//        212072, 219543, 227014, 234485, 241956, 249427, 256898, 264369, 271840, 279311,
//        286782, 294253, 301724, 309195, 316666, 324137, 331608, 339079, 346550, 354021,
//        361492, 368963, 376434, 383905, 391376, 398847, 406318, 413789, 421260, 428731,
//        436202, 443673, 451144, 458615, 466086, 473557, 481028, 488499, 495970, 503441,
//        510912, 518383, 525854, 533325, 540796, 548267, 555738, 563209, 570680, 578151,
//        585622, 593093, 600564, 608035, 615506, 622977, 630448, 637919, 645390, 652861,
//        660332, 667803, 675274, 682745, 690216, 697687, 705158, 712629, 720100, 727571,
//        735042, 742513, 749984, 757455, 764926, 772397, 779868, 787339, 794810, 802281,
//        809752, 817223, 824694, 832165, 839636, 847107, 854578, 862049, 869520, 876991,
//        884462, 891933, 899404, 906875, 914346, 921817, 929288, 936759, 944230, 951701,
//        959172, 966643, 974114, 981585, 989056, 996527, 1003998, 1011469, 1018940, 1026411,
//        1033882, 1041353, 1048824, 1056295, 1063766, 1071237, 1078708, 1086179, 1093650,
//        1101121, 1108592, 1116063, 1123534, 1131005, 1138476, 1145947, 1153418, 1160889,
//        1168360, 1175831, 1183302, 1190773, 1198244, 1205715, 1213186, 1220657, 1228128,
//        1235599, 1243070, 1250541, 1258012, 1265483, 1272954, 1280425, 1287896, 1295367,
//        1302838, 1310309, 1317780, 1325251, 1332722, 1340193, 1347664, 1355135, 1362606,
//        1370077, 1377548, 1385019, 1392490, 1399961, 1407432, 1414903, 1422374, 1429845,
//        1437316, 1444787, 1452258, 1459729, 1467200, 1474671, 1482142, 1489613, 1497084,
//        1504555, 1512026, 1519497, 1526968, 1534439, 1541910, 1549381, 1556852, 1564323,
//        1571794, 1579265, 1586736, 1594207, 1601678, 1609149, 1616620, 1624091, 1631562,
//        1639033, 1646504, 1653975, 1661446, 1668917, 1676388, 1683859, 1691330, 1698801,
//        1706272, 1713743, 1721214, 1728685, 1736156, 1743627, 1751098, 1758569, 1766040,
//        1773511, 1780982, 1788453, 1795924, 1803395, 1810866, 1818337, 1825808, 1833279,
//        1840750, 1848221, 1855692, 1863163, 1870634, 1878105, 1885576, 1893047, 1900518,
//        1907989, 1915460, 1922931, 1930402, 1937873, 0, -11059, -22118, -33177, -44236,
//        -55295, -66354, -77413, -88472, -99531, -110590, -121649, -132708, -143767,
//        -154826, -165885, -176944, -188003, -199062, -210121, -221180, -232239, -243298,
//        -254357, -265416, -276475, -287534, -298593, -309652, -320711, -331770, -342829,
//        -353888, -364947, -376006, -387065, -398124, -409183, -420242, -431301, -442360,
//        -453419, -464478, -475537, -486596, -497655, -508714, -519773, -530832, -541891,
//        -552950, -564009, -575068, -586127, -597186, -608245, -619304, -630363, -641422,
//        -652481, -663540, -674599, -685658, -696717, -707776, -718835, -729894, -740953,
//        -752012, -763071, -774130, -785189, -796248, -807307, -818366, -829425, -840484,
//        -851543, -862602, -873661, -884720, -895779, -906838, -917897, -928956, -940015,
//        -951074, -962133, -973192, -984251, -995310, -1006369, -1017428, -1028487,
//        -1039546, -1050605, -1061664, -1072723, -1083782, -1094841, -1105900, -1116959,
//        -1128018, -1139077, -1150136, -1161195, -1172254, -1183313, -1194372, -1205431,
//        -1216490, -1227549, -1238608, -1249667, -1260726, -1271785, -1282844, -1293903,
//        -1304962, -1316021, -1327080, -1338139, -1349198, -1360257, -1371316, -1382375,
//        -1393434, -1404493, -1415552, -1426611, -1437670, -1448729, -1459788, -1470847,
//        -1481906, -1492965, -1504024, -1515083, -1526142, -1537201, -1548260, -1559319,
//        -1570378, -1581437, -1592496, -1603555, -1614614, -1625673, -1636732, -1647791,
//        -1658850, -1669909, -1680968, -1692027, -1703086, -1714145, -1725204, -1736263,
//        -1747322, -1758381, -1769440, -1780499, -1791558, -1802617, -1813676, -1824735,
//        -1835794, -1846853, -1857912, -1868971, -1880030, -1891089, -1902148, -1913207,
//        -1924266, -1935325, -1946384, -1957443, -1968502, -1979561, -1990620, -2001679,
//        -2012738, -2023797, -2034856, -2045915, -2056974, -2068033, -2079092, -2090151,
//        -2101210, -2112269, -2123328, -2134387, -2145446, -2156505, -2167564, -2178623,
//        -2189682, -2200741, -2211800, -2222859, -2233918, -2244977, -2256036, -2267095,
//        -2278154, -2289213, -2300272, -2311331, -2322390, -2333449, -2344508, -2355567,
//        -2366626, -2377685, -2388744, -2399803, -2410862, -2421921, -2432980, -2444039,
//        -2455098, -2466157, -2477216, -2488275, -2499334, -2510393, -2521452, -2532511,
//        -2543570, -2554629, -2565688, -2576747, -2587806, -2598865, -2609924, -2620983,
//        -2632042, -2643101, -2654160, -2665219, -2676278, -2687337, -2698396, -2709455,
//        -2720514, -2731573, -2742632, -2753691, -2764750, -2775809, -2786868, -2797927,
//        -2808986, -2820045, 0, -21709, -43418, -65127, -86836, -108545, -130254, -151963,
//        -173672, -195381, -217090, -238799, -260508, -282217, -303926, -325635, -347344,
//        -369053, -390762, -412471, -434180, -455889, -477598, -499307, -521016, -542725,
//        -564434, -586143, -607852, -629561, -651270, -672979, -694688, -716397, -738106,
//        -759815, -781524, -803233, -824942, -846651, -868360, -890069, -911778, -933487,
//        -955196, -976905, -998614, -1020323, -1042032, -1063741, -1085450, -1107159,
//        -1128868, -1150577, -1172286, -1193995, -1215704, -1237413, -1259122, -1280831,
//        -1302540, -1324249, -1345958, -1367667, -1389376, -1411085, -1432794, -1454503,
//        -1476212, -1497921, -1519630, -1541339, -1563048, -1584757, -1606466, -1628175,
//        -1649884, -1671593, -1693302, -1715011, -1736720, -1758429, -1780138, -1801847,
//        -1823556, -1845265, -1866974, -1888683, -1910392, -1932101, -1953810, -1975519,
//        -1997228, -2018937, -2040646, -2062355, -2084064, -2105773, -2127482, -2149191,
//        -2170900, -2192609, -2214318, -2236027, -2257736, -2279445, -2301154, -2322863,
//        -2344572, -2366281, -2387990, -2409699, -2431408, -2453117, -2474826, -2496535,
//        -2518244, -2539953, -2561662, -2583371, -2605080, -2626789, -2648498, -2670207,
//        -2691916, -2713625, -2735334, -2757043, -2778752, -2800461, -2822170, -2843879,
//        -2865588, -2887297, -2909006, -2930715, -2952424, -2974133, -2995842, -3017551,
//        -3039260, -3060969, -3082678, -3104387, -3126096, -3147805, -3169514, -3191223,
//        -3212932, -3234641, -3256350, -3278059, -3299768, -3321477, -3343186, -3364895,
//        -3386604, -3408313, -3430022, -3451731, -3473440, -3495149, -3516858, -3538567,
//        -3560276, -3581985, -3603694, -3625403, -3647112, -3668821, -3690530, -3712239,
//        -3733948, -3755657, -3777366, -3799075, -3820784, -3842493, -3864202, -3885911,
//        -3907620, -3929329, -3951038, -3972747, -3994456, -4016165, -4037874, -4059583,
//        -4081292, -4103001, -4124710, -4146419, -4168128, -4189837, -4211546, -4233255,
//        -4254964, -4276673, -4298382, -4320091, -4341800, -4363509, -4385218, -4406927,
//        -4428636, -4450345, -4472054, -4493763, -4515472, -4537181, -4558890, -4580599,
//        -4602308, -4624017, -4645726, -4667435, -4689144, -4710853, -4732562, -4754271,
//        -4775980, -4797689, -4819398, -4841107, -4862816, -4884525, -4906234, -4927943,
//        -4949652, -4971361, -4993070, -5014779, -5036488, -5058197, -5079906, -5101615,
//        -5123324, -5145033, -5166742, -5188451, -5210160, -5231869, -5253578, -5275287,
//        -5296996, -5318705, -5340414, -5362123, -5383832, -5405541, -5427250, -5448959,
//        -5470668, -5492377, -5514086, -5535795, 8421375, 8454143, 8486911, 8519679,
//        8552447, 8585215, 8617983, 8650751, 8683519, 8716287, 8749055, 8781823, 8814591,
//        8847359, 8880127, 8912895, 8945663, 8978431, 9011199, 9043967, 9076735, 9109503,
//        9142271, 9175039, 9207807, 9240575, 9273343, 9306111, 9338879, 9371647, 9404415,
//        9437183, 9469951, 9502719, 9535487, 9568255, 9601023, 9633791, 9666559, 9699327,
//        9732095, 9764863, 9797631, 9830399, 9863167, 9895935, 9928703, 9961471, 9994239,
//        10027007, 10059775, 10092543, 10125311, 10158079, 10190847, 10223615, 10256383,
//        10289151, 10321919, 10354687, 10387455, 10420223, 10452991, 10485759, 10518527,
//        10551295, 10584063, 10616831, 10649599, 10682367, 10715135, 10747903, 10780671,
//        10813439, 10846207, 10878975, 10911743, 10944511, 10977279, 11010047, 11042815,
//        11075583, 11108351, 11141119, 11173887, 11206655, 11239423, 11272191, 11304959,
//        11337727, 11370495, 11403263, 11436031, 11468799, 11501567, 11534335, 11567103,
//        11599871, 11632639, 11665407, 11698175, 11730943, 11763711, 11796479, 11829247,
//        11862015, 11894783, 11927551, 11960319, 11993087, 12025855, 12058623, 12091391,
//        12124159, 12156927, 12189695, 12222463, 12255231, 12287999, 12320767, 12353535,
//        12386303, 12419071, 12451839, 12484607, 12517375, 12550143, 12582911, 12615679,
//        12648447, 12681215, 12713983, 12746751, 12779519, 12812287, 12845055, 12877823,
//        12910591, 12943359, 12976127, 13008895, 13041663, 13074431, 13107199, 13139967,
//        13172735, 13205503, 13238271, 13271039, 13303807, 13336575, 13369343, 13402111,
//        13434879, 13467647, 13500415, 13533183, 13565951, 13598719, 13631487, 13664255,
//        13697023, 13729791, 13762559, 13795327, 13828095, 13860863, 13893631, 13926399,
//        13959167, 13991935, 14024703, 14057471, 14090239, 14123007, 14155775, 14188543,
//        14221311, 14254079, 14286847, 14319615, 14352383, 14385151, 14417919, 14450687,
//        14483455, 14516223, 14548991, 14581759, 14614527, 14647295, 14680063, 14712831,
//        14745599, 14778367, 14811135, 14843903, 14876671, 14909439, 14942207, 14974975,
//        15007743, 15040511, 15073279, 15106047, 15138815, 15171583, 15204351, 15237119,
//        15269887, 15302655, 15335423, 15368191, 15400959, 15433727, 15466495, 15499263,
//        15532031, 15564799, 15597567, 15630335, 15663103, 15695871, 15728639, 15761407,
//        15794175, 15826943, 15859711, 15892479, 15925247, 15958015, 15990783, 16023551,
//        16056319, 16089087, 16121855, 16154623, 16187391, 16220159, 16252927, 16285695,
//        16318463, 16351231, 16383999, 16416767, 16449535, 16482303, 16515071, 16547839,
//        16580607, 16613375, 16646143, 16678911, 16711679, 16744447, 16777215, 0, -27439,
//        -54878, -82317, -109756, -137195, -164634, -192073, -219512, -246951, -274390,
//        -301829, -329268, -356707, -384146, -411585, -439024, -466463, -493902, -521341,
//        -548780, -576219, -603658, -631097, -658536, -685975, -713414, -740853, -768292,
//        -795731, -823170, -850609, -878048, -905487, -932926, -960365, -987804, -1015243,
//        -1042682, -1070121, -1097560, -1124999, -1152438, -1179877, -1207316, -1234755,
//        -1262194, -1289633, -1317072, -1344511, -1371950, -1399389, -1426828, -1454267,
//        -1481706, -1509145, -1536584, -1564023, -1591462, -1618901, -1646340, -1673779,
//        -1701218, -1728657, -1756096, -1783535, -1810974, -1838413, -1865852, -1893291,
//        -1920730, -1948169, -1975608, -2003047, -2030486, -2057925, -2085364, -2112803,
//        -2140242, -2167681, -2195120, -2222559, -2249998, -2277437, -2304876, -2332315,
//        -2359754, -2387193, -2414632, -2442071, -2469510, -2496949, -2524388, -2551827,
//        -2579266, -2606705, -2634144, -2661583, -2689022, -2716461, -2743900, -2771339,
//        -2798778, -2826217, -2853656, -2881095, -2908534, -2935973, -2963412, -2990851,
//        -3018290, -3045729, -3073168, -3100607, -3128046, -3155485, -3182924, -3210363,
//        -3237802, -3265241, -3292680, -3320119, -3347558, -3374997, -3402436, -3429875,
//        -3457314, -3484753, -3512192, -3539631, -3567070, -3594509, -3621948, -3649387,
//        -3676826, -3704265, -3731704, -3759143, -3786582, -3814021, -3841460, -3868899,
//        -3896338, -3923777, -3951216, -3978655, -4006094, -4033533, -4060972, -4088411,
//        -4115850, -4143289, -4170728, -4198167, -4225606, -4253045, -4280484, -4307923,
//        -4335362, -4362801, -4390240, -4417679, -4445118, -4472557, -4499996, -4527435,
//        -4554874, -4582313, -4609752, -4637191, -4664630, -4692069, -4719508, -4746947,
//        -4774386, -4801825, -4829264, -4856703, -4884142, -4911581, -4939020, -4966459,
//        -4993898, -5021337, -5048776, -5076215, -5103654, -5131093, -5158532, -5185971,
//        -5213410, -5240849, -5268288, -5295727, -5323166, -5350605, -5378044, -5405483,
//        -5432922, -5460361, -5487800, -5515239, -5542678, -5570117, -5597556, -5624995,
//        -5652434, -5679873, -5707312, -5734751, -5762190, -5789629, -5817068, -5844507,
//        -5871946, -5899385, -5926824, -5954263, -5981702, -6009141, -6036580, -6064019,
//        -6091458, -6118897, -6146336, -6173775, -6201214, -6228653, -6256092, -6283531,
//        -6310970, -6338409, -6365848, -6393287, -6420726, -6448165, -6475604, -6503043,
//        -6530482, -6557921, -6585360, -6612799, -6640238, -6667677, -6695116, -6722555,
//        -6749994, -6777433, -6804872, -6832311, -6859750, -6887189, -6914628, -6942067,
//        -6969506, -6996945, 0, -5329, -10658, -15987, -21316, -26645, -31974, -37303,
//        -42632, -47961, -53290, -58619, -63948, -69277, -74606, -79935, -85264, -90593,
//        -95922, -101251, -106580, -111909, -117238, -122567, -127896, -133225, -138554,
//        -143883, -149212, -154541, -159870, -165199, -170528, -175857, -181186, -186515,
//        -191844, -197173, -202502, -207831, -213160, -218489, -223818, -229147, -234476,
//        -239805, -245134, -250463, -255792, -261121, -266450, -271779, -277108, -282437,
//        -287766, -293095, -298424, -303753, -309082, -314411, -319740, -325069, -330398,
//        -335727, -341056, -346385, -351714, -357043, -362372, -367701, -373030, -378359,
//        -383688, -389017, -394346, -399675, -405004, -410333, -415662, -420991, -426320,
//        -431649, -436978, -442307, -447636, -452965, -458294, -463623, -468952, -474281,
//        -479610, -484939, -490268, -495597, -500926, -506255, -511584, -516913, -522242,
//        -527571, -532900, -538229, -543558, -548887, -554216, -559545, -564874, -570203,
//        -575532, -580861, -586190, -591519, -596848, -602177, -607506, -612835, -618164,
//        -623493, -628822, -634151, -639480, -644809, -650138, -655467, -660796, -666125,
//        -671454, -676783, -682112, -687441, -692770, -698099, -703428, -708757, -714086,
//        -719415, -724744, -730073, -735402, -740731, -746060, -751389, -756718, -762047,
//        -767376, -772705, -778034, -783363, -788692, -794021, -799350, -804679, -810008,
//        -815337, -820666, -825995, -831324, -836653, -841982, -847311, -852640, -857969,
//        -863298, -868627, -873956, -879285, -884614, -889943, -895272, -900601, -905930,
//        -911259, -916588, -921917, -927246, -932575, -937904, -943233, -948562, -953891,
//        -959220, -964549, -969878, -975207, -980536, -985865, -991194, -996523, -1001852,
//        -1007181, -1012510, -1017839, -1023168, -1028497, -1033826, -1039155, -1044484,
//        -1049813, -1055142, -1060471, -1065800, -1071129, -1076458, -1081787, -1087116,
//        -1092445, -1097774, -1103103, -1108432, -1113761, -1119090, -1124419, -1129748,
//        -1135077, -1140406, -1145735, -1151064, -1156393, -1161722, -1167051, -1172380,
//        -1177709, -1183038, -1188367, -1193696, -1199025, -1204354, -1209683, -1215012,
//        -1220341, -1225670, -1230999, -1236328, -1241657, -1246986, -1252315, -1257644,
//        -1262973, -1268302, -1273631, -1278960, -1284289, -1289618, -1294947, -1300276,
//        -1305605, -1310934, -1316263, -1321592, -1326921, -1332250, -1337579, -1342908,
//        -1348237, -1353566, -1358895, 0, 19595, 39190, 58785, 78380, 97975, 117570, 137165,
//        156760, 176355, 195950, 215545, 235140, 254735, 274330, 293925, 313520, 333115,
//        352710, 372305, 391900, 411495, 431090, 450685, 470280, 489875, 509470, 529065,
//        548660, 568255, 587850, 607445, 627040, 646635, 666230, 685825, 705420, 725015,
//        744610, 764205, 783800, 803395, 822990, 842585, 862180, 881775, 901370, 920965,
//        940560, 960155, 979750, 999345, 1018940, 1038535, 1058130, 1077725, 1097320,
//        1116915, 1136510, 1156105, 1175700, 1195295, 1214890, 1234485, 1254080, 1273675,
//        1293270, 1312865, 1332460, 1352055, 1371650, 1391245, 1410840, 1430435, 1450030,
//        1469625, 1489220, 1508815, 1528410, 1548005, 1567600, 1587195, 1606790, 1626385,
//        1645980, 1665575, 1685170, 1704765, 1724360, 1743955, 1763550, 1783145, 1802740,
//        1822335, 1841930, 1861525, 1881120, 1900715, 1920310, 1939905, 1959500, 1979095,
//        1998690, 2018285, 2037880, 2057475, 2077070, 2096665, 2116260, 2135855, 2155450,
//        2175045, 2194640, 2214235, 2233830, 2253425, 2273020, 2292615, 2312210, 2331805,
//        2351400, 2370995, 2390590, 2410185, 2429780, 2449375, 2468970, 2488565, 2508160,
//        2527755, 2547350, 2566945, 2586540, 2606135, 2625730, 2645325, 2664920, 2684515,
//        2704110, 2723705, 2743300, 2762895, 2782490, 2802085, 2821680, 2841275, 2860870,
//        2880465, 2900060, 2919655, 2939250, 2958845, 2978440, 2998035, 3017630, 3037225,
//        3056820, 3076415, 3096010, 3115605, 3135200, 3154795, 3174390, 3193985, 3213580,
//        3233175, 3252770, 3272365, 3291960, 3311555, 3331150, 3350745, 3370340, 3389935,
//        3409530, 3429125, 3448720, 3468315, 3487910, 3507505, 3527100, 3546695, 3566290,
//        3585885, 3605480, 3625075, 3644670, 3664265, 3683860, 3703455, 3723050, 3742645,
//        3762240, 3781835, 3801430, 3821025, 3840620, 3860215, 3879810, 3899405, 3919000,
//        3938595, 3958190, 3977785, 3997380, 4016975, 4036570, 4056165, 4075760, 4095355,
//        4114950, 4134545, 4154140, 4173735, 4193330, 4212925, 4232520, 4252115, 4271710,
//        4291305, 4310900, 4330495, 4350090, 4369685, 4389280, 4408875, 4428470, 4448065,
//        4467660, 4487255, 4506850, 4526445, 4546040, 4565635, 4585230, 4604825, 4624420,
//        4644015, 4663610, 4683205, 4702800, 4722395, 4741990, 4761585, 4781180, 4800775,
//        4820370, 4839965, 4859560, 4879155, 4898750, 4918345, 4937940, 4957535, 4977130,
//        4996725, 0, 38470, 76940, 115410, 153880, 192350, 230820, 269290, 307760, 346230,
//        384700, 423170, 461640, 500110, 538580, 577050, 615520, 653990, 692460, 730930,
//        769400, 807870, 846340, 884810, 923280, 961750, 1000220, 1038690, 1077160, 1115630,
//        1154100, 1192570, 1231040, 1269510, 1307980, 1346450, 1384920, 1423390, 1461860,
//        1500330, 1538800, 1577270, 1615740, 1654210, 1692680, 1731150, 1769620, 1808090,
//        1846560, 1885030, 1923500, 1961970, 2000440, 2038910, 2077380, 2115850, 2154320,
//        2192790, 2231260, 2269730, 2308200, 2346670, 2385140, 2423610, 2462080, 2500550,
//        2539020, 2577490, 2615960, 2654430, 2692900, 2731370, 2769840, 2808310, 2846780,
//        2885250, 2923720, 2962190, 3000660, 3039130, 3077600, 3116070, 3154540, 3193010,
//        3231480, 3269950, 3308420, 3346890, 3385360, 3423830, 3462300, 3500770, 3539240,
//        3577710, 3616180, 3654650, 3693120, 3731590, 3770060, 3808530, 3847000, 3885470,
//        3923940, 3962410, 4000880, 4039350, 4077820, 4116290, 4154760, 4193230, 4231700,
//        4270170, 4308640, 4347110, 4385580, 4424050, 4462520, 4500990, 4539460, 4577930,
//        4616400, 4654870, 4693340, 4731810, 4770280, 4808750, 4847220, 4885690, 4924160,
//        4962630, 5001100, 5039570, 5078040, 5116510, 5154980, 5193450, 5231920, 5270390,
//        5308860, 5347330, 5385800, 5424270, 5462740, 5501210, 5539680, 5578150, 5616620,
//        5655090, 5693560, 5732030, 5770500, 5808970, 5847440, 5885910, 5924380, 5962850,
//        6001320, 6039790, 6078260, 6116730, 6155200, 6193670, 6232140, 6270610, 6309080,
//        6347550, 6386020, 6424490, 6462960, 6501430, 6539900, 6578370, 6616840, 6655310,
//        6693780, 6732250, 6770720, 6809190, 6847660, 6886130, 6924600, 6963070, 7001540,
//        7040010, 7078480, 7116950, 7155420, 7193890, 7232360, 7270830, 7309300, 7347770,
//        7386240, 7424710, 7463180, 7501650, 7540120, 7578590, 7617060, 7655530, 7694000,
//        7732470, 7770940, 7809410, 7847880, 7886350, 7924820, 7963290, 8001760, 8040230,
//        8078700, 8117170, 8155640, 8194110, 8232580, 8271050, 8309520, 8347990, 8386460,
//        8424930, 8463400, 8501870, 8540340, 8578810, 8617280, 8655750, 8694220, 8732690,
//        8771160, 8809630, 8848100, 8886570, 8925040, 8963510, 9001980, 9040450, 9078920,
//        9117390, 9155860, 9194330, 9232800, 9271270, 9309740, 9348210, 9386680, 9425150,
//        9463620, 9502090, 9540560, 9579030, 9617500, 9655970, 9694440, 9732910, 9771380,
//        9809850, 32768, 40239, 47710, 55181, 62652, 70123, 77594, 85065, 92536, 100007,
//        107478, 114949, 122420, 129891, 137362, 144833, 152304, 159775, 167246, 174717,
//        182188, 189659, 197130, 204601, 212072, 219543, 227014, 234485, 241956, 249427,
//        256898, 264369, 271840, 279311, 286782, 294253, 301724, 309195, 316666, 324137,
//        331608, 339079, 346550, 354021, 361492, 368963, 376434, 383905, 391376, 398847,
//        406318, 413789, 421260, 428731, 436202, 443673, 451144, 458615, 466086, 473557,
//        481028, 488499, 495970, 503441, 510912, 518383, 525854, 533325, 540796, 548267,
//        555738, 563209, 570680, 578151, 585622, 593093, 600564, 608035, 615506, 622977,
//        630448, 637919, 645390, 652861, 660332, 667803, 675274, 682745, 690216, 697687,
//        705158, 712629, 720100, 727571, 735042, 742513, 749984, 757455, 764926, 772397,
//        779868, 787339, 794810, 802281, 809752, 817223, 824694, 832165, 839636, 847107,
//        854578, 862049, 869520, 876991, 884462, 891933, 899404, 906875, 914346, 921817,
//        929288, 936759, 944230, 951701, 959172, 966643, 974114, 981585, 989056, 996527,
//        1003998, 1011469, 1018940, 1026411, 1033882, 1041353, 1048824, 1056295, 1063766,
//        1071237, 1078708, 1086179, 1093650, 1101121, 1108592, 1116063, 1123534, 1131005,
//        1138476, 1145947, 1153418, 1160889, 1168360, 1175831, 1183302, 1190773, 1198244,
//        1205715, 1213186, 1220657, 1228128, 1235599, 1243070, 1250541, 1258012, 1265483,
//        1272954, 1280425, 1287896, 1295367, 1302838, 1310309, 1317780, 1325251, 1332722,
//        1340193, 1347664, 1355135, 1362606, 1370077, 1377548, 1385019, 1392490, 1399961,
//        1407432, 1414903, 1422374, 1429845, 1437316, 1444787, 1452258, 1459729, 1467200,
//        1474671, 1482142, 1489613, 1497084, 1504555, 1512026, 1519497, 1526968, 1534439,
//        1541910, 1549381, 1556852, 1564323, 1571794, 1579265, 1586736, 1594207, 1601678,
//        1609149, 1616620, 1624091, 1631562, 1639033, 1646504, 1653975, 1661446, 1668917,
//        1676388, 1683859, 1691330, 1698801, 1706272, 1713743, 1721214, 1728685, 1736156,
//        1743627, 1751098, 1758569, 1766040, 1773511, 1780982, 1788453, 1795924, 1803395,
//        1810866, 1818337, 1825808, 1833279, 1840750, 1848221, 1855692, 1863163, 1870634,
//        1878105, 1885576, 1893047, 1900518, 1907989, 1915460, 1922931, 1930402, 1937873,
//        0, -11059, -22118, -33177, -44236, -55295, -66354, -77413, -88472, -99531, -110590,
//        -121649, -132708, -143767, -154826, -165885, -176944, -188003, -199062, -210121,
//        -221180, -232239, -243298, -254357, -265416, -276475, -287534, -298593, -309652,
//        -320711, -331770, -342829, -353888, -364947, -376006, -387065, -398124, -409183,
//        -420242, -431301, -442360, -453419, -464478, -475537, -486596, -497655, -508714,
//        -519773, -530832, -541891, -552950, -564009, -575068, -586127, -597186, -608245,
//        -619304, -630363, -641422, -652481, -663540, -674599, -685658, -696717, -707776,
//        -718835, -729894, -740953, -752012, -763071, -774130, -785189, -796248, -807307,
//        -818366, -829425, -840484, -851543, -862602, -873661, -884720, -895779, -906838,
//        -917897, -928956, -940015, -951074, -962133, -973192, -984251, -995310, -1006369,
//        -1017428, -1028487, -1039546, -1050605, -1061664, -1072723, -1083782, -1094841,
//        -1105900, -1116959, -1128018, -1139077, -1150136, -1161195, -1172254, -1183313,
//        -1194372, -1205431, -1216490, -1227549, -1238608, -1249667, -1260726, -1271785,
//        -1282844, -1293903, -1304962, -1316021, -1327080, -1338139, -1349198, -1360257,
//        -1371316, -1382375, -1393434, -1404493, -1415552, -1426611, -1437670, -1448729,
//        -1459788, -1470847, -1481906, -1492965, -1504024, -1515083, -1526142, -1537201,
//        -1548260, -1559319, -1570378, -1581437, -1592496, -1603555, -1614614, -1625673,
//        -1636732, -1647791, -1658850, -1669909, -1680968, -1692027, -1703086, -1714145,
//        -1725204, -1736263, -1747322, -1758381, -1769440, -1780499, -1791558, -1802617,
//        -1813676, -1824735, -1835794, -1846853, -1857912, -1868971, -1880030, -1891089,
//        -1902148, -1913207, -1924266, -1935325, -1946384, -1957443, -1968502, -1979561,
//        -1990620, -2001679, -2012738, -2023797, -2034856, -2045915, -2056974, -2068033,
//        -2079092, -2090151, -2101210, -2112269, -2123328, -2134387, -2145446, -2156505,
//        -2167564, -2178623, -2189682, -2200741, -2211800, -2222859, -2233918, -2244977,
//        -2256036, -2267095, -2278154, -2289213, -2300272, -2311331, -2322390, -2333449,
//        -2344508, -2355567, -2366626, -2377685, -2388744, -2399803, -2410862, -2421921,
//        -2432980, -2444039, -2455098, -2466157, -2477216, -2488275, -2499334, -2510393,
//        -2521452, -2532511, -2543570, -2554629, -2565688, -2576747, -2587806, -2598865,
//        -2609924, -2620983, -2632042, -2643101, -2654160, -2665219, -2676278, -2687337,
//        -2698396, -2709455, -2720514, -2731573, -2742632, -2753691, -2764750, -2775809,
//        -2786868, -2797927, -2808986, -2820045, 0, -21709, -43418, -65127, -86836,
//        -108545, -130254, -151963, -173672, -195381, -217090, -238799, -260508, -282217,
//        -303926, -325635, -347344, -369053, -390762, -412471, -434180, -455889, -477598,
//        -499307, -521016, -542725, -564434, -586143, -607852, -629561, -651270, -672979,
//        -694688, -716397, -738106, -759815, -781524, -803233, -824942, -846651, -868360,
//        -890069, -911778, -933487, -955196, -976905, -998614, -1020323, -1042032,
//        -1063741, -1085450, -1107159, -1128868, -1150577, -1172286, -1193995, -1215704,
//        -1237413, -1259122, -1280831, -1302540, -1324249, -1345958, -1367667, -1389376,
//        -1411085, -1432794, -1454503, -1476212, -1497921, -1519630, -1541339, -1563048,
//        -1584757, -1606466, -1628175, -1649884, -1671593, -1693302, -1715011, -1736720,
//        -1758429, -1780138, -1801847, -1823556, -1845265, -1866974, -1888683, -1910392,
//        -1932101, -1953810, -1975519, -1997228, -2018937, -2040646, -2062355, -2084064,
//        -2105773, -2127482, -2149191, -2170900, -2192609, -2214318, -2236027, -2257736,
//        -2279445, -2301154, -2322863, -2344572, -2366281, -2387990, -2409699, -2431408,
//        -2453117, -2474826, -2496535, -2518244, -2539953, -2561662, -2583371, -2605080,
//        -2626789, -2648498, -2670207, -2691916, -2713625, -2735334, -2757043, -2778752,
//        -2800461, -2822170, -2843879, -2865588, -2887297, -2909006, -2930715, -2952424,
//        -2974133, -2995842, -3017551, -3039260, -3060969, -3082678, -3104387, -3126096,
//        -3147805, -3169514, -3191223, -3212932, -3234641, -3256350, -3278059, -3299768,
//        -3321477, -3343186, -3364895, -3386604, -3408313, -3430022, -3451731, -3473440,
//        -3495149, -3516858, -3538567, -3560276, -3581985, -3603694, -3625403, -3647112,
//        -3668821, -3690530, -3712239, -3733948, -3755657, -3777366, -3799075, -3820784,
//        -3842493, -3864202, -3885911, -3907620, -3929329, -3951038, -3972747, -3994456,
//        -4016165, -4037874, -4059583, -4081292, -4103001, -4124710, -4146419, -4168128,
//        -4189837, -4211546, -4233255, -4254964, -4276673, -4298382, -4320091, -4341800,
//        -4363509, -4385218, -4406927, -4428636, -4450345, -4472054, -4493763, -4515472,
//        -4537181, -4558890, -4580599, -4602308, -4624017, -4645726, -4667435, -4689144,
//        -4710853, -4732562, -4754271, -4775980, -4797689, -4819398, -4841107, -4862816,
//        -4884525, -4906234, -4927943, -4949652, -4971361, -4993070, -5014779, -5036488,
//        -5058197, -5079906, -5101615, -5123324, -5145033, -5166742, -5188451, -5210160,
//        -5231869, -5253578, -5275287, -5296996, -5318705, -5340414, -5362123, -5383832,
//        -5405541, -5427250, -5448959, -5470668, -5492377, -5514086, -5535795, 8421375,
//        8454143, 8486911, 8519679, 8552447, 8585215, 8617983, 8650751, 8683519, 8716287,
//        8749055, 8781823, 8814591, 8847359, 8880127, 8912895, 8945663, 8978431, 9011199,
//        9043967, 9076735, 9109503, 9142271, 9175039, 9207807, 9240575, 9273343, 9306111,
//        9338879, 9371647, 9404415, 9437183, 9469951, 9502719, 9535487, 9568255, 9601023,
//        9633791, 9666559, 9699327, 9732095, 9764863, 9797631, 9830399, 9863167, 9895935,
//        9928703, 9961471, 9994239, 10027007, 10059775, 10092543, 10125311, 10158079,
//        10190847, 10223615, 10256383, 10289151, 10321919, 10354687, 10387455, 10420223,
//        10452991, 10485759, 10518527, 10551295, 10584063, 10616831, 10649599, 10682367,
//        10715135, 10747903, 10780671, 10813439, 10846207, 10878975, 10911743, 10944511,
//        10977279, 11010047, 11042815, 11075583, 11108351, 11141119, 11173887, 11206655,
//        11239423, 11272191, 11304959, 11337727, 11370495, 11403263, 11436031, 11468799,
//        11501567, 11534335, 11567103, 11599871, 11632639, 11665407, 11698175, 11730943,
//        11763711, 11796479, 11829247, 11862015, 11894783, 11927551, 11960319, 11993087,
//        12025855, 12058623, 12091391, 12124159, 12156927, 12189695, 12222463, 12255231,
//        12287999, 12320767, 12353535, 12386303, 12419071, 12451839, 12484607, 12517375,
//        12550143, 12582911, 12615679, 12648447, 12681215, 12713983, 12746751, 12779519,
//        12812287, 12845055, 12877823, 12910591, 12943359, 12976127, 13008895, 13041663,
//        13074431, 13107199, 13139967, 13172735, 13205503, 13238271, 13271039, 13303807,
//        13336575, 13369343, 13402111, 13434879, 13467647, 13500415, 13533183, 13565951,
//        13598719, 13631487, 13664255, 13697023, 13729791, 13762559, 13795327, 13828095,
//        13860863, 13893631, 13926399, 13959167, 13991935, 14024703, 14057471, 14090239,
//        14123007, 14155775, 14188543, 14221311, 14254079, 14286847, 14319615, 14352383,
//        14385151, 14417919, 14450687, 14483455, 14516223, 14548991, 14581759, 14614527,
//        14647295, 14680063, 14712831, 14745599, 14778367, 14811135, 14843903, 14876671,
//        14909439, 14942207, 14974975, 15007743, 15040511, 15073279, 15106047, 15138815,
//        15171583, 15204351, 15237119, 15269887, 15302655, 15335423, 15368191, 15400959,
//        15433727, 15466495, 15499263, 15532031, 15564799, 15597567, 15630335, 15663103,
//        15695871, 15728639, 15761407, 15794175, 15826943, 15859711, 15892479, 15925247,
//        15958015, 15990783, 16023551, 16056319, 16089087, 16121855, 16154623, 16187391,
//        16220159, 16252927, 16285695, 16318463, 16351231, 16383999, 16416767, 16449535,
//        16482303, 16515071, 16547839, 16580607, 16613375, 16646143, 16678911, 16711679,
//        16744447, 16777215, 0, -27439, -54878, -82317, -109756, -137195, -164634, -192073,
//        -219512, -246951, -274390, -301829, -329268, -356707, -384146, -411585, -439024,
//        -466463, -493902, -521341, -548780, -576219, -603658, -631097, -658536, -685975,
//        -713414, -740853, -768292, -795731, -823170, -850609, -878048, -905487, -932926,
//        -960365, -987804, -1015243, -1042682, -1070121, -1097560, -1124999, -1152438,
//        -1179877, -1207316, -1234755, -1262194, -1289633, -1317072, -1344511, -1371950,
//        -1399389, -1426828, -1454267, -1481706, -1509145, -1536584, -1564023, -1591462,
//        -1618901, -1646340, -1673779, -1701218, -1728657, -1756096, -1783535, -1810974,
//        -1838413, -1865852, -1893291, -1920730, -1948169, -1975608, -2003047, -2030486,
//        -2057925, -2085364, -2112803, -2140242, -2167681, -2195120, -2222559, -2249998,
//        -2277437, -2304876, -2332315, -2359754, -2387193, -2414632, -2442071, -2469510,
//        -2496949, -2524388, -2551827, -2579266, -2606705, -2634144, -2661583, -2689022,
//        -2716461, -2743900, -2771339, -2798778, -2826217, -2853656, -2881095, -2908534,
//        -2935973, -2963412, -2990851, -3018290, -3045729, -3073168, -3100607, -3128046,
//        -3155485, -3182924, -3210363, -3237802, -3265241, -3292680, -3320119, -3347558,
//        -3374997, -3402436, -3429875, -3457314, -3484753, -3512192, -3539631, -3567070,
//        -3594509, -3621948, -3649387, -3676826, -3704265, -3731704, -3759143, -3786582,
//        -3814021, -3841460, -3868899, -3896338, -3923777, -3951216, -3978655, -4006094,
//        -4033533, -4060972, -4088411, -4115850, -4143289, -4170728, -4198167, -4225606,
//        -4253045, -4280484, -4307923, -4335362, -4362801, -4390240, -4417679, -4445118,
//        -4472557, -4499996, -4527435, -4554874, -4582313, -4609752, -4637191, -4664630,
//        -4692069, -4719508, -4746947, -4774386, -4801825, -4829264, -4856703, -4884142,
//        -4911581, -4939020, -4966459, -4993898, -5021337, -5048776, -5076215, -5103654,
//        -5131093, -5158532, -5185971, -5213410, -5240849, -5268288, -5295727, -5323166,
//        -5350605, -5378044, -5405483, -5432922, -5460361, -5487800, -5515239, -5542678,
//        -5570117, -5597556, -5624995, -5652434, -5679873, -5707312, -5734751, -5762190,
//        -5789629, -5817068, -5844507, -5871946, -5899385, -5926824, -5954263, -5981702,
//        -6009141, -6036580, -6064019, -6091458, -6118897, -6146336, -6173775, -6201214,
//        -6228653, -6256092, -6283531, -6310970, -6338409, -6365848, -6393287, -6420726,
//        -6448165, -6475604, -6503043, -6530482, -6557921, -6585360, -6612799, -6640238,
//        -6667677, -6695116, -6722555, -6749994, -6777433, -6804872, -6832311, -6859750,
//        -6887189, -6914628, -6942067, -6969506, -6996945, 0, -5329, -10658, -15987,
//        -21316, -26645, -31974, -37303, -42632, -47961, -53290, -58619, -63948, -69277,
//        -74606, -79935, -85264, -90593, -95922, -101251, -106580, -111909, -117238,
//        -122567, -127896, -133225, -138554, -143883, -149212, -154541, -159870, -165199,
//        -170528, -175857, -181186, -186515, -191844, -197173, -202502, -207831, -213160,
//        -218489, -223818, -229147, -234476, -239805, -245134, -250463, -255792, -261121,
//        -266450, -271779, -277108, -282437, -287766, -293095, -298424, -303753, -309082,
//        -314411, -319740, -325069, -330398, -335727, -341056, -346385, -351714, -357043,
//        -362372, -367701, -373030, -378359, -383688, -389017, -394346, -399675, -405004,
//        -410333, -415662, -420991, -426320, -431649, -436978, -442307, -447636, -452965,
//        -458294, -463623, -468952, -474281, -479610, -484939, -490268, -495597, -500926,
//        -506255, -511584, -516913, -522242, -527571, -532900, -538229, -543558, -548887,
//        -554216, -559545, -564874, -570203, -575532, -580861, -586190, -591519, -596848,
//        -602177, -607506, -612835, -618164, -623493, -628822, -634151, -639480, -644809,
//        -650138, -655467, -660796, -666125, -671454, -676783, -682112, -687441, -692770,
//        -698099, -703428, -708757, -714086, -719415, -724744, -730073, -735402, -740731,
//        -746060, -751389, -756718, -762047, -767376, -772705, -778034, -783363, -788692,
//        -794021, -799350, -804679, -810008, -815337, -820666, -825995, -831324, -836653,
//        -841982, -847311, -852640, -857969, -863298, -868627, -873956, -879285, -884614,
//        -889943, -895272, -900601, -905930, -911259, -916588, -921917, -927246, -932575,
//        -937904, -943233, -948562, -953891, -959220, -964549, -969878, -975207, -980536,
//        -985865, -991194, -996523, -1001852, -1007181, -1012510, -1017839, -1023168,
//        -1028497, -1033826, -1039155, -1044484, -1049813, -1055142, -1060471, -1065800,
//        -1071129, -1076458, -1081787, -1087116, -1092445, -1097774, -1103103, -1108432,
//        -1113761, -1119090, -1124419, -1129748, -1135077, -1140406, -1145735, -1151064,
//        -1156393, -1161722, -1167051, -1172380, -1177709, -1183038, -1188367, -1193696,
//        -1199025, -1204354, -1209683, -1215012, -1220341, -1225670, -1230999, -1236328,
//        -1241657, -1246986, -1252315, -1257644, -1262973, -1268302, -1273631, -1278960,
//        -1284289, -1289618, -1294947, -1300276, -1305605, -1310934, -1316263, -1321592,
//        -1326921, -1332250, -1337579, -1342908, -1348237, -1353566, -1358895
//    };
}
