/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg;

import com.idrsolutions.image.jpeg.AdobeHolder;
import com.idrsolutions.image.jpeg.Component;
import com.idrsolutions.image.jpeg.DCT;
import com.idrsolutions.image.jpeg.Frame;
import com.idrsolutions.image.jpeg.Info;
import com.idrsolutions.image.jpeg.JFIFHolder;
import com.idrsolutions.image.jpeg.JpegHuffman;
import com.idrsolutions.image.jpeg.JpegLUT;
import com.idrsolutions.image.jpeg.JpegScanner;
import com.idrsolutions.image.jpeg2000.EnumeratedSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.HashMap;

public class JpegDecoder {
    private int offset;
    private byte[] data;
    private boolean cmykInverted = true;
    private final HashMap<Integer, int[]> qTables = new HashMap();
    private Info info;

    public BufferedImage read(byte[] jpegRawData) throws Exception {
        this.info = new Info();
        this.updateJpegInfo(jpegRawData);
        Object[] YCBCR = JpegDecoder.decodeSampling(this.info);
        return this.getBufferdImageFromInfo(this.info, YCBCR);
    }

    public byte[] readComponentsAsRawBytes(byte[] jpegRawData) throws Exception {
        this.info = new Info();
        this.updateJpegInfo(jpegRawData);
        Object[] YCBCR = JpegDecoder.decodeSampling(this.info);
        return JpegDecoder.getBytesArrayFromInfo(this.info, YCBCR);
    }

    public byte[] readComponentsAsConvertedBytes(byte[] jpegRawData) throws Exception {
        this.info = new Info();
        this.updateJpegInfo(jpegRawData);
        Object[] YCBCR = JpegDecoder.decodeSampling(this.info);
        return this.getConvertedBytesFromInfo(this.info, YCBCR);
    }

    private static Object[] decodeSampling(Info info) {
        Component comp;
        int i;
        int nComp = info.nComp;
        int maxH = info.maxH;
        int maxV = info.maxV;
        Object[] lineComps = new Object[nComp];
        int maxLineX = 0;
        int maxLineY = 0;
        for (i = 0; i < nComp; ++i) {
            comp = info.frame.components.get(i);
            int blocksX = comp.blocksX + 1;
            int blocksY = comp.blocksY + 1;
            int lineX = blocksX << 3;
            int lineY = blocksY << 3;
            maxLineX = Math.max(lineX, maxLineX);
            maxLineY = Math.max(lineY, maxLineY);
        }
        info.maxLineX = maxLineX;
        for (i = 0; i < nComp; ++i) {
            int pointer;
            comp = info.frame.components.get(i);
            int vIter = maxV / comp.v;
            int hIter = maxH / comp.h;
            int blocksX = comp.blocksX + 1;
            int blocksY = comp.blocksY + 1;
            int lineX = blocksX << 3;
            int lineY = blocksY << 3;
            int[] compData = comp.codeBlock;
            byte[] maxData = new byte[maxLineY * maxLineX];
            int idx = 0;
            if (vIter == 1 && hIter == 1) {
                for (int r = 0; r < blocksY; ++r) {
                    for (int c = 0; c < blocksX; ++c) {
                        pointer = c + r * lineX << 3;
                        for (int a = 0; a < 8; ++a) {
                            for (int b = 0; b < 8; ++b) {
                                maxData[pointer + b] = (byte)compData[idx++];
                            }
                            pointer += lineX;
                        }
                    }
                }
            } else {
                byte[] tempData = new byte[lineX * lineY];
                for (int r = 0; r < blocksY; ++r) {
                    for (int c = 0; c < blocksX; ++c) {
                        pointer = c + r * lineX << 3;
                        for (int a = 0; a < 8; ++a) {
                            for (int b = 0; b < 8; ++b) {
                                tempData[pointer + b] = (byte)compData[idx++];
                            }
                            pointer += lineX;
                        }
                    }
                }
                idx = 0;
                int sPos = 0;
                byte[] tempLine = new byte[lineX * hIter];
                for (int y = 0; y < lineY; ++y) {
                    int tPos = 0;
                    for (int x = 0; x < lineX; ++x) {
                        byte tVal = tempData[idx++];
                        for (int h = 0; h < hIter; ++h) {
                            tempLine[tPos++] = tVal;
                        }
                    }
                    for (int v = 0; v < vIter; ++v) {
                        if (sPos + maxLineX >= maxData.length) continue;
                        System.arraycopy(tempLine, 0, maxData, sPos, maxLineX);
                        sPos += maxLineX;
                    }
                }
            }
            lineComps[i] = maxData;
        }
        info.frame.components.clear();
        return lineComps;
    }

    private static byte[] getBytesArrayFromInfo(Info info, Object[] YCBCR) {
        byte[] output = null;
        int p = 0;
        int maxLineX = info.maxLineX;
        switch (info.nComp) {
            case 1: {
                byte[] comp0 = (byte[])YCBCR[0];
                output = new byte[info.height * info.width];
                for (int i = 0; i < info.height; ++i) {
                    int index = i * maxLineX;
                    for (int j = 0; j < info.width; ++j) {
                        output[p++] = comp0[index++];
                    }
                }
                break;
            }
            case 2: {
                byte[] comp0 = (byte[])YCBCR[0];
                byte[] comp1 = (byte[])YCBCR[1];
                output = new byte[info.height * info.width * 2];
                for (int i = 0; i < info.height; ++i) {
                    int index = i * maxLineX;
                    for (int j = 0; j < info.width; ++j) {
                        output[p++] = comp0[index];
                        output[p++] = comp1[index];
                        ++index;
                    }
                }
                break;
            }
            case 3: {
                byte[] comp0 = (byte[])YCBCR[0];
                byte[] comp1 = (byte[])YCBCR[1];
                byte[] comp2 = (byte[])YCBCR[2];
                output = new byte[info.height * info.width * 3];
                for (int i = 0; i < info.height; ++i) {
                    int index = i * maxLineX;
                    for (int j = 0; j < info.width; ++j) {
                        output[p++] = comp0[index];
                        output[p++] = comp1[index];
                        output[p++] = comp2[index];
                        ++index;
                    }
                }
                break;
            }
            case 4: {
                byte[] comp0 = (byte[])YCBCR[0];
                byte[] comp1 = (byte[])YCBCR[1];
                byte[] comp2 = (byte[])YCBCR[2];
                byte[] comp3 = (byte[])YCBCR[3];
                output = new byte[info.height * info.width * 4];
                for (int i = 0; i < info.height; ++i) {
                    int index = i * maxLineX;
                    for (int j = 0; j < info.width; ++j) {
                        output[p++] = comp0[index];
                        output[p++] = comp1[index];
                        output[p++] = comp2[index];
                        output[p++] = comp3[index];
                        ++index;
                    }
                }
                break;
            }
        }
        return output;
    }

    private byte[] getConvertedBytesFromInfo(Info info, Object[] YCBCR) {
        byte[] pixelsByte = null;
        int p = 0;
        int maxLineX = info.maxLineX;
        switch (info.nComp) {
            case 1: {
                pixelsByte = new byte[info.width * info.height];
                byte[] comp0 = (byte[])YCBCR[0];
                for (int i = 0; i < info.height; ++i) {
                    int index = i * maxLineX;
                    for (int j = 0; j < info.width; ++j) {
                        pixelsByte[p++] = comp0[index++];
                    }
                }
                break;
            }
            case 2: {
                System.out.println("two color component jpegs not supported yet");
                break;
            }
            case 3: {
                pixelsByte = new byte[info.width * info.height * 3];
                byte[] comp0 = (byte[])YCBCR[0];
                byte[] comp1 = (byte[])YCBCR[1];
                byte[] comp2 = (byte[])YCBCR[2];
                if (info.adobe != null && info.adobe.transformCode == 0) {
                    for (int i = 0; i < info.height; ++i) {
                        int index = i * maxLineX;
                        for (int j = 0; j < info.width; ++j) {
                            int r = comp0[index] & 0xFF;
                            int g = comp1[index] & 0xFF;
                            int b = comp2[index] & 0xFF;
                            int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
                            int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
                            b = b < 0 ? 0 : (b > 255 ? 255 : b);
                            pixelsByte[p++] = (byte)r;
                            pixelsByte[p++] = (byte)g;
                            pixelsByte[p++] = (byte)b;
                            ++index;
                        }
                    }
                } else {
                    for (int i = 0; i < info.height; ++i) {
                        int index = i * maxLineX;
                        for (int j = 0; j < info.width; ++j) {
                            int y = comp0[index] & 0xFF;
                            int u = comp1[index] & 0xFF;
                            int v = comp2[index] & 0xFF;
                            int u2 = (u -= 128) >> 2;
                            int v35 = ((v -= 128) >> 3) + (v >> 5);
                            int r = y + v + (v >> 2) + v35;
                            int g = y - (u2 + (u >> 4) + (u >> 5)) - ((v >> 1) + v35 + (v >> 4));
                            int b = y + u + (u >> 1) + u2 + (u >> 6);
                            int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
                            int n3 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
                            b = b < 0 ? 0 : (b > 255 ? 255 : b);
                            pixelsByte[p++] = (byte)r;
                            pixelsByte[p++] = (byte)g;
                            pixelsByte[p++] = (byte)b;
                            ++index;
                        }
                    }
                }
                break;
            }
            case 4: {
                pixelsByte = new byte[info.width * info.height * 3];
                byte[] comp0 = (byte[])YCBCR[0];
                byte[] comp1 = (byte[])YCBCR[1];
                byte[] comp2 = (byte[])YCBCR[2];
                byte[] comp3 = (byte[])YCBCR[3];
                EnumeratedSpace cmyk = new EnumeratedSpace();
                if (info.adobe.transformCode == 0) {
                    if (this.cmykInverted) {
                        for (int i = 0; i < info.height; ++i) {
                            int index = i * maxLineX;
                            for (int j = 0; j < info.width; ++j) {
                                int c = 255 - (comp0[index] & 0xFF);
                                int m = 255 - (comp1[index] & 0xFF);
                                int y = 255 - (comp2[index] & 0xFF);
                                int k = 255 - (comp3[index] & 0xFF);
                                byte[] bb = cmyk.getRGB((byte)c, (byte)m, (byte)y, (byte)k);
                                pixelsByte[p++] = bb[0];
                                pixelsByte[p++] = bb[1];
                                pixelsByte[p++] = bb[2];
                                ++index;
                            }
                        }
                    } else {
                        for (int i = 0; i < info.height; ++i) {
                            int index = i * maxLineX;
                            for (int j = 0; j < info.width; ++j) {
                                int c = comp0[index] & 0xFF;
                                int m = comp1[index] & 0xFF;
                                int y = comp2[index] & 0xFF;
                                int k = comp3[index] & 0xFF;
                                byte[] bb = cmyk.getRGB((byte)c, (byte)m, (byte)y, (byte)k);
                                pixelsByte[p++] = bb[0];
                                pixelsByte[p++] = bb[1];
                                pixelsByte[p++] = bb[2];
                                ++index;
                            }
                        }
                    }
                } else if (this.cmykInverted) {
                    for (int i = 0; i < info.height; ++i) {
                        int index = i * maxLineX;
                        for (int j = 0; j < info.width; ++j) {
                            int m;
                            int c;
                            int y = 255 - (comp0[index] & 0xFF);
                            int u = 255 - (comp1[index] & 0xFF);
                            int v = 255 - (comp2[index] & 0xFF);
                            int k = 255 - (comp3[index] & 0xFF);
                            double cc = 434.456 - (double)y - 1.402 * (double)v;
                            double mm = 119.541 - (double)y + 0.344 * (double)u + 0.714 * (double)v;
                            double yy = 481.816 - (double)y - 1.772 * (double)u;
                            int n = cc < 0.0 ? 0 : (c = cc > 255.0 ? 255 : (int)cc);
                            int n4 = mm < 0.0 ? 0 : (m = mm > 255.0 ? 255 : (int)mm);
                            y = yy < 0.0 ? 0 : (yy > 255.0 ? 255 : (int)yy);
                            byte[] bb = cmyk.getRGB((byte)c, (byte)m, (byte)y, (byte)k);
                            pixelsByte[p++] = bb[0];
                            pixelsByte[p++] = bb[1];
                            pixelsByte[p++] = bb[2];
                            ++index;
                        }
                    }
                } else {
                    for (int i = 0; i < info.height; ++i) {
                        int index = i * maxLineX;
                        for (int j = 0; j < info.width; ++j) {
                            int m;
                            int c;
                            int y = comp0[index] & 0xFF;
                            int u = comp1[index] & 0xFF;
                            int v = comp2[index] & 0xFF;
                            int k = comp3[index] & 0xFF;
                            double cc = 434.456 - (double)y - 1.402 * (double)v;
                            double mm = 119.541 - (double)y + 0.344 * (double)u + 0.714 * (double)v;
                            double yy = 481.816 - (double)y - 1.772 * (double)u;
                            int n = cc < 0.0 ? 0 : (c = cc > 255.0 ? 255 : (int)cc);
                            int n5 = mm < 0.0 ? 0 : (m = mm > 255.0 ? 255 : (int)mm);
                            y = yy < 0.0 ? 0 : (yy > 255.0 ? 255 : (int)yy);
                            byte[] bb = cmyk.getRGB((byte)c, (byte)m, (byte)y, (byte)k);
                            pixelsByte[p++] = bb[0];
                            pixelsByte[p++] = bb[1];
                            pixelsByte[p++] = bb[2];
                            ++index;
                        }
                    }
                }
                break;
            }
        }
        return pixelsByte;
    }

    private BufferedImage getBufferdImageFromInfo(Info info, Object[] YCBCR) {
        BufferedImage image = null;
        int p = 0;
        int maxLineX = info.maxLineX;
        switch (info.nComp) {
            case 1: {
                image = new BufferedImage(info.width, info.height, 10);
                byte[] pixelsByte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                byte[] comp0 = (byte[])YCBCR[0];
                for (int i = 0; i < info.height; ++i) {
                    int index = i * maxLineX;
                    for (int j = 0; j < info.width; ++j) {
                        pixelsByte[p++] = comp0[index++];
                    }
                }
                break;
            }
            case 2: {
                System.out.println("two color component jpegs not supported yet");
                break;
            }
            case 3: {
                image = new BufferedImage(info.width, info.height, 1);
                int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                byte[] comp0 = (byte[])YCBCR[0];
                byte[] comp1 = (byte[])YCBCR[1];
                byte[] comp2 = (byte[])YCBCR[2];
                if (info.adobe != null && info.adobe.transformCode == 0) {
                    for (int i = 0; i < info.height; ++i) {
                        int index = i * maxLineX;
                        for (int j = 0; j < info.width; ++j) {
                            int r = comp0[index] & 0xFF;
                            int g = comp1[index] & 0xFF;
                            int b = comp2[index] & 0xFF;
                            int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
                            int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
                            b = b < 0 ? 0 : (b > 255 ? 255 : b);
                            pixels[p++] = r << 16 | g << 8 | b;
                            ++index;
                        }
                    }
                } else {
                    for (int i = 0; i < info.height; ++i) {
                        int index = i * maxLineX;
                        for (int j = 0; j < info.width; ++j) {
                            int y = comp0[index] & 0xFF;
                            int u = comp1[index] & 0xFF;
                            int v = comp2[index] & 0xFF;
                            y = (y << 8) + 128;
                            int r = y + 359 * (v -= 128) >> 8;
                            int g = y - 88 * (u -= 128) - 183 * v >> 8;
                            int b = y + 454 * u >> 8;
                            int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
                            int n3 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
                            b = b < 0 ? 0 : (b > 255 ? 255 : b);
                            pixels[p++] = r << 16 | g << 8 | b;
                            ++index;
                        }
                    }
                }
                break;
            }
            case 4: {
                image = new BufferedImage(info.width, info.height, 1);
                int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                byte[] comp0 = (byte[])YCBCR[0];
                byte[] comp1 = (byte[])YCBCR[1];
                byte[] comp2 = (byte[])YCBCR[2];
                byte[] comp3 = (byte[])YCBCR[3];
                EnumeratedSpace cmyk = new EnumeratedSpace();
                if (info.adobe.transformCode == 0) {
                    if (this.cmykInverted) {
                        for (int i = 0; i < info.height; ++i) {
                            int index = i * maxLineX;
                            for (int j = 0; j < info.width; ++j) {
                                int c = 255 - (comp0[index] & 0xFF);
                                int m = 255 - (comp1[index] & 0xFF);
                                int y = 255 - (comp2[index] & 0xFF);
                                int k = 255 - (comp3[index] & 0xFF);
                                byte[] bb = cmyk.getRGB((byte)c, (byte)m, (byte)y, (byte)k);
                                int r = bb[0] & 0xFF;
                                int g = bb[1] & 0xFF;
                                int b = bb[2] & 0xFF;
                                pixels[p++] = r << 16 | g << 8 | b;
                                ++index;
                            }
                        }
                    } else {
                        for (int i = 0; i < info.height; ++i) {
                            int index = i * maxLineX;
                            for (int j = 0; j < info.width; ++j) {
                                int c = comp0[index] & 0xFF;
                                int m = comp1[index] & 0xFF;
                                int y = comp2[index] & 0xFF;
                                int k = comp3[index] & 0xFF;
                                byte[] bb = cmyk.getRGB((byte)c, (byte)m, (byte)y, (byte)k);
                                int r = bb[0] & 0xFF;
                                int g = bb[1] & 0xFF;
                                int b = bb[2] & 0xFF;
                                pixels[p++] = r << 16 | g << 8 | b;
                                ++index;
                            }
                        }
                    }
                } else if (this.cmykInverted) {
                    for (int i = 0; i < info.height; ++i) {
                        int index = i * maxLineX;
                        for (int j = 0; j < info.width; ++j) {
                            int m;
                            int c;
                            int y = 255 - (comp0[index] & 0xFF);
                            int u = 255 - (comp1[index] & 0xFF);
                            int v = 255 - (comp2[index] & 0xFF);
                            int k = 255 - (comp3[index] & 0xFF);
                            double cc = 434.456 - (double)y - 1.402 * (double)v;
                            double mm = 119.541 - (double)y + 0.344 * (double)u + 0.714 * (double)v;
                            double yy = 481.816 - (double)y - 1.772 * (double)u;
                            int n = cc < 0.0 ? 0 : (c = cc > 255.0 ? 255 : (int)cc);
                            int n4 = mm < 0.0 ? 0 : (m = mm > 255.0 ? 255 : (int)mm);
                            y = yy < 0.0 ? 0 : (yy > 255.0 ? 255 : (int)yy);
                            byte[] bb = cmyk.getRGB((byte)c, (byte)m, (byte)y, (byte)k);
                            int r = bb[0] & 0xFF;
                            int g = bb[1] & 0xFF;
                            int b = bb[2] & 0xFF;
                            pixels[p++] = r << 16 | g << 8 | b;
                            ++index;
                        }
                    }
                } else {
                    for (int i = 0; i < info.height; ++i) {
                        int index = i * maxLineX;
                        for (int j = 0; j < info.width; ++j) {
                            int m;
                            int c;
                            int y = comp0[index] & 0xFF;
                            int u = comp1[index] & 0xFF;
                            int v = comp2[index] & 0xFF;
                            int k = comp3[index] & 0xFF;
                            double cc = 434.456 - (double)y - 1.402 * (double)v;
                            double mm = 119.541 - (double)y + 0.344 * (double)u + 0.714 * (double)v;
                            double yy = 481.816 - (double)y - 1.772 * (double)u;
                            int n = cc < 0.0 ? 0 : (c = cc > 255.0 ? 255 : (int)cc);
                            int n5 = mm < 0.0 ? 0 : (m = mm > 255.0 ? 255 : (int)mm);
                            y = yy < 0.0 ? 0 : (yy > 255.0 ? 255 : (int)yy);
                            byte[] bb = cmyk.getRGB((byte)c, (byte)m, (byte)y, (byte)k);
                            int r = bb[0] & 0xFF;
                            int g = bb[1] & 0xFF;
                            int b = bb[2] & 0xFF;
                            pixels[p++] = r << 16 | g << 8 | b;
                            ++index;
                        }
                    }
                }
                break;
            }
        }
        return image;
    }

    private void updateJpegInfo(byte[] data) throws Exception {
        this.data = data;
        int length = data.length;
        int ri = 0;
        Frame frame = new Frame();
        if (this.readUShort() != 65496) {
            throw new Exception("This File is not a valid JPEG");
        }
        Object[] huffmanTablesAC = new Object[10];
        Object[] huffmanTablesDC = new Object[10];
        int markerRead = this.readUShort();
        while (markerRead != 65497 && this.offset < length) {
            switch (markerRead) {
                case 65504: 
                case 65505: 
                case 65506: 
                case 65507: 
                case 65508: 
                case 65509: 
                case 65510: 
                case 65511: 
                case 65512: 
                case 65513: 
                case 65514: 
                case 65515: 
                case 65516: 
                case 65517: 
                case 65518: 
                case 65519: {
                    byte[] apps = this.readDataArray();
                    if (markerRead == 65504 && JpegDecoder.isJFIF(apps)) {
                        JFIFHolder jfif = new JFIFHolder();
                        jfif.majorNo = apps[5] & 0xFF;
                        jfif.minorNo = apps[6] & 0xFF;
                        jfif.xDensity = (apps[8] & 0xFF) << 8 | apps[9] & 0xFF;
                        jfif.yDensity = (apps[10] & 0xFF) << 8 | apps[11] & 0xFF;
                        jfif.thumbnailWidth = apps[12] & 0xFF;
                        jfif.thumbnailHeight = apps[13] & 0xFF;
                        this.info.jfif = jfif;
                        break;
                    }
                    if (markerRead != 65518 || !JpegDecoder.isAdobe(apps)) break;
                    AdobeHolder adobe = new AdobeHolder();
                    adobe.version = apps[6] & 0xFF;
                    adobe.flag0 = apps[7] & 0xFF00 | apps[8] & 0xFF;
                    adobe.flag1 = apps[9] & 0xFF00 | apps[10] & 0xFF;
                    adobe.transformCode = apps[11] & 0xFF;
                    this.info.adobe = adobe;
                    break;
                }
                case 65472: 
                case 65473: 
                case 65474: {
                    this.offset += 2;
                    frame.baseline = markerRead == 65472;
                    frame.extended = markerRead == 65473;
                    frame.progressive = markerRead == 65474;
                    frame.precision = data[this.offset++] & 0xFF;
                    frame.scanV = this.readUShort();
                    frame.scanH = this.readUShort();
                    int componentsCount = data[this.offset++] & 0xFF;
                    int maxH = 0;
                    int maxV = 0;
                    for (int i = 0; i < componentsCount; ++i) {
                        int componentId = data[this.offset] & 0xFF;
                        int vh = data[this.offset + 1] & 0xFF;
                        int h = vh >> 4;
                        int v = vh & 0xF;
                        if (maxH < h) {
                            maxH = h;
                        }
                        if (maxV < v) {
                            maxV = v;
                        }
                        int qId = data[this.offset + 2] & 0xFF;
                        Component comp = new Component();
                        comp.h = h;
                        comp.v = v;
                        comp.qTable = this.qTables.get(qId);
                        frame.components.add(comp);
                        frame.componentID.put(componentId, frame.components.size() - 1);
                        this.offset += 3;
                    }
                    frame.maxH = maxH;
                    frame.maxV = maxV;
                    JpegDecoder.initializeComponents(frame);
                    break;
                }
                case 65475: 
                case 65477: 
                case 65478: 
                case 65479: {
                    throw new Exception("Lossless Jpeg is not supported yet");
                }
                case 65481: 
                case 65482: 
                case 65483: {
                    throw new Exception("Arithmetic encoded Jpeg is not supported yet");
                }
                case 65499: {
                    int dqtLen = this.readUShort();
                    int quantizationTablesEnd = dqtLen + this.offset - 2;
                    while (this.offset < quantizationTablesEnd) {
                        byte z;
                        int i;
                        int qs = data[this.offset++] & 0xFF;
                        int[] tableData = new int[64];
                        if (qs >> 4 == 0) {
                            for (i = 0; i < 64; ++i) {
                                z = JpegLUT.ZIGZAGORDER[i];
                                tableData[z] = data[this.offset++] & 0xFF;
                            }
                        } else if (qs >> 4 == 1) {
                            for (i = 0; i < 64; ++i) {
                                z = JpegLUT.ZIGZAGORDER[i];
                                tableData[z] = this.readUShort();
                            }
                        }
                        this.qTables.put(qs & 0xF, tableData);
                    }
                    break;
                }
                case 65476: {
                    int codeLengthTotal;
                    int huffmanLength = this.readUShort();
                    for (int i = 2; i < huffmanLength; i += 17 + codeLengthTotal) {
                        int huffmanTableSpec = data[this.offset++] & 0xFF;
                        int[] codeLengths = new int[16];
                        codeLengthTotal = 0;
                        for (int j = 0; j < 16; ++j) {
                            codeLengths[j] = data[this.offset] & 0xFF;
                            codeLengthTotal += codeLengths[j];
                            ++this.offset;
                        }
                        int[] huffmanValues = new int[codeLengthTotal];
                        int j = 0;
                        while (j < codeLengthTotal) {
                            huffmanValues[j] = data[this.offset] & 0xFF;
                            ++j;
                            ++this.offset;
                        }
                        if (huffmanTableSpec >> 4 == 0) {
                            huffmanTablesDC[huffmanTableSpec & 0xF] = JpegHuffman.generateHuffmanTable(codeLengths, huffmanValues);
                            continue;
                        }
                        huffmanTablesAC[huffmanTableSpec & 0xF] = JpegHuffman.generateHuffmanTable(codeLengths, huffmanValues);
                    }
                    break;
                }
                case 65501: {
                    this.offset += 2;
                    ri = this.readUShort();
                    break;
                }
                case 65498: {
                    this.offset += 2;
                    int sc = data[this.offset++] & 0xFF;
                    ArrayList<Component> components = new ArrayList<Component>();
                    for (int i = 0; i < sc; ++i) {
                        int componentIndex = frame.componentID.get(data[this.offset++] & 0xFF);
                        Component component = frame.components.get(componentIndex);
                        int tableSpec = data[this.offset++] & 0xFF;
                        component.huffmanTableDC = huffmanTablesDC[tableSpec >> 4];
                        component.huffmanTableAC = huffmanTablesAC[tableSpec & 0xF];
                        components.add(component);
                    }
                    int sStart = data[this.offset++] & 0xFF;
                    int sEnd = data[this.offset++] & 0xFF;
                    int sApprox = data[this.offset++] & 0xFF;
                    JpegScanner scanner = new JpegScanner(data);
                    int processed = scanner.decodeScan(this.offset, frame, components, ri, sStart, sEnd, sApprox >> 4, sApprox & 0xF);
                    this.offset += processed;
                    break;
                }
                case 65534: {
                    this.readDataArray();
                    break;
                }
                default: {
                    System.err.println("Invalid jpeg marker found");
                    int len = this.readUShort();
                    this.offset += len - 2;
                }
            }
            markerRead = this.readUShort();
        }
        this.info.width = frame.scanH;
        this.info.height = frame.scanV;
        for (Component component : frame.components) {
            component.codeBlock = JpegDecoder.buildComponentData(component);
        }
        this.info.maxH = frame.maxH;
        this.info.maxV = frame.maxV;
        this.info.nComp = frame.components.size();
        this.info.frame = frame;
    }

    private int readUShort() {
        int value = (this.data[this.offset] & 0xFF) << 8 | this.data[this.offset + 1] & 0xFF;
        this.offset += 2;
        return value;
    }

    private static boolean isJFIF(byte[] db) {
        return (db[0] & 0xFF) == 74 && (db[1] & 0xFF) == 70 && (db[2] & 0xFF) == 73 && (db[3] & 0xFF) == 70 && (db[4] & 0xFF) == 0;
    }

    private static boolean isAdobe(byte[] db) {
        return (db[0] & 0xFF) == 65 && (db[1] & 0xFF) == 100 && (db[2] & 0xFF) == 111 && (db[3] & 0xFF) == 98 && (db[4] & 0xFF) == 101 && (db[5] & 0xFF) == 0;
    }

    private byte[] readDataArray() {
        int len = this.readUShort();
        byte[] bb = new byte[len - 2];
        System.arraycopy(this.data, this.offset, bb, 0, bb.length);
        this.offset += bb.length;
        return bb;
    }

    private static void initializeComponents(Frame frame) {
        int mcusPerLine = (int)Math.ceil((double)frame.scanH / 8.0 / (double)frame.maxH);
        int mcusPerColumn = (int)Math.ceil((double)frame.scanV / 8.0 / (double)frame.maxV);
        for (Component component : frame.components) {
            int blocksPerLine = (int)Math.ceil(Math.ceil((double)frame.scanH / 8.0) * (double)component.h / (1.0 * (double)frame.maxH));
            int blocksPerColumn = (int)Math.ceil(Math.ceil((double)frame.scanV / 8.0) * (double)component.v / (1.0 * (double)frame.maxV));
            int blocksPerLineForMcu = mcusPerLine * component.h;
            int blocksPerColumnForMcu = mcusPerColumn * component.v;
            int blocksBufferSize = 64 * (blocksPerColumnForMcu + 1) * (blocksPerLineForMcu + 1);
            component.codeBlock = new int[blocksBufferSize];
            component.blocksX = blocksPerLine;
            component.blocksY = blocksPerColumn;
        }
        frame.mcusX = mcusPerLine;
        frame.mcusY = mcusPerColumn;
    }

    private static int[] buildComponentData(Component component) {
        int blocksPerLine = component.blocksX;
        int blocksPerColumn = component.blocksY;
        for (int blockRow = 0; blockRow < blocksPerColumn; ++blockRow) {
            for (int blockCol = 0; blockCol < blocksPerLine; ++blockCol) {
                int offset = JpegScanner.getCodeBlockOffset(component, blockRow, blockCol);
                DCT.IDCTQ(component, offset);
            }
        }
        return component.codeBlock;
    }

    public boolean isInverted() {
        return this.cmykInverted;
    }

    public void setInverted(boolean inverted) {
        this.cmykInverted = inverted;
    }

    public Info getInfo() {
        return this.info;
    }
}

