/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg;

import com.idrsolutions.image.jpeg.DCT;
import com.idrsolutions.image.jpeg.JpegHuffman;
import com.idrsolutions.image.jpeg.JpegLUT;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.OutputStream;

public class JpegEncoder {
    private static final int[] sampleFrequency = new int[]{1, 1, 1};
    private static final int[] TableNumber = new int[]{0, 1, 1};

    public void write(BufferedImage image, OutputStream out) throws IOException {
        int i;
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        int nComp = 3;
        JpegHuffman huffman = new JpegHuffman();
        JpegEncoder.WriteHeaders(out, huffman, imageW, imageH, nComp);
        int[] frequencyH = new int[nComp];
        int[] frequencyW = new int[nComp];
        int maxF = 1;
        for (i = 0; i < sampleFrequency.length; ++i) {
            maxF = Math.max(maxF, sampleFrequency[i]);
        }
        for (i = 0; i < nComp; ++i) {
            double hh = Math.ceil(1.0 * (double)imageH * (double)sampleFrequency[i] / (double)maxF);
            double ww = Math.ceil(1.0 * (double)imageW * (double)sampleFrequency[i] / (double)maxF);
            frequencyH[i] = (int)(hh % 8.0 != 0.0 ? (Math.floor(hh / 8.0) + 1.0) * 8.0 : hh);
            frequencyW[i] = (int)(ww % 8.0 != 0.0 ? (Math.floor(ww / 8.0) + 1.0) * 8.0 : ww);
        }
        int cc = 0;
        int fw = frequencyW[0];
        int fh = frequencyH[0];
        int imageDiff = frequencyW[0] - imageW;
        int freqDim = fw * fh;
        byte[] r = new byte[freqDim];
        byte[] g = new byte[freqDim];
        byte[] b = new byte[freqDim];
        switch (image.getType()) {
            case 1: 
            case 2: {
                int[] pixInts = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                int a = 0;
                for (int i2 = 0; i2 < imageH; ++i2) {
                    for (int j = 0; j < imageW; ++j) {
                        byte[] bgr = JpegEncoder.intToBytes(pixInts[a]);
                        r[cc] = bgr[1];
                        g[cc] = bgr[2];
                        b[cc] = bgr[3];
                        ++a;
                        ++cc;
                    }
                    cc += imageDiff;
                }
                break;
            }
            case 4: {
                int[] pixBGR = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                int aa = 0;
                for (int i3 = 0; i3 < imageH; ++i3) {
                    for (int j = 0; j < imageW; ++j) {
                        byte[] bgr = JpegEncoder.intToBytes(pixBGR[aa]);
                        r[cc] = bgr[3];
                        g[cc] = bgr[2];
                        b[cc] = bgr[1];
                        ++aa;
                        ++cc;
                    }
                    cc += imageDiff;
                }
                break;
            }
            case 5: {
                byte[] pByte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int pb = 0;
                for (int i4 = 0; i4 < imageH; ++i4) {
                    for (int j = 0; j < imageW; ++j) {
                        r[cc] = pByte[pb + 2];
                        g[cc] = pByte[pb + 1];
                        b[cc] = pByte[pb];
                        pb += 3;
                        ++cc;
                    }
                    cc += imageDiff;
                }
                break;
            }
            case 6: {
                byte[] pBytes = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int pb4 = 0;
                for (int i5 = 0; i5 < imageH; ++i5) {
                    for (int j = 0; j < imageW; ++j) {
                        r[cc] = pBytes[pb4 + 3];
                        g[cc] = pBytes[pb4 + 2];
                        b[cc] = pBytes[pb4 + 1];
                        pb4 += 4;
                        ++cc;
                    }
                    cc += imageDiff;
                }
                break;
            }
            default: {
                BufferedImage bImage = new BufferedImage(imageW, imageH, 1);
                bImage.createGraphics().drawImage((Image)image, 0, 0, null);
                int[] pixInt = ((DataBufferInt)bImage.getRaster().getDataBuffer()).getData();
                int ii = 0;
                for (int i6 = 0; i6 < imageH; ++i6) {
                    for (int j = 0; j < imageW; ++j) {
                        byte[] bgr = JpegEncoder.intToBytes(pixInt[ii]);
                        r[cc] = bgr[1];
                        g[cc] = bgr[2];
                        b[cc] = bgr[3];
                        ++ii;
                        ++cc;
                    }
                    cc += imageDiff;
                }
            }
        }
        cc = 0;
        int dim = fw * fh;
        for (int i7 = 0; i7 < dim; ++i7) {
            int rr = r[cc] & 0xFF;
            int gg = g[cc] & 0xFF;
            int bb = b[cc] & 0xFF;
            int y = 128 + 76 * rr + 150 * gg + 29 * bb >> 8;
            int u = 128 + 127 * bb - 84 * gg - 43 * rr >> 8;
            int v = 128 + 127 * rr - 106 * gg - 21 * bb >> 8;
            r[cc] = (byte)(y -= 128);
            g[cc] = (byte)u;
            b[cc] = (byte)v;
            ++cc;
        }
        Object[] YCBCR = new Object[]{r, g, b};
        JpegEncoder.WriteCompressedData(out, huffman, YCBCR, fh, fw, nComp);
        JpegEncoder.WriteEOI(out);
    }

    private static void WriteCompressedData(OutputStream out, JpegHuffman huffman, Object[] YCBCR, int fh, int fw, int nComp) throws IOException {
        int[] arrayDCT = new int[64];
        int yBlocks = fh / 8;
        int xBlocks = fw / 8;
        int[] lastDCvalue = new int[nComp];
        for (int y = 0; y < yBlocks; ++y) {
            for (int x = 0; x < xBlocks; ++x) {
                int pos = (x + y * fw) * 8;
                for (int comp = 0; comp < nComp; ++comp) {
                    byte[] compBytes = (byte[])YCBCR[comp];
                    int idx = 0;
                    int ayfw = pos;
                    for (int a = 0; a < 8; ++a) {
                        for (int b = 0; b < 8; ++b) {
                            arrayDCT[idx++] = compBytes[ayfw + b];
                        }
                        ayfw += fw;
                    }
                    DCT.FDCTQ(arrayDCT, TableNumber[comp]);
                    huffman.encodeBlock(out, arrayDCT, lastDCvalue[comp], TableNumber[comp]);
                    lastDCvalue[comp] = arrayDCT[0];
                }
            }
        }
        huffman.end(out);
    }

    private static void WriteEOI(OutputStream out) throws IOException {
        byte[] EOI = new byte[]{-1, -39};
        out.write(EOI);
    }

    private static void WriteHeaders(OutputStream out, JpegHuffman huffman, int imageWidth, int imageHeight, int nComp) throws IOException {
        JpegEncoder.writeMarker(out, 65496);
        byte[] JFIF = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
        out.write(JFIF);
        byte[] DQT = new byte[134];
        DQT[0] = -1;
        DQT[1] = -37;
        DQT[2] = 0;
        DQT[3] = -124;
        int offset = 4;
        for (int i = 0; i < 2; ++i) {
            int j;
            byte[] tempArray;
            DQT[offset++] = (byte)i;
            if (i == 0) {
                tempArray = JpegLUT.QL;
                for (j = 0; j < 64; ++j) {
                    DQT[offset++] = tempArray[JpegLUT.ZIGZAGORDER[j]];
                }
                continue;
            }
            tempArray = JpegLUT.QC;
            for (j = 0; j < 64; ++j) {
                DQT[offset++] = tempArray[JpegLUT.ZIGZAGORDER[j]];
            }
        }
        out.write(DQT);
        JpegEncoder.writeMarker(out, 65472);
        JpegEncoder.writeLength(out, 17);
        byte[] SOF = new byte[15];
        SOF[0] = 8;
        SOF[1] = (byte)(imageHeight >> 8 & 0xFF);
        SOF[2] = (byte)(imageHeight & 0xFF);
        SOF[3] = (byte)(imageWidth >> 8 & 0xFF);
        SOF[4] = (byte)(imageWidth & 0xFF);
        SOF[5] = (byte)nComp;
        int index = 6;
        for (int i = 0; i < nComp; ++i) {
            SOF[index++] = (byte)(i + 1);
            SOF[index++] = (byte)((sampleFrequency[i] << 4) + sampleFrequency[i]);
            SOF[index++] = (byte)TableNumber[i];
        }
        out.write(SOF);
        index = 4;
        int oldindex = 4;
        byte[] DHT1 = new byte[17];
        byte[] DHT4 = new byte[4];
        DHT4[0] = -1;
        DHT4[1] = -60;
        for (int i = 0; i < 4; ++i) {
            int j;
            int bytes = 0;
            DHT1[index++ - oldindex] = (byte)huffman.bitList.get(i)[0];
            for (j = 1; j < 17; ++j) {
                int temp = huffman.bitList.get(i)[j];
                DHT1[index++ - oldindex] = (byte)temp;
                bytes += temp;
            }
            int intermediateindex = index;
            byte[] DHT2 = new byte[bytes];
            for (j = 0; j < bytes; ++j) {
                DHT2[index++ - intermediateindex] = (byte)huffman.valList.get(i)[j];
            }
            byte[] DHT3 = new byte[index];
            System.arraycopy(DHT4, 0, DHT3, 0, oldindex);
            System.arraycopy(DHT1, 0, DHT3, oldindex, 17);
            System.arraycopy(DHT2, 0, DHT3, oldindex + 17, bytes);
            DHT4 = DHT3;
            oldindex = index;
        }
        DHT4[2] = (byte)(index - 2 >> 8 & 0xFF);
        DHT4[3] = (byte)(index - 2 & 0xFF);
        out.write(DHT4);
        byte[] SOS = new byte[14];
        SOS[0] = -1;
        SOS[1] = -38;
        SOS[2] = 0;
        SOS[3] = 12;
        SOS[4] = (byte)nComp;
        index = 5;
        for (int i = 0; i < SOS[4]; ++i) {
            SOS[index++] = (byte)(i + 1);
            SOS[index++] = (byte)((TableNumber[i] << 4) + TableNumber[i]);
        }
        SOS[index++] = 0;
        SOS[index++] = 63;
        SOS[index] = 0;
        out.write(SOS);
    }

    private static void writeMarker(OutputStream out, int marker) throws IOException {
        out.write((byte)marker >> 8);
        out.write((byte)marker);
    }

    private static void writeLength(OutputStream out, int length) throws IOException {
        out.write((byte)length >> 8);
        out.write((byte)length);
    }

    private static byte[] intToBytes(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }
}

