/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg;

import com.idrsolutions.image.jpeg.Component;
import com.idrsolutions.image.jpeg.Frame;
import com.idrsolutions.image.jpeg.JpegLUT;
import java.util.List;

public class JpegScanner {
    private static final int DCFirst = 0;
    private static final int DCSuccessive = 1;
    private static final int ACFirst = 2;
    private static final int ACSuccessive = 3;
    private static final int Baseline = 4;
    private final byte[] data;
    private int bitPos;
    private int bitBuffer;
    private int eobrun;
    private int mcusX;
    private int offset;
    private int successive;
    private int sStart;
    private int sEnd;
    private int stateAC;
    private int stateNextAC;

    public JpegScanner(byte[] data) {
        this.data = data;
    }

    public int decodeScan(int off, Frame frame, List<Component> components, int resetInterval, int sStart, int sEnd, int sPrev, int successive) {
        int nc;
        this.mcusX = frame.mcusX;
        this.offset = off;
        this.successive = successive;
        this.sStart = sStart;
        this.sEnd = sEnd;
        int componentsLength = components.size();
        int decodeFn = frame.progressive ? (sStart == 0 ? (sPrev == 0 ? 0 : 1) : (sPrev == 0 ? 2 : 3)) : 4;
        int mcu = 0;
        int mcuExpected = componentsLength == 1 ? components.get((int)0).blocksX * components.get((int)0).blocksY : this.mcusX * frame.mcusY;
        int n = nc = resetInterval == 0 ? mcuExpected : resetInterval;
        while (mcu < mcuExpected) {
            int n2;
            Component component;
            int i;
            for (i = 0; i < componentsLength; ++i) {
                components.get((int)i).pred = 0;
            }
            this.eobrun = 0;
            if (componentsLength == 1) {
                component = components.get(0);
                for (n2 = 0; n2 < nc; ++n2) {
                    this.decodeBlock(component, decodeFn, mcu);
                    ++mcu;
                }
            } else {
                for (n2 = 0; n2 < nc; ++n2) {
                    for (i = 0; i < componentsLength; ++i) {
                        component = components.get(i);
                        int h = component.h;
                        int v = component.v;
                        for (int j = 0; j < v; ++j) {
                            for (int k = 0; k < h; ++k) {
                                this.decodeMcu(component, decodeFn, mcu, j, k);
                            }
                        }
                    }
                    ++mcu;
                }
            }
            this.bitPos = 0;
            int marker = (this.data[this.offset] & 0xFF) << 8 | this.data[this.offset + 1] & 0xFF;
            if (marker <= 65280) {
                // empty if block
            }
            if (marker < 65488 || marker > 65495) break;
            this.offset += 2;
        }
        return this.offset - off;
    }

    private int findHuffmanValue(Object tree) {
        Object node = tree;
        while (!((node = ((Object[])node)[this.readBit()]) instanceof Integer)) {
        }
        return (Integer)node;
    }

    private int readBit() {
        int nextByte;
        if (this.bitPos > 0) {
            --this.bitPos;
            return this.bitBuffer >> this.bitPos & 1;
        }
        this.bitBuffer = this.data[this.offset++] & 0xFF;
        if (this.bitBuffer == 255 && (nextByte = this.data[this.offset++] & 0xFF) != 0) {
            System.err.println("invalid marker found");
        }
        this.bitPos = 7;
        return this.bitBuffer >>> 7;
    }

    private int getNext(int length) {
        int n = 0;
        while (length > 0) {
            n = n << 1 | this.readBit();
            --length;
        }
        return n;
    }

    private int getNextFull(int length) {
        if (length == 1) {
            return this.readBit() == 1 ? 1 : -1;
        }
        int n = this.getNext(length);
        if (n >= 1 << length - 1) {
            return n;
        }
        return n + (-1 << length) + 1;
    }

    private void decodeMcu(Component component, int decodeFn, int mcu, int row, int col) {
        int mcuRow = mcu / this.mcusX;
        int mcuCol = mcu % this.mcusX;
        int blockRow = mcuRow * component.v + row;
        int blockCol = mcuCol * component.h + col;
        int offsetD = JpegScanner.getCodeBlockOffset(component, blockRow, blockCol);
        this.decodeOrdering(component, offsetD, decodeFn);
    }

    private void decodeBlock(Component component, int decodeFn, int mcu) {
        int blockRow = mcu / component.blocksX;
        int blockCol = mcu % component.blocksX;
        int offsetD = JpegScanner.getCodeBlockOffset(component, blockRow, blockCol);
        this.decodeOrdering(component, offsetD, decodeFn);
    }

    private void decodeOrdering(Component component, int offset, int decodeFn) {
        block0 : switch (decodeFn) {
            case 0: {
                int e = this.findHuffmanValue(component.huffmanTableDC);
                int diff = e == 0 ? 0 : this.getNextFull(e) << this.successive;
                component.codeBlock[offset] = component.pred += diff;
                break;
            }
            case 1: {
                int n = offset;
                component.codeBlock[n] = component.codeBlock[n] | this.readBit() << this.successive;
                break;
            }
            case 2: {
                if (this.eobrun > 0) {
                    --this.eobrun;
                    return;
                }
                int a = this.sStart;
                int b = this.sEnd;
                while (a <= b) {
                    int f = this.findHuffmanValue(component.huffmanTableAC);
                    int d = f & 0xF;
                    int c = f >> 4;
                    if (d == 0) {
                        if (c < 15) {
                            this.eobrun = this.getNext(c) + (1 << c) - 1;
                            break block0;
                        }
                        a += 16;
                        continue;
                    }
                    byte z = JpegLUT.ZIGZAGORDER[a += c];
                    component.codeBlock[offset + z] = this.getNextFull(d) * (1 << this.successive);
                    ++a;
                }
                break;
            }
            case 3: {
                int a = this.sStart;
                int b = this.sEnd;
                int c = 0;
                block14: while (a <= b) {
                    byte z = JpegLUT.ZIGZAGORDER[a];
                    switch (this.stateAC) {
                        case 0: {
                            int f = this.findHuffmanValue(component.huffmanTableAC);
                            int d = f & 0xF;
                            c = f >> 4;
                            if (d == 0) {
                                if (c < 15) {
                                    this.eobrun = this.getNext(c) + (1 << c);
                                    this.stateAC = 4;
                                    continue block14;
                                }
                                c = 16;
                                this.stateAC = 1;
                                continue block14;
                            }
                            if (d != 1) {
                                // empty if block
                            }
                            this.stateNextAC = this.getNextFull(d);
                            this.stateAC = c != 0 ? 2 : 3;
                            continue block14;
                        }
                        case 1: 
                        case 2: {
                            if (component.codeBlock[offset + z] != 0) {
                                int n = offset + z;
                                component.codeBlock[n] = component.codeBlock[n] + (this.readBit() << this.successive);
                                break;
                            }
                            if (--c != 0) break;
                            this.stateAC = this.stateAC == 2 ? 3 : 0;
                            break;
                        }
                        case 3: {
                            if (component.codeBlock[offset + z] != 0) {
                                int n = offset + z;
                                component.codeBlock[n] = component.codeBlock[n] + (this.readBit() << this.successive);
                                break;
                            }
                            component.codeBlock[offset + z] = this.stateNextAC << this.successive;
                            this.stateAC = 0;
                            break;
                        }
                        case 4: {
                            if (component.codeBlock[offset + z] == 0) break;
                            int n = offset + z;
                            component.codeBlock[n] = component.codeBlock[n] + (this.readBit() << this.successive);
                        }
                    }
                    ++a;
                }
                if (this.stateAC != 4) break;
                --this.eobrun;
                if (this.eobrun != 0) break;
                this.stateAC = 0;
                break;
            }
            case 4: {
                int e = this.findHuffmanValue(component.huffmanTableDC);
                int diff = e == 0 ? 0 : this.getNextFull(e);
                component.codeBlock[offset] = component.pred += diff;
                int a = 1;
                while (a < 64) {
                    int f = this.findHuffmanValue(component.huffmanTableAC);
                    int d = f & 0xF;
                    int c = f >> 4;
                    if (d == 0) {
                        if (c < 15) break block0;
                        a += 16;
                        continue;
                    }
                    byte z = JpegLUT.ZIGZAGORDER[a += c];
                    component.codeBlock[offset + z] = this.getNextFull(d);
                    ++a;
                }
                break;
            }
        }
    }

    public static int getCodeBlockOffset(Component component, int row, int col) {
        return 64 * ((component.blocksX + 1) * row + col);
    }
}

