/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg2000;

import com.idrsolutions.image.jpeg2000.BlockData;
import com.idrsolutions.image.jpeg2000.COD;
import com.idrsolutions.image.jpeg2000.Cmap;
import com.idrsolutions.image.jpeg2000.CodeBlock;
import com.idrsolutions.image.jpeg2000.CodeBlockInfo;
import com.idrsolutions.image.jpeg2000.EntropyDecoder;
import com.idrsolutions.image.jpeg2000.EnumeratedSpace;
import com.idrsolutions.image.jpeg2000.Info;
import com.idrsolutions.image.jpeg2000.JPXBitReader;
import com.idrsolutions.image.jpeg2000.JPXReader;
import com.idrsolutions.image.jpeg2000.LRCP;
import com.idrsolutions.image.jpeg2000.Palette;
import com.idrsolutions.image.jpeg2000.Precinct;
import com.idrsolutions.image.jpeg2000.PrecinctInfo;
import com.idrsolutions.image.jpeg2000.QCD;
import com.idrsolutions.image.jpeg2000.RLCP;
import com.idrsolutions.image.jpeg2000.SIZ;
import com.idrsolutions.image.jpeg2000.SubbandCoefficient;
import com.idrsolutions.image.jpeg2000.Tier1Decoder;
import com.idrsolutions.image.jpeg2000.Tile;
import com.idrsolutions.image.jpeg2000.TileBand;
import com.idrsolutions.image.jpeg2000.TileComponent;
import com.idrsolutions.image.jpeg2000.TileParser;
import com.idrsolutions.image.jpeg2000.TileResolution;
import com.idrsolutions.image.jpeg2000.Trns;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;

public class Jpeg2000Decoder {
    private static final boolean debug = false;

    public BufferedImage read(byte[] jpxRawData) throws Exception {
        Info info = new Info();
        JPXReader reader = new JPXReader(jpxRawData);
        if (65359 == ((jpxRawData[0] & 0xFF) << 8 | jpxRawData[1] & 0xFF)) {
            Jpeg2000Decoder.readCodeStream(info, reader, jpxRawData.length);
        } else {
            Jpeg2000Decoder.decodeMain(info, reader);
            Jpeg2000Decoder.decodeContiguousCodeStreamBoxes(info, reader);
        }
        Jpeg2000Decoder.generateTileMap(info);
        Jpeg2000Decoder.decodeTileOffsets(info, reader);
        if (info.palette != null && info.siz.nComp == 1) {
            return Jpeg2000Decoder.convertPalette(info);
        }
        if (info.enumerateCS == 12) {
            return Jpeg2000Decoder.convertCMYKTileToRGB(info, true);
        }
        return Jpeg2000Decoder.convertTileComponentsToBuffered(info);
    }

    private static void decodeMain(Info info, JPXReader reader) {
        long remaining;
        int signLen = reader.readInt();
        int signType = reader.readInt();
        if (signLen != 12 && signType != 1783636000) {
            throw new RuntimeException("Jpeg2000 Error: Not a valid jp2 file ");
        }
        reader.readInt();
        long ftypLen = reader.readInt();
        int ftypType = reader.readInt();
        if (ftypType != 1718909296) {
            throw new RuntimeException("Jpeg2000 Error: Not a valid filetype declared in file ");
        }
        boolean isJP2BRFound = false;
        if (ftypLen == 1L) {
            ftypLen = reader.readLong();
            remaining = ftypLen - 16L;
        } else {
            remaining = ftypLen - 8L;
        }
        long size = remaining / 4L;
        int i = 0;
        while ((long)i < size) {
            if (reader.readInt() == 1785737760) {
                isJP2BRFound = true;
            }
            ++i;
        }
        if (!isJP2BRFound) {
            throw new RuntimeException("Jpeg2000 Error: Not a valid JP2 Branded File");
        }
        boolean hasBoxes = true;
        block17: while (reader.getRemaining() > 0 && hasBoxes) {
            int offset = reader.getPosition();
            long tempLen = reader.readInt();
            int tempType = reader.readInt();
            if (tempLen == 1L) {
                tempLen = reader.readLong();
            } else if (tempLen == 0L) {
                hasBoxes = false;
            }
            switch (tempType) {
                case 1785737832: {
                    long tLen = reader.readInt();
                    reader.readInt();
                    if (tLen == 1L) {
                        reader.readLong();
                    }
                    info.imageHeight = reader.readInt();
                    info.imageWidth = reader.readInt();
                    info.nComp = reader.readUShort();
                    info.bitDepth = reader.readUByte();
                    info.compressionType = reader.readUByte();
                    info.unknownColorSpace = reader.readUByte();
                    info.ip = reader.readUByte();
                    long ii = (long)offset + tempLen;
                    block18: while ((long)reader.getPosition() < ii) {
                        int start = reader.getPosition();
                        tLen = reader.readInt();
                        int tType = reader.readInt();
                        if (tLen == 1L) {
                            reader.readLong();
                        }
                        switch (tType) {
                            case 1651532643: {
                                info.bitDepths = new byte[info.nComp];
                                for (int i2 = 0; i2 < info.bitDepths.length; ++i2) {
                                    info.bitDepths[i2] = reader.readByte();
                                }
                                continue block18;
                            }
                            case 1668246642: {
                                int m = reader.readUByte();
                                reader.readByte();
                                reader.readUByte();
                                if (m == 1) {
                                    info.enumerateCS = reader.readInt();
                                } else if (m == 2) {
                                    reader.readInt();
                                }
                                reader.setPosition((int)((long)start + tLen));
                                break;
                            }
                            case 1885564018: {
                                int i3;
                                Palette pal = new Palette();
                                pal.nEntries = reader.readUShort();
                                pal.nColumns = reader.readUByte();
                                pal.bitDepts = new int[pal.nColumns];
                                for (i3 = 0; i3 < pal.nColumns; ++i3) {
                                    pal.bitDepts[i3] = reader.readUByte();
                                }
                                pal.cValues = new int[pal.nEntries][pal.nColumns];
                                for (i3 = 0; i3 < pal.nEntries; ++i3) {
                                    for (int j = 0; j < pal.nColumns; ++j) {
                                        pal.cValues[i3][j] = reader.readUByte();
                                    }
                                }
                                info.palette = pal;
                                reader.setPosition((int)((long)start + tLen));
                                break;
                            }
                            case 1668112752: {
                                int mapLen = (int)(tLen - (long)(reader.getPosition() - start));
                                Cmap cmap = new Cmap();
                                cmap.cmp = new int[mapLen /= 4];
                                cmap.mtyp = new int[mapLen];
                                cmap.pcol = new int[mapLen];
                                for (int i4 = 0; i4 < mapLen; ++i4) {
                                    cmap.cmp[i4] = reader.readUShort();
                                    cmap.mtyp[i4] = reader.readUByte();
                                    cmap.pcol[i4] = reader.readUByte();
                                }
                                info.cmap = cmap;
                                reader.setPosition((int)((long)start + tLen));
                                break;
                            }
                            case 1667523942: {
                                int nDef = reader.readShort();
                                for (int i5 = 0; i5 < nDef; ++i5) {
                                    short key = reader.readShort();
                                    short type = reader.readShort();
                                    short val = reader.readShort();
                                    if (type != 0) continue;
                                    info.cDef.put(Integer.valueOf(key), Integer.valueOf(val));
                                }
                                reader.setPosition((int)((long)start + tLen));
                                break;
                            }
                            case 1919251232: {
                                reader.setPosition((int)((long)start + tLen));
                                break;
                            }
                            default: {
                                reader.setPosition((int)((long)start + tLen));
                            }
                        }
                    }
                    reader.setPosition((int)ii);
                    continue block17;
                }
                case 1785737827: {
                    info.contiguousCodeStreamBoxes.add(offset);
                    reader.setPosition((int)((long)offset + tempLen));
                    continue block17;
                }
                case 1685074537: {
                    reader.setPosition((int)((long)offset + tempLen));
                    continue block17;
                }
                case 2020437024: {
                    reader.setPosition((int)((long)offset + tempLen));
                    continue block17;
                }
                case 1970628964: {
                    reader.setPosition((int)((long)offset + tempLen));
                    continue block17;
                }
                case 1969843814: {
                    reader.setPosition((int)((long)offset + tempLen));
                    continue block17;
                }
            }
            reader.setPosition((int)((long)offset + tempLen));
        }
    }

    private static void generateTileMap(Info info) {
        SIZ siz = info.siz;
        int numXTiles = (int)Math.ceil(1.0 * (double)(siz.Xsiz - siz.XTOsiz) / (double)siz.XTsiz);
        int numYTiles = (int)Math.ceil(1.0 * (double)(siz.Ysiz - siz.YTOsiz) / (double)siz.YTsiz);
        int index = 0;
        for (int q = 0; q < numYTiles; ++q) {
            for (int p = 0; p < numXTiles; ++p) {
                Tile tile = new Tile();
                tile.tx0 = Math.max(siz.XTOsiz + p * siz.XTsiz, siz.XOsiz);
                tile.ty0 = Math.max(siz.YTOsiz + q * siz.YTsiz, siz.YOsiz);
                tile.tx1 = Math.min(siz.XTOsiz + (p + 1) * siz.XTsiz, siz.Xsiz);
                tile.ty1 = Math.min(siz.YTOsiz + (q + 1) * siz.YTsiz, siz.Ysiz);
                for (int i = 0; i < siz.nComp; ++i) {
                    int XRsiz_ = siz.precisionInfo[i][1];
                    int YRsiz_ = siz.precisionInfo[i][2];
                    TileComponent tileComp = new TileComponent();
                    tileComp.x0 = (int)Math.ceil(1.0 * (double)tile.tx0 / (double)XRsiz_);
                    tileComp.x1 = (int)Math.ceil(1.0 * (double)tile.tx1 / (double)XRsiz_);
                    tileComp.y0 = (int)Math.ceil(1.0 * (double)tile.ty0 / (double)YRsiz_);
                    tileComp.y1 = (int)Math.ceil(1.0 * (double)tile.ty1 / (double)YRsiz_);
                    tile.components.add(tileComp);
                }
                info.tilesMap.put(index, tile);
                ++index;
            }
        }
    }

    private static void decodeContiguousCodeStreamBoxes(Info info, JPXReader reader) {
        for (int is : info.contiguousCodeStreamBoxes) {
            reader.setPosition(is);
            long tempLen = reader.readInt();
            reader.readInt();
            if (tempLen == 1L) {
                tempLen = reader.readLong();
            } else if (tempLen == 0L) {
                tempLen = reader.getLimit() - is;
            }
            long maxRead = (long)is + tempLen;
            Jpeg2000Decoder.readCodeStream(info, reader, maxRead);
        }
    }

    private static void readCodeStream(Info info, JPXReader reader, long maxRead) {
        block22: while ((long)reader.getPosition() < maxRead) {
            int header = reader.readUShort();
            switch (header) {
                case 65359: {
                    continue block22;
                }
                case 65361: {
                    reader.readUShort();
                    info.siz = Jpeg2000Decoder.readSIZ(reader);
                    info.qcc = new QCD[info.siz.nComp];
                    continue block22;
                }
                case 65362: {
                    reader.readUShort();
                    info.cod = Jpeg2000Decoder.readCOD(reader);
                    continue block22;
                }
                case 65363: {
                    int LCOC = reader.readUShort();
                    reader.setPosition(reader.getPosition() + LCOC - 2);
                    continue block22;
                }
                case 65372: {
                    int LQCD = reader.readUShort();
                    info.qcd = Jpeg2000Decoder.readQCD(reader, LQCD);
                    continue block22;
                }
                case 65373: {
                    int LQCC = reader.readUShort();
                    int cVal = reader.readUByte();
                    QCD qcc = new QCD();
                    Byte qccQS = reader.readByte();
                    JPXBitReader qccBR = new JPXBitReader(qccQS);
                    qcc.guardBits = qccBR.readBits(3);
                    qcc.quantBits = qccBR.readBits(5);
                    qcc.hasScalar = false;
                    int qccBalance = LQCC - 4;
                    switch (qcc.quantBits) {
                        case 0: {
                            qcc.hasScalar = true;
                            int qccNB = qccBalance;
                            qcc.exponentB = new int[qccNB];
                            qcc.mantissaB = new int[qccNB];
                            for (int i = 0; i < qccNB; ++i) {
                                qccBR = new JPXBitReader(reader.readByte());
                                qcc.exponentB[i] = qccBR.readBits(5);
                                qcc.mantissaB[i] = 0;
                            }
                            break;
                        }
                        case 1: {
                            qcc.hasScalar = false;
                            byte[] temp = new byte[]{reader.readByte(), reader.readByte()};
                            qccBR = new JPXBitReader(temp);
                            int eB = qccBR.readBits(5);
                            int muB = qccBR.readBits(11);
                            qcc.exponentB = new int[]{eB};
                            qcc.mantissaB = new int[]{muB};
                            break;
                        }
                        case 2: {
                            int qccNB = qccBalance / 2;
                            qcc.hasScalar = true;
                            qcc.exponentB = new int[qccNB];
                            qcc.mantissaB = new int[qccNB];
                            for (int i = 0; i < qccNB; ++i) {
                                byte[] tt = new byte[]{reader.readByte(), reader.readByte()};
                                qccBR = new JPXBitReader(tt);
                                qcc.exponentB[i] = qccBR.readBits(5);
                                qcc.mantissaB[i] = qccBR.readBits(11);
                            }
                            break;
                        }
                    }
                    info.qcc[cVal] = qcc;
                    continue block22;
                }
                case 65374: {
                    int LRGN = reader.readUShort();
                    reader.setPosition(reader.getPosition() + LRGN - 2);
                    continue block22;
                }
                case 65375: {
                    int LPOC = reader.readUShort();
                    reader.setPosition(reader.getPosition() + LPOC - 2);
                    continue block22;
                }
                case 65376: {
                    int LPPM = reader.readUShort();
                    reader.setPosition(reader.getPosition() + LPPM - 2);
                    continue block22;
                }
                case 65367: {
                    int LPLM = reader.readUShort();
                    reader.setPosition(reader.getPosition() + LPLM - 2);
                    continue block22;
                }
                case 65365: {
                    int LTLM = reader.readUShort();
                    reader.setPosition(reader.getPosition() + LTLM - 2);
                    continue block22;
                }
                case 65379: {
                    int LCRG = reader.readUShort();
                    reader.setPosition(reader.getPosition() + LCRG - 2);
                    continue block22;
                }
                case 65380: {
                    int LCOM = reader.readUShort();
                    reader.setPosition(reader.getPosition() + LCOM - 2);
                    continue block22;
                }
                case 65424: {
                    int tileOffset = reader.getPosition() - 2;
                    reader.readInt();
                    int LTP = reader.readInt();
                    reader.readShort();
                    reader.setPosition(tileOffset + LTP);
                    info.tileOffsets.add(tileOffset);
                    continue block22;
                }
                case 65497: {
                    return;
                }
            }
            System.err.println("undefined header in jpeg2000file" + header);
        }
    }

    private static SIZ readSIZ(JPXReader reader) {
        SIZ siz = new SIZ();
        siz.capabilities = reader.readUShort();
        siz.Xsiz = reader.readInt();
        siz.Ysiz = reader.readInt();
        siz.XOsiz = reader.readInt();
        siz.YOsiz = reader.readInt();
        siz.XTsiz = reader.readInt();
        siz.YTsiz = reader.readInt();
        siz.XTOsiz = reader.readInt();
        siz.YTOsiz = reader.readInt();
        siz.nComp = reader.readUShort();
        siz.precisionInfo = new int[siz.nComp][3];
        for (int i = 0; i < siz.nComp; ++i) {
            siz.precisionInfo[i][0] = reader.readUByte();
            siz.precisionInfo[i][1] = reader.readUByte();
            siz.precisionInfo[i][2] = reader.readUByte();
        }
        return siz;
    }

    private static COD readCOD(JPXReader reader) {
        COD cod = new COD();
        boolean[] bools = Jpeg2000Decoder.toBoolean8(reader.readByte());
        cod.hasPrecint = bools[7];
        cod.hasSOP = bools[6];
        cod.hasEPH = bools[5];
        cod.progressionOrder = reader.readUByte();
        cod.nLayers = reader.readUShort();
        cod.multiCompTransform = reader.readByte();
        cod.nDecompLevel = reader.readUByte();
        cod.xcb = reader.readUByte() + 2;
        cod.ycb = reader.readUByte() + 2;
        cod.codeBlockStyle = reader.readByte();
        cod.transformation = reader.readUByte();
        if (cod.hasPrecint) {
            cod.precintSizes = new int[cod.nDecompLevel + 1];
            for (int i = 0; i < cod.precintSizes.length; ++i) {
                cod.precintSizes[i] = reader.readByte();
            }
        }
        return cod;
    }

    private static QCD readQCD(JPXReader reader, int qcdLength) {
        QCD qcd = new QCD();
        Byte qs = reader.readByte();
        JPXBitReader br = new JPXBitReader(qs);
        qcd.guardBits = br.readBits(3);
        qcd.quantBits = br.readBits(5);
        qcd.hasScalar = false;
        int balance = qcdLength - 3;
        switch (qcd.quantBits) {
            case 0: {
                qcd.hasScalar = true;
                int NB = balance;
                qcd.exponentB = new int[NB];
                qcd.mantissaB = new int[NB];
                for (int i = 0; i < NB; ++i) {
                    br = new JPXBitReader(reader.readByte());
                    qcd.exponentB[i] = br.readBits(5);
                    qcd.mantissaB[i] = 0;
                }
                break;
            }
            case 1: {
                qcd.hasScalar = false;
                byte[] temp = new byte[]{reader.readByte(), reader.readByte()};
                br = new JPXBitReader(temp);
                int eB = br.readBits(5);
                int muB = br.readBits(11);
                qcd.exponentB = new int[]{eB};
                qcd.mantissaB = new int[]{muB};
                break;
            }
            case 2: {
                int NB = balance / 2;
                qcd.hasScalar = true;
                qcd.exponentB = new int[NB];
                qcd.mantissaB = new int[NB];
                for (int i = 0; i < NB; ++i) {
                    byte[] tt = new byte[]{reader.readByte(), reader.readByte()};
                    br = new JPXBitReader(tt);
                    qcd.exponentB[i] = br.readBits(5);
                    qcd.mantissaB[i] = br.readBits(11);
                }
                break;
            }
        }
        return qcd;
    }

    private static void decodeTileOffsets(Info info, JPXReader reader) {
        for (int offset : info.tileOffsets) {
            reader.setPosition(offset);
            reader.readUShort();
            reader.readUShort();
            int tileIndex = reader.readUShort();
            int lengthTilePart = reader.readInt();
            int indexTilePart = reader.readUByte();
            int numberTilePart = reader.readUByte();
            int totalLen = lengthTilePart - 12;
            int maxRead = offset + lengthTilePart;
            Tile tile = new Tile();
            tile.cod = info.cod;
            tile.qcd = info.qcd;
            tile.qcc = info.qcc;
            tile.index = tileIndex;
            tile.partIndex = indexTilePart;
            tile.partCount = numberTilePart;
            int otherRead = 0;
            while (reader.getPosition() < maxRead) {
                int header = reader.readUShort();
                switch (header) {
                    case 65362: {
                        int LCOD = reader.readUShort();
                        otherRead = otherRead + 2 + LCOD;
                        tile.cod = Jpeg2000Decoder.readCOD(reader);
                        break;
                    }
                    case 65372: {
                        int LQCD = reader.readUShort();
                        otherRead = otherRead + 2 + LQCD;
                        tile.qcd = Jpeg2000Decoder.readQCD(reader, LQCD);
                        break;
                    }
                    case 65373: {
                        int LQCC = reader.readUShort();
                        int cVal = reader.readUByte();
                        QCD qcc = new QCD();
                        Byte qccQS = reader.readByte();
                        JPXBitReader qccBR = new JPXBitReader(qccQS);
                        qcc.guardBits = qccBR.readBits(3);
                        qcc.quantBits = qccBR.readBits(5);
                        qcc.hasScalar = false;
                        int qccBalance = LQCC - 4;
                        switch (qcc.quantBits) {
                            case 0: {
                                qcc.hasScalar = true;
                                int qccNB = qccBalance;
                                qcc.exponentB = new int[qccNB];
                                qcc.mantissaB = new int[qccNB];
                                for (int i = 0; i < qccNB; ++i) {
                                    qccBR = new JPXBitReader(reader.readByte());
                                    qcc.exponentB[i] = qccBR.readBits(5);
                                    qcc.mantissaB[i] = 0;
                                }
                                break;
                            }
                            case 1: {
                                qcc.hasScalar = false;
                                byte[] temp = new byte[]{reader.readByte(), reader.readByte()};
                                qccBR = new JPXBitReader(temp);
                                int eB = qccBR.readBits(5);
                                int muB = qccBR.readBits(11);
                                qcc.exponentB = new int[]{eB};
                                qcc.mantissaB = new int[]{muB};
                                break;
                            }
                            case 2: {
                                int qccNB = qccBalance / 2;
                                qcc.hasScalar = true;
                                qcc.exponentB = new int[qccNB];
                                qcc.mantissaB = new int[qccNB];
                                for (int i = 0; i < qccNB; ++i) {
                                    byte[] tt = new byte[]{reader.readByte(), reader.readByte()};
                                    qccBR = new JPXBitReader(tt);
                                    qcc.exponentB[i] = qccBR.readBits(5);
                                    qcc.mantissaB[i] = qccBR.readBits(11);
                                }
                                break;
                            }
                        }
                        tile.qcc[cVal] = qcc;
                        break;
                    }
                    case 65363: 
                    case 65368: 
                    case 65374: 
                    case 65375: 
                    case 65377: 
                    case 65380: {
                        int temp = reader.readUShort();
                        otherRead = otherRead + 2 + temp;
                        reader.setPosition(reader.getPosition() + temp - 2);
                        break;
                    }
                    case 65427: {
                        byte[] bb = new byte[totalLen - (otherRead += 2)];
                        for (int i = 0; i < bb.length; ++i) {
                            bb[i] = reader.readByte();
                        }
                        tile.data = bb;
                        if (tile.partIndex == 0) {
                            Jpeg2000Decoder.initializeDimensions(info, tile, tile.index);
                        }
                        TileParser parser = new TileParser(tile.data, info.tilesMap.get(tile.index));
                        parser.parseTile();
                        break;
                    }
                }
            }
        }
    }

    private static void initializeDimensions(Info info, Tile cur, int tileIndex) {
        Tile tile = info.tilesMap.get(tileIndex);
        tile.cod = tile.cod != null ? tile.cod : cur.cod;
        tile.qcd = tile.qcd != null ? tile.qcd : cur.qcd;
        tile.qcc = tile.qcc != null ? tile.qcc : cur.qcc;
        switch (tile.cod.progressionOrder) {
            case 0: {
                tile.progress = new LRCP(info, tileIndex);
                break;
            }
            case 1: {
                tile.progress = new RLCP(info, tileIndex);
                break;
            }
            case 2: {
                System.err.print("This progression order not supported");
                break;
            }
            case 3: {
                System.err.print("This progression order not supported");
                break;
            }
            case 4: {
                System.err.print("This progression order not supported");
                break;
            }
            default: {
                System.err.println("Unknown progression order found");
            }
        }
        int NL = tile.cod.nDecompLevel;
        int xcb = tile.cod.xcb;
        int ycb = tile.cod.xcb;
        int ppx = 15;
        int ppy = 15;
        for (TileComponent tc : tile.components) {
            for (int r = 0; r <= NL; ++r) {
                int xcb_ = r == 0 ? Math.min(xcb, 15) : Math.min(xcb, 14);
                int ycb_ = r == 0 ? Math.min(ycb, 15) : Math.min(ycb, 14);
                TileResolution tr = new TileResolution();
                int NL_R2 = 1 << NL - r;
                tr.x0 = (int)Math.ceil(1.0 * (double)tc.x0 / (double)NL_R2);
                tr.x1 = (int)Math.ceil(1.0 * (double)tc.x1 / (double)NL_R2);
                tr.y0 = (int)Math.ceil(1.0 * (double)tc.y0 / (double)NL_R2);
                tr.y1 = (int)Math.ceil(1.0 * (double)tc.y1 / (double)NL_R2);
                Jpeg2000Decoder.updatePrecinctInfo(tr, r, 15, 15);
                if (r == 0) {
                    int powN = 1 << NL;
                    TileBand tb = new TileBand(0);
                    tb.x0 = (int)Math.abs(Math.ceil(1.0 * (double)tc.x0 / (double)powN));
                    tb.y0 = (int)Math.abs(Math.ceil(1.0 * (double)tc.y0 / (double)powN));
                    tb.x1 = (int)Math.abs(Math.ceil(1.0 * (double)tc.x1 / (double)powN));
                    tb.y1 = (int)Math.abs(Math.ceil(1.0 * (double)tc.y1 / (double)powN));
                    tr.tileBands.add(tb);
                    Jpeg2000Decoder.updateCodeBlocks(tr, tb, xcb_, ycb_);
                } else {
                    int n = NL + 1 - r;
                    int powN = 1 << n;
                    int powM = 1 << n - 1;
                    TileBand tb = new TileBand(2);
                    tb.x0 = (int)Math.abs(Math.ceil((1.0 * (double)tc.x0 - (double)(powM * 1)) / (double)powN));
                    tb.y0 = (int)Math.abs(Math.ceil((1.0 * (double)tc.y0 - (double)(powM * 0)) / (double)powN));
                    tb.x1 = (int)Math.abs(Math.ceil((1.0 * (double)tc.x1 - (double)(powM * 1)) / (double)powN));
                    tb.y1 = (int)Math.abs(Math.ceil((1.0 * (double)tc.y1 - (double)(powM * 0)) / (double)powN));
                    tr.tileBands.add(tb);
                    Jpeg2000Decoder.updateCodeBlocks(tr, tb, xcb_, ycb_);
                    tb = new TileBand(1);
                    tb.x0 = (int)Math.abs(Math.ceil((1.0 * (double)tc.x0 - (double)(powM * 0)) / (double)powN));
                    tb.y0 = (int)Math.abs(Math.ceil((1.0 * (double)tc.y0 - (double)(powM * 1)) / (double)powN));
                    tb.x1 = (int)Math.abs(Math.ceil((1.0 * (double)tc.x1 - (double)(powM * 0)) / (double)powN));
                    tb.y1 = (int)Math.abs(Math.ceil((1.0 * (double)tc.y1 - (double)(powM * 1)) / (double)powN));
                    tr.tileBands.add(tb);
                    Jpeg2000Decoder.updateCodeBlocks(tr, tb, xcb_, ycb_);
                    tb = new TileBand(3);
                    tb.x0 = (int)Math.abs(Math.ceil((1.0 * (double)tc.x0 - (double)(powM * 1)) / (double)powN));
                    tb.y0 = (int)Math.abs(Math.ceil((1.0 * (double)tc.y0 - (double)(powM * 1)) / (double)powN));
                    tb.x1 = (int)Math.abs(Math.ceil((1.0 * (double)tc.x1 - (double)(powM * 1)) / (double)powN));
                    tb.y1 = (int)Math.abs(Math.ceil((1.0 * (double)tc.y1 - (double)(powM * 1)) / (double)powN));
                    tr.tileBands.add(tb);
                    Jpeg2000Decoder.updateCodeBlocks(tr, tb, xcb_, ycb_);
                }
                tc.resolutions.add(tr);
            }
        }
    }

    private static void updatePrecinctInfo(TileResolution resolution, int r, int ppx, int ppy) {
        PrecinctInfo pInfo = new PrecinctInfo();
        pInfo.precinctWidth = 1 << ppx;
        pInfo.precinctHeight = 1 << ppy;
        pInfo.precinctWidthInSubband = 1 << ppx + (r == 0 ? 0 : -1);
        pInfo.precinctHeightInSubband = 1 << ppy + (r == 0 ? 0 : -1);
        pInfo.numPrecinctsWide = (int)(resolution.x1 > resolution.x0 ? Math.ceil(1.0 * (double)resolution.x1 / (double)pInfo.precinctWidth) - Math.floor(1.0 * (double)resolution.x0 / (double)pInfo.precinctWidth) : 0.0);
        pInfo.numPrecinctsHigh = (int)(resolution.y1 > resolution.y0 ? Math.ceil(1.0 * (double)resolution.y1 / (double)pInfo.precinctHeight) - Math.floor(1.0 * (double)resolution.y0 / (double)pInfo.precinctHeight) : 0.0);
        pInfo.numPrecincts = pInfo.numPrecinctsWide * pInfo.numPrecinctsHigh;
        resolution.precinctInfo = pInfo;
    }

    private static void updateCodeBlocks(TileResolution tr, TileBand tb, int xcb_, int ycb_) {
        int codeblockWidth = 1 << xcb_;
        int codeblockHeight = 1 << ycb_;
        int cbx0 = tb.x0 >> xcb_;
        int cby0 = tb.y0 >> ycb_;
        int cbx1 = tb.x1 + codeblockWidth - 1 >> xcb_;
        int cby1 = tb.y1 + codeblockHeight - 1 >> ycb_;
        PrecinctInfo precintInfo = tr.precinctInfo;
        List<CodeBlock> codeblocks = tb.codeBlocks;
        List<Precinct> precincts = tb.precincts;
        for (int j = cby0; j < cby1; ++j) {
            for (int i = cbx0; i < cbx1; ++i) {
                Precinct precinct;
                int precintNumber;
                CodeBlock cblk = new CodeBlock();
                cblk.x = i;
                cblk.y = j;
                cblk.tbx0 = codeblockWidth * i;
                cblk.tby0 = codeblockHeight * j;
                cblk.tbx1 = codeblockWidth * (i + 1);
                cblk.tby1 = codeblockHeight * (j + 1);
                cblk.tbx0_ = Math.max(tb.x0, cblk.tbx0);
                cblk.tby0_ = Math.max(tb.y0, cblk.tby0);
                cblk.tbx1_ = Math.min(tb.x1, cblk.tbx1);
                cblk.tby1_ = Math.min(tb.y1, cblk.tby1);
                int pi = (int)Math.floor((double)(cblk.tbx0_ - tb.x0) / ((double)precintInfo.precinctWidthInSubband * 1.0));
                int pj = (int)Math.floor((double)(cblk.tby0_ - tb.y0) / ((double)precintInfo.precinctHeightInSubband * 1.0));
                cblk.precinctNumber = precintNumber = pi + pj * precintInfo.numPrecinctsWide;
                cblk.subbandType = tb.type;
                cblk.Lblock = 3;
                if (cblk.tbx1_ <= cblk.tbx0_ || cblk.tby1_ <= cblk.tby0_) continue;
                codeblocks.add(cblk);
                if (precincts.size() > precintNumber) {
                    precinct = precincts.get(precintNumber);
                    if (i < precinct.cbx0) {
                        precinct.cbx0 = i;
                    } else if (i > precinct.cbx1) {
                        precinct.cbx1 = i;
                    }
                    if (j < precinct.cby0) {
                        precinct.cbx0 = j;
                    } else if (j > precinct.cby1) {
                        precinct.cby1 = j;
                    }
                } else {
                    precinct = new Precinct();
                    precinct.cby0 = j;
                    precinct.cby1 = j;
                    precinct.cbx0 = i;
                    precinct.cbx1 = i;
                    precincts.add(precinct);
                }
                cblk.precinct = precinct;
            }
        }
        tb.codeBlockInfo = new CodeBlockInfo();
        tb.codeBlockInfo.codeBlockWidth = xcb_;
        tb.codeBlockInfo.codeBlockHeight = ycb_;
        tb.codeBlockInfo.numCodeBlockWide = cbx1 - cbx0 + 1;
        tb.codeBlockInfo.numCodeBlockHigh = cby1 - cby0 + 1;
    }

    private static BufferedImage convertPalette(Info info) {
        BufferedImage image;
        int j;
        int[] cc;
        byte[] mainData;
        SIZ siz = info.siz;
        int componentsCount = siz.nComp;
        ArrayList<SubbandCoefficient> resultImages = new ArrayList<SubbandCoefficient>();
        for (int i = 0; i < info.tilesMap.size(); ++i) {
            Tile tile = info.tilesMap.get(i);
            SubbandCoefficient[] transformedTiles = new SubbandCoefficient[componentsCount];
            for (int c = 0; c < componentsCount; ++c) {
                transformedTiles[c] = Jpeg2000Decoder.transformTile(info, tile, c);
                tile.components.get((int)c).resolutions.clear();
            }
            SubbandCoefficient inputSC = transformedTiles[0];
            SubbandCoefficient result = new SubbandCoefficient();
            result.x = inputSC.x;
            result.y = inputSC.y;
            result.width = inputSC.width;
            result.height = inputSC.height;
            byte[] out = new byte[result.width * result.height * componentsCount];
            result.byteItems = out;
            for (int c = 0; c < componentsCount; ++c) {
                int pos;
                float offset;
                float[] items = transformedTiles[c].floatItems;
                int shift = info.siz.precisionInfo[c][0] + 1 - 8;
                if (shift == 0) {
                    offset = 128.5f;
                    float max = 127.5f;
                    float min = -max;
                    pos = c;
                    for (int j2 = 0; j2 < items.length; ++j2) {
                        float val = items[j2];
                        out[pos] = (byte)(val <= min ? 0.0f : (val >= max ? 255.0f : val + offset));
                        pos += componentsCount;
                    }
                    continue;
                }
                if (shift >= 0) continue;
                pos = c;
                offset = 1 << info.siz.precisionInfo[c][0];
                boolean minVal = false;
                int maxVal = (1 << info.siz.precisionInfo[c][0] + 1) - 1;
                for (int j3 = 0; j3 < items.length; ++j3) {
                    float val = items[j3] + offset;
                    out[pos] = (byte)Math.max(0.0f, Math.min(val, (float)maxVal));
                    pos += componentsCount;
                }
            }
            resultImages.add(result);
        }
        info.tilesMap.clear();
        if (resultImages.size() == 1) {
            mainData = ((SubbandCoefficient)resultImages.get((int)0)).byteItems;
        } else {
            mainData = new byte[siz.nComp * siz.Xsiz * siz.Ysiz];
            int c = siz.nComp;
            int mainStripLen = siz.Xsiz * c;
            for (SubbandCoefficient sc : resultImages) {
                byte[] subData = sc.byteItems;
                int x = sc.x;
                int y = sc.y;
                int w = sc.width;
                int h = sc.height;
                int subStripLen = w * c;
                int xc = x * c;
                for (int i = 0; i < h; ++i) {
                    int stripOffset = i * subStripLen;
                    int mainOffset = (i + y) * mainStripLen + xc;
                    System.arraycopy(subData, stripOffset, mainData, mainOffset, subStripLen);
                }
                sc.byteItems = null;
            }
        }
        if (info.enumerateCS == 12) {
            byte[] tempData = new byte[4 * siz.Xsiz * siz.Ysiz];
            int pos = 0;
            for (int i = 0; i < mainData.length; ++i) {
                cc = info.palette.cValues[mainData[i] & 0xFF];
                for (j = 0; j < cc.length; ++j) {
                    tempData[pos] = (byte)cc[j];
                    ++pos;
                }
            }
            image = new BufferedImage(siz.Xsiz, siz.Ysiz, 1);
            int[] imageData = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
            pos = 0;
            double cc2 = 0.0;
            double mm = 0.0;
            double yy = 0.0;
            double kk = 0.0;
            for (int i = 0; i < imageData.length; ++i) {
                double c = (double)(tempData[pos++] & 0xFF) / 255.0;
                double m = (double)(tempData[pos++] & 0xFF) / 255.0;
                double y = (double)(tempData[pos++] & 0xFF) / 255.0;
                double k = (double)(tempData[pos++] & 0xFF) / 255.0;
                if (c == cc2 && m == mm && y == yy && k == kk && i > 0) {
                    imageData[i] = imageData[i - 1];
                    continue;
                }
                double dif = 1.0 - k;
                double r = 255.0 * (1.0 - c) * dif;
                double g = 255.0 * (1.0 - m) * dif;
                double b = 255.0 * (1.0 - y) * dif;
                cc2 = c;
                mm = m;
                yy = y;
                kk = k;
                imageData[i] = (int)r << 16 | (int)g << 8 | (int)b;
            }
        } else {
            image = Jpeg2000Decoder.generateBufferedImage(info.palette.nColumns, siz.Xsiz, siz.Ysiz);
            byte[] imageData = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            int pos = 0;
            for (int i = 0; i < mainData.length; ++i) {
                cc = info.palette.cValues[mainData[i] & 0xFF];
                for (j = 0; j < cc.length; ++j) {
                    imageData[pos] = (byte)cc[j];
                    ++pos;
                }
            }
        }
        return image;
    }

    private static BufferedImage convertCMYKTileToRGB(Info info, boolean convertCMYK) {
        BufferedImage image;
        byte[] mainData;
        SIZ siz = info.siz;
        int componentsCount = siz.nComp;
        ArrayList<SubbandCoefficient> resultImages = new ArrayList<SubbandCoefficient>();
        for (int i = 0; i < info.tilesMap.size(); ++i) {
            float min;
            float max;
            float offset;
            int shift;
            Tile tile = info.tilesMap.get(i);
            SubbandCoefficient[] transformedTiles = new SubbandCoefficient[componentsCount];
            for (int c = 0; c < componentsCount; ++c) {
                transformedTiles[c] = Jpeg2000Decoder.transformTile(info, tile, c);
                tile.components.get((int)c).resolutions.clear();
            }
            SubbandCoefficient inputSC = transformedTiles[0];
            SubbandCoefficient result = new SubbandCoefficient();
            result.x = inputSC.x;
            result.y = inputSC.y;
            result.width = inputSC.width;
            result.height = inputSC.height;
            byte[] out = new byte[result.width * result.height * componentsCount];
            result.byteItems = out;
            int pos = 0;
            if (tile.cod.multiCompTransform == 1) {
                double b;
                double g;
                double r;
                double c4;
                double c3;
                double c2;
                double c1;
                int j;
                float[] comp1Floats = transformedTiles[0].floatItems;
                float[] comp2Floats = transformedTiles[1].floatItems;
                float[] comp3Floats = transformedTiles[2].floatItems;
                float[] comp4Floats = transformedTiles[3].floatItems;
                shift = info.siz.precisionInfo[0][0] + 1 - 8;
                offset = (float)(128 << shift) + 0.5f;
                max = 255 * (1 << shift);
                float maxK = max * 0.5f;
                min = -maxK;
                if (tile.cod.transformation == 0) {
                    pos = 0;
                    for (j = 0; j < comp1Floats.length; ++j) {
                        c1 = comp1Floats[j] + offset;
                        c2 = comp2Floats[j];
                        c3 = comp3Floats[j];
                        c4 = comp4Floats[j];
                        r = c1 + 1.402 * c3;
                        g = c1 - 0.34413 * c2 - 0.71414 * c3;
                        b = c1 + 1.772 * c2;
                        out[pos++] = (byte)(r <= 0.0 ? 0 : (r >= (double)max ? 255 : (int)r >> shift));
                        out[pos++] = (byte)(g <= 0.0 ? 0 : (g >= (double)max ? 255 : (int)g >> shift));
                        out[pos++] = (byte)(b <= 0.0 ? 0 : (b >= (double)max ? 255 : (int)b >> shift));
                        out[pos++] = (byte)(c4 <= (double)min ? 0 : (c4 >= (double)maxK ? 255 : (int)(c4 + (double)offset) >> shift));
                    }
                } else {
                    for (j = 0; j < comp1Floats.length; ++j) {
                        c1 = comp1Floats[j] + offset;
                        c2 = comp2Floats[j];
                        c3 = comp3Floats[j];
                        c4 = comp4Floats[j];
                        g = c1 - (double)((int)(c3 + c2) >> 2);
                        r = g + c3;
                        b = g + c2;
                        out[pos++] = (byte)(r <= 0.0 ? 0 : (r >= (double)max ? 255 : (int)r >> shift));
                        out[pos++] = (byte)(g <= 0.0 ? 0 : (g >= (double)max ? 255 : (int)g >> shift));
                        out[pos++] = (byte)(b <= 0.0 ? 0 : (b >= (double)max ? 255 : (int)b >> shift));
                        out[pos++] = (byte)(c4 <= (double)min ? 0 : (c4 >= (double)maxK ? 255 : (int)(c4 + (double)offset) >> shift));
                    }
                }
            } else {
                for (int c = 0; c < componentsCount; ++c) {
                    float[] items = transformedTiles[c].floatItems;
                    shift = info.siz.precisionInfo[c][0] + 1 - 8;
                    offset = (float)(128 << shift) + 0.5f;
                    max = (int)(127.5f * (float)(1 << shift));
                    min = -max;
                    pos = c;
                    for (int j = 0; j < items.length; ++j) {
                        float val = items[j];
                        out[pos] = (byte)(val <= min ? 0 : (val >= max ? 255 : (int)(val + offset) >> shift));
                        pos += componentsCount;
                    }
                }
            }
            resultImages.add(result);
        }
        info.tilesMap.clear();
        if (resultImages.size() == 1) {
            mainData = ((SubbandCoefficient)resultImages.get((int)0)).byteItems;
        } else {
            mainData = new byte[siz.nComp * siz.Xsiz * siz.Ysiz];
            int c = siz.nComp;
            int mainStripLen = siz.Xsiz * c;
            for (SubbandCoefficient sc : resultImages) {
                byte[] subData = sc.byteItems;
                int x = sc.x;
                int y = sc.y;
                int w = sc.width;
                int h = sc.height;
                int subStripLen = w * c;
                int xc = x * c;
                for (int i = 0; i < h; ++i) {
                    int stripOffset = i * subStripLen;
                    int mainOffset = (i + y) * mainStripLen + xc;
                    System.arraycopy(subData, stripOffset, mainData, mainOffset, subStripLen);
                }
                sc.byteItems = null;
            }
        }
        if (convertCMYK) {
            image = new BufferedImage(siz.Xsiz, siz.Ysiz, 1);
            int[] imageData = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
            int pos = 0;
            EnumeratedSpace cs = new EnumeratedSpace();
            for (int i = 0; i < imageData.length; ++i) {
                byte c = mainData[pos++];
                byte m = mainData[pos++];
                byte y = mainData[pos++];
                byte k = mainData[pos++];
                byte[] rgb = cs.getRGB(c, m, y, k);
                int r = rgb[0] & 0xFF;
                int g = rgb[1] & 0xFF;
                int b = rgb[2] & 0xFF;
                imageData[i] = r << 16 | g << 8 | b;
            }
        } else {
            image = Jpeg2000Decoder.generateBufferedImage(4, siz.Xsiz, siz.Ysiz);
            byte[] imageData = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            System.arraycopy(mainData, 0, imageData, 0, mainData.length);
        }
        return image;
    }

    private static BufferedImage convertTileComponentsToBuffered(Info info) {
        SIZ siz = info.siz;
        int componentsCount = siz.nComp;
        ArrayList<SubbandCoefficient> resultImages = new ArrayList<SubbandCoefficient>();
        for (int i = 0; i < info.tilesMap.size(); ++i) {
            double b;
            double g;
            double r;
            double y2;
            double y1;
            double y0;
            int j;
            int max;
            double offset;
            int shift;
            float[] y2items;
            float[] y1items;
            byte[] out;
            Tile tile = info.tilesMap.get(i);
            SubbandCoefficient[] transformedTiles = new SubbandCoefficient[componentsCount];
            for (int c = 0; c < componentsCount; ++c) {
                transformedTiles[c] = Jpeg2000Decoder.transformTile(info, tile, c);
                tile.components.get((int)c).resolutions.clear();
            }
            SubbandCoefficient inputSC = transformedTiles[0];
            SubbandCoefficient result = new SubbandCoefficient();
            result.x = inputSC.x;
            result.y = inputSC.y;
            result.width = inputSC.width;
            result.height = inputSC.height;
            if (info.tilesMap.size() == 1) {
                result.bufferedImage = Jpeg2000Decoder.generateBufferedImage(componentsCount, result.width, result.height);
                out = ((DataBufferByte)result.bufferedImage.getRaster().getDataBuffer()).getData();
            } else {
                out = new byte[result.width * result.height * componentsCount];
                result.byteItems = out;
            }
            int pos = 0;
            if (tile.cod.multiCompTransform != 0) {
                float[] y0items = Jpeg2000Decoder.getMappedComponent(transformedTiles, 0, info);
                y1items = Jpeg2000Decoder.getMappedComponent(transformedTiles, 1, info);
                y2items = Jpeg2000Decoder.getMappedComponent(transformedTiles, 2, info);
                shift = info.siz.precisionInfo[0][0] + 1 - 8;
                offset = (float)(128 << shift) + 0.5f;
                max = 255 * (1 << shift);
                int alpha01 = componentsCount - 3;
                if (tile.cod.transformation == 0) {
                    j = 0;
                    while (j < y0items.length) {
                        y0 = (double)y0items[j] + offset;
                        y1 = y1items[j];
                        y2 = y2items[j];
                        r = y0 + 1.402 * y2;
                        g = y0 - 0.34413 * y1 - 0.71414 * y2;
                        b = y0 + 1.772 * y1;
                        out[pos++] = (byte)(r < 0.0 ? 0 : (r > (double)max ? 255 : (int)r >> shift));
                        out[pos++] = (byte)(g < 0.0 ? 0 : (g > (double)max ? 255 : (int)g >> shift));
                        out[pos++] = (byte)(b < 0.0 ? 0 : (b > (double)max ? 255 : (int)b >> shift));
                        ++j;
                        pos += alpha01;
                    }
                } else {
                    int yLen = y0items.length;
                    int j2 = 0;
                    while (j2 < yLen) {
                        y0 = (double)y0items[j2] + offset;
                        y1 = y1items[j2];
                        y2 = y2items[j2];
                        g = y0 - (double)((int)(y2 + y1) >> 2);
                        r = g + y2;
                        b = g + y1;
                        out[pos++] = (byte)(r < 0.0 ? 0 : (r > (double)max ? 255 : (int)r >> shift));
                        out[pos++] = (byte)(g < 0.0 ? 0 : (g > (double)max ? 255 : (int)g >> shift));
                        out[pos++] = (byte)(b < 0.0 ? 0 : (b > (double)max ? 255 : (int)b >> shift));
                        ++j2;
                        pos += alpha01;
                    }
                }
            } else if (info.enumerateCS == 18 && componentsCount == 3) {
                float[] y0items = Jpeg2000Decoder.getMappedComponent(transformedTiles, 0, info);
                y1items = Jpeg2000Decoder.getMappedComponent(transformedTiles, 1, info);
                y2items = Jpeg2000Decoder.getMappedComponent(transformedTiles, 2, info);
                shift = info.siz.precisionInfo[0][0] + 1 - 8;
                offset = (float)(128 << shift) + 0.5f;
                max = 255 * (1 << shift);
                int yLen = y0items.length;
                for (j = 0; j < yLen; ++j) {
                    y0 = (double)y0items[j] + offset;
                    y1 = y1items[j];
                    y2 = y2items[j];
                    r = y0 + 1.402 * y2;
                    g = y0 - 0.34413 * y1 - 0.71414 * y2;
                    b = y0 + 1.772 * y1;
                    out[pos++] = (byte)(r < 0.0 ? 0 : (r > (double)max ? 255 : (int)r >> shift));
                    out[pos++] = (byte)(g < 0.0 ? 0 : (g > (double)max ? 255 : (int)g >> shift));
                    out[pos++] = (byte)(b < 0.0 ? 0 : (b > (double)max ? 255 : (int)b >> shift));
                }
            } else {
                for (int c = 0; c < componentsCount; ++c) {
                    float[] items = transformedTiles[c].floatItems;
                    shift = info.siz.precisionInfo[c][0] + 1 - 8;
                    offset = (float)(128 << shift) + 0.5f;
                    max = (int)(127.5f * (float)(1 << shift));
                    int min = -max;
                    pos = c;
                    for (int j3 = 0; j3 < items.length; ++j3) {
                        float val = items[j3];
                        out[pos] = (byte)(val <= (float)min ? 0 : (val >= (float)max ? 255 : (int)((double)val + offset) >> shift));
                        pos += componentsCount;
                    }
                }
            }
            inputSC.floatItems = null;
            resultImages.add(result);
        }
        info.tilesMap.clear();
        if (resultImages.size() == 1) {
            return ((SubbandCoefficient)resultImages.get((int)0)).bufferedImage;
        }
        BufferedImage image = Jpeg2000Decoder.generateBufferedImage(siz.nComp, siz.Xsiz, siz.Ysiz);
        byte[] mainData = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int c = siz.nComp;
        int mainStripLen = siz.Xsiz * c;
        for (SubbandCoefficient sc : resultImages) {
            byte[] subData = sc.byteItems;
            int x = sc.x;
            int y = sc.y;
            int w = sc.width;
            int h = sc.height;
            int subStripLen = w * c;
            int xc = x * c;
            for (int i = 0; i < h; ++i) {
                int stripOffset = i * subStripLen;
                int mainOffset = (i + y) * mainStripLen + xc;
                System.arraycopy(subData, stripOffset, mainData, mainOffset, subStripLen);
            }
            sc.byteItems = null;
        }
        return image;
    }

    private static float[] getMappedComponent(SubbandCoefficient[] arr, int keyVal, Info info) {
        if (info.cDef.isEmpty()) {
            return arr[keyVal].floatItems;
        }
        if (info.cDef.containsKey(keyVal)) {
            return arr[info.cDef.get((Object)Integer.valueOf((int)keyVal)).intValue() - 1].floatItems;
        }
        return arr[keyVal].floatItems;
    }

    private static SubbandCoefficient transformTile(Info info, Tile tile, int c) {
        SIZ siz = info.siz;
        TileComponent comp = tile.components.get(c);
        QCD qcd = tile.qcc[c] != null ? tile.qcc[c] : tile.qcd;
        COD cod = tile.cod;
        int NL = cod.nDecompLevel;
        int guardBits = qcd.guardBits;
        int precision = siz.precisionInfo[c][0] + 1;
        boolean reversible = cod.transformation == 1;
        Trns trns = new Trns(reversible);
        ArrayList<SubbandCoefficient> subcos = new ArrayList<SubbandCoefficient>();
        int b = 0;
        for (int i = 0; i <= NL; ++i) {
            TileResolution resolution = comp.resolutions.get(i);
            int width = resolution.getWidth();
            int height = resolution.getHeight();
            float[] coefficients = new float[width * height];
            for (TileBand subband1 : resolution.tileBands) {
                int mu;
                int epsilon;
                if (!qcd.hasScalar) {
                    epsilon = qcd.exponentB[0] + (i > 0 ? 1 - i : 0);
                    mu = qcd.mantissaB[0];
                } else {
                    epsilon = qcd.exponentB[b];
                    mu = qcd.mantissaB[b];
                    ++b;
                }
                int multi = subband1.getMultiplier();
                double toBePowered = precision + multi - epsilon;
                float delta = (float)(cod.transformation == 1 ? 1.0 : Math.pow(2.0, toBePowered) * (double)(1.0f + (float)mu / 2048.0f));
                int mb = guardBits + epsilon - 1;
                Jpeg2000Decoder.sendForPassing(coefficients, width, subband1, delta, mb, reversible);
            }
            SubbandCoefficient sc = new SubbandCoefficient();
            sc.width = width;
            sc.height = height;
            sc.floatItems = coefficients;
            subcos.add(sc);
        }
        SubbandCoefficient result = trns.getInversed(subcos, comp.x0, comp.y0);
        result.x = comp.x0;
        result.y = comp.y0;
        int sw = result.width;
        int sh = result.height;
        int dw = result.width * siz.precisionInfo[c][1];
        int dh = result.height * siz.precisionInfo[c][1];
        if (sw != dw || sh != dh) {
            result.floatItems = Jpeg2000Decoder.applyBilinearScaling(result.floatItems, sw, sh, dw, dh);
        }
        return result;
    }

    private static float[] applyBilinearScaling(float[] data, int sw, int sh, int dw, int dh) {
        float[] temp;
        if (sh == 1) {
            temp = new float[2 * sw];
            System.arraycopy(data, 0, temp, 0, sw);
            System.arraycopy(data, 0, temp, sw, sw);
            sh = 2;
            data = temp;
        }
        temp = new float[dw * dh];
        float xRatio = (float)(sw - 1) / (float)dw;
        float yRatio = (float)(sh - 1) / (float)dh;
        int offset = 0;
        for (int i = 0; i < dh; ++i) {
            for (int j = 0; j < dw; ++j) {
                int x = (int)(xRatio * (float)j);
                int y = (int)(yRatio * (float)i);
                float xDiff = xRatio * (float)j - (float)x;
                float yDiff = yRatio * (float)i - (float)y;
                int index = y * sw + x;
                float A = data[index];
                float B2 = data[index + 1];
                float C = data[index + sw];
                float D2 = data[index + sw + 1];
                temp[offset++] = A * (1.0f - xDiff) * (1.0f - yDiff) + B2 * xDiff * (1.0f - yDiff) + C * yDiff * (1.0f - xDiff) + D2 * (xDiff * yDiff);
            }
        }
        return temp;
    }

    private static void sendForPassing(float[] coefficients, int resWidth, TileBand subband, float delta, int mb, boolean reversible) {
        int width = subband.x1 - subband.x0;
        List<CodeBlock> codeBlocks = subband.codeBlocks;
        int right = 0;
        int bottom = 0;
        switch (subband.type) {
            case 3: {
                right = 1;
                bottom = resWidth;
                break;
            }
            case 1: {
                bottom = resWidth;
                break;
            }
            case 2: {
                right = 1;
            }
        }
        for (CodeBlock codeBlock : codeBlocks) {
            int blockWidth = codeBlock.tbx1_ - codeBlock.tbx0_;
            int blockHeight = codeBlock.tby1_ - codeBlock.tby0_;
            if (blockWidth == 0 || blockHeight == 0 || codeBlock.dataList.isEmpty()) continue;
            Tier1Decoder tier1 = new Tier1Decoder(blockWidth, blockHeight, subband, codeBlock.zeroBitPlanes, mb);
            List<BlockData> datas = codeBlock.dataList;
            int totalLength = 0;
            int codingpasses = 0;
            for (BlockData dataItem : datas) {
                totalLength += dataItem.end - dataItem.start;
                codingpasses += dataItem.nCodingPass & 0xFF;
            }
            byte[] encodedData = new byte[totalLength];
            int position = 0;
            for (BlockData dataItem : datas) {
                byte[] chunk = new byte[dataItem.end - dataItem.start];
                System.arraycopy(dataItem.data, dataItem.start, chunk, 0, chunk.length);
                System.arraycopy(chunk, 0, encodedData, position, chunk.length);
                position += chunk.length;
            }
            EntropyDecoder decoder = new EntropyDecoder(encodedData, 0, totalLength);
            tier1.setDecoder(decoder);
            int currentCodingpassType = 2;
            for (int j = 0; j < codingpasses; ++j) {
                switch (currentCodingpassType) {
                    case 0: {
                        tier1.runSPP();
                        break;
                    }
                    case 1: {
                        tier1.runMRP();
                        break;
                    }
                    case 2: {
                        tier1.runCP();
                    }
                }
                currentCodingpassType = (currentCodingpassType + 1) % 3;
            }
            int offset = codeBlock.tbx0_ - subband.x0 + (codeBlock.tby0_ - subband.y0) * width;
            byte[] sign = tier1.coefficientsSign;
            Object magObj = tier1.magnitude;
            byte[] bitsDecoded = tier1.bitsDecoded;
            float magnitudeCorrection = reversible ? 0.0f : 0.5f;
            position = 0;
            boolean interleave = subband.type != 0;
            for (int j = 0; j < blockHeight; ++j) {
                int row = offset / width;
                int levelOffset = 2 * row * (resWidth - width) + right + bottom;
                for (int k = 0; k < blockWidth; ++k) {
                    float n = 0.0f;
                    switch (tier1.mbType) {
                        case 0: {
                            n = ((byte[])magObj)[position] & 0xFF;
                            break;
                        }
                        case 1: {
                            n = ((short[])magObj)[position] & 0xFFFF;
                            break;
                        }
                        case 2: {
                            n = ((int[])magObj)[position];
                        }
                    }
                    if (n != 0.0f) {
                        n = (n + magnitudeCorrection) * delta;
                        if (sign[position] != 0) {
                            n = -n;
                        }
                        int nb = bitsDecoded[position] & 0xFF;
                        int pos = interleave ? levelOffset + (offset << 1) : offset;
                        coefficients[pos] = reversible && nb >= mb ? n : n * (float)(1 << mb - nb);
                    }
                    ++offset;
                    ++position;
                }
                offset += width - blockWidth;
            }
            tier1.neighborSigns = null;
            tier1.coefficientsSign = null;
            tier1.magnitude = null;
            tier1.currentFlag = null;
            tier1.bitsDecoded = null;
            tier1.cx = null;
        }
    }

    private static boolean[] toBoolean8(byte b) {
        boolean[] bool = new boolean[8];
        for (int j = 7; j >= 0; --j) {
            bool[j] = (b >> j & 1) == 1;
        }
        return bool;
    }

    private static BufferedImage generateBufferedImage(int nComp, int width, int height) {
        switch (nComp) {
            case 1: {
                ICC_ColorSpace cSpace = new ICC_ColorSpace(ICC_Profile.getInstance(1003));
                ComponentColorModel model = new ComponentColorModel(cSpace, false, false, 1, 0);
                WritableRaster ras = model.createCompatibleWritableRaster(width, height);
                return new BufferedImage(model, ras, false, null);
            }
            case 2: {
                ICC_ColorSpace cSpace = new ICC_ColorSpace(ICC_Profile.getInstance(1003));
                ComponentColorModel model = new ComponentColorModel(cSpace, true, false, 1, 0);
                WritableRaster ras = model.createCompatibleWritableRaster(width, height);
                return new BufferedImage(model, ras, false, null);
            }
            case 3: {
                ICC_ColorSpace cSpace = new ICC_ColorSpace(ICC_Profile.getInstance(1000));
                ComponentColorModel model = new ComponentColorModel(cSpace, false, false, 1, 0);
                WritableRaster ras = model.createCompatibleWritableRaster(width, height);
                return new BufferedImage(model, ras, false, null);
            }
            case 4: {
                ICC_ColorSpace cSpace = new ICC_ColorSpace(ICC_Profile.getInstance(1000));
                ComponentColorModel model = new ComponentColorModel(cSpace, true, false, 1, 0);
                WritableRaster ras = model.createCompatibleWritableRaster(width, height);
                return new BufferedImage(model, ras, false, null);
            }
        }
        return null;
    }

    public byte[] readComponentsAsConvertedBytes(byte[] jpxRawData) throws Exception {
        boolean isPalette;
        byte[] mainData;
        Info info = new Info();
        JPXReader reader = new JPXReader(jpxRawData);
        if (65359 == ((jpxRawData[0] & 0xFF) << 8 | jpxRawData[1] & 0xFF)) {
            Jpeg2000Decoder.readCodeStream(info, reader, jpxRawData.length);
        } else {
            Jpeg2000Decoder.decodeMain(info, reader);
            Jpeg2000Decoder.decodeContiguousCodeStreamBoxes(info, reader);
        }
        Jpeg2000Decoder.generateTileMap(info);
        Jpeg2000Decoder.decodeTileOffsets(info, reader);
        SIZ siz = info.siz;
        int componentsCount = siz.nComp;
        ArrayList<SubbandCoefficient> resultImages = new ArrayList<SubbandCoefficient>();
        for (int i = 0; i < info.tilesMap.size(); ++i) {
            float min;
            float max;
            float offset;
            int shift;
            Tile tile = info.tilesMap.get(i);
            SubbandCoefficient[] transformedTiles = new SubbandCoefficient[componentsCount];
            for (int c = 0; c < componentsCount; ++c) {
                transformedTiles[c] = Jpeg2000Decoder.transformTile(info, tile, c);
                tile.components.get((int)c).resolutions.clear();
            }
            SubbandCoefficient inputSC = transformedTiles[0];
            SubbandCoefficient result = new SubbandCoefficient();
            result.x = inputSC.x;
            result.y = inputSC.y;
            result.width = inputSC.width;
            result.height = inputSC.height;
            byte[] out = new byte[result.width * result.height * componentsCount];
            result.byteItems = out;
            int pos = 0;
            float[] comp4 = null;
            if (tile.cod.multiCompTransform == 1) {
                double c4;
                double b;
                double g;
                double r;
                double c3;
                double c2;
                double c1;
                int j;
                float[] comp1 = transformedTiles[0].floatItems;
                float[] comp2 = transformedTiles[1].floatItems;
                float[] comp3 = transformedTiles[2].floatItems;
                if (tile.components.size() == 4) {
                    comp4 = transformedTiles[3].floatItems;
                }
                shift = info.siz.precisionInfo[0][0] + 1 - 8;
                offset = (float)(128 << shift) + 0.5f;
                max = 255 * (1 << shift);
                float maxK = max * 0.5f;
                min = -maxK;
                if (tile.cod.transformation == 0) {
                    pos = 0;
                    for (j = 0; j < comp1.length; ++j) {
                        c1 = comp1[j] + offset;
                        c2 = comp2[j];
                        c3 = comp3[j];
                        r = c1 + 1.402 * c3;
                        g = c1 - 0.34413 * c2 - 0.71414 * c3;
                        b = c1 + 1.772 * c2;
                        out[pos++] = (byte)(r <= 0.0 ? 0 : (r >= (double)max ? 255 : (int)r >> shift));
                        out[pos++] = (byte)(g <= 0.0 ? 0 : (g >= (double)max ? 255 : (int)g >> shift));
                        out[pos++] = (byte)(b <= 0.0 ? 0 : (b >= (double)max ? 255 : (int)b >> shift));
                        if (comp4 == null) continue;
                        c4 = comp4[j];
                        out[pos++] = (byte)(c4 <= (double)min ? 0 : (c4 >= (double)maxK ? 255 : (int)(c4 + (double)offset) >> shift));
                    }
                } else {
                    for (j = 0; j < comp1.length; ++j) {
                        c1 = comp1[j] + offset;
                        c2 = comp2[j];
                        c3 = comp3[j];
                        g = c1 - (double)((int)(c3 + c2) >> 2);
                        r = g + c3;
                        b = g + c2;
                        out[pos++] = (byte)(r <= 0.0 ? 0 : (r >= (double)max ? 255 : (int)r >> shift));
                        out[pos++] = (byte)(g <= 0.0 ? 0 : (g >= (double)max ? 255 : (int)g >> shift));
                        out[pos++] = (byte)(b <= 0.0 ? 0 : (b >= (double)max ? 255 : (int)b >> shift));
                        if (comp4 == null) continue;
                        c4 = comp4[j];
                        out[pos++] = (byte)(c4 <= (double)min ? 0 : (c4 >= (double)maxK ? 255 : (int)(c4 + (double)offset) >> shift));
                    }
                }
            } else {
                for (int c = 0; c < componentsCount; ++c) {
                    float[] items = transformedTiles[c].floatItems;
                    shift = info.siz.precisionInfo[c][0] + 1 - 8;
                    offset = (float)(128 << shift) + 0.5f;
                    max = (int)(127.5f * (float)(1 << shift));
                    min = -max;
                    pos = c;
                    for (int j = 0; j < items.length; ++j) {
                        float val = items[j];
                        out[pos] = (byte)(val <= min ? 0 : (val >= max ? 255 : (int)(val + offset) >> shift));
                        pos += componentsCount;
                    }
                }
            }
            resultImages.add(result);
        }
        info.tilesMap.clear();
        if (resultImages.size() == 1) {
            mainData = ((SubbandCoefficient)resultImages.get((int)0)).byteItems;
        } else {
            mainData = new byte[siz.nComp * siz.Xsiz * siz.Ysiz];
            int c = siz.nComp;
            int mainStripLen = siz.Xsiz * c;
            for (SubbandCoefficient sc : resultImages) {
                byte[] subData = sc.byteItems;
                int x = sc.x;
                int y = sc.y;
                int w = sc.width;
                int h = sc.height;
                int subStripLen = w * c;
                int xc = x * c;
                for (int i = 0; i < h; ++i) {
                    int stripOffset = i * subStripLen;
                    int mainOffset = (i + y) * mainStripLen + xc;
                    System.arraycopy(subData, stripOffset, mainData, mainOffset, subStripLen);
                }
                sc.byteItems = null;
            }
        }
        boolean bl = isPalette = info.palette != null && info.siz.nComp == 1;
        if (isPalette) {
            byte[] imageData = new byte[info.palette.nColumns * siz.Xsiz * siz.Ysiz];
            int pos = 0;
            for (int i = 0; i < mainData.length; ++i) {
                int[] cc = info.palette.cValues[mainData[i] & 0xFF];
                for (int j = 0; j < cc.length; ++j) {
                    imageData[pos] = (byte)cc[j];
                    ++pos;
                }
            }
            mainData = imageData;
        }
        if (info.enumerateCS == 12) {
            EnumeratedSpace cs = new EnumeratedSpace();
            int a = 0;
            int p = 0;
            byte[] rgbData = new byte[info.imageHeight * info.imageWidth * 3];
            for (int i = 0; i < mainData.length; i += 4) {
                byte c = mainData[a++];
                byte m = mainData[a++];
                byte y = mainData[a++];
                byte k = mainData[a++];
                byte[] rgb = cs.getRGB(c, m, y, k);
                rgbData[p++] = rgb[0];
                rgbData[p++] = rgb[1];
                rgbData[p++] = rgb[2];
            }
            mainData = rgbData;
        }
        return mainData;
    }
}

