/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png;

public class D3 {
    public final int r;
    public final int g;
    public final int b;
    public final int rgb;

    public D3(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.rgb = r << 16 | g << 8 | b;
    }

    private static int diff(int r, int g, int b, D3 pal) {
        int Rdiff = r - pal.r;
        int Gdiff = g - pal.g;
        int Bdiff = b - pal.b;
        return Rdiff * Rdiff + Gdiff * Gdiff + Bdiff * Bdiff;
    }

    public static int[] findClosest(int argb, D3[] palette) {
        D3 closest = palette[0];
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        int cDiff = D3.diff(r, g, b, closest);
        int found = 0;
        for (int i = 1; i < 256; ++i) {
            D3 n = palette[i];
            int nDiff = D3.diff(r, g, b, n);
            if (nDiff >= cDiff) continue;
            closest = n;
            found = i;
            cDiff = nDiff;
        }
        return new int[]{closest.rgb, found};
    }

    public static byte[] process(byte[] colorPalette, int[][] image, int h, int w) {
        int p = 0;
        D3[] palette = new D3[256];
        for (int i = 0; i < 256; ++i) {
            int r = colorPalette[p++] & 0xFF;
            int g = colorPalette[p++] & 0xFF;
            int b = colorPalette[p++] & 0xFF;
            palette[i] = new D3(r, g, b);
        }
        byte[] indexedPixels = new byte[h * w];
        p = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int update;
                int argb = image[y][x];
                int[] obj = D3.findClosest(argb, palette);
                int nextArgb = obj[0];
                indexedPixels[p++] = (byte)obj[1];
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb & 0xFF;
                int nr = nextArgb >> 16 & 0xFF;
                int ng = nextArgb >> 8 & 0xFF;
                int nb = nextArgb & 0xFF;
                int errR = r - nr;
                int errG = g - ng;
                int errB = b - nb;
                if (x + 1 < w) {
                    image[y][x + 1] = update = D3.applyFloyd(image[y][x + 1], errR, errG, errB, 7);
                    if (y + 1 < h) {
                        image[y + 1][x + 1] = update = D3.applyFloyd(image[y + 1][x + 1], errR, errG, errB, 1);
                    }
                }
                if (y + 1 >= h) continue;
                image[y + 1][x] = update = D3.applyFloyd(image[y + 1][x], errR, errG, errB, 5);
                if (x - 1 < 0) continue;
                image[y + 1][x - 1] = update = D3.applyFloyd(image[y + 1][x - 1], errR, errG, errB, 3);
            }
        }
        return indexedPixels;
    }

    private static int applyFloyd(int argb, int errR, int errG, int errB, int mul) {
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        g += errG * mul / 16;
        b += errB * mul / 16;
        if ((r += errR * mul / 16) < 0) {
            r = 0;
        } else if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        } else if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        } else if (b > 255) {
            b = 255;
        }
        return r << 16 | g << 8 | b;
    }
}

