/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png;

public class D4 {
    public final int a;
    public final int r;
    public final int g;
    public final int b;
    public final int argb;

    public D4(int a, int r, int g, int b) {
        this.a = a;
        this.r = r;
        this.g = g;
        this.b = b;
        this.argb = a << 24 | r << 16 | g << 8 | b;
    }

    private static int diff(int a, int r, int g, int b, D4 pal) {
        int Adiff = a - pal.a;
        int Rdiff = r - pal.r;
        int Gdiff = g - pal.g;
        int Bdiff = b - pal.b;
        return Adiff * Adiff + Rdiff * Rdiff + Gdiff * Gdiff + Bdiff * Bdiff;
    }

    public static int[] findClosest(int argb, D4[] palette) {
        D4 closest = palette[0];
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        int cDiff = D4.diff(a, r, g, b, closest);
        int found = 0;
        for (int i = 1; i < 256; ++i) {
            D4 n = palette[i];
            int nDiff = D4.diff(a, r, g, b, n);
            if (nDiff >= cDiff) continue;
            closest = n;
            found = i;
            cDiff = nDiff;
        }
        return new int[]{closest.argb, found};
    }

    public static byte[] process(byte[] colorPalette, byte[] trns, int[][] image, int h, int w) {
        int p = 0;
        D4[] palette = new D4[256];
        for (int i = 0; i < 256; ++i) {
            int a = trns[i] & 0xFF;
            int r = colorPalette[p++] & 0xFF;
            int g = colorPalette[p++] & 0xFF;
            int b = colorPalette[p++] & 0xFF;
            palette[i] = new D4(a, r, g, b);
        }
        byte[] indexedPixels = new byte[h * w];
        p = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int update;
                int argb = image[y][x];
                int[] obj = D4.findClosest(argb, palette);
                int nextArgb = obj[0];
                indexedPixels[p++] = (byte)obj[1];
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb & 0xFF;
                int na = nextArgb >> 24 & 0xFF;
                int nr = nextArgb >> 16 & 0xFF;
                int ng = nextArgb >> 8 & 0xFF;
                int nb = nextArgb & 0xFF;
                int errA = a - na;
                int errR = r - nr;
                int errG = g - ng;
                int errB = b - nb;
                if (x + 1 < w) {
                    image[y][x + 1] = update = D4.applyFloyd(image[y][x + 1], errA, errR, errG, errB, 7);
                    if (y + 1 < h) {
                        image[y + 1][x + 1] = update = D4.applyFloyd(image[y + 1][x + 1], errA, errR, errG, errB, 1);
                    }
                }
                if (y + 1 >= h) continue;
                image[y + 1][x] = update = D4.applyFloyd(image[y + 1][x], errA, errR, errG, errB, 5);
                if (x - 1 < 0) continue;
                image[y + 1][x - 1] = update = D4.applyFloyd(image[y + 1][x - 1], errA, errR, errG, errB, 3);
            }
        }
        return indexedPixels;
    }

    private static int applyFloyd(int argb, int errA, int errR, int errG, int errB, int mul) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        r += errR * mul / 16;
        g += errG * mul / 16;
        b += errB * mul / 16;
        if ((a += errA * mul / 16) < 0) {
            a = 0;
        } else if (a > 255) {
            a = 255;
        }
        if (r < 0) {
            r = 0;
        } else if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        } else if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        } else if (b > 255) {
            b = 255;
        }
        return a << 24 | r << 16 | g << 8 | b;
    }
}

