/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png;

import java.util.BitSet;

public class PngBitReader {
    private int p;
    private final int totalBitLen;
    private BitSet bitset;
    private byte[] data;
    private final boolean hasSmallBits;

    public PngBitReader(byte[] data, boolean hasSmallBits) {
        this.hasSmallBits = hasSmallBits;
        this.totalBitLen = data.length * 8;
        if (this.hasSmallBits) {
            this.bitset = new BitSet(this.totalBitLen);
            int c = 0;
            for (byte b : data) {
                for (int j = 7; j >= 0; --j) {
                    boolean isOn = (b >> j & 1) == 1;
                    this.bitset.set(c, isOn);
                    ++c;
                }
            }
        } else {
            this.data = data;
        }
    }

    private int readBits(int lenToRead) {
        int retVal = 0;
        if (this.hasSmallBits) {
            BitSet smallSet = this.bitset.get(this.p, this.p + lenToRead);
            for (int i = 0; i < lenToRead; ++i) {
                if (smallSet.get(i)) {
                    retVal = retVal << 1 | 1;
                    continue;
                }
                retVal <<= 1;
            }
            this.p += lenToRead;
        } else {
            int len = lenToRead / 8;
            for (int i = 0; i < len; ++i) {
                retVal <<= 8;
                retVal |= this.data[this.p / 8] & 0xFF;
                this.p += 8;
            }
        }
        return retVal;
    }

    public int getPositive(int bitLen) {
        return this.readBits(bitLen);
    }

    public int getPointer() {
        return this.p;
    }

    public int getTotalBitLen() {
        return this.totalBitLen;
    }
}

