/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.tiff;

import com.idrsolutions.image.tiff.Deflate;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class TiffEncoder {
    private boolean compress;

    public void write(BufferedImage image, OutputStream outputStream) throws IOException {
        int imageW;
        int imageH;
        boolean hasAlpha;
        byte[] raw = TiffEncoder.getComponentBytes(image);
        boolean bl = hasAlpha = raw.length > (imageH = image.getHeight()) * (imageW = image.getWidth()) * 3;
        if (this.compress) {
            raw = Deflate.compress(raw);
        }
        int offsetIFD = 8;
        TiffEncoder.writeIdentifier(outputStream, offsetIFD);
        TiffEncoder.writeContents(outputStream, raw, imageW, imageH, offsetIFD, hasAlpha, this.compress);
        TiffEncoder.writePadding(outputStream, raw.length);
    }

    public void append(BufferedImage img, String fileName) throws IOException {
        File file = new File(fileName);
        if (file.exists() && file.length() > 0L) {
            boolean hasAlpha;
            int endFile = (int)file.length();
            int padding = endFile % 8;
            RandomAccessFile rFile = new RandomAccessFile(fileName, "rw");
            rFile.seek(endFile);
            for (int i = 0; i < padding; ++i) {
                rFile.write(0);
            }
            TiffEncoder.alterLastIFDOffset(rFile, endFile += padding);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] data = TiffEncoder.getComponentBytes(img);
            boolean bl = hasAlpha = data.length > img.getWidth() * img.getHeight() * 3;
            if (this.compress) {
                data = Deflate.compress(data);
            }
            TiffEncoder.writeContents(bos, data, img.getWidth(), img.getHeight(), endFile, hasAlpha, this.compress);
            bos.close();
            data = bos.toByteArray();
            rFile.seek(endFile);
            rFile.write(data);
            rFile.close();
        } else {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileName));
            TiffEncoder.createImage(img, out, this.compress);
            out.close();
        }
    }

    public boolean isCompressed() {
        return this.compress;
    }

    public void setCompressed(boolean compress) {
        this.compress = compress;
    }

    private static void alterLastIFDOffset(RandomAccessFile rFile, int fileLen) throws IOException {
        rFile.seek(0L);
        rFile.skipBytes(4);
        int offsetIFD = rFile.readInt();
        do {
            rFile.seek(offsetIFD);
            short dirs = rFile.readShort();
            rFile.skipBytes(dirs * 12);
        } while ((offsetIFD = rFile.readInt()) != 0);
        int pointer = (int)rFile.getFilePointer();
        rFile.seek(pointer - 4);
        rFile.writeInt(fileLen);
    }

    private static void createImage(BufferedImage image, OutputStream out, boolean isCompress) throws IOException {
        int imageW;
        int imageH;
        boolean hasAlpha;
        byte[] raw = TiffEncoder.getComponentBytes(image);
        boolean bl = hasAlpha = raw.length > (imageH = image.getHeight()) * (imageW = image.getWidth()) * 3;
        if (isCompress) {
            raw = Deflate.compress(raw);
        }
        int offsetIFD = 8;
        TiffEncoder.writeIdentifier(out, offsetIFD);
        TiffEncoder.writeContents(out, raw, imageW, imageH, offsetIFD, hasAlpha, isCompress);
        TiffEncoder.writePadding(out, raw.length);
    }

    private static byte[] getComponentBytes(BufferedImage image) {
        byte[] raw;
        int imageH = image.getHeight();
        int imageW = image.getWidth();
        int index = 0;
        switch (image.getType()) {
            case 1: {
                raw = new byte[imageH * imageW * 3];
                int[] pixInts = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                int aa = 0;
                for (int i = 0; i < imageH; ++i) {
                    for (int j = 0; j < imageW; ++j) {
                        byte[] rgb = TiffEncoder.intToBytes(pixInts[aa]);
                        raw[index++] = rgb[1];
                        raw[index++] = rgb[2];
                        raw[index++] = rgb[3];
                        ++aa;
                    }
                }
                break;
            }
            case 2: {
                raw = new byte[imageH * imageW * 4];
                int[] pixInts = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                int xx = 0;
                for (int i = 0; i < imageH; ++i) {
                    for (int j = 0; j < imageW; ++j) {
                        byte[] argb = TiffEncoder.intToBytes(pixInts[xx]);
                        raw[index++] = argb[1];
                        raw[index++] = argb[2];
                        raw[index++] = argb[3];
                        raw[index++] = argb[0];
                        ++xx;
                    }
                }
                break;
            }
            case 4: {
                raw = new byte[imageH * imageW * 3];
                int[] pixInts = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                int bb = 0;
                for (int i = 0; i < imageH; ++i) {
                    for (int j = 0; j < imageW; ++j) {
                        byte[] bgr = TiffEncoder.intToBytes(pixInts[bb]);
                        raw[index++] = bgr[3];
                        raw[index++] = bgr[2];
                        raw[index++] = bgr[1];
                        ++bb;
                    }
                }
                break;
            }
            case 5: {
                raw = new byte[imageH * imageW * 3];
                byte[] pByte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int pb = 0;
                for (int i = 0; i < imageH; ++i) {
                    for (int j = 0; j < imageW; ++j) {
                        raw[index++] = pByte[pb + 2];
                        raw[index++] = pByte[pb + 1];
                        raw[index++] = pByte[pb];
                        pb += 3;
                    }
                }
                break;
            }
            case 6: {
                raw = new byte[imageH * imageW * 4];
                byte[] pByte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int pb4 = 0;
                for (int i = 0; i < imageH; ++i) {
                    for (int j = 0; j < imageW; ++j) {
                        raw[index++] = pByte[pb4 + 3];
                        raw[index++] = pByte[pb4 + 2];
                        raw[index++] = pByte[pb4 + 1];
                        raw[index++] = pByte[pb4];
                        pb4 += 4;
                    }
                }
                break;
            }
            default: {
                raw = new byte[imageH * imageW * 3];
                BufferedImage bImage = new BufferedImage(imageW, imageH, 1);
                bImage.createGraphics().drawImage((Image)image, 0, 0, null);
                int[] pixInts = ((DataBufferInt)bImage.getRaster().getDataBuffer()).getData();
                int cc = 0;
                for (int i = 0; i < imageH; ++i) {
                    for (int j = 0; j < imageW; ++j) {
                        byte[] rgb = TiffEncoder.intToBytes(pixInts[cc]);
                        raw[index++] = rgb[1];
                        raw[index++] = rgb[2];
                        raw[index++] = rgb[3];
                        ++cc;
                    }
                }
            }
        }
        return raw;
    }

    private static void writeIdentifier(OutputStream out, int offsetIFD) throws IOException {
        out.write(new byte[]{77, 77});
        out.write(new byte[]{0, 42});
        out.write(TiffEncoder.intToBytes(offsetIFD));
    }

    private static void writePadding(OutputStream out, int rawLen) throws IOException {
        int balance = rawLen % 8;
        for (int i = 0; i < balance; ++i) {
            out.write(0);
        }
    }

    private static void writeContents(OutputStream out, byte[] raw, int imageWidth, int imageHeight, int offsetIFD, boolean hasAlpha, boolean isCompress) throws IOException {
        int nComp = hasAlpha ? 4 : 3;
        byte totalEntries = (byte)(hasAlpha ? 13 : 12);
        int dataLen = raw.length;
        int sampleOffset = offsetIFD + 2 + totalEntries * 12 + 4;
        int offsetXR = sampleOffset + 2 * nComp;
        int offsetYR = offsetXR + 8;
        int offsetStrip = offsetYR + 8;
        out.write(TiffEncoder.shortToBytes(totalEntries));
        out.write(TiffEncoder.shortToBytes((short)256));
        out.write(TiffEncoder.shortToBytes((short)3));
        out.write(TiffEncoder.intToBytes(1));
        out.write(TiffEncoder.shortToBytes((short)imageWidth));
        out.write(TiffEncoder.shortToBytes((short)0));
        out.write(TiffEncoder.shortToBytes((short)257));
        out.write(TiffEncoder.shortToBytes((short)3));
        out.write(TiffEncoder.intToBytes(1));
        out.write(TiffEncoder.shortToBytes((short)imageHeight));
        out.write(TiffEncoder.shortToBytes((short)0));
        out.write(TiffEncoder.shortToBytes((short)258));
        out.write(TiffEncoder.shortToBytes((short)3));
        out.write(TiffEncoder.intToBytes(nComp));
        out.write(TiffEncoder.intToBytes(sampleOffset));
        out.write(TiffEncoder.shortToBytes((short)259));
        out.write(TiffEncoder.shortToBytes((short)3));
        out.write(TiffEncoder.intToBytes(1));
        int compressValue = isCompress ? 32946 : 1;
        out.write(TiffEncoder.shortToBytes((short)compressValue));
        out.write(TiffEncoder.shortToBytes((short)0));
        out.write(TiffEncoder.shortToBytes((short)262));
        out.write(TiffEncoder.shortToBytes((short)3));
        out.write(TiffEncoder.intToBytes(1));
        out.write(TiffEncoder.shortToBytes((short)2));
        out.write(TiffEncoder.shortToBytes((short)0));
        out.write(TiffEncoder.shortToBytes((short)273));
        out.write(TiffEncoder.shortToBytes((short)4));
        out.write(TiffEncoder.intToBytes(1));
        out.write(TiffEncoder.intToBytes(offsetStrip));
        out.write(TiffEncoder.shortToBytes((short)277));
        out.write(TiffEncoder.shortToBytes((short)3));
        out.write(TiffEncoder.intToBytes(1));
        out.write(TiffEncoder.shortToBytes((short)nComp));
        out.write(TiffEncoder.shortToBytes((short)0));
        out.write(TiffEncoder.shortToBytes((short)278));
        out.write(TiffEncoder.shortToBytes((short)4));
        out.write(TiffEncoder.intToBytes(1));
        out.write(TiffEncoder.intToBytes(imageHeight));
        out.write(TiffEncoder.shortToBytes((short)279));
        out.write(TiffEncoder.shortToBytes((short)4));
        out.write(TiffEncoder.intToBytes(1));
        out.write(TiffEncoder.intToBytes(dataLen));
        out.write(TiffEncoder.shortToBytes((short)282));
        out.write(TiffEncoder.shortToBytes((short)5));
        out.write(TiffEncoder.intToBytes(1));
        out.write(TiffEncoder.intToBytes(offsetXR));
        out.write(TiffEncoder.shortToBytes((short)283));
        out.write(TiffEncoder.shortToBytes((short)5));
        out.write(TiffEncoder.intToBytes(1));
        out.write(TiffEncoder.intToBytes(offsetYR));
        out.write(TiffEncoder.shortToBytes((short)296));
        out.write(TiffEncoder.shortToBytes((short)3));
        out.write(TiffEncoder.intToBytes(1));
        out.write(TiffEncoder.shortToBytes((short)1));
        out.write(TiffEncoder.shortToBytes((short)0));
        if (hasAlpha) {
            out.write(TiffEncoder.shortToBytes((short)338));
            out.write(TiffEncoder.shortToBytes((short)3));
            out.write(TiffEncoder.intToBytes(1));
            out.write(TiffEncoder.shortToBytes((short)2));
            out.write(TiffEncoder.shortToBytes((short)0));
        }
        out.write(TiffEncoder.intToBytes(0));
        for (int i = 0; i < nComp; ++i) {
            out.write(TiffEncoder.shortToBytes((short)8));
        }
        out.write(TiffEncoder.intToBytes(1));
        out.write(TiffEncoder.intToBytes(1));
        out.write(TiffEncoder.intToBytes(1));
        out.write(TiffEncoder.intToBytes(1));
        out.write(raw);
    }

    private static byte[] shortToBytes(short sValue) {
        int iVal = sValue & 0xFFFF;
        return new byte[]{(byte)(iVal >> 8), (byte)iVal};
    }

    private static byte[] intToBytes(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }
}

