/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.blends;

import java.awt.CompositeContext;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class BlendContext
implements CompositeContext {
    private final int blendMode;

    public BlendContext(int blendMode, float alpha) {
        this.blendMode = blendMode;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
        int width = Math.min(src.getWidth(), dstIn.getWidth());
        int height = Math.min(src.getHeight(), dstIn.getHeight());
        int[] srcPixels = new int[width];
        int[] dstInPixels = new int[width];
        int[] dstOutPixels = new int[width];
        for (int y = 0; y < height; ++y) {
            src.getDataElements(0, y, width, 1, srcPixels);
            dstIn.getDataElements(0, y, width, 1, dstInPixels);
            int oldS = 0;
            int oldD = 0;
            int oldR = 0;
            for (int x = 0; x < width; ++x) {
                int s = srcPixels[x];
                int d = dstInPixels[x];
                if (s == oldS && d == oldD) {
                    dstOutPixels[x] = oldR;
                    continue;
                }
                oldS = s;
                oldD = d;
                int[] sp = BlendContext.getRGBA(s);
                int[] dp = BlendContext.getRGBA(d);
                int[] result = new int[4];
                switch (this.blendMode) {
                    case 1111314299: {
                        break;
                    }
                    case 1451587725: {
                        result = BlendContext.doMultiply(sp, dp);
                        break;
                    }
                    case 1110792305: {
                        result = BlendContext.doScreen(sp, dp);
                        break;
                    }
                    case 1113290622: {
                        result = BlendContext.doOverlay(sp, dp);
                        break;
                    }
                    case 1111181679: {
                        result = BlendContext.doDarken(sp, dp);
                        break;
                    }
                    case 945843829: {
                        result = BlendContext.doLighten(sp, dp);
                        break;
                    }
                    case 2071170184: {
                        result = BlendContext.doColorDodge(sp, dp);
                        break;
                    }
                    case 1367441811: {
                        result = BlendContext.doColorBurn(sp, dp);
                        break;
                    }
                    case 1786342520: {
                        result = BlendContext.doHardLight(sp, dp);
                        break;
                    }
                    case 2020441219: {
                        result = BlendContext.doSoftLight(sp, dp);
                        break;
                    }
                    case 1802796208: {
                        result = BlendContext.doDifference(sp, dp);
                        break;
                    }
                    case -1955824744: {
                        result = BlendContext.doExclusion(sp, dp);
                        break;
                    }
                    case 1590581: {
                        result = BlendContext.doHue(sp, dp);
                        break;
                    }
                    case -2004966240: {
                        result = BlendContext.doSaturation(sp, dp);
                        break;
                    }
                    case 1060912981: {
                        result = BlendContext.doColor(sp, dp);
                        break;
                    }
                    case -2139971891: {
                        result = BlendContext.doLuminosity(sp, dp);
                        break;
                    }
                }
                if (sp[3] != 255) {
                    double sr = (double)result[0] / 255.0;
                    double sg = (double)result[1] / 255.0;
                    double sb = (double)result[2] / 255.0;
                    double sa = (double)sp[3] / 255.0;
                    double dr = (double)dp[0] / 255.0;
                    double dg = (double)dp[1] / 255.0;
                    double db = (double)dp[2] / 255.0;
                    sr = (1.0 - sa) * dr + sa * sr;
                    sg = (1.0 - sa) * dg + sa * sg;
                    sb = (1.0 - sa) * db + sa * sb;
                    result[0] = (int)(sr * 255.0);
                    result[1] = (int)(sg * 255.0);
                    result[2] = (int)(sb * 255.0);
                }
                dstOutPixels[x] = oldR = Math.min(255, sp[3] + dp[3]) << 24 | result[0] << 16 | result[1] << 8 | result[2];
            }
            dstOut.setDataElements(0, y, width, 1, dstOutPixels);
        }
    }

    private static int[] getRGBA(int argb) {
        return new int[]{argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, argb >> 24 & 0xFF};
    }

    private static int[] doMultiply(int[] src, int[] dst) {
        return new int[]{src[0] * dst[0] >> 8, src[1] * dst[1] >> 8, src[2] * dst[2] >> 8};
    }

    private static int[] doScreen(int[] src, int[] dst) {
        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255) {
            return new int[]{src[0], src[1], src[2]};
        }
        return new int[]{255 - ((255 - src[0]) * (255 - dst[0]) >> 8), 255 - ((255 - src[1]) * (255 - dst[1]) >> 8), 255 - ((255 - src[2]) * (255 - dst[2]) >> 8)};
    }

    private static int[] doOverlay(int[] src, int[] dst) {
        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255) {
            return new int[]{src[0], src[1], src[2]};
        }
        int[] result = new int[3];
        for (int i = 0; i < 3; ++i) {
            double ss = (double)dst[i] / 255.0;
            double dd = (double)src[i] / 255.0;
            if (ss > 0.5) {
                ss = 2.0 * ss - 1.0;
                result[i] = (int)(255.0 * (ss + dd - ss * dd));
                continue;
            }
            ss = 2.0 * ss;
            result[i] = (int)(255.0 * (ss * dd));
        }
        return result;
    }

    private static int[] doHardLight(int[] src, int[] dst) {
        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255) {
            return new int[]{src[0], src[1], src[2]};
        }
        int[] result = new int[3];
        for (int i = 0; i < 3; ++i) {
            double ss = (double)src[i] / 255.0;
            double dd = (double)dst[i] / 255.0;
            if (ss <= 0.5) {
                ss = 2.0 * ss;
                result[i] = (int)(255.0 * (ss * dd));
                continue;
            }
            ss = 2.0 * ss - 1.0;
            result[i] = (int)(255.0 * (ss + dd - ss * dd));
        }
        return result;
    }

    private static int[] doDarken(int[] src, int[] dst) {
        return new int[]{Math.min(src[0], dst[0]), Math.min(src[1], dst[1]), Math.min(src[2], dst[2])};
    }

    private static int[] doLighten(int[] src, int[] dst) {
        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255) {
            return new int[]{src[0], src[1], src[2]};
        }
        return new int[]{Math.max(src[0], dst[0]), Math.max(src[1], dst[1]), Math.max(src[2], dst[2])};
    }

    private static int[] doColorDodge(int[] src, int[] dst) {
        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255) {
            return new int[]{src[0], src[1], src[2]};
        }
        return new int[]{src[0] == 255 ? 255 : Math.min((dst[0] << 8) / (255 - src[0]), 255), src[1] == 255 ? 255 : Math.min((dst[1] << 8) / (255 - src[1]), 255), src[2] == 255 ? 255 : Math.min((dst[2] << 8) / (255 - src[2]), 255)};
    }

    private static int[] doColorBurn(int[] src, int[] dst) {
        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255) {
            return new int[]{src[0], src[1], src[2]};
        }
        return new int[]{src[0] == 0 ? 0 : Math.max(0, 255 - (255 - dst[0] << 8) / src[0]), src[1] == 0 ? 0 : Math.max(0, 255 - (255 - dst[1] << 8) / src[1]), src[2] == 0 ? 0 : Math.max(0, 255 - (255 - dst[2] << 8) / src[2])};
    }

    private static int[] doSoftLight(int[] src, int[] dst) {
        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255) {
            return new int[]{src[0], src[1], src[2]};
        }
        int[] result = new int[3];
        for (int i = 0; i < 3; ++i) {
            double ss = (double)src[i] / 255.0;
            double dd = (double)dst[i] / 255.0;
            result[i] = ss <= 0.5 ? (int)(255.0 * (dd - (1.0 - 2.0 * ss) * dd * (1.0 - dd))) : (dd > 0.25 ? (int)(255.0 * (dd + (2.0 * ss - 1.0) * (Math.sqrt(dd) - dd))) : (int)(255.0 * (dd + (2.0 * ss - 1.0) * (((16.0 * dd - 12.0) * dd + 4.0) * dd - dd))));
        }
        return result;
    }

    private static int[] doDifference(int[] src, int[] dst) {
        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255) {
            return new int[]{src[0], src[1], src[2]};
        }
        return new int[]{Math.abs(dst[0] - src[0]), Math.abs(dst[1] - src[1]), Math.abs(dst[2] - src[2])};
    }

    private static int[] doExclusion(int[] src, int[] dst) {
        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255) {
            return new int[]{src[0], src[1], src[2]};
        }
        return new int[]{dst[0] + src[0] - (dst[0] * src[0] >> 7), dst[1] + src[1] - (dst[1] * src[1] >> 7), dst[2] + src[2] - (dst[2] * src[2] >> 7)};
    }

    private static int[] doColor(int[] src, int[] dst) {
        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255) {
            return new int[]{src[0], src[1], src[2]};
        }
        int[] result = new int[3];
        double sr = (double)src[0] / 255.0;
        double sg = (double)src[1] / 255.0;
        double sb = (double)src[2] / 255.0;
        double dr = (double)dst[0] / 255.0;
        double dg = (double)dst[1] / 255.0;
        double db = (double)dst[2] / 255.0;
        double[] rgb = BlendContext.setLum(sr, sg, sb, BlendContext.lum(dr, dg, db));
        result[0] = (int)(255.0 * rgb[0]);
        result[1] = (int)(255.0 * rgb[1]);
        result[2] = (int)(255.0 * rgb[2]);
        return result;
    }

    private static int[] doLuminosity(int[] src, int[] dst) {
        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255) {
            return new int[]{src[0], src[1], src[2]};
        }
        int[] result = new int[3];
        double sr = (double)src[0] / 255.0;
        double sg = (double)src[1] / 255.0;
        double sb = (double)src[2] / 255.0;
        double dr = (double)dst[0] / 255.0;
        double dg = (double)dst[1] / 255.0;
        double db = (double)dst[2] / 255.0;
        double[] rgb = BlendContext.setLum(dr, dg, db, BlendContext.lum(sr, sg, sb));
        result[0] = (int)(255.0 * rgb[0]);
        result[1] = (int)(255.0 * rgb[1]);
        result[2] = (int)(255.0 * rgb[2]);
        return result;
    }

    private static int[] doHue(int[] src, int[] dst) {
        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255) {
            return new int[]{src[0], src[1], src[2]};
        }
        double[] srcHSL = new double[3];
        BlendContext.rgbToHSL(src[0], src[1], src[2], srcHSL);
        double[] dstHSL = new double[3];
        BlendContext.rgbToHSL(dst[0], dst[1], dst[2], dstHSL);
        int[] result = new int[4];
        BlendContext.hslToRGB(srcHSL[0], dstHSL[1], dstHSL[2], result);
        return result;
    }

    private static int[] doSaturation(int[] src, int[] dst) {
        if (dst[0] == 255 && dst[1] == 255 && dst[2] == 255) {
            return new int[]{src[0], src[1], src[2]};
        }
        double[] srcHSL = new double[3];
        BlendContext.rgbToHSL(src[0], src[1], src[2], srcHSL);
        double[] dstHSL = new double[3];
        BlendContext.rgbToHSL(dst[0], dst[1], dst[2], dstHSL);
        int[] result = new int[4];
        BlendContext.hslToRGB(dstHSL[0], srcHSL[1], dstHSL[2], result);
        return result;
    }

    private static double lum(double r, double g, double b) {
        return 0.3 * r + 0.59 * g + 0.11 * b;
    }

    private static double[] setLum(double r, double g, double b, double l) {
        double d = l - BlendContext.lum(r, g, b);
        return BlendContext.clipColor(r += d, g += d, b += d);
    }

    private static double[] clipColor(double r, double g, double b) {
        double l = BlendContext.lum(r, g, b);
        double n = Math.min(Math.min(r, g), b);
        double x = Math.max(Math.max(r, g), b);
        if (n < 0.0) {
            r = l + (r - l) * l / (l - n);
            g = l + (g - l) * l / (l - n);
            b = l + (b - l) * l / (l - n);
        }
        if (x > 1.0) {
            r = l + (r - l) * (1.0 - l) / (x - l);
            g = l + (g - l) * (1.0 - l) / (x - l);
            b = l + (b - l) * (1.0 - l) / (x - l);
        }
        return new double[]{r, g, b};
    }

    private static void rgbToHSL(int r, int g, int b, double[] hsl) {
        double S2;
        double H;
        double rr = (double)r / 255.0;
        double gg = (double)g / 255.0;
        double bb = (double)b / 255.0;
        double var_Min = Math.min(Math.min(rr, gg), bb);
        double var_Max = Math.max(Math.max(rr, gg), bb);
        double del_Max = var_Max - var_Min;
        double L = (var_Max + var_Min) / 2.0;
        if (del_Max - 0.01 <= 0.0) {
            H = 0.0;
            S2 = 0.0;
        } else {
            S2 = L < 0.5 ? del_Max / (var_Max + var_Min) : del_Max / (2.0 - var_Max - var_Min);
            double del_R = ((var_Max - rr) / 6.0 + del_Max / 2.0) / del_Max;
            double del_G = ((var_Max - gg) / 6.0 + del_Max / 2.0) / del_Max;
            double del_B = ((var_Max - bb) / 6.0 + del_Max / 2.0) / del_Max;
            H = rr == var_Max ? del_B - del_G : (gg == var_Max ? 0.3333333432674408 + del_R - del_B : 0.6666666865348816 + del_G - del_R);
            if (H < 0.0) {
                H += 1.0;
            }
            if (H > 1.0) {
                H -= 1.0;
            }
        }
        hsl[0] = H;
        hsl[1] = S2;
        hsl[2] = L;
    }

    private static void hslToRGB(double h, double s, double l, int[] rgb) {
        int B2;
        int G2;
        int R;
        if (s - 0.01 <= 0.0) {
            R = (int)(l * 255.0);
            G2 = (int)(l * 255.0);
            B2 = (int)(l * 255.0);
        } else {
            double v2 = l < 0.5 ? l * (1.0 + s) : l + s - s * l;
            double v1 = 2.0 * l - v2;
            R = (int)(255.0 * BlendContext.hueToRGB(v1, v2, h + 0.3333333333333333));
            G2 = (int)(255.0 * BlendContext.hueToRGB(v1, v2, h));
            B2 = (int)(255.0 * BlendContext.hueToRGB(v1, v2, h - 0.3333333333333333));
        }
        rgb[0] = R;
        rgb[1] = G2;
        rgb[2] = B2;
    }

    private static double hueToRGB(double v1, double v2, double vH) {
        if (vH < 0.0) {
            vH += 1.0;
        }
        if (vH > 1.0) {
            vH -= 1.0;
        }
        if (6.0 * vH < 1.0) {
            return v1 + (v2 - v1) * 6.0 * vH;
        }
        if (2.0 * vH < 1.0) {
            return v2;
        }
        if (3.0 * vH < 2.0) {
            return v1 + (v2 - v1) * (0.6666666666666666 - vH) * 6.0;
        }
        return v1;
    }
}

