/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.BitReader;
import com.idrsolutions.pdf.color.shading.PixelFactory;
import com.idrsolutions.pdf.color.shading.ShadingUtils;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.objects.raw.PdfObject;

public class FreeFormContext
implements PaintContext {
    private final int bitsPerCoordinate;
    private final int bitsPerComponent;
    private final int bitsPerFlag;
    private final int colCompCount;
    private final float[] decodeArr;
    private final float[][] matrix;
    private final ArrayList<Point2D> triangles;
    private final ArrayList<Color> triColors;
    private final ArrayList<GeneralPath> shapes;
    private final int pageHeight;
    private final float scaling;
    private final int offX;
    private final int offY;
    private final BitReader reader;

    FreeFormContext(GenericColorSpace shadingColorSpace, float[] background, PdfObject shadingObject, float[][] matrix, int pageHeight, float scaling, int offX, int offY) {
        this.bitsPerComponent = shadingObject.getInt(-1344207655);
        this.bitsPerFlag = shadingObject.getInt(1500422077);
        this.bitsPerCoordinate = shadingObject.getInt(-335950113);
        this.decodeArr = shadingObject.getFloatArray(859785322);
        this.colCompCount = shadingColorSpace.getColorComponentCount();
        this.matrix = matrix;
        this.pageHeight = pageHeight;
        this.scaling = scaling;
        this.offX = offX;
        this.offY = offY;
        this.triangles = new ArrayList();
        this.triColors = new ArrayList();
        this.shapes = new ArrayList();
        boolean hasSmallBits = this.bitsPerFlag < 8 || this.bitsPerComponent < 8 || this.bitsPerCoordinate < 8;
        this.reader = new BitReader(shadingObject.getDecodedStream(), hasSmallBits);
        this.process();
        this.adjustPoints();
    }

    private void process() {
        while (this.reader.getPointer() < this.reader.getTotalBitLen()) {
            int flag = this.reader.getPositive(this.bitsPerFlag);
            Point2D p = this.getPointCoords();
            float[] cc = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            for (int z = 0; z < this.colCompCount; ++z) {
                cc[z] = this.reader.getFloat(this.bitsPerComponent);
            }
            Color c = new Color(cc[0], cc[1], cc[2], cc[3]);
            switch (flag) {
                case 0: {
                    break;
                }
                case 1: {
                    Point2D[] temp = new Point2D[]{this.triangles.get(this.triangles.size() - 2), this.triangles.get(this.triangles.size() - 1)};
                    this.triangles.addAll(Arrays.asList(temp));
                    Color[] tc = new Color[]{this.triColors.get(this.triColors.size() - 2), this.triColors.get(this.triColors.size() - 1)};
                    this.triColors.addAll(Arrays.asList(tc));
                    break;
                }
                case 2: {
                    Point2D[] ff = new Point2D[]{this.triangles.get(this.triangles.size() - 3), this.triangles.get(this.triangles.size() - 1)};
                    this.triangles.addAll(Arrays.asList(ff));
                    Color[] fc = new Color[]{this.triColors.get(this.triColors.size() - 3), this.triColors.get(this.triColors.size() - 1)};
                    this.triColors.addAll(Arrays.asList(fc));
                }
            }
            this.triangles.add(p);
            this.triColors.add(c);
        }
    }

    private void adjustPoints() {
        float xMin = this.decodeArr[0];
        float xMax = this.decodeArr[1];
        float yMin = this.decodeArr[2];
        float yMax = this.decodeArr[3];
        float xw = xMax - xMin;
        float yw = yMax - yMin;
        ArrayList<Point2D.Double> triPoints = new ArrayList<Point2D.Double>();
        for (Point2D p : this.triangles) {
            double xx = p.getX();
            double yy = p.getY();
            xx = (double)xw * xx + (double)xMin;
            yy = (double)yw * yy + (double)yMin;
            triPoints.add(new Point2D.Double(xx, yy));
        }
        this.triangles.clear();
        float scaleX = 1.0f / this.matrix[0][0];
        float scaleY = 1.0f / this.matrix[1][1];
        float tx = this.matrix[2][0] * scaleX;
        float ty = this.matrix[2][1] * scaleY;
        for (Point2D point2D : triPoints) {
            double x = point2D.getX();
            double y = point2D.getY();
            float b = 0.0f;
            float c = 0.0f;
            double xx = x + (double)c * y + (double)tx;
            double yy = (double)b * x + y + (double)ty;
            xx = (int)xx;
            yy = (int)yy;
            this.triangles.add(new Point2D.Double(xx, yy));
        }
        for (int t = 0; t < this.triangles.size(); t += 3) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(this.triangles.get(t).getX(), this.triangles.get(t).getY());
            generalPath.lineTo(this.triangles.get(t + 1).getX(), this.triangles.get(t + 1).getY());
            generalPath.lineTo(this.triangles.get(t + 2).getX(), this.triangles.get(t + 2).getY());
            generalPath.closePath();
            this.shapes.add(generalPath);
        }
    }

    private Point2D getPointCoords() {
        double x = 0.0;
        double y = 0.0;
        block4: for (int z = 0; z < 2; ++z) {
            switch (z) {
                case 0: {
                    x = this.reader.getFloat(this.bitsPerCoordinate);
                    continue block4;
                }
                case 1: {
                    y = this.reader.getFloat(this.bitsPerCoordinate);
                }
            }
        }
        return new Point2D.Double(x, y);
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int xStart, int yStart, int w, int h) {
        int rastSize = w * h * 4;
        int[] data = new int[rastSize];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                float[] xy = PixelFactory.convertPhysicalToPDF(false, x, y, this.offX, this.offY, 1.0f / this.scaling, xStart, yStart, 0, this.pageHeight);
                float pdfX = xy[0];
                float pdfY = xy[1];
                int sc = 0;
                for (GeneralPath sh : this.shapes) {
                    Point2D.Double pdfPoint;
                    if (sh.contains(pdfPoint = new Point2D.Double(pdfX, pdfY))) {
                        Color result;
                        Color firstColor;
                        double second;
                        double first;
                        double ci;
                        Color col;
                        float fraction;
                        double ai;
                        Point2D inter;
                        Rectangle2D rect = sh.getBounds2D();
                        Point2D.Double scanStart = new Point2D.Double(-1024.0, pdfY);
                        Point2D.Double scanEnd = new Point2D.Double(rect.getX() + rect.getWidth(), pdfY);
                        Line2D.Double scanLine = new Line2D.Double(scanStart, scanEnd);
                        Point2D a = this.triangles.get(sc + 0);
                        Color aCol = this.triColors.get(sc + 0);
                        Point2D b = this.triangles.get(sc + 1);
                        Color bCol = this.triColors.get(sc + 1);
                        Point2D c = this.triangles.get(sc + 2);
                        Color cCol = this.triColors.get(sc + 2);
                        Line2D.Double ab = new Line2D.Double(a, b);
                        Line2D.Double bc = new Line2D.Double(b, c);
                        Line2D.Double ac = new Line2D.Double(a, c);
                        ArrayList<Color> colPoints = new ArrayList<Color>();
                        ArrayList<Point2D> interPoints = new ArrayList<Point2D>();
                        if (ab.intersectsLine(scanLine)) {
                            inter = ShadingUtils.findIntersect(scanStart, scanEnd, a, b);
                            ai = a.distance(inter);
                            double bi = b.distance(inter);
                            fraction = (float)(ai / (ai + bi));
                            col = ShadingUtils.interpolate2Color(aCol, bCol, fraction);
                            colPoints.add(col);
                            interPoints.add(inter);
                        }
                        if (bc.intersectsLine(scanLine)) {
                            inter = ShadingUtils.findIntersect(scanStart, scanEnd, b, c);
                            double bi = b.distance(inter);
                            ci = c.distance(inter);
                            fraction = (float)(bi / (bi + ci));
                            col = ShadingUtils.interpolate2Color(bCol, cCol, fraction);
                            colPoints.add(col);
                            interPoints.add(inter);
                        }
                        if (ac.intersectsLine(scanLine)) {
                            inter = ShadingUtils.findIntersect(scanStart, scanEnd, a, c);
                            ai = a.distance(inter);
                            ci = c.distance(inter);
                            fraction = (float)(ai / (ai + ci));
                            col = ShadingUtils.interpolate2Color(aCol, cCol, fraction);
                            colPoints.add(col);
                            interPoints.add(inter);
                        }
                        if (interPoints.size() == 2) {
                            first = ((Point2D)interPoints.get(0)).distance(pdfPoint);
                            second = ((Point2D)interPoints.get(1)).distance(pdfPoint);
                            firstColor = (Color)colPoints.get(0);
                            Color secondColor = (Color)colPoints.get(1);
                            float fraction2 = (float)(first / (first + second));
                            result = ShadingUtils.interpolate2Color(firstColor, secondColor, fraction2);
                        } else if (a.getY() == ((Point2D)pdfPoint).getY()) {
                            first = ((Point2D)interPoints.get(1)).distance(pdfPoint);
                            second = a.distance(pdfPoint);
                            firstColor = (Color)colPoints.get(1);
                            fraction = (float)(first / (first + second));
                            result = ShadingUtils.interpolate2Color(firstColor, aCol, fraction);
                        } else if (b.getY() == ((Point2D)pdfPoint).getY()) {
                            first = ((Point2D)interPoints.get(2)).distance(pdfPoint);
                            second = b.distance(pdfPoint);
                            firstColor = (Color)colPoints.get(2);
                            fraction = (float)(first / (first + second));
                            result = ShadingUtils.interpolate2Color(firstColor, bCol, fraction);
                        } else {
                            first = ((Point2D)interPoints.get(0)).distance(pdfPoint);
                            second = c.distance(pdfPoint);
                            firstColor = (Color)colPoints.get(0);
                            fraction = (float)(first / (first + second));
                            result = ShadingUtils.interpolate2Color(firstColor, cCol, fraction);
                        }
                        int base = (y * w + x) * 4;
                        data[base] = result.getRed();
                        data[base + 1] = result.getGreen();
                        data[base + 2] = result.getBlue();
                        data[base + 3] = result.getAlpha();
                    }
                    sc += 3;
                }
            }
        }
        WritableRaster raster = new BufferedImage(w, h, 2).getRaster();
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }
}

