/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.ShadingUtils;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class Shape67 {
    private Rectangle boundingBox;
    private final GeneralPath shape;
    private final Color[] colorsArr;
    private final Point2D[] pointsArr;
    private int nSteps = 10;
    private final List<TinyPatch> patches = new ArrayList<TinyPatch>();
    private TinyPatch lastFound;

    public Shape67(Point2D[] sp, Color[] colors) {
        this.pointsArr = sp;
        this.colorsArr = colors;
        this.shape = new GeneralPath();
        this.shape.moveTo(sp[0].getX(), sp[0].getY());
        this.shape.curveTo(sp[1].getX(), sp[1].getY(), sp[2].getX(), sp[2].getY(), sp[3].getX(), sp[3].getY());
        this.shape.curveTo(sp[4].getX(), sp[4].getY(), sp[5].getX(), sp[5].getY(), sp[6].getX(), sp[6].getY());
        this.shape.curveTo(sp[7].getX(), sp[7].getY(), sp[8].getX(), sp[8].getY(), sp[9].getX(), sp[9].getY());
        this.shape.curveTo(sp[10].getX(), sp[10].getY(), sp[11].getX(), sp[11].getY(), sp[0].getX(), sp[0].getY());
        this.shape.closePath();
        this.boundingBox = this.shape.getBounds();
    }

    public GeneralPath getShape() {
        return this.shape;
    }

    public void applyTransformation(AffineTransform af) {
        this.shape.transform(af);
        double[] coords = new double[6];
        PathIterator iter = this.shape.getPathIterator(null);
        int count = 0;
        while (!iter.isDone()) {
            iter.currentSegment(coords);
            switch (count) {
                case 0: {
                    this.pointsArr[0] = new Point2D.Double(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    this.pointsArr[1] = new Point2D.Double(coords[0], coords[1]);
                    this.pointsArr[2] = new Point2D.Double(coords[2], coords[3]);
                    this.pointsArr[3] = new Point2D.Double(coords[4], coords[5]);
                    break;
                }
                case 2: {
                    this.pointsArr[4] = new Point2D.Double(coords[0], coords[1]);
                    this.pointsArr[5] = new Point2D.Double(coords[2], coords[3]);
                    this.pointsArr[6] = new Point2D.Double(coords[4], coords[5]);
                    break;
                }
                case 3: {
                    this.pointsArr[7] = new Point2D.Double(coords[0], coords[1]);
                    this.pointsArr[8] = new Point2D.Double(coords[2], coords[3]);
                    this.pointsArr[9] = new Point2D.Double(coords[4], coords[5]);
                    break;
                }
                case 4: {
                    this.pointsArr[10] = new Point2D.Double(coords[0], coords[1]);
                    this.pointsArr[11] = new Point2D.Double(coords[2], coords[3]);
                }
            }
            ++count;
            iter.next();
        }
        this.determineSteps();
        this.boundingBox = this.shape.getBounds();
    }

    public Point2D[] getPointsArray() {
        return this.pointsArr;
    }

    public Rectangle getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(Rectangle boundingBox) {
        this.boundingBox = boundingBox;
    }

    private static Point2D[] curvePoints(Point2D p1, Point2D p2, Point2D p3, Point2D p4, int nSteps) {
        Point2D[] arr = new Point2D[nSteps + 1];
        arr[0] = p1;
        for (int i = 1; i <= nSteps; ++i) {
            Point2D p;
            float t = 1.0f / (float)nSteps * (float)i;
            arr[i] = p = ShadingUtils.findDistancedPoint(t, p1, p2, p3, p4);
        }
        return arr;
    }

    private static Point2D[] linePoints(Point2D p1, Point2D p2, int nSteps) {
        double len = p1.distance(p2);
        Point2D[] arr = new Point2D[nSteps + 1];
        double d = len / (double)nSteps;
        for (int i = 0; i <= nSteps; ++i) {
            double ratio = d * (double)i / len;
            double x = ratio * p2.getX() + (1.0 - ratio) * p1.getX();
            double y = ratio * p2.getY() + (1.0 - ratio) * p1.getY();
            arr[i] = new Point2D.Double(x, y);
        }
        return arr;
    }

    private Point2D[] getC1Points() {
        return Shape67.curvePoints(this.pointsArr[0], this.pointsArr[11], this.pointsArr[10], this.pointsArr[9], this.nSteps);
    }

    private Point2D[] getC2Points() {
        return Shape67.curvePoints(this.pointsArr[3], this.pointsArr[4], this.pointsArr[5], this.pointsArr[6], this.nSteps);
    }

    private Point2D[] getD1Points() {
        return Shape67.curvePoints(this.pointsArr[0], this.pointsArr[1], this.pointsArr[2], this.pointsArr[3], this.nSteps);
    }

    private Point2D[] getD2Points() {
        return Shape67.curvePoints(this.pointsArr[9], this.pointsArr[8], this.pointsArr[7], this.pointsArr[6], this.nSteps);
    }

    public void generateBilinearMapping() {
        Point2D[] C1 = this.getC1Points();
        Point2D[] C2 = this.getC2Points();
        Point2D[] D1 = this.getD1Points();
        Point2D[] D2 = this.getD2Points();
        int szu = C1.length;
        int szv = D1.length;
        Point2D[][] xy = new Point2D[szv][szu];
        Color[][] cc = new Color[szv][szu];
        double stepV = 1.0 / (double)(szv - 1);
        double stepU = 1.0 / (double)(szu - 1);
        double v = -stepV;
        int[][] pointColors = new int[4][4];
        for (int i = 0; i < 4; ++i) {
            pointColors[i] = new int[]{this.colorsArr[i].getRed(), this.colorsArr[i].getGreen(), this.colorsArr[i].getBlue(), this.colorsArr[i].getAlpha()};
        }
        for (int i = 0; i < szv; ++i) {
            double vMinus = 1.0 - (v += stepV);
            double u = -stepU;
            for (int j = 0; j < szu; ++j) {
                double uMinus = 1.0 - (u += stepU);
                double scx = vMinus * C1[j].getX() + v * C2[j].getX();
                double scy = vMinus * C1[j].getY() + v * C2[j].getY();
                double sdx = uMinus * D1[i].getX() + u * D2[i].getX();
                double sdy = uMinus * D1[i].getY() + u * D2[i].getY();
                double sbx = vMinus * (uMinus * C1[0].getX() + u * C1[C1.length - 1].getX()) + v * (uMinus * C2[0].getX() + u * C2[C2.length - 1].getX());
                double sby = vMinus * ((1.0 - u) * C1[0].getY() + u * C1[C1.length - 1].getY()) + v * (uMinus * C2[0].getY() + u * C2[C2.length - 1].getY());
                double sx = scx + sdx - sbx;
                double sy = scy + sdy - sby;
                xy[i][j] = new Point2D.Double(sx, sy);
                int[] temp = new int[4];
                for (int ci = 0; ci < 4; ++ci) {
                    temp[ci] = (int)(vMinus * (uMinus * (double)pointColors[0][ci] + u * (double)pointColors[3][ci]) + v * (uMinus * (double)pointColors[1][ci] + u * (double)pointColors[2][ci]));
                }
                cc[i][j] = new Color(temp[0], temp[1], temp[2], temp[3]);
            }
        }
        int d = xy.length - 1;
        for (int i = 0; i < d; ++i) {
            for (int j = 0; j < d; ++j) {
                Point2D[] patchPoints = new Point2D[]{xy[i][j], xy[i][j + 1], xy[i + 1][j + 1], xy[i + 1][j]};
                Color[] patchColors = new Color[]{cc[i][j], cc[i][j + 1], cc[i + 1][j + 1], cc[i + 1][j]};
                this.patches.add(new TinyPatch(patchPoints, patchColors));
            }
        }
    }

    public Color findPointColor(Point p, boolean isRecursive) {
        if (this.patches.isEmpty()) {
            this.generateBilinearMapping();
        }
        Color pColor = null;
        if (this.lastFound != null && this.lastFound.getPath().contains(p)) {
            Color[] colors = this.lastFound.getColors();
            Point2D[] points = this.lastFound.getPoints();
            return this.recurseTrapezoidal(p, points, colors, isRecursive, 0);
        }
        for (TinyPatch patch : this.patches) {
            if (patch.getPath().contains(p)) {
                this.lastFound = patch;
                Color[] colors = patch.getColors();
                Point2D[] points = patch.getPoints();
                return this.recurseTrapezoidal(p, points, colors, isRecursive, 0);
            }
            this.lastFound = null;
        }
        return pColor;
    }

    public Color recurseTrapezoidal(Point2D p, Point2D[] points, Color[] colors, boolean isRecursive, int depth) {
        if (depth > 2 || !isRecursive || points[0].distance(points[1]) < 4.0) {
            return colors[0];
        }
        Point2D[] C1 = Shape67.linePoints(points[0], points[3], 2);
        Point2D[] C2 = Shape67.linePoints(points[1], points[2], 2);
        Point2D[] D1 = Shape67.linePoints(points[0], points[1], 2);
        Point2D[] D2 = Shape67.linePoints(points[3], points[2], 2);
        int szu = C1.length;
        int szv = D1.length;
        Point2D[][] xy = new Point2D[szv][szu];
        Color[][] cc = new Color[szv][szu];
        double stepV = 1.0 / (double)(szv - 1);
        double stepU = 1.0 / (double)(szu - 1);
        double v = -stepV;
        int[][] pointColors = new int[4][4];
        for (int i = 0; i < 4; ++i) {
            pointColors[i] = new int[]{colors[i].getRed(), colors[i].getGreen(), colors[i].getBlue(), colors[i].getAlpha()};
        }
        for (int i = 0; i < szv; ++i) {
            double vMinus = 1.0 - (v += stepV);
            double u = -stepU;
            for (int j = 0; j < szu; ++j) {
                double uMinus = 1.0 - (u += stepU);
                double scx = vMinus * C1[j].getX() + v * C2[j].getX();
                double scy = vMinus * C1[j].getY() + v * C2[j].getY();
                double sdx = uMinus * D1[i].getX() + u * D2[i].getX();
                double sdy = uMinus * D1[i].getY() + u * D2[i].getY();
                double sbx = vMinus * (uMinus * C1[0].getX() + u * C1[C1.length - 1].getX()) + v * (uMinus * C2[0].getX() + u * C2[C2.length - 1].getX());
                double sby = vMinus * ((1.0 - u) * C1[0].getY() + u * C1[C1.length - 1].getY()) + v * (uMinus * C2[0].getY() + u * C2[C2.length - 1].getY());
                double sx = scx + sdx - sbx;
                double sy = scy + sdy - sby;
                xy[i][j] = new Point2D.Double(sx, sy);
                int[] temp = new int[4];
                for (int ci = 0; ci < 4; ++ci) {
                    temp[ci] = (int)(vMinus * (uMinus * (double)pointColors[0][ci] + u * (double)pointColors[3][ci]) + v * (uMinus * (double)pointColors[1][ci] + u * (double)pointColors[2][ci]));
                }
                cc[i][j] = new Color(temp[0], temp[1], temp[2], temp[3]);
            }
        }
        int d = xy.length - 1;
        for (int i = 0; i < d; ++i) {
            for (int j = 0; j < d; ++j) {
                Point2D[] patchPoints = new Point2D[]{xy[i][j], xy[i][j + 1], xy[i + 1][j + 1], xy[i + 1][j]};
                Color[] patchColors = new Color[]{cc[i][j], cc[i][j + 1], cc[i + 1][j + 1], cc[i + 1][j]};
                TinyPatch tiny = new TinyPatch(patchPoints, patchColors);
                if (!tiny.getPath().contains(p)) continue;
                return this.recurseTrapezoidal(p, patchPoints, patchColors, isRecursive, ++depth);
            }
        }
        return colors[0];
    }

    private void determineSteps() {
        int crossLen = (int)this.pointsArr[0].distance(this.pointsArr[6]);
        this.nSteps = crossLen < 4 ? 4 : Math.min(10, crossLen);
    }

    protected Shape67 cloneShape() {
        return new Shape67((Point2D[])this.pointsArr.clone(), (Color[])this.colorsArr.clone());
    }

    public class TinyPatch {
        private final GeneralPath path;
        private final Color[] colors;
        private final Point2D[] points;

        public TinyPatch(Point2D[] points, Color[] colors) {
            this.colors = colors;
            this.points = points;
            this.path = new GeneralPath();
            this.path.moveTo(points[0].getX(), points[0].getY());
            this.path.lineTo(points[1].getX(), points[1].getY());
            this.path.lineTo(points[2].getX(), points[2].getY());
            this.path.lineTo(points[3].getX(), points[3].getY());
            this.path.closePath();
        }

        public GeneralPath getPath() {
            return this.path;
        }

        public Color[] getColors() {
            return this.colors;
        }

        public Point2D[] getPoints() {
            return this.points;
        }
    }
}

