/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class DeviceCMYKColorSpace
extends GenericColorSpace {
    private static final long serialVersionUID = 4054062852632000027L;
    private float lastC = -1.0f;
    private float lastM = -1.0f;
    private float lastY = -1.0f;
    private float lastK = -1.0f;
    public static ColorSpace CMYK;

    @Override
    public void clearCache() {
        this.lastC = -1.0f;
    }

    private void initColorspace() {
        InputStream stream = null;
        try {
            String profile = System.getProperty("org.jpedal.CMYKprofile");
            if (profile == null) {
                stream = this.getClass().getResourceAsStream("/org/jpedal/res/cmm/cmyk.icm");
            } else {
                try {
                    stream = new FileInputStream(profile);
                }
                catch (FileNotFoundException ee) {
                    try {
                        throw new PdfException("PdfException attempting to use user profile " + profile + " Message=" + ee);
                    }
                    catch (PdfException ex) {
                        Logger.getLogger(DeviceCMYKColorSpace.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            ICC_Profile p = ICC_Profile.getInstance(stream);
            CMYK = new ICC_ColorSpace(p);
        }
        catch (IOException e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + e);
            }
            throw new RuntimeException("Problem setting CMYK Colorspace with message " + e + " Possible cause file cmyk.icm corrupted");
        }
        finally {
            block18: {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        if (!LogWriter.isOutput()) break block18;
                        LogWriter.writeLog("Exception " + e);
                    }
                }
            }
        }
    }

    public DeviceCMYKColorSpace() {
        this.componentCount = 4;
        if (CMYK == null) {
            this.initColorspace();
        }
        this.cs = CMYK;
        this.setType(1498837125);
    }

    @Override
    public final void setColor(String[] number_values, int items) {
        float[] colValues = new float[items];
        for (int ii = 0; ii < items; ++ii) {
            colValues[ii] = Float.parseFloat(number_values[ii]);
        }
        this.setColor(colValues, items);
    }

    @Override
    public final void setColor(float[] operand, int length) {
        this.c = 1.0f;
        this.y = 1.0f;
        this.m = 1.0f;
        this.k = 1.0f;
        if (length > 3) {
            this.c = operand[0];
            this.m = operand[1];
            this.y = operand[2];
            this.k = operand[3];
        } else {
            if (length > 0) {
                this.c = operand[0];
            }
            if (length > 1) {
                this.m = operand[1];
            }
            if (length > 2) {
                this.y = operand[2];
            }
            if (length > 3) {
                this.k = operand[3];
            }
        }
        if (this.lastC != this.c || this.lastM != this.m || this.lastY != this.y || this.lastK != this.k) {
            this.rawValues = new float[4];
            this.rawValues[0] = this.c;
            this.rawValues[1] = this.m;
            this.rawValues[2] = this.y;
            this.rawValues[3] = this.k;
            if (this.c == 0.0f && this.y == 0.0f && this.m == 0.0f && this.k == 0.0f) {
                this.currentColor = new PdfColor(1.0f, 1.0f, 1.0f);
            } else if (this.c == 1.0f && this.y == 1.0f && this.m == 1.0f && this.k == 1.0f) {
                this.currentColor = new PdfColor(0.0f, 0.0f, 0.0f);
            } else {
                if ((double)this.c > 0.99) {
                    this.c = 1.0f;
                } else if ((double)this.c < 0.01) {
                    this.c = 0.0f;
                }
                if ((double)this.m > 0.99) {
                    this.m = 1.0f;
                } else if ((double)this.m < 0.01) {
                    this.m = 0.0f;
                }
                if ((double)this.y > 0.99) {
                    this.y = 1.0f;
                } else if ((double)this.y < 0.01) {
                    this.y = 0.0f;
                }
                if ((double)this.k > 0.99) {
                    this.k = 1.0f;
                } else if ((double)this.k < 0.01) {
                    this.k = 0.0f;
                }
                float[] rgb = null;
                if (rgb == null) {
                    float[] cmykValues = new float[]{this.c, this.m, this.y, this.k};
                    rgb = CMYK.toRGB(cmykValues);
                    for (int jj = 0; jj < 3; ++jj) {
                        if ((double)rgb[jj] > 0.99) {
                            rgb[jj] = 1.0f;
                            continue;
                        }
                        if (!((double)rgb[jj] < 0.01)) continue;
                        rgb[jj] = 0.0f;
                    }
                }
                this.currentColor = new PdfColor((float)rgb[0], (float)rgb[1], (float)rgb[2]);
            }
            this.lastC = this.c;
            this.lastM = this.m;
            this.lastY = this.y;
            this.lastK = this.k;
        }
    }

    @Override
    public final BufferedImage JPEGToRGBImage(byte[] data, int w, int h, float[] decodeArray, int pX, int pY, boolean arrayInverted, PdfObject XObject2) {
        return this.nonRGBJPEGToRGBImage(data, w, h, decodeArray, pX, pY);
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] data, int w, int h, boolean arrayInverted) {
        int pixelCount = w * h * 4;
        int dataSize = data.length;
        if (pixelCount > dataSize) {
            pixelCount = dataSize - 3;
        }
        ColorSpace CMYK = DeviceCMYKColorSpace.getColorSpaceInstance();
        int lastC = -1;
        int lastM = -1;
        int lastY = -1;
        int lastK = -1;
        byte[] rgbData = new byte[w * h * 3];
        int j = 0;
        float[] RGB = new float[]{0.0f, 0.0f, 0.0f};
        for (int i = 0; i < pixelCount; i += 4) {
            int C = data[i] & 0xFF;
            int M = data[i + 1] & 0xFF;
            int Y = data[i + 2] & 0xFF;
            int K2 = data[i + 3] & 0xFF;
            if (C != lastC || M != lastM || Y != lastY || K2 != lastK) {
                if (C == 0 && M == 0 && Y == 0 && K2 == 0) {
                    RGB = new float[]{1.0f, 1.0f, 1.0f};
                } else if (C == 255 && M == 255 && Y == 255 && K2 == 255) {
                    RGB = new float[]{0.0f, 0.0f, 0.0f};
                } else {
                    RGB = CMYK.toRGB(new float[]{(float)C / 255.0f, (float)M / 255.0f, (float)Y / 255.0f, (float)K2 / 255.0f});
                    lastC = C;
                    lastM = M;
                    lastY = Y;
                    lastK = K2;
                }
            }
            rgbData[j] = (byte)(RGB[0] * 255.0f);
            rgbData[j + 1] = (byte)(RGB[1] * 255.0f);
            rgbData[j + 2] = (byte)(RGB[2] * 255.0f);
            j += 3;
        }
        return rgbData;
    }

    @Override
    public BufferedImage JPEG2000ToRGBImage(byte[] data, int w, int h, float[] decodeArray, int pX, int pY, int d) throws PdfException {
        BufferedImage image = DefaultImageHelper.JPEG2000ToRGBImage(data, w, h, decodeArray, pX, pY);
        if (image != null) {
            return image;
        }
        return this.JPEG2000ToImage(data, pX, pY, decodeArray);
    }

    @Override
    public final byte[] convertIndexToRGB(byte[] index) {
        this.isConverted = true;
        return this.convert4Index(index);
    }

    public static ColorSpace getColorSpaceInstance() {
        ColorSpace CMYK = new DeviceCMYKColorSpace().getColorSpace();
        String CMYKprofile = System.getProperty("org.jpedal.CMYKprofile");
        if (CMYKprofile != null) {
            try {
                CMYK = new ICC_ColorSpace(ICC_Profile.getInstance(new FileInputStream(CMYKprofile)));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create CMYK colorspace with  " + CMYKprofile + "\nPlease check Path and file valid or use built-in " + e);
            }
        }
        return CMYK;
    }
}

