/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.JPEGDecoder;
import org.jpedal.color.PdfColor;
import org.jpedal.objects.raw.MaskObject;
import org.jpedal.objects.raw.PdfObject;

public class DeviceGrayColorSpace
extends GenericColorSpace {
    private static final long serialVersionUID = -8160089076145994695L;

    public DeviceGrayColorSpace() {
        this.setType(1568372915);
        this.cs = ColorSpace.getInstance(1003);
    }

    @Override
    public final void setColor(String[] number_values, int opCount) {
        float[] colValues = new float[]{Float.parseFloat(number_values[0])};
        this.setColor(colValues, 1);
    }

    @Override
    public final void setColor(float[] operand, int length) {
        float tmp = operand[0];
        int val = tmp <= 1.0f ? (int)(255.0f * tmp) : (int)tmp;
        if (val < 0) {
            val = 0;
        }
        this.currentColor = new PdfColor(val, val, val);
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] data, int w, int h, boolean arrayInverted) {
        int size = data.length;
        byte[] newData = new byte[size * 3];
        int ptr = 0;
        for (int a = 0; a < size; ++a) {
            for (int comp = 0; comp < 3; ++comp) {
                newData[ptr] = data[a];
                ++ptr;
            }
        }
        return newData;
    }

    @Override
    public byte[] convertIndexToRGB(byte[] index) {
        this.isConverted = true;
        int count = index.length;
        byte[] newIndex = new byte[count * 3];
        for (int i = 0; i < count; ++i) {
            byte value = index[i];
            for (int j = 0; j < 3; ++j) {
                newIndex[i * 3 + j] = value;
            }
        }
        return newIndex;
    }

    @Override
    public BufferedImage JPEGToRGBImage(byte[] data, int w, int h, float[] decodeArray, int pX, int pY, boolean arrayInverted, PdfObject XObject2) {
        if (XObject2 instanceof MaskObject) {
            return super.JPEGToRGBImage(data, w, h, decodeArray, pX, pY, arrayInverted, XObject2);
        }
        return JPEGDecoder.grayJPEGToRGBImage(data, pX, pY, arrayInverted);
    }
}

