/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class ICCColorSpace
extends GenericColorSpace {
    private final int[] a1;
    private final int[] b1;
    private final int[] c1;
    private final Map cache = new HashMap();
    private float[] prevFloat;

    @Override
    public void reset() {
        super.reset();
        this.isConverted = false;
    }

    public ICCColorSpace(PdfObject colorSpace) {
        this.a1 = new int[256];
        this.b1 = new int[256];
        this.c1 = new int[256];
        for (int i = 0; i < 256; ++i) {
            this.a1[i] = -1;
            this.b1[i] = -1;
            this.c1[i] = -1;
        }
        this.setType(1247168582);
        this.cs = ColorSpace.getInstance(1000);
        byte[] icc_data = colorSpace.getDecodedStream();
        if (icc_data == null) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Error in ICC data");
            }
        } else {
            try {
                this.cs = new ICC_ColorSpace(ICC_Profile.getInstance(icc_data));
                this.type = this.cs.getType();
            }
            catch (Exception e) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[PDF] Problem " + e.getMessage() + " with ICC data ");
                }
                this.failed = true;
            }
        }
        this.componentCount = this.cs.getNumComponents();
    }

    @Override
    public final void setColor(String[] number_values, int items) {
        float[] colValues = new float[items];
        for (int ii = 0; ii < items; ++ii) {
            colValues[ii] = Float.parseFloat(number_values[ii]);
        }
        this.setColor(colValues, items);
    }

    private static boolean isSame(float[] arr0, float[] arr1) {
        if (arr0 == null || arr1 == null) {
            return false;
        }
        for (int i = 0; i < arr0.length; ++i) {
            if (arr0[i] == arr1[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void setColor(float[] operand, int size) {
        if (ICCColorSpace.isSame(this.prevFloat, operand)) {
            return;
        }
        float[] result = this.cs.toRGB(operand);
        this.currentColor = new PdfColor(result[0], result[1], result[2]);
        this.prevFloat = (float[])operand.clone();
    }

    @Override
    public byte[] convertIndexToRGB(byte[] data) {
        this.isConverted = true;
        if (this.componentCount == 4) {
            return this.convert4Index(data);
        }
        return data;
    }

    @Override
    public BufferedImage JPEGToRGBImage(byte[] data, int w, int h, float[] decodeArray, int pX, int pY, boolean arrayInverted, PdfObject XObject2) {
        if (data.length > 9 && data[6] == 74 && data[7] == 70 && data[8] == 73 && data[9] == 70) {
            return this.nonRGBJPEGToRGBImage(data, w, h, null, pX, pY);
        }
        return this.algorithmicICCToRGB(data, w, h, pX, pY, decodeArray);
    }

    @Override
    public BufferedImage JPEG2000ToRGBImage(byte[] data, int w, int h, float[] decodeArray, int pX, int pY, int d) throws PdfException {
        byte[] index = this.getIndexedMap();
        if (this.cs.getNumComponents() == 3 || index != null) {
            return super.JPEG2000ToRGBImage(data, w, h, decodeArray, pX, pY, d);
        }
        return this.JPEG2000ToImage(data, pX, pY, decodeArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage algorithmicICCToRGB(byte[] data, int w, int h, int pX, int pY, float[] decodeArray) {
        BufferedImage image = null;
        ImageReader iir = null;
        ImageInputStream iin = null;
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            ImageReader o;
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG");
            while (iterator.hasNext() && !(iir = (o = iterator.next())).canReadRaster()) {
            }
            ImageIO.setUseCache(false);
            iin = ImageIO.createImageInputStream(in);
            iir.setInput(iin, true);
            Raster ras = iir.readRaster(0, null);
            if (iir.getRawImageType(0) == null || this.alternative == -1) {
                BufferedImage bufferedImage = this.nonRGBJPEGToRGBImage(data, w, h, decodeArray, pX, pY);
                return bufferedImage;
            }
            ras = ICCColorSpace.cleanupRaster(ras, pX, pY, this.componentCount);
            w = ras.getWidth();
            h = ras.getHeight();
            byte[] new_data = new byte[w * h * 3];
            data = ((DataBufferByte)ras.getDataBuffer()).getData();
            int pixelCount = w * h * 3;
            float lastR = 0.0f;
            float lastG = 0.0f;
            float lastB = 0.0f;
            int pixelReached = 0;
            float lastIn1 = -1.0f;
            float lastIn2 = -1.0f;
            float lastIn3 = -1.0f;
            for (int i = 0; i < pixelCount; i += 3) {
                float in1 = (float)(data[i] & 0xFF) / 255.0f;
                float in2 = (float)(data[1 + i] & 0xFF) / 255.0f;
                float in3 = (float)(data[2 + i] & 0xFF) / 255.0f;
                if (lastIn1 != in1 || lastIn2 != in2 || lastIn3 != in3) {
                    float[] inputValues = new float[]{in1, in2, in3};
                    float[] outputValues = this.cs.toRGB(inputValues);
                    lastR = outputValues[0] * 255.0f;
                    lastG = outputValues[1] * 255.0f;
                    lastB = outputValues[2] * 255.0f;
                    lastIn1 = in1;
                    lastIn2 = in2;
                    lastIn3 = in3;
                }
                new_data[pixelReached++] = (byte)lastR;
                new_data[pixelReached++] = (byte)lastG;
                new_data[pixelReached++] = (byte)lastB;
            }
            int[] bands = new int[]{0, 1, 2};
            DataBufferByte db = new DataBufferByte(new_data, new_data.length);
            image = new BufferedImage(w, h, 1);
            WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w * 3, 3, bands, null);
            image.setData(raster);
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Problem with color conversion " + e);
            }
        }
        finally {
            block20: {
                try {
                    in.close();
                    iir.dispose();
                    iin.close();
                }
                catch (Exception ee) {
                    if (!LogWriter.isOutput()) break block20;
                    LogWriter.writeLog("Problem closing  " + ee);
                }
            }
        }
        return image;
    }
}

