/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javafx.scene.layout.Pane;
import org.jpedal.display.Display;
import org.jpedal.display.DisplayOffsets;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.display.MultiDisplayOptions;
import org.jpedal.display.PageOffsets;
import org.jpedal.exception.PdfException;
import org.jpedal.external.RenderChangeListener;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.text.TextLines;
import org.jpedal.utils.ScalingFactory;

public class GUIDisplay
implements Display {
    protected int lastFormPage = -1;
    protected int lastStart = -1;
    protected int lastEnd = -1;
    protected int pageUsedForTransform;
    protected int lastIndent = -1;
    protected double indent;
    public RenderChangeListener customRenderChangeListener;
    public int rx;
    public int ry;
    public int rw;
    public int rh;
    protected DisplayOffsets displayOffsets;
    public DecoderOptions options;
    public static boolean allowChangeCursor = true;
    public final MultiDisplayOptions multiDisplayOptions = new MultiDisplayOptions();
    public static boolean default_turnoverOn = true;
    public static boolean default_separateCover = true;
    public DynamicVectorRenderer currentDisplay;
    public boolean isInitialised;
    public boolean overRideAcceleration;
    public boolean useAcceleration = true;
    public boolean ignoreScalingForAcceleration;
    public boolean accelerationAlwaysRedraw;
    public PageOffsets currentOffset;
    private int[] highlightedImage;
    protected GUIThumbnailPanel thumbnails;
    public int[] pageOffsetH;
    public int[] pageOffsetW;
    public boolean[] isRotated;
    public int topW;
    public int topH;
    public double cropX;
    public double cropY;
    public double cropW;
    public double cropH;
    public int crx;
    public int cry;
    public int crw;
    public int crh;
    public int displayRotation;
    public int displayView = 1;
    public int lastDisplayRotation;
    public int insetW;
    public int insetH;
    public float scaling;
    public float lastScaling;
    public int pageNumber;
    public float oldScaling = -1.0f;
    public float oldRotation = -1.0f;
    public PdfPageData pageData;
    @Deprecated
    public static int CURRENT_BORDER_STYLE = 1;
    protected double[] displayScalingDbl;

    @Override
    public int getYCordForPage(int page, float scaling) {
        if (scaling == -2.0f || scaling != -1.0f && scaling != this.oldScaling) {
            this.oldScaling = scaling;
            this.setPageOffsets(page);
        }
        return this.getYCordForPage(page);
    }

    @Override
    public boolean getBoolean(Display.BoolValue option) {
        switch (option) {
            case SEPARATE_COVER: {
                return this.multiDisplayOptions.isSeparateCover();
            }
            case TURNOVER_ON: {
                return this.multiDisplayOptions.isTurnoverOn();
            }
        }
        return false;
    }

    @Override
    public void setBoolean(Display.BoolValue option, boolean value) {
        switch (option) {
            case SEPARATE_COVER: {
                this.multiDisplayOptions.setSeparateCover(value);
                return;
            }
            case TURNOVER_ON: {
                this.multiDisplayOptions.setTurnoverOn(value);
                return;
            }
        }
    }

    @Override
    public void setObjectValue(int type, Object newHandler) {
        switch (type) {
            case 21: {
                this.customRenderChangeListener = (RenderChangeListener)newHandler;
                break;
            }
            default: {
                throw new RuntimeException("setObjectValue does not take value " + type);
            }
        }
    }

    @Override
    public void setCursorBoxOnScreen(Rectangle cursorBoxOnScreen, boolean isSamePage) {
    }

    @Override
    public int[] getPageSize(int displayView) {
        int[] pageSize = new int[2];
        int biggestFacingHeight = 0;
        int facingWidth = 0;
        if (displayView == 4 && this.multiDisplayOptions.getPageW() != null) {
            int p2;
            int p1;
            if (this.multiDisplayOptions.isSeparateCover()) {
                p1 = this.pageNumber;
                if ((p1 & 1) == 1) {
                    --p1;
                }
                p2 = p1 + 1;
            } else {
                p1 = this.pageNumber;
                if ((p1 & 1) == 0) {
                    --p1;
                }
                p2 = p1 + 1;
            }
            if (p1 == 0) {
                biggestFacingHeight = this.multiDisplayOptions.getPageH(p2);
                facingWidth = this.multiDisplayOptions.getPageW(p2) * 2;
            } else {
                biggestFacingHeight = this.multiDisplayOptions.getPageH(p1);
                if (p2 < this.multiDisplayOptions.getPageH().length) {
                    if (biggestFacingHeight < this.multiDisplayOptions.getPageH(p2)) {
                        biggestFacingHeight = this.multiDisplayOptions.getPageH(p2);
                    }
                    facingWidth = this.multiDisplayOptions.getPageW(p1) + this.multiDisplayOptions.getPageW(p2);
                } else {
                    facingWidth = this.multiDisplayOptions.getPageW(p1) * 2;
                }
            }
        }
        int gaps = this.currentOffset.getGaps();
        int doubleGaps = this.currentOffset.getDoubleGaps();
        switch (displayView) {
            case 4: {
                pageSize[0] = facingWidth + this.insetW + this.insetW;
                pageSize[1] = biggestFacingHeight + this.insetH + this.insetH;
                break;
            }
            case 2: {
                if (this.displayRotation == 90 | this.displayRotation == 270) {
                    pageSize[0] = (int)((float)this.currentOffset.getBiggestHeight() * this.scaling) + this.insetW + this.insetW;
                    pageSize[1] = (int)((float)this.currentOffset.getTotalSingleWidth() * this.scaling) + gaps + this.insetH + this.insetH;
                    break;
                }
                pageSize[0] = (int)((float)this.currentOffset.getBiggestWidth() * this.scaling) + this.insetW + this.insetW;
                pageSize[1] = (int)((float)this.currentOffset.getTotalSingleHeight() * this.scaling) + gaps + this.insetH + this.insetH;
                break;
            }
            case 3: {
                int pageCount = this.pageData.getPageCount();
                if (this.displayRotation == 90 | this.displayRotation == 270) {
                    if (pageCount == 2) {
                        pageSize[0] = (int)((float)this.currentOffset.getDoublePageHeight() * this.scaling) + this.insetW + this.insetW;
                        pageSize[1] = (int)((float)this.currentOffset.getBiggestWidth() * this.scaling) + gaps + this.insetH + this.insetH;
                        break;
                    }
                    pageSize[0] = (int)((float)this.currentOffset.getDoublePageHeight() * this.scaling) + this.insetW + this.insetW;
                    pageSize[1] = (int)((float)this.currentOffset.getTotalDoubleWidth() * this.scaling) + doubleGaps + this.insetH + this.insetH;
                    break;
                }
                if (pageCount == 2) {
                    pageSize[0] = (int)((float)this.currentOffset.getDoublePageWidth() * this.scaling) + this.insetW + this.insetW;
                    pageSize[1] = (int)((float)this.currentOffset.getBiggestHeight() * this.scaling) + gaps + this.insetH + this.insetH;
                    break;
                }
                pageSize[0] = (int)((float)this.currentOffset.getDoublePageWidth() * this.scaling) + this.insetW + this.insetW;
                pageSize[1] = (int)((float)this.currentOffset.getTotalDoubleHeight() * this.scaling) + doubleGaps + this.insetH + this.insetH;
            }
        }
        return pageSize;
    }

    @Override
    public void setup(boolean useAcceleration, PageOffsets currentOffset) {
        this.useAcceleration = useAcceleration;
        this.currentOffset = currentOffset;
        this.overRideAcceleration = false;
    }

    @Override
    public void setAcceleration(boolean enable) {
        this.useAcceleration = enable;
    }

    @Override
    public void setAccelerationAlwaysRedraw(boolean enable) {
        this.accelerationAlwaysRedraw = enable;
    }

    public void setPageSize(int pageNumber, float scaling) {
        this.pageData.setScalingValue(scaling);
        this.topW = this.pageData.getScaledCropBoxWidth(pageNumber);
        this.topH = this.pageData.getScaledCropBoxHeight(pageNumber);
        double mediaH = this.pageData.getScaledMediaBoxHeight(pageNumber);
        this.cropX = this.pageData.getScaledCropBoxX(pageNumber);
        this.cropY = this.pageData.getScaledCropBoxY(pageNumber);
        this.cropW = this.topW;
        this.cropH = this.topH;
        if (this.displayView == 1) {
            this.crx = (int)((double)this.insetW + this.cropX);
            this.cry = (int)((double)this.insetH - this.cropY);
        } else {
            this.crx = this.insetW;
            this.cry = this.insetH;
        }
        int offsetY = (int)(mediaH - this.cropH);
        if (this.displayRotation == 90 || this.displayRotation == 270) {
            this.crw = (int)this.cropH;
            this.crh = (int)this.cropW;
            int tmp = this.crx;
            this.crx = this.cry;
            this.cry = tmp;
            this.crx += offsetY;
        } else {
            this.crw = (int)this.cropW;
            this.crh = (int)this.cropH;
            this.cry += offsetY;
        }
    }

    @Override
    public void decodeOtherPages(int pageNumber, int pageCount) {
    }

    @Override
    public void disableScreen() {
        this.isInitialised = false;
        this.oldScaling = -1.0f;
    }

    @Override
    public float getOldScaling() {
        return this.oldScaling;
    }

    @Override
    public void refreshDisplay() {
        throw new UnsupportedOperationException("refreshDisplay Not supported yet.");
    }

    @Override
    public void flushPageCaches() {
    }

    @Override
    public void init(float scaling, int displayRotation, int pageNumber, DynamicVectorRenderer currentDisplay, boolean isInit) {
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        if (currentDisplay != null) {
            this.currentDisplay = currentDisplay;
        }
        this.scaling = scaling;
        this.displayRotation = displayRotation;
        this.pageNumber = pageNumber;
        this.insetW = this.options.getInsetW();
        this.insetH = this.options.getInsetH();
        if (currentDisplay != null) {
            currentDisplay.setInset(this.insetW, this.insetH);
        }
        this.pageData.setScalingValue(scaling);
        if (isInit) {
            this.setPageOffsets(this.pageNumber);
            this.isInitialised = true;
        }
        this.lastScaling = scaling;
    }

    @Override
    public void setThumbnailPanel(GUIThumbnailPanel thumbnails) {
        this.thumbnails = thumbnails;
    }

    @Override
    public void stopGeneratingPage() {
        this.multiDisplayOptions.setIsGeneratingOtherPages(false);
        this.multiDisplayOptions.waitToDieThred();
    }

    @Override
    public int getYCordForPage(int page) {
        int[] yReached = this.multiDisplayOptions.getyReached();
        if (yReached != null) {
            return yReached[page] + this.insetH;
        }
        return this.insetH;
    }

    public int getStartPage() {
        return this.multiDisplayOptions.getStartViewPage();
    }

    public int getEndPage() {
        return this.multiDisplayOptions.getEndViewPage();
    }

    @Override
    public void setScaling(float scaling) {
        this.scaling = scaling;
        if (this.pageData != null) {
            this.pageData.setScalingValue(scaling);
        }
    }

    @Override
    public void setHighlightedImage(int[] highlightedImage) {
        this.highlightedImage = highlightedImage;
    }

    @Override
    public int[] getHighlightedImage() {
        return this.highlightedImage;
    }

    @Override
    public void drawBorder() {
        throw new UnsupportedOperationException("drawBorder Not supported yet.");
    }

    @Override
    public int getXCordForPage(int page) {
        int[] xReached = this.multiDisplayOptions.getxReached();
        if (xReached != null) {
            return xReached[page] + this.insetW;
        }
        return this.insetW;
    }

    @Override
    public void setPageOffsets(int pageNumber) {
        int pageCount = this.pageData.getPageCount();
        this.multiDisplayOptions.resetValues(pageCount);
        this.pageOffsetW = new int[pageCount + 1];
        this.pageOffsetH = new int[pageCount + 1];
        this.isRotated = new boolean[pageCount + 1];
        int gap = 10;
        if (this.multiDisplayOptions.isTurnoverOn() && pageCount != 2 && !this.pageData.hasMultipleSizes() && this.displayView == 4) {
            gap = 0;
        }
        int LmaxWidth = 0;
        int LmaxHeight = 0;
        int RmaxWidth = 0;
        int RmaxHeight = 0;
        int[] pageW = this.multiDisplayOptions.getPageW();
        int[] pageH = this.multiDisplayOptions.getPageH();
        for (int i = 1; i < pageCount + 1; ++i) {
            pageW[i] = this.pageData.getScaledCropBoxWidth(i);
            pageH[i] = this.pageData.getScaledCropBoxHeight(i);
            int displayRotation = this.pageData.getRotation(i) + this.displayRotation;
            if (displayRotation >= 360) {
                displayRotation -= 360;
            }
            if (displayRotation == 90 || displayRotation == 270) {
                int tmp = pageW[i];
                pageW[i] = pageH[i];
                pageH[i] = tmp;
                this.isRotated[i] = true;
            }
            if ((i & 1) == 1) {
                if (pageW[i] > RmaxWidth) {
                    RmaxWidth = pageW[i];
                }
                if (pageH[i] <= RmaxHeight) continue;
                RmaxHeight = pageH[i];
                continue;
            }
            if (this.multiDisplayOptions.getPageW(i) > LmaxWidth) {
                LmaxWidth = this.multiDisplayOptions.getPageW(i);
            }
            if (pageH[i] <= LmaxHeight) continue;
            LmaxHeight = pageH[i];
        }
        int[] xReached = this.multiDisplayOptions.getxReached();
        int[] yReached = this.multiDisplayOptions.getyReached();
        for (int i = 1; i < pageCount + 1; ++i) {
            int heightCorrection = 0;
            if (pageCount == 2 && (this.displayView == 4 || this.displayView == 3) || this.displayView == 4 && !this.multiDisplayOptions.isSeparateCover()) {
                if ((i & 1) == 1) {
                    xReached[i] = 0;
                    yReached[i] = 0;
                    continue;
                }
                xReached[i] = xReached[i - 1] + pageW[i - 1] + gap;
                yReached[i] = 0;
                if (i == 2 && this.pageData.getRotation(1) == 270) continue;
                this.pageOffsetW[2] = pageW[2] - pageW[1] + this.pageOffsetW[1];
                this.pageOffsetH[2] = pageH[2] - pageH[1] + this.pageOffsetH[1];
                continue;
            }
            if (i == 1) {
                if (this.displayView == 2) {
                    xReached[1] = 0;
                    yReached[1] = 0;
                    this.pageOffsetW[1] = 0;
                    this.pageOffsetH[1] = 0;
                    this.pageOffsetW[0] = gap;
                    this.pageOffsetH[0] = gap;
                    continue;
                }
                if (this.displayView == 3) {
                    this.pageOffsetW[0] = gap;
                    this.pageOffsetH[0] = gap;
                    this.pageOffsetW[1] = 0;
                    this.pageOffsetH[1] = 0;
                    xReached[1] = LmaxWidth + gap;
                    yReached[1] = 0;
                    continue;
                }
                if (this.displayView != 4) continue;
                xReached[1] = pageW[1] + gap;
                yReached[1] = 0;
                continue;
            }
            if (this.displayView == 3) {
                if (i < 2 || (this.pageData.getRotation(i) != 270 && this.pageData.getRotation(i) != 90 || this.pageData.getRotation(i - 1) == 270 && this.pageData.getRotation(i - 1) == 90) && (this.pageData.getRotation(i - 1) != 270 && this.pageData.getRotation(i - 1) != 90 || this.pageData.getRotation(i) == 270 && this.pageData.getRotation(i) == 90)) {
                    this.pageOffsetW[i] = pageW[i] - pageW[i - 1] + this.pageOffsetW[i - 1];
                    this.pageOffsetH[i] = pageH[i] - pageH[i - 1] + this.pageOffsetH[i - 1];
                }
                if ((i & 1) == 0) {
                    int temp;
                    if (i < pageCount) {
                        heightCorrection = (pageH[i + 1] - pageH[i]) / 2;
                    }
                    if (heightCorrection < 0) {
                        heightCorrection = 0;
                    }
                    if (i > 3 && (temp = (pageH[i - 2] - pageH[i - 1]) / 2) > 0) {
                        heightCorrection += temp;
                    }
                    yReached[i] = yReached[i - 1] + pageH[i - 1] + gap + heightCorrection;
                } else {
                    heightCorrection = (pageH[i - 1] - pageH[i]) / 2;
                    yReached[i] = yReached[i - 1] + heightCorrection;
                }
                if ((i & 1) == 0) {
                    int n = i;
                    xReached[n] = xReached[n] + (LmaxWidth - pageW[i]);
                    continue;
                }
                xReached[i] = xReached[i - 1] + pageW[i - 1] + gap;
                continue;
            }
            if (this.displayView == 2) {
                yReached[i] = yReached[i - 1] + pageH[i - 1] + gap;
                if (i >= 2 && ((this.pageData.getRotation(i) == 270 || this.pageData.getRotation(i) == 90) && (this.pageData.getRotation(i - 1) != 270 || this.pageData.getRotation(i - 1) != 90) || (this.pageData.getRotation(i - 1) == 270 || this.pageData.getRotation(i - 1) == 90) && (this.pageData.getRotation(i) != 270 || this.pageData.getRotation(i) != 90))) continue;
                this.pageOffsetW[i] = pageW[i] - pageW[i - 1] + this.pageOffsetW[i - 1];
                this.pageOffsetH[i] = pageH[i] - pageH[i - 1] + this.pageOffsetH[i - 1];
                continue;
            }
            if (this.displayView != 4) continue;
            if ((i & 1) == 1) {
                xReached[i] = xReached[i - 1] + pageW[i - 1] + gap;
                if (pageH[i] >= pageH[i - 1]) continue;
                int n = i;
                yReached[n] = yReached[n] + (pageH[i - 1] - pageH[i]) / 2;
                continue;
            }
            xReached[i] = 0;
            if (i >= pageCount || pageH[i] >= pageH[i + 1]) continue;
            int n = i;
            yReached[n] = yReached[n] + (pageH[i + 1] - pageH[i]) / 2;
        }
    }

    @Override
    public void dispose() {
        this.currentOffset = null;
        this.multiDisplayOptions.setPageValuesToNull();
        this.isRotated = null;
    }

    @Override
    public Rectangle getCursorBoxOnScreen() {
        throw new UnsupportedOperationException("Please use public int[] getCursorBoxOnScreenAsArray() instead");
    }

    @Override
    public int[] getCursorBoxOnScreenAsArray() {
        throw new UnsupportedOperationException("getCursorBoxOnScreenAsArray Not supported yet.");
    }

    @Override
    public double getIndent() {
        return this.indent;
    }

    @Override
    public void forceRedraw() {
        this.lastFormPage = -1;
        this.lastEnd = -1;
        this.lastStart = -1;
    }

    @Override
    public void setPageRotation(int newRotation) {
        if (this.displayView != 1) {
            newRotation = 0;
        }
        this.pageUsedForTransform = this.pageNumber;
        this.displayScalingDbl = this.displayView != 1 && this.displayView != 4 ? ScalingFactory.getScalingForImage(1, 0, this.scaling, this.pageData) : ScalingFactory.getScalingForImage(this.pageNumber, newRotation, this.scaling, this.pageData);
        int insetW = this.options.getInsetW();
        int insetH = this.options.getInsetH();
        if (newRotation == 90) {
            this.displayScalingDbl[4] = this.displayScalingDbl[4] + (double)((float)insetW / this.scaling) * this.displayScalingDbl[1];
            this.displayScalingDbl[5] = this.displayScalingDbl[5] + (double)((float)insetH / this.scaling) * this.displayScalingDbl[2];
        } else if (newRotation == 270) {
            this.displayScalingDbl[4] = this.displayScalingDbl[4] + (double)((float)(-insetW) / this.scaling) * this.displayScalingDbl[1];
            this.displayScalingDbl[5] = this.displayScalingDbl[5] + (double)((float)(-insetH) / this.scaling) * this.displayScalingDbl[2];
        } else if (newRotation == 180) {
            this.displayScalingDbl[4] = this.displayScalingDbl[4] + (double)((float)(-insetW) / this.scaling) * this.displayScalingDbl[0];
            this.displayScalingDbl[5] = this.displayScalingDbl[5] + (double)((float)insetH / this.scaling) * this.displayScalingDbl[3];
        } else {
            this.displayScalingDbl[4] = this.displayScalingDbl[4] + (double)((float)insetW / this.scaling) * this.displayScalingDbl[0];
            this.displayScalingDbl[5] = this.displayScalingDbl[5] + (double)((float)(-insetH) / this.scaling) * this.displayScalingDbl[3];
        }
        this.refreshDisplay();
    }

    @Override
    public void resetViewableArea() {
        throw new UnsupportedOperationException("resetViewableArea Not supported yet.");
    }

    @Override
    public void paintPage(Graphics2D g2, AcroRenderer formRenderer, TextLines textLines) {
        throw new UnsupportedOperationException("paintPage not supported yet.");
    }

    @Override
    public void updateCursorBoxOnScreen(Rectangle newOutlineRectangle, Color outlineColor, int pageNumber, int x_size, int y_size) {
        throw new UnsupportedOperationException("please use updateCursorBoxOnScreen(int[] newOutlineRectangle, int outlineColor, int pageNumber,int x_size,int y_size) instead");
    }

    @Override
    public void updateCursorBoxOnScreen(int[] newOutlineRectangle, int outlineColor, int pageNumber, int x_size, int y_size) {
        throw new UnsupportedOperationException("updateCursorBoxOnScreen Not supported yet.");
    }

    @Override
    public void drawCursor(Graphics g, float scaling) {
        throw new UnsupportedOperationException("drawCursor Not supported yet.");
    }

    @Override
    public AffineTransform setViewableArea(Rectangle viewport) throws PdfException {
        throw new UnsupportedOperationException("setViewableArea Not supported yet.");
    }

    @Override
    public AffineTransform setViewableArea(int[] viewport) throws PdfException {
        throw new UnsupportedOperationException("setViewableArea Not supported yet.");
    }

    @Override
    public void drawFacing(Rectangle visibleRect) {
        throw new UnsupportedOperationException("drawFacing Not supported yet.");
    }

    @Override
    public void paintPage(Pane box, AcroRenderer formRenderer, TextLines textLines) {
        throw new UnsupportedOperationException("paintPage Not supported yet.");
    }

    public void setCurrentDisplay(DynamicVectorRenderer pageView) {
        this.currentDisplay = pageView;
    }

    public int getDisplayRotation() {
        return this.displayRotation;
    }

    public int getRx() {
        return this.rx;
    }

    public int getRy() {
        return this.ry;
    }

    public int getRw() {
        return this.rw;
    }

    public int getRh() {
        return this.rh;
    }

    public int getInsetW() {
        return this.insetW;
    }

    public int getInsetH() {
        return this.insetH;
    }

    @Override
    public Rectangle getDisplayedRectangle() {
        throw new UnsupportedOperationException("getDisplayedRectangle Not supported yet.");
    }

    public Rectangle getDisplayedRectangle(boolean isShowing, Rectangle userAnnot) {
        this.rx = userAnnot.x;
        this.ry = userAnnot.y;
        this.rw = userAnnot.width;
        this.rh = userAnnot.height;
        if (!(isShowing || this.rw != 0 && this.rh != 0)) {
            this.rx = 0;
            this.ry = 0;
            this.rw = this.pageData.getScaledCropBoxWidth(this.pageNumber);
            this.rh = this.pageData.getScaledCropBoxHeight(this.pageNumber);
            if (this.pageData.getRotation(this.pageNumber) % 180 != 0) {
                this.rh = this.pageData.getScaledCropBoxWidth(this.pageNumber);
                this.rw = this.pageData.getScaledCropBoxHeight(this.pageNumber);
            }
        }
        return userAnnot;
    }
}

