/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.JMenuItem;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.RecentDocumentsFactory;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.SaveForm;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RecentDocuments
implements RecentDocumentsFactory {
    public final int noOfRecentDocs;
    private final Stack previousFiles = new Stack();
    private final Stack nextFiles = new Stack();
    public final JMenuItem[] recentDocuments;

    public RecentDocuments(int noOfRecentDocs) {
        this.noOfRecentDocs = noOfRecentDocs;
        this.recentDocuments = new JMenuItem[noOfRecentDocs];
    }

    static String getShortenedFileName(String fileNameToAdd) {
        int maxChars = 30;
        if (fileNameToAdd.length() <= 30) {
            return fileNameToAdd;
        }
        StringTokenizer st = new StringTokenizer(fileNameToAdd, "\\/");
        int noOfTokens = st.countTokens();
        if (noOfTokens == 1) {
            return fileNameToAdd.substring(0, 30);
        }
        String[] arrayedFile = new String[noOfTokens];
        for (int i = 0; i < noOfTokens; ++i) {
            arrayedFile[i] = st.nextToken();
        }
        String filePathBody = fileNameToAdd.substring(arrayedFile[0].length(), fileNameToAdd.length() - arrayedFile[noOfTokens - 1].length());
        StringBuilder sb = new StringBuilder(filePathBody);
        for (int i = noOfTokens - 2; i > 0; --i) {
            int start = sb.lastIndexOf(arrayedFile[i]);
            int end = start + arrayedFile[i].length();
            sb.replace(start, end, "...");
            if (sb.length() <= 30) break;
        }
        return arrayedFile[0] + sb + arrayedFile[noOfTokens - 1];
    }

    @Override
    public String getPreviousDocument() {
        String fileToOpen = null;
        if (this.previousFiles.size() > 1) {
            this.nextFiles.push(this.previousFiles.pop());
            fileToOpen = (String)this.previousFiles.pop();
        }
        return fileToOpen;
    }

    @Override
    public String getNextDocument() {
        String fileToOpen = null;
        if (!this.nextFiles.isEmpty()) {
            fileToOpen = (String)this.nextFiles.pop();
        }
        return fileToOpen;
    }

    @Override
    public void addToFileList(String selectedFile) {
        this.previousFiles.push(selectedFile);
    }

    @Override
    public void enableRecentDocuments(boolean enable) {
        if (this.recentDocuments == null) {
            return;
        }
        for (int i = 0; i < this.recentDocuments.length; ++i) {
            if (this.recentDocuments[i] == null || this.recentDocuments[i].getText().equals(i + 1 + ": ")) continue;
            this.recentDocuments[i].setVisible(enable);
            this.recentDocuments[i].setEnabled(enable);
        }
    }

    @Override
    public void updateRecentDocuments(String[] recentDocs) {
        if (recentDocs == null) {
            return;
        }
        for (int i = 0; i < recentDocs.length; ++i) {
            if (recentDocs[i] == null) continue;
            String shortenedFileName = RecentDocuments.getShortenedFileName(recentDocs[i]);
            if (this.recentDocuments[i] == null) {
                this.recentDocuments[i] = new JMenuItem();
            }
            this.recentDocuments[i].setText(i + 1 + ": " + shortenedFileName);
            if (this.recentDocuments[i].getText().equals(i + 1 + ": ")) {
                this.recentDocuments[i].setVisible(false);
            } else {
                this.recentDocuments[i].setVisible(true);
            }
            this.recentDocuments[i].setName(recentDocs[i]);
        }
    }

    @Override
    public void clearRecentDocuments(PropertiesFile properties) {
        NodeList nl = properties.getDoc().getElementsByTagName("recentfiles");
        if (nl != null && nl.getLength() > 0) {
            NodeList allRecentDocs = ((Element)nl.item(0)).getElementsByTagName("*");
            for (int i = 0; i < allRecentDocs.getLength(); ++i) {
                Node item = allRecentDocs.item(i);
                nl.item(0).removeChild(item);
            }
        }
        for (int i = 0; i < this.noOfRecentDocs; ++i) {
            this.recentDocuments[i].setText(i + 1 + ": ");
            this.recentDocuments[i].setVisible(false);
        }
    }

    @Override
    public void createMenuItems(String fileNameToAdd, int position, final GUIFactory currentGUI, final Values commonValues, final PdfDecoderInt decode_pdf, PropertiesFile properties, GUIThumbnailPanel thumbnails, GUISearchWindow searchFrame) {
        String shortenedFileName = RecentDocuments.getShortenedFileName(fileNameToAdd);
        this.recentDocuments[position] = new JMenuItem(position + 1 + ": " + shortenedFileName);
        if (this.recentDocuments[position].getText().equals(position + 1 + ": ")) {
            this.recentDocuments[position].setVisible(false);
        }
        this.recentDocuments[position].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Values.isProcessing()) {
                    currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                } else {
                    SaveForm.handleUnsaveForms(currentGUI, commonValues, decode_pdf);
                    JMenuItem item = (JMenuItem)e.getSource();
                    String fileName = item.getName();
                    if (!fileName.isEmpty()) {
                        currentGUI.open(fileName);
                    }
                }
            }
        });
        this.recentDocuments[position].setName(fileNameToAdd);
        currentGUI.getMenuItems().addToMenu(this.recentDocuments[position], 317);
    }
}

