/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.generic.GUIExtractSelectionAsImage;
import org.jpedal.examples.viewer.utils.FileFilterer;
import org.jpedal.examples.viewer.utils.IconiseImage;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;

public class ExtractSelectionAsImage
extends GUIExtractSelectionAsImage {
    public static void execute(Values commonValues, final GUIFactory currentGUI, PdfDecoderInt decode_pdf) {
        ExtractSelectionAsImage.extractSelectedScreenAsImage(commonValues, currentGUI, decode_pdf);
        JPanel image_display = new JPanel();
        image_display.setLayout(new BorderLayout());
        if (snapShot == null) {
            return;
        }
        IconiseImage icon_image = new IconiseImage(snapShot);
        image_display.add((Component)new JLabel(icon_image), "Center");
        final JScrollPane image_scroll = new JScrollPane();
        image_scroll.getViewport().add(image_display);
        int imgSize = snapShot.getWidth();
        if (imgSize < snapShot.getHeight()) {
            imgSize = snapShot.getHeight();
        }
        if ((imgSize += 50) > 450) {
            imgSize = 450;
        }
        Container frame = (Container)currentGUI.getFrame();
        final JDialog displayFrame = new JDialog((Frame)null, true);
        displayFrame.setDefaultCloseOperation(2);
        if (commonValues.getModeOfOperation() != 1) {
            displayFrame.setLocationRelativeTo(null);
            displayFrame.setLocation(frame.getLocationOnScreen().x + 10, frame.getLocationOnScreen().y + 10);
        }
        displayFrame.setSize(imgSize, imgSize);
        displayFrame.setTitle(Messages.getMessage("PdfViewerMessage.SaveImage"));
        displayFrame.getContentPane().setLayout(new BorderLayout());
        displayFrame.getContentPane().add((Component)image_scroll, "Center");
        JPanel buttonBar = new JPanel();
        buttonBar.setLayout(new BorderLayout());
        displayFrame.getContentPane().add((Component)buttonBar, "South");
        JButton yes = new JButton(Messages.getMessage("PdfMessage.Yes"));
        yes.setFont(new Font("SansSerif", 0, 12));
        buttonBar.add((Component)yes, "West");
        yes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                displayFrame.setVisible(false);
                boolean finished = false;
                while (!finished) {
                    JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
                    FileFilterer defaultOpt = new FileFilterer(new String[]{"png", "png"}, "PNG");
                    chooser.setFileFilter(defaultOpt);
                    chooser.addChoosableFileFilter(new FileFilterer(new String[]{"tif", "tiff"}, "TIFF"));
                    chooser.addChoosableFileFilter(new FileFilterer(new String[]{"jpg", "jpeg"}, "JPEG"));
                    int approved = chooser.showSaveDialog(image_scroll);
                    if (approved == 0) {
                        block7: {
                            int n;
                            File file = chooser.getSelectedFile();
                            StringBuffer fileToSave = new StringBuffer(file.getAbsolutePath());
                            String format = chooser.getFileFilter().getDescription();
                            if (format.equals("All Files")) {
                                format = "TIFF";
                            }
                            if (!fileToSave.toString().toLowerCase().endsWith(('.' + format).toLowerCase())) {
                                fileToSave.append('.').append(format);
                                file = new File(fileToSave.toString());
                            }
                            if (file.exists() && (n = currentGUI.showConfirmDialog(fileToSave.append('\n') + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + ".\n" + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                            if (snapShot != null) {
                                try {
                                    DefaultImageHelper.write(snapShot, format, fileToSave.toString());
                                }
                                catch (IOException ex) {
                                    if (!LogWriter.isOutput()) break block7;
                                    LogWriter.writeLog("Exception in writing image " + ex);
                                }
                            }
                        }
                        finished = true;
                        continue;
                    }
                    return;
                }
                displayFrame.dispose();
            }
        });
        JButton no = new JButton(Messages.getMessage("PdfMessage.No"));
        no.setFont(new Font("SansSerif", 0, 12));
        buttonBar.add((Component)no, "East");
        no.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                displayFrame.dispose();
            }
        });
        displayFrame.setVisible(true);
    }
}

