/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands;

import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.objects.PdfPageData;

public class Scroll {
    public static void execute(Object[] args, Values commonValues, PdfDecoderInt decode_pdf) {
        if (args != null) {
            int[] scrollTo = (int[])args[0];
            int page = commonValues.getCurrentPage();
            if (args.length > 1 && args[1] != null) {
                page = (Integer)args[1];
            }
            if (scrollTo != null) {
                Scroll.rectToHighlight(scrollTo, page, decode_pdf);
            }
        }
    }

    public static void rectToHighlight(int[] highlight, int page, PdfDecoderInt decode_pdf) {
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        int insetW = decode_pdf.getInsetW();
        int insetH = decode_pdf.getInsetH();
        float scaling = decode_pdf.getScaling();
        int scrollInterval = decode_pdf.getScrollInterval();
        int displayView = decode_pdf.getDisplayView();
        if (page < 1 || page > decode_pdf.getPageCount() || displayView == 1) {
            page = decode_pdf.getPageNumber();
        }
        PdfPageData pageData = decode_pdf.getPdfPageData();
        int cropW = pageData.getCropBoxWidth(page);
        int cropH = pageData.getCropBoxHeight(page);
        int cropX = pageData.getCropBoxX(page);
        int cropY = pageData.getCropBoxY(page);
        switch (decode_pdf.getDisplayRotation()) {
            case 0: {
                x = (int)((float)(highlight[0] - cropX) * scaling) + insetW;
                y = (int)((float)(cropH - (highlight[1] - cropY)) * scaling) + insetH;
                w = (int)((float)highlight[2] * scaling);
                h = (int)((float)highlight[3] * scaling);
                break;
            }
            case 90: {
                x = (int)((float)(highlight[1] - cropY) * scaling) + insetH;
                y = (int)((float)(highlight[0] - cropX) * scaling) + insetW;
                w = (int)((float)highlight[3] * scaling);
                h = (int)((float)highlight[2] * scaling);
                break;
            }
            case 180: {
                x = (int)((float)(cropW - (highlight[0] - cropX)) * scaling) + insetW;
                y = (int)((float)(highlight[1] - cropY) * scaling) + insetH;
                w = (int)((float)highlight[2] * scaling);
                h = (int)((float)highlight[3] * scaling);
                break;
            }
            case 270: {
                x = (int)((float)(cropH - (highlight[1] - cropY)) * scaling) + insetH;
                y = (int)((float)(cropW - (highlight[0] - cropX)) * scaling) + insetW;
                w = (int)((float)highlight[3] * scaling);
                h = (int)((float)highlight[2] * scaling);
            }
        }
        if (displayView != 1 && displayView != 5) {
            x += decode_pdf.getPages().getXCordForPage(page);
            y += decode_pdf.getPages().getYCordForPage(page);
        }
    }
}

