/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.generic;

import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.viewer.Values;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.gui.GUIFactory;
import org.jpedal.objects.PdfPageData;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;

public class GUICopy {
    public static String copySelectedText(PdfDecoderInt decode_pdf, GUIFactory currentGUI, Values commonValues) {
        if (!decode_pdf.isExtractionAllowed()) {
            currentGUI.showMessageDialog("Not allowed");
            return "";
        }
        StringBuilder returnValue = new StringBuilder("");
        int[][] highlights = decode_pdf.getTextLines().getHighlightedAreasAs2DArray(commonValues.getCurrentPage());
        if (highlights == null) {
            return "";
        }
        boolean multipleAreas = highlights.length > 1;
        PdfPageData page_data = decode_pdf.getPdfPageData();
        int cropX = page_data.getCropBoxX(commonValues.getCurrentPage());
        int cropY = page_data.getCropBoxY(commonValues.getCurrentPage());
        int cropW = page_data.getCropBoxWidth(commonValues.getCurrentPage());
        int cropH = page_data.getCropBoxHeight(commonValues.getCurrentPage());
        if (highlights != null) {
            for (int t = 0; t != highlights.length; ++t) {
                int temp;
                highlights[t] = GUICopy.adjustHighlightForExtraction(highlights[t]);
                int t_x1 = highlights[t][0];
                int t_x2 = highlights[t][0] + highlights[t][2];
                int t_y1 = highlights[t][1] + highlights[t][3];
                int t_y2 = highlights[t][1];
                if (t_y1 < t_y2) {
                    temp = t_y2;
                    t_y2 = t_y1;
                    t_y1 = temp;
                }
                if (t_x1 > t_x2) {
                    temp = t_x2;
                    t_x2 = t_x1;
                    t_x1 = temp;
                }
                if (t_x1 < cropX) {
                    t_x1 = cropX;
                }
                if (t_x1 > cropW + cropX) {
                    t_x1 = cropW + cropX;
                }
                if (t_x2 < cropX) {
                    t_x2 = cropX;
                }
                if (t_x2 > cropW + cropX) {
                    t_x2 = cropW + cropX;
                }
                if (t_y1 < cropY) {
                    t_y1 = cropY;
                }
                if (t_y1 > cropH + cropY) {
                    t_y1 = cropH + cropY;
                }
                if (t_y2 < cropY) {
                    t_y2 = cropY;
                }
                if (t_y2 > cropH + cropY) {
                    t_y2 = cropH + cropY;
                }
                try {
                    PdfGroupingAlgorithms currentGrouping = decode_pdf.getGroupingObject();
                    String extractedText = currentGrouping.extractTextInRectangle(t_x1, t_y1, t_x2, t_y2, commonValues.getCurrentPage(), false, true);
                    if (extractedText == null || extractedText.isEmpty()) {
                        if (!multipleAreas) {
                            currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound"));
                        }
                    } else {
                        extractedText = Strip.stripXML(extractedText, decode_pdf.isXMLExtraction()).toString();
                    }
                    if (extractedText == null) continue;
                    returnValue.append(extractedText).append('\r').append('\n');
                    continue;
                }
                catch (PdfException e) {
                    System.err.println("Exception " + e.getMessage() + " in file " + commonValues.getSelectedFile());
                    e.printStackTrace();
                }
            }
        }
        if (returnValue.length() > 2) {
            return returnValue.substring(0, returnValue.length() - 2);
        }
        return "";
    }

    public static int[] adjustHighlightForExtraction(int[] highlight) {
        int x = highlight[0] - 1;
        int y = highlight[1] - 3;
        int width = highlight[2] + 2;
        int height = highlight[3] + 6;
        return new int[]{x, y, width, height};
    }
}

