/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.stage.Stage;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.Viewer;
import org.jpedal.examples.viewer.commands.SaveForm;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.LogWriter;

public class JavaFXExit {
    public static void execute(Object[] args, GUIThumbnailPanel thumbnails, GUIFactory currentGUI, Values commonValues, PdfDecoderInt decode_pdf, PropertiesFile properties) {
        if (args == null) {
            JavaFXExit.exit(thumbnails, currentGUI, commonValues, decode_pdf, properties);
        }
    }

    public static void exit(GUIThumbnailPanel thumbnails, GUIFactory currentGUI, Values commonValues, PdfDecoderInt decode_pdf, PropertiesFile properties) {
        block17: {
            thumbnails.terminateDrawing();
            SaveForm.handleUnsaveForms(currentGUI, commonValues, decode_pdf);
            if (decode_pdf.getDisplayView() == 5) {
                decode_pdf.getPages().stopGeneratingPage();
            }
            decode_pdf.closePdfFile();
            try {
                properties.setValue("lastDocumentPage", String.valueOf(commonValues.getCurrentPage()));
                if (properties.getValue("trackViewerSize").equalsIgnoreCase("true")) {
                    properties.setValue("startViewerWidth", String.valueOf(((Stage)currentGUI.getFrame()).getWidth()));
                    properties.setValue("startViewerHeight", String.valueOf(((Stage)currentGUI.getFrame()).getHeight()));
                }
                if (properties.getValue("trackScaling").equalsIgnoreCase("true")) {
                    properties.setValue("startScaling", String.valueOf(((GUI)currentGUI).getSelectedComboItem(252)));
                }
                if (properties.getValue("trackView").equalsIgnoreCase("true")) {
                    properties.setValue("startView", String.valueOf(decode_pdf.getDisplayView()));
                }
                if (properties.getValue("startSideTabOpen").equalsIgnoreCase("true")) {
                    properties.setValue("startSideTabOpen", "true");
                }
                if (properties.getValue("trackSelectedSideTab").equalsIgnoreCase("true")) {
                    TabPane tabs = (TabPane)currentGUI.getSideTabBar();
                    if (DecoderOptions.isRunningOnMac) {
                        properties.setValue("startSelectedSideTab", ((Tab)tabs.getTabs().get(tabs.getSelectionModel().getSelectedIndex())).getText());
                    } else {
                        properties.setValue("startSelectedSideTab", ((Tab)tabs.getTabs().get(tabs.getSelectionModel().getSelectedIndex())).getText());
                    }
                }
                if (properties.getValue("trackSideTabExpandedSize").equalsIgnoreCase("true")) {
                    properties.setValue("sideTabBarExpandLength", String.valueOf(currentGUI.getSplitDividerLocation()));
                }
                properties.writeDoc();
            }
            catch (Exception e1) {
                if (!LogWriter.isOutput()) break block17;
                LogWriter.writeLog("Exception attempting to Write proterties: " + e1);
            }
        }
        if (!Viewer.exitOnClose) {
            currentGUI.dispose();
        } else if (Viewer.exitOnClose) {
            decode_pdf.dispose();
            currentGUI.dispose();
            System.exit(0);
        } else {
            Stage stage = (Stage)currentGUI.getFrame();
            if (stage == null) {
                decode_pdf.dispose();
            } else {
                ((Stage)currentGUI.getFrame()).close();
                decode_pdf.dispose();
                currentGUI.dispose();
            }
        }
    }
}

