/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.jpedal.PdfDecoderInt;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.generic.GUIExtractSelectionAsImage;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXDialog;
import org.jpedal.gui.GUIFactory;
import org.jpedal.utils.LogWriter;

public class JavaFXExtractSelectionAsImage
extends GUIExtractSelectionAsImage {
    protected static final int BUTTONWIDTH = 55;

    public static void execute(Values commonValues, GUIFactory currentGUI, PdfDecoderInt decode_pdf) {
        JavaFXExtractSelectionAsImage.extractSelectedScreenAsImage(commonValues, currentGUI, decode_pdf);
        VBox pane = new VBox();
        final FXDialog dialog = new FXDialog((Stage)currentGUI.getFrame(), Modality.APPLICATION_MODAL, (Pane)pane);
        dialog.setResizeable(false);
        if (snapShot == null) {
            return;
        }
        ImageView imv1 = new ImageView();
        imv1.setImage((Image)SwingFXUtils.toFXImage((BufferedImage)snapShot, null));
        dialog.setWidth(imv1.getImage().getWidth());
        dialog.setHeight(imv1.getImage().getHeight() + 50.0);
        pane.getChildren().add((Object)imv1);
        HBox btnBox = new HBox();
        Button saveBtn = new Button("Save");
        Button cancelBtn = new Button("Cancel");
        btnBox.getChildren().addAll((Object[])new Node[]{saveBtn, cancelBtn});
        btnBox.setAlignment(Pos.BOTTOM_RIGHT);
        pane.getChildren().add((Object)btnBox);
        saveBtn.setPrefWidth(55.0);
        saveBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                block6: {
                    dialog.getDialog().hide();
                    FileChooser chooser = new FileChooser();
                    chooser.setTitle("Open PDF file");
                    chooser.setInitialDirectory(new File(System.getProperty("user.dir")));
                    FileChooser.ExtensionFilter extFilter1 = new FileChooser.ExtensionFilter("TIFF (*.tif)", new String[]{"*.tif", "*.tiff"});
                    chooser.getExtensionFilters().add((Object)extFilter1);
                    FileChooser.ExtensionFilter extFilter2 = new FileChooser.ExtensionFilter("JPEG (*.jpg)", new String[]{"*.jpg", "*.jpeg"});
                    chooser.getExtensionFilters().add((Object)extFilter2);
                    File outputFile = chooser.showSaveDialog((Window)dialog.getDialog());
                    if (outputFile != null) {
                        StringBuilder outName = new StringBuilder(outputFile.getAbsolutePath());
                        FileChooser.ExtensionFilter filter = chooser.getSelectedExtensionFilter();
                        String format = "tif";
                        if (filter.getDescription().toLowerCase().contains("jp")) {
                            format = "jpg";
                        }
                        if (!outName.toString().toLowerCase().endsWith(('.' + format).toLowerCase())) {
                            outName.append('.').append(format);
                        }
                        if (snapShot != null) {
                            try {
                                DefaultImageHelper.write(snapShot, format, outName.toString());
                            }
                            catch (IOException ex) {
                                if (!LogWriter.isOutput()) break block6;
                                LogWriter.writeLog("Exception in writing image " + ex);
                            }
                        }
                    }
                }
            }
        });
        cancelBtn.setPrefWidth(55.0);
        cancelBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                dialog.close();
            }
        });
        dialog.show();
    }
}

