/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.JavaFxGUI;
import org.jpedal.examples.viewer.gui.javafx.FXViewerTransitions;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXDialog;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXMessageDialog;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXOptionDialog;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.Speech;
import org.jpedal.objects.javascript.DefaultParser;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.mozilla.javascript.ScriptRuntime;
import org.w3c.dom.NodeList;

public class JavaFXPreferences {
    private static final Map reverseMessage = new HashMap();
    private static final String[] menuTabs = new String[]{"ShowMenubar", "ShowButtons", "ShowDisplayoptions", "ShowNavigationbar", "ShowSidetabbar"};
    private static FXDialog preferenceDialog;
    private static final int contentGap = 10;
    private static final BorderPane borderPane;
    private static final Font titleFont;
    private static final Text title;
    private static ScrollPane contentScrollPane;
    private static PropertiesFile properties;
    private static final int GENERAL = 0;
    private static final int PAGEDISPLAY = 1;
    private static final int INTERFACE = 2;
    private static final int COLOR = 3;
    private static final int MENU = 4;
    private static final int PRINTING = 5;
    private static final int EXTENSION = 6;
    private static TextField resolutionTF;
    private static CheckBox trueTypeCB;
    private static CheckBox autoScrollCB;
    private static CheckBox confirmCloseCB;
    private static CheckBox checkUpdatesCB;
    private static CheckBox openDocCB;
    private static Button clearRecentDocsBtn;
    private static CheckBox enhancedViewerCB;
    private static CheckBox showBorderCB;
    private static TextField pageInsetsTF;
    private static ComboBox displayCombo;
    private static CheckBox enablePageFlipCB;
    private static CheckBox scrollableThumbsCB;
    private static TextField winTitleTF;
    private static TextField iconLocTF;
    private static ComboBox searchStyle;
    private static TextField maxViewerTF;
    private static TextField sideTabTF;
    private static CheckBox consistentSideTabCB;
    private static CheckBox rightClickCB;
    private static CheckBox wheelZoomCB;
    private static CheckBox mouseSelectCB;
    private static ComboBox voiceSelect;
    private static ComboBox transitionSelect;
    private static ColorPicker highlightsPicker;
    private static TextField highlightTF;
    private static CheckBox invertHighlightsCB;
    private static ColorPicker pageColorPicker;
    private static CheckBox replaceTextColorCB;
    private static ColorPicker textColorPicker;
    private static CheckBox changeLineArtColorCB;
    private static CheckBox replaceDisplayCB;
    private static ColorPicker displayBGColorPicker;
    private static CheckBox hiResPrintingCB;
    private static ComboBox printerCombo;
    private static ComboBox paperSizesCombo;
    private static TextField defaultDPITF;
    private static TextField blackListTF;
    private static TabPane tabs;
    private static Speech speech;

    public static void execute(Object[] args, GUIFactory currentGUI) {
        if (args == null) {
            JavaFXPreferences.showPreferenceWindow(currentGUI);
        }
    }

    private static void init(final GUIFactory currentGUI) {
        speech = (Speech)currentGUI.getPdfDecoder().getExternalHandler(32);
        resolutionTF = new TextField();
        trueTypeCB = new CheckBox(Messages.getMessage("PdfCustomGui.useHinting"));
        autoScrollCB = new CheckBox(Messages.getMessage("PdfViewerViewMenuAutoscrollSet.text"));
        confirmCloseCB = new CheckBox(Messages.getMessage("PfdViewerViewMenuConfirmClose.text"));
        checkUpdatesCB = new CheckBox(Messages.getMessage("PdfPreferences.CheckForUpdate"));
        openDocCB = new CheckBox(Messages.getMessage("PdfViewerViewMenuOpenLastDoc.text"));
        clearRecentDocsBtn = new Button(Messages.getMessage("PageLayoutViewMenu.ClearHistory"));
        clearRecentDocsBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                currentGUI.getRecentDocument().clearRecentDocuments(currentGUI.getProperties());
            }
        });
        enhancedViewerCB = new CheckBox(Messages.getMessage("PdfCustomGui.enhancedViewer"));
        showBorderCB = new CheckBox(Messages.getMessage("PageLayoutViewMenu.Borders_Show"));
        pageInsetsTF = new TextField();
        ObservableList pageOptions = FXCollections.observableArrayList((Object[])new String[]{Messages.getMessage("PageLayoutViewMenu.SinglePage"), Messages.getMessage("PageLayoutViewMenu.Continuous"), Messages.getMessage("PageLayoutViewMenu.Facing"), Messages.getMessage("PageLayoutViewMenu.ContinousFacing"), Messages.getMessage("PageLayoutViewMenu.PageFlow")});
        displayCombo = new ComboBox(pageOptions);
        enablePageFlipCB = new CheckBox(Messages.getMessage("PdfCustomGui.enhancedFacing"));
        scrollableThumbsCB = new CheckBox(Messages.getMessage("PdfCustomGui.thumbnailScroll"));
        winTitleTF = new TextField();
        iconLocTF = new TextField();
        ObservableList layoutOptions = currentGUI.isSingle() ? FXCollections.observableArrayList((Object[])new String[]{Messages.getMessage("PageLayoutViewMenu.WindowSearch"), Messages.getMessage("PageLayoutViewMenu.TabbedSearch"), Messages.getMessage("PageLayoutViewMenu.MenuSearch")}) : FXCollections.observableArrayList((Object[])new String[]{Messages.getMessage("PageLayoutViewMenu.WindowSearch"), Messages.getMessage("PageLayoutViewMenu.TabbedSearch")});
        searchStyle = new ComboBox(layoutOptions);
        maxViewerTF = new TextField();
        sideTabTF = new TextField();
        consistentSideTabCB = new CheckBox(Messages.getMessage("PdfCustomGui.consistentTabs"));
        rightClickCB = new CheckBox(Messages.getMessage("PdfCustomGui.allowRightClick"));
        wheelZoomCB = new CheckBox(Messages.getMessage("PdfCustomGui.allowScrollwheelZoom"));
        mouseSelectCB = new CheckBox("Show Mouse Selection Box");
        if (speech != null) {
            ArrayList<String> availableVoices = new ArrayList<String>(Arrays.asList(speech.listVoices()));
            FXViewerTransitions.TransitionType[] speechOptions = FXCollections.observableList(availableVoices);
            voiceSelect = new ComboBox((ObservableList)speechOptions);
        } else {
            ObservableList speechOptions = FXCollections.observableArrayList((Object[])new String[]{"No Voice Options Detected"});
            voiceSelect = new ComboBox(speechOptions);
        }
        ArrayList<String> transitions = new ArrayList<String>();
        for (FXViewerTransitions.TransitionType s : FXViewerTransitions.TransitionType.values()) {
            transitions.add(s.name().replace("_", " "));
        }
        ObservableList transitionOptions = FXCollections.observableArrayList(transitions);
        transitionSelect = new ComboBox(transitionOptions);
        transitionSelect.getSelectionModel().select(0);
        tabs = new TabPane();
        hiResPrintingCB = new CheckBox(Messages.getMessage("Printing.HiRes"));
        defaultDPITF = new TextField();
        blackListTF = new TextField();
    }

    private static void showPreferenceWindow(GUIFactory currentGUI) {
        properties = currentGUI.getProperties();
        JavaFXPreferences.init(currentGUI);
        JavaFXPreferences.loadSettings();
        borderPane.setLeft((Node)JavaFXPreferences.setupSideNavBar(currentGUI));
        borderPane.setCenter((Node)JavaFXPreferences.getGeneralContent());
        borderPane.setBottom((Node)JavaFXPreferences.setupBottomBar(currentGUI));
        preferenceDialog = new FXDialog(null, Modality.APPLICATION_MODAL, (Parent)borderPane, 550.0, 450.0);
        preferenceDialog.setTitle(Messages.getMessage("PdfPreferences.windowTitle"));
        preferenceDialog.show();
    }

    private static ScrollPane setupSideNavBar(GUIFactory currentGUI) {
        VBox vBox = new VBox();
        ToggleGroup buttonsGroup = new ToggleGroup();
        Object[] buttonsArr = new ToggleButton[]{new ToggleButton(Messages.getMessage("PdfPreferences.GeneralTitle"), (Node)new ImageView(new Image("/org/jpedal/examples/viewer/res/display.png"))), new ToggleButton(Messages.getMessage("PdfPreferences.PageDisplayTitle"), (Node)new ImageView(new Image("/org/jpedal/examples/viewer/res/pagedisplay.png"))), new ToggleButton(Messages.getMessage("PdfPreferences.InterfaceTitle"), (Node)new ImageView(new Image("/org/jpedal/examples/viewer/res/interface.png"))), new ToggleButton("Color", (Node)new ImageView(new Image("/org/jpedal/examples/viewer/res/color.png"))), new ToggleButton("Menu", (Node)new ImageView(new Image("/org/jpedal/examples/viewer/res/menu.png"))), new ToggleButton(Messages.getMessage("PdfPreferences.PrintingTitle"), (Node)new ImageView(new Image("/org/jpedal/examples/viewer/res/printing.png"))), new ToggleButton(Messages.getMessage("PdfPreferences.ExtensionsTitle"), (Node)new ImageView(new Image("/org/jpedal/examples/viewer/res/extensions.png")))};
        buttonsArr[0].setSelected(true);
        for (ToggleButton toggleButton : buttonsArr) {
            toggleButton.setContentDisplay(ContentDisplay.TOP);
            toggleButton.setTextFill((Paint)Color.BLACK);
            toggleButton.setStyle("-fx-base: transparent;");
            toggleButton.setToggleGroup(buttonsGroup);
        }
        vBox.getChildren().addAll(buttonsArr);
        vBox.setAlignment(Pos.CENTER);
        buttonsGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>((ToggleButton[])buttonsArr, buttonsGroup, currentGUI){
            final /* synthetic */ ToggleButton[] val$buttonsArr;
            final /* synthetic */ ToggleGroup val$buttonsGroup;
            final /* synthetic */ GUIFactory val$currentGUI;
            {
                this.val$buttonsArr = toggleButtonArray;
                this.val$buttonsGroup = toggleGroup;
                this.val$currentGUI = gUIFactory;
            }

            public void changed(ObservableValue<? extends Toggle> ov, Toggle toggle, Toggle new_toggle) {
                for (int i = 0; i < this.val$buttonsArr.length; ++i) {
                    if (this.val$buttonsGroup.getSelectedToggle() != this.val$buttonsArr[i]) continue;
                    JavaFXPreferences.updateDisplay(i, this.val$currentGUI);
                }
            }
        });
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)vBox);
        return scrollPane;
    }

    private static void updateDisplay(int menuSelection, GUIFactory currentGUI) {
        switch (menuSelection) {
            case 0: {
                borderPane.setCenter((Node)JavaFXPreferences.getGeneralContent());
                break;
            }
            case 1: {
                borderPane.setCenter((Node)JavaFXPreferences.getPageDisplayContent());
                break;
            }
            case 2: {
                borderPane.setCenter((Node)JavaFXPreferences.getInterfaceContent(currentGUI));
                break;
            }
            case 3: {
                borderPane.setCenter((Node)JavaFXPreferences.getColorContent());
                break;
            }
            case 4: {
                borderPane.setCenter((Node)JavaFXPreferences.getMenuContent());
                break;
            }
            case 5: {
                borderPane.setCenter((Node)JavaFXPreferences.getPrintingContent());
                break;
            }
            case 6: {
                borderPane.setCenter((Node)JavaFXPreferences.getExtensionContent());
                break;
            }
            default: {
                System.out.println("menu selection not available");
            }
        }
    }

    private static HBox setupBottomBar(final GUIFactory currentGUI) {
        Button resetBtn = new Button(Messages.getMessage("PdfPreferences.ResetToDefault"));
        Button okBtn = new Button("OK");
        Button saveAsBtn = new Button(Messages.getMessage("PdfPreferences.SaveAs"));
        Button cancelBtn = new Button("Cancel");
        HBox hBox = new HBox();
        hBox.setPadding(new Insets(8.0));
        hBox.setSpacing(8.0);
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        hBox.getChildren().addAll((Object[])new Node[]{resetBtn, spacer, okBtn, saveAsBtn, cancelBtn});
        okBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                JavaFXPreferences.updateSettings(currentGUI);
                preferenceDialog.close();
            }
        });
        cancelBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                preferenceDialog.close();
            }
        });
        saveAsBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                String lastProperties;
                block3: {
                    lastProperties = currentGUI.getPropertiesFileLocation();
                    FileChooser chooser = new FileChooser();
                    chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("XML File", new String[]{"*.xml"})});
                    chooser.setInitialFileName("*.xml");
                    File xmlFile = chooser.showSaveDialog(null);
                    if (xmlFile != null) {
                        currentGUI.setPropertiesFileLocation(xmlFile.getAbsolutePath());
                        JavaFXPreferences.updateSettings(currentGUI);
                        try {
                            properties.writeDoc();
                        }
                        catch (Exception e1) {
                            if (!LogWriter.isOutput()) break block3;
                            LogWriter.writeLog("Exception attempting to Write proterties: " + e1);
                        }
                    }
                }
                currentGUI.setPropertiesFileLocation(lastProperties);
            }
        });
        resetBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                int result = new FXOptionDialog(preferenceDialog.getDialog(), Messages.getMessage("PdfPreferences.reset"), "Reset to Default", 0, null, null).showOptionDialog();
                if (result == 0) {
                    block5: {
                        String lastProperties = currentGUI.getPropertiesFileLocation();
                        File f = new File(lastProperties);
                        if (f.exists()) {
                            f.delete();
                        }
                        properties.loadProperties(lastProperties);
                        try {
                            properties.writeDoc();
                        }
                        catch (Exception e2) {
                            if (!LogWriter.isOutput()) break block5;
                            LogWriter.writeLog("Exception attempting to Write proterties: " + e2);
                        }
                    }
                    if (GUI.showMessages) {
                        new FXMessageDialog(preferenceDialog.getDialog(), Modality.APPLICATION_MODAL, Messages.getMessage("PdfPreferences.restart")).showAndWait();
                    }
                    preferenceDialog.close();
                }
            }
        });
        return hBox;
    }

    private static ScrollPane getGeneralContent() {
        contentScrollPane = new ScrollPane();
        VBox contentVBox = new VBox();
        title.setText(Messages.getMessage("PdfPreferences.GeneralTitle"));
        title.setFont(titleFont);
        Text generalOptions = new Text(Messages.getMessage("PdfPreferences.GeneralSection"));
        generalOptions.setFont(titleFont);
        HBox resolutionHBox = new HBox();
        resolutionHBox.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfViewerViewMenu.Resolution")), resolutionTF});
        Text startupOptions = new Text(Messages.getMessage("PdfPreferences.StartUp"));
        startupOptions.setFont(titleFont);
        contentVBox.getChildren().addAll((Object[])new Node[]{title, generalOptions, resolutionHBox, trueTypeCB, autoScrollCB, confirmCloseCB, startupOptions, checkUpdatesCB, openDocCB, clearRecentDocsBtn});
        contentVBox.setPadding(new Insets(10.0));
        contentVBox.setSpacing(10.0);
        contentScrollPane.setContent((Node)contentVBox);
        return contentScrollPane;
    }

    private static ScrollPane getPageDisplayContent() {
        contentScrollPane = new ScrollPane();
        VBox contentVBox = new VBox();
        title.setText(Messages.getMessage("PdfPreferences.PageDisplayTitle"));
        Text generalOptions = new Text(Messages.getMessage("PdfPreferences.GeneralSection"));
        generalOptions.setFont(titleFont);
        HBox pageInsetsHBox = new HBox();
        pageInsetsHBox.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfViewerViewMenu.pageInsets")), pageInsetsTF});
        Text displayOptions = new Text(Messages.getMessage("PdfPreferences.DisplayModes"));
        displayOptions.setFont(titleFont);
        HBox displayModeHBox = new HBox();
        displayModeHBox.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PageLayoutViewMenu.PageLayout")), displayCombo});
        contentVBox.getChildren().addAll((Object[])new Node[]{title, generalOptions, enhancedViewerCB, showBorderCB, pageInsetsHBox, displayOptions, displayModeHBox, enablePageFlipCB, scrollableThumbsCB});
        contentVBox.setPadding(new Insets(10.0));
        contentVBox.setSpacing(10.0);
        contentScrollPane.setContent((Node)contentVBox);
        return contentScrollPane;
    }

    private static ScrollPane getInterfaceContent(GUIFactory currentGUI) {
        contentScrollPane = new ScrollPane();
        title.setText(Messages.getMessage("PdfPreferences.InterfaceTitle"));
        TabPane tabPane = new TabPane();
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        Tab appearance = new Tab(Messages.getMessage("PdfPreferences.AppearanceTab"));
        VBox appearanceVBox = new VBox();
        Text appGenOptions = new Text(Messages.getMessage("PdfPreferences.GeneralSection"));
        appGenOptions.setFont(titleFont);
        HBox winTitleHBox = new HBox();
        winTitleHBox.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfCustomGui.windowTitle")), winTitleTF});
        HBox iconLocHBox = new HBox();
        iconLocHBox.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfViewerViewMenu.iconLocation")), iconLocTF});
        HBox searchStyleHBox = new HBox();
        searchStyleHBox.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PageLayoutViewMenu.SearchLayout")), searchStyle});
        HBox maxViewersHBox = new HBox();
        maxViewersHBox.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfPreferences.MaxMultiViewers")), maxViewerTF});
        Text appSideTabOptions = new Text(Messages.getMessage("PdfPreferences.SideTab"));
        appSideTabOptions.setFont(titleFont);
        HBox sideTabHBox = new HBox();
        sideTabHBox.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfCustomGui.SideTabLength")), sideTabTF});
        HBox transitionHBox = new HBox();
        transitionHBox.getChildren().addAll((Object[])new Node[]{new Label("Transition type: "), transitionSelect});
        appearanceVBox.getChildren().addAll((Object[])new Node[]{appGenOptions, winTitleHBox, iconLocHBox, searchStyleHBox, maxViewersHBox, appSideTabOptions, sideTabHBox, consistentSideTabCB, transitionHBox});
        appearanceVBox.setPadding(new Insets(10.0));
        appearanceVBox.setSpacing(10.0);
        appearance.setContent((Node)appearanceVBox);
        Tab mouse = new Tab(Messages.getMessage("PdfPreferences.Mouse"));
        VBox mouseVBox = new VBox();
        Text mouseGenOptions = new Text(Messages.getMessage("PdfPreferences.GeneralSection"));
        mouseGenOptions.setFont(titleFont);
        mouseVBox.getChildren().addAll((Object[])new Node[]{mouseGenOptions, rightClickCB, wheelZoomCB, mouseSelectCB});
        mouseVBox.setPadding(new Insets(10.0));
        mouseVBox.setSpacing(10.0);
        mouse.setContent((Node)mouseVBox);
        Tab speech = new Tab(Messages.getMessage("PdfPreferences.Voice"));
        VBox speechVBox = new VBox();
        Text speechGenOptions = new Text(Messages.getMessage("PdfPreferences.GeneralSection"));
        speechGenOptions.setFont(titleFont);
        speechVBox.getChildren().addAll((Object[])new Node[]{speechGenOptions, voiceSelect});
        speechVBox.setPadding(new Insets(10.0));
        speechVBox.setSpacing(10.0);
        speech.setContent((Node)speechVBox);
        tabPane.getTabs().addAll((Object[])new Tab[]{appearance, mouse, speech});
        VBox contentVBox = new VBox();
        contentVBox.setPadding(new Insets(10.0));
        contentVBox.setSpacing(10.0);
        contentVBox.getChildren().addAll((Object[])new Node[]{title, tabPane});
        contentScrollPane.setContent((Node)contentVBox);
        return contentScrollPane;
    }

    private static ScrollPane getColorContent() {
        contentScrollPane = new ScrollPane();
        title.setText("Color");
        VBox contentVBox = new VBox();
        Text highlightsTitle = new Text("Highlights");
        highlightsTitle.setFont(titleFont);
        final HBox highlightsHBox = new HBox();
        Label changeHighlightsLabel = new Label(Messages.getMessage("PdfPreferences.ChangeHighlightColor") + ' ');
        highlightsHBox.getChildren().addAll((Object[])new Node[]{changeHighlightsLabel, highlightsPicker});
        final HBox transparencyHBox = new HBox();
        Label highlightLabel = new Label(Messages.getMessage("PdfPreferences.ChangeHighlightTransparency") + ' ');
        transparencyHBox.getChildren().addAll((Object[])new Node[]{highlightLabel, highlightTF});
        String invertHighlights = properties.getValue("invertHighlights");
        if (!invertHighlights.isEmpty() && invertHighlights.equalsIgnoreCase("true")) {
            transparencyHBox.setDisable(true);
            highlightsHBox.setDisable(true);
        } else {
            transparencyHBox.setDisable(false);
            highlightsHBox.setDisable(false);
        }
        invertHighlightsCB.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                if (invertHighlightsCB.isSelected()) {
                    transparencyHBox.setDisable(true);
                    highlightsHBox.setDisable(true);
                } else {
                    transparencyHBox.setDisable(false);
                    highlightsHBox.setDisable(false);
                }
            }
        });
        Text displayTitle = new Text("Display Colors");
        displayTitle.setFont(titleFont);
        HBox displayColorsHBox = new HBox();
        Label pageColorLabel = new Label(Messages.getMessage("PdfPreferences.ChangeBackgroundColor") + ' ');
        displayColorsHBox.getChildren().addAll((Object[])new Node[]{pageColorLabel, pageColorPicker});
        final HBox textColorHB = new HBox();
        Label textColorLabel = new Label(Messages.getMessage("PdfPreferences.ChangeForegroundColor") + ' ');
        textColorHB.getChildren().addAll((Object[])new Node[]{textColorLabel, textColorPicker});
        String replaceTextCol = properties.getValue("replaceDocumentTextColors");
        if (!replaceTextCol.isEmpty() && replaceTextCol.equalsIgnoreCase("true")) {
            replaceTextColorCB.setSelected(true);
            textColorHB.setDisable(false);
            changeLineArtColorCB.setDisable(false);
        } else {
            replaceTextColorCB.setSelected(false);
            textColorHB.setDisable(true);
            changeLineArtColorCB.setDisable(true);
        }
        replaceTextColorCB.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                if (replaceTextColorCB.isSelected()) {
                    textColorHB.setDisable(false);
                    changeLineArtColorCB.setDisable(false);
                } else {
                    textColorHB.setDisable(true);
                    changeLineArtColorCB.setDisable(true);
                }
            }
        });
        final HBox displayColorHB = new HBox();
        Label displayColorLabel = new Label(Messages.getMessage("PdfPreferences.ChangeDisplayBackgroundColor") + ' ');
        displayColorHB.getChildren().addAll((Object[])new Node[]{displayColorLabel, displayBGColorPicker});
        String replaceDisplayCol = properties.getValue("replacePdfDisplayBackground");
        if (!replaceDisplayCol.isEmpty() && replaceDisplayCol.equalsIgnoreCase("true")) {
            replaceDisplayCB.setSelected(true);
            displayColorHB.setDisable(false);
        } else {
            replaceDisplayCB.setSelected(false);
            displayColorHB.setDisable(true);
        }
        replaceDisplayCB.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                if (replaceDisplayCB.isSelected()) {
                    displayColorHB.setDisable(false);
                } else {
                    displayColorHB.setDisable(true);
                }
            }
        });
        contentVBox.setPadding(new Insets(10.0));
        contentVBox.setSpacing(10.0);
        contentVBox.getChildren().addAll((Object[])new Node[]{title, highlightsTitle, highlightsHBox, transparencyHBox, invertHighlightsCB, displayTitle, displayColorsHBox, replaceTextColorCB, textColorHB, changeLineArtColorCB, replaceDisplayCB, displayColorHB});
        contentScrollPane.setContent((Node)contentVBox);
        return contentScrollPane;
    }

    public static Color shiftColorSpaceToFX(int raw) {
        int r = raw >> 16 & 0xFF;
        int g = raw >> 8 & 0xFF;
        int b = raw & 0xFF;
        return Color.rgb((int)r, (int)g, (int)b);
    }

    private static int shiftColorSpaceToSwing(Color newCol) {
        int r = (int)(newCol.getRed() * 255.0);
        int g = (int)(newCol.getGreen() * 255.0);
        int b = (int)(newCol.getBlue() * 255.0);
        return (r << 16) + (g << 8) + b;
    }

    private static void addMenuToTree(NodeList nodes, CheckBoxTreeItem top, List previous) {
        for (int i = 0; i != nodes.getLength(); ++i) {
            String name;
            if (i >= nodes.getLength() || JavaFXPreferences.removeOption(name = nodes.item(i).getNodeName()) || name.startsWith("#")) continue;
            final CheckBoxTreeItem newLeaf = new CheckBoxTreeItem((Object)Messages.getMessage("PdfCustomGui." + name));
            reverseMessage.put(Messages.getMessage("PdfCustomGui." + name), name);
            String propValue = properties.getValue(name);
            if (!propValue.isEmpty() && propValue.equals("true")) {
                newLeaf.setSelected(true);
            } else {
                newLeaf.setSelected(false);
            }
            if (name.equals("Preferences")) {
                newLeaf.selectedProperty().addListener(new ChangeListener(){

                    public void changed(ObservableValue ov, Object t, Object t1) {
                        int result;
                        if (!newLeaf.isSelected() && (result = new FXOptionDialog(null, "Disabling this option will mean you can not acces this menu using this properties file. Do you want to continue?", "Preferences Access", 0, null, null).showOptionDialog()) == 1) {
                            newLeaf.setSelected(true);
                        }
                    }
                });
            }
            if (nodes.item(i).hasChildNodes()) {
                previous.add(top);
                top.getChildren().add((Object)newLeaf);
                JavaFXPreferences.addMenuToTree(nodes.item(i).getChildNodes(), newLeaf, previous);
                continue;
            }
            top.getChildren().add((Object)newLeaf);
        }
    }

    private static boolean removeOption(String name) {
        if (name.equals("Helpbutton")) {
            return true;
        }
        if (name.equals("RSSbutton")) {
            return true;
        }
        return name.equals("Helpforum");
    }

    private static ScrollPane getMenuContent() {
        contentScrollPane = new ScrollPane();
        VBox contentVBox = new VBox();
        title.setText("Menu");
        tabs.getTabs().clear();
        tabs.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        for (int t = 0; t != menuTabs.length; ++t) {
            reverseMessage.put(Messages.getMessage("PdfCustomGui." + menuTabs[t]), menuTabs[t]);
            CheckBoxTreeItem top = new CheckBoxTreeItem((Object)Messages.getMessage("PdfCustomGui." + menuTabs[t]));
            top.setSelected(true);
            ArrayList<CheckBoxTreeItem> last = new ArrayList<CheckBoxTreeItem>();
            last.add(top);
            NodeList nodes = properties.getChildren(Messages.getMessage("PdfCustomGui." + menuTabs[t]) + "Menu");
            JavaFXPreferences.addMenuToTree(nodes, top, last);
            top.setExpanded(true);
            TreeView tree = new TreeView((TreeItem)top);
            tree.setCellFactory(CheckBoxTreeCell.forTreeView());
            tabs.getTabs().addAll((Object[])new Tab[]{new Tab(Messages.getMessage("PdfCustomGui." + menuTabs[t]))});
            ((Tab)tabs.getTabs().get(t)).setContent((Node)tree);
        }
        contentVBox.setPadding(new Insets(10.0));
        contentVBox.setSpacing(10.0);
        contentVBox.getChildren().addAll((Object[])new Node[]{title, tabs});
        contentScrollPane.setContent((Node)contentVBox);
        return contentScrollPane;
    }

    private static ScrollPane getPrintingContent() {
        contentScrollPane = new ScrollPane();
        title.setText(Messages.getMessage("PdfPreferences.PrintingTitle"));
        VBox contentVBox = new VBox();
        Text generalOptions = new Text(Messages.getMessage("PdfPreferences.GeneralSection"));
        generalOptions.setFont(titleFont);
        HBox printerHBox = new HBox();
        printerHBox.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfViewerPrint.defaultPrinter")), printerCombo});
        HBox pageSizeHBox = new HBox();
        pageSizeHBox.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfViewerPrint.defaultPagesize")), paperSizesCombo});
        HBox defaultDPIHBox = new HBox();
        defaultDPIHBox.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfViewerPrint.defaultDPI")), defaultDPITF});
        HBox blackListHBox = new HBox();
        blackListHBox.getChildren().addAll((Object[])new Node[]{new Label(Messages.getMessage("PdfViewerPrint.blacklist")), blackListTF});
        contentVBox.setPadding(new Insets(10.0));
        contentVBox.setSpacing(10.0);
        contentVBox.getChildren().addAll((Object[])new Node[]{title, generalOptions, hiResPrintingCB, printerHBox, pageSizeHBox, defaultDPIHBox, blackListHBox});
        contentScrollPane.setContent((Node)contentVBox);
        return contentScrollPane;
    }

    private static ScrollPane getExtensionContent() {
        contentScrollPane = new ScrollPane();
        title.setText(Messages.getMessage("PdfPreferences.ExtensionsTitle"));
        VBox contentVBox = new VBox();
        GridPane contentGridPane = new GridPane();
        contentGridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(100.0), new ColumnConstraints(200.0)});
        Text nameTitle = new Text(Messages.getMessage("PdfPreferences.ExtensionName"));
        Text bcmailName = new Text("BCMail");
        Text cidName = new Text("CID");
        Text jceName = new Text("JCE");
        Text rhinoName = new Text("Rhino");
        nameTitle.setFont(titleFont);
        Text descriptionTitle = new Text(Messages.getMessage("PdfPreferences.ExtensionDescription"));
        Text bcmailDescr = new Text(Messages.getMessage("PdfExtensions.BCMail.text"));
        Text cidDescr = new Text(Messages.getMessage("PdfExtensions.CID.text"));
        Text jceDescr = new Text(Messages.getMessage("PdfExtensions.JCE.text"));
        Text rhinoDescr = new Text(Messages.getMessage("PdfExtensions.Rhino.text"));
        descriptionTitle.setFont(titleFont);
        Text versionTitle = new Text(Messages.getMessage("PdfPreferences.ExtensionVersion"));
        versionTitle.setFont(titleFont);
        Hyperlink bcmailVersion = new Hyperlink();
        String details = JavaFXPreferences.getBCMailVersion(bcmailVersion);
        Hyperlink cidVersion = new Hyperlink();
        details = details + JavaFXPreferences.getCidVersion(cidVersion);
        Hyperlink jceVersion = new Hyperlink();
        details = details + JavaFXPreferences.getJCEVersion(jceVersion);
        Hyperlink rhinoVersion = new Hyperlink();
        details = details + JavaFXPreferences.getRhinoVersion(rhinoVersion);
        Button copyBtn = JavaFXPreferences.createCopyDetailsButton(details);
        contentVBox.setPadding(new Insets(10.0));
        contentVBox.setSpacing(10.0);
        contentVBox.getChildren().addAll((Object[])new Node[]{title, contentGridPane, copyBtn});
        contentScrollPane.setContent((Node)contentVBox);
        int y = 0;
        JavaFXPreferences.addLineToExtensionGrid(contentGridPane, (Node)nameTitle, (Node)descriptionTitle, (Node)versionTitle, y);
        JavaFXPreferences.addLineToExtensionGrid(contentGridPane, (Node)bcmailName, (Node)bcmailDescr, (Node)bcmailVersion, ++y);
        JavaFXPreferences.addLineToExtensionGrid(contentGridPane, (Node)cidName, (Node)cidDescr, (Node)cidVersion, ++y);
        JavaFXPreferences.addLineToExtensionGrid(contentGridPane, (Node)jceName, (Node)jceDescr, (Node)jceVersion, ++y);
        JavaFXPreferences.addLineToExtensionGrid(contentGridPane, (Node)rhinoName, (Node)rhinoDescr, (Node)rhinoVersion, ++y);
        return contentScrollPane;
    }

    private static Button createCopyDetailsButton(String details) {
        Button copyBtn = new Button(Messages.getMessage("PdfPreferences.CopyToClipboard"));
        final String finalDetails = "java: " + System.getProperty("java.vendor") + ' ' + System.getProperty("java.version") + '\n' + "os: " + System.getProperty("os.name") + ' ' + System.getProperty("os.version") + ' ' + System.getProperty("os.arch") + '\n' + "jpedal: " + "6.6b14" + '\n' + details;
        copyBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                FXMessageDialog dialog = new FXMessageDialog(null, Modality.APPLICATION_MODAL, Messages.getMessage("PdfExtensions.clipboard"));
                dialog.show();
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent clipboardContent = new ClipboardContent();
                clipboardContent.putString(finalDetails);
                clipboard.setContent((Map)clipboardContent);
            }
        });
        return copyBtn;
    }

    private static String getRhinoVersion(Hyperlink versionNode) {
        String details = "";
        InputStream in = DefaultParser.class.getClassLoader().getResourceAsStream("org/mozilla/javascript/Context.class");
        if (in != null) {
            String version = ScriptRuntime.getMessage0((String)"implementation.version");
            details = details + "rhino: " + version + '\n';
            String release = "";
            if (!version.replaceAll("release 1", "").equals(version)) {
                release = " R1";
            }
            if (!version.replaceAll("release 2", "").equals(version)) {
                release = " R2";
            }
            version = version.substring(0, 12).replaceAll("[^0-9|.]", "");
            versionNode.setText(version + release);
        } else {
            versionNode.setText(Messages.getMessage("PdfExtensions.getText"));
            versionNode.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    try {
                        BrowserLauncher.openURL(Messages.getMessage("PdfExtensions.Rhino.link"));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        return details;
    }

    private static String getJCEVersion(Hyperlink versionNode) {
        String details = "";
        String version = "Unknown Version";
        try {
            Class<?> jcec = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
            String className = jcec.getName().replace('.', '/');
            String[] paths = jcec.getResource('/' + className + ".class").getPath().split("!");
            URL file = new URL(paths[0]);
            JarFile jar = new JarFile(file.getFile());
            if (!jar.getManifest().getMainAttributes().getValue("Implementation-Version").isEmpty()) {
                version = jar.getManifest().getMainAttributes().getValue("Implementation-Version");
            }
            versionNode.setText(version);
            details = details + "jce: " + version + '\n';
        }
        catch (Exception e) {
            versionNode.setText(Messages.getMessage("PdfExtensions.getText") + ' ' + e);
            versionNode.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    try {
                        BrowserLauncher.openURL(Messages.getMessage("PdfExtensions.JCE.link"));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        return details;
    }

    private static String getCidVersion(Hyperlink versionNode) {
        String details = "";
        try {
            if (JavaFXPreferences.class.getResourceAsStream("/org/jpedal/res/cid/00_ReadMe.pdf") != null) {
                versionNode.setText("1.0");
                details = details + "cid: 1.0\n";
            } else {
                versionNode.setText(Messages.getMessage("PdfExtensions.getText"));
                versionNode.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent e) {
                        try {
                            BrowserLauncher.openURL(Messages.getMessage("PdfExtensions.CID.link"));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return details;
    }

    private static String getBCMailVersion(Hyperlink versionNode) {
        String details = "";
        String version = "Unknown Version";
        try {
            Class<?> bcmailc = Class.forName("org.bouncycastle.jcajce.JcaJceHelper");
            String className = bcmailc.getName().replace('.', '/');
            String[] paths = bcmailc.getResource('/' + className + ".class").getPath().split("!");
            URL file = new URL(paths[0]);
            JarFile jar = new JarFile(file.getFile());
            if (!jar.getManifest().getMainAttributes().getValue("Implementation-Version").isEmpty()) {
                version = jar.getManifest().getMainAttributes().getValue("Implementation-Version");
            }
            versionNode.setText(version);
            details = details + "bcmail: " + version + '\n';
        }
        catch (Exception e) {
            versionNode.setText(Messages.getMessage("PdfExtensions.getText") + ' ' + e);
            versionNode.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    try {
                        BrowserLauncher.openURL(Messages.getMessage("PdfExtensions.BCMail.link"));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        return details;
    }

    private static void addLineToExtensionGrid(GridPane contentGridPane, Node name, Node desc, Node value, int y) {
        contentGridPane.add(name, 0, y);
        contentGridPane.add(desc, 1, y);
        contentGridPane.add(value, 2, y);
    }

    private static void updateSettings(GUIFactory currentGUI) {
        properties.setValue("resolution", String.valueOf(resolutionTF.getText()));
        properties.setValue("useHinting", String.valueOf(trueTypeCB.isSelected()));
        properties.setValue("autoScroll", String.valueOf(autoScrollCB.isSelected()));
        properties.setValue("confirmClose", String.valueOf(confirmCloseCB.isSelected()));
        properties.setValue("automaticupdate", String.valueOf(checkUpdatesCB.isSelected()));
        properties.setValue("openLastDocument", String.valueOf(openDocCB.isSelected()));
        properties.setValue("enhancedViewerMode", String.valueOf(enhancedViewerCB.isSelected()));
        properties.setValue("pageInsets", String.valueOf(pageInsetsTF.getText()));
        properties.setValue("enhancedFacingMode", String.valueOf(enablePageFlipCB.isSelected()));
        properties.setValue("previewOnSingleScroll", String.valueOf(scrollableThumbsCB.isSelected()));
        properties.setValue("windowTitle", String.valueOf(winTitleTF.getText()));
        String loc = iconLocTF.getText();
        if (!loc.endsWith("/") && !loc.endsWith("\\")) {
            loc = loc + '/';
        }
        properties.setValue("iconLocation", String.valueOf(loc));
        properties.setValue("searchWindowType", Integer.toString(searchStyle.getItems().indexOf(searchStyle.getValue())));
        properties.setValue("maxmultiviewers", String.valueOf(maxViewerTF.getText()));
        properties.setValue("sideTabBarCollapseLength", String.valueOf(sideTabTF.getText()));
        properties.setValue("consistentTabBar", String.valueOf(consistentSideTabCB.isSelected()));
        properties.setValue("allowRightClick", String.valueOf(rightClickCB.isSelected()));
        properties.setValue("allowScrollwheelZoom", String.valueOf(wheelZoomCB.isSelected()));
        properties.setValue("showMouseSelectionBox", String.valueOf(mouseSelectCB.isSelected()));
        properties.setValue("transitionType", transitionSelect.getSelectionModel().getSelectedItem().toString());
        ((JavaFxGUI)currentGUI).updateTransitionType();
        if (speech != null) {
            properties.setValue("voice", String.valueOf(voiceSelect.getValue()));
        }
        Color col = (Color)highlightsPicker.getValue();
        properties.setValue("highlightBoxColor", String.valueOf(JavaFXPreferences.shiftColorSpaceToSwing(col)));
        properties.setValue("highlightComposite", String.valueOf(highlightTF.getText()));
        properties.setValue("invertHighlights", String.valueOf(invertHighlightsCB.isSelected()));
        col = (Color)pageColorPicker.getValue();
        properties.setValue("vbgColor", String.valueOf(JavaFXPreferences.shiftColorSpaceToSwing(col)));
        properties.setValue("replaceDocumentTextColors", String.valueOf(replaceTextColorCB.isSelected()));
        col = (Color)displayBGColorPicker.getValue();
        properties.setValue("pdfDisplayBackground", String.valueOf(JavaFXPreferences.shiftColorSpaceToSwing(col)));
        properties.setValue("changeTextAndLineart", String.valueOf(changeLineArtColorCB.isSelected()));
        properties.setValue("replacePdfDisplayBackground", String.valueOf(replaceDisplayCB.isSelected()));
        col = (Color)textColorPicker.getValue();
        properties.setValue("vfgColor", String.valueOf(JavaFXPreferences.shiftColorSpaceToSwing(col)));
        properties.setValue("useHiResPrinting", String.valueOf(hiResPrintingCB.isSelected()));
        if (((String)printerCombo.getValue()).startsWith("System Default")) {
            properties.setValue("defaultPrinter", "");
        } else {
            properties.setValue("defaultPrinter", String.valueOf(printerCombo.getValue()));
        }
        properties.setValue("defaultPagesize", String.valueOf(paperSizesCombo.getValue()));
        properties.setValue("defaultDPI", String.valueOf(defaultDPITF.getText()));
        properties.setValue("printerBlacklist", String.valueOf(blackListTF.getText()));
        JavaFXPreferences.saveGUIPreferences(currentGUI);
    }

    private static void saveMenuPreferencesChildren(CheckBoxTreeItem<String> root, GUIFactory gui) {
        for (int i = 0; i != root.getChildren().size(); ++i) {
            CheckBoxTreeItem node = (CheckBoxTreeItem)root.getChildren().get(i);
            String value = (String)reverseMessage.get(node.getValue());
            if (node.isSelected()) {
                properties.setValue(value, "true");
                gui.alterProperty(value, true);
            } else {
                properties.setValue(value, "false");
                gui.alterProperty(value, false);
            }
            if (node.getChildren().isEmpty()) continue;
            JavaFXPreferences.saveMenuPreferencesChildren((CheckBoxTreeItem<String>)node, gui);
        }
    }

    private static void saveGUIPreferences(GUIFactory gui) {
        for (int i = 0; i != tabs.getTabs().size(); ++i) {
            Tab currentTab = (Tab)tabs.getTabs().get(i);
            TreeView tree = (TreeView)currentTab.getContent();
            CheckBoxTreeItem root = (CheckBoxTreeItem)tree.getRoot();
            if (root.getChildren().isEmpty()) continue;
            JavaFXPreferences.saveMenuPreferencesChildren((CheckBoxTreeItem<String>)root, gui);
        }
    }

    private static void loadSettings() {
        String propValue;
        block69: {
            propValue = properties.getValue("resolution");
            if (!propValue.isEmpty()) {
                resolutionTF.setText(propValue);
            } else {
                resolutionTF.setText("72");
            }
            propValue = properties.getValue("useHinting");
            if (!propValue.isEmpty() && propValue.equals("true")) {
                trueTypeCB.setSelected(true);
            } else {
                trueTypeCB.setSelected(false);
            }
            propValue = properties.getValue("autoScroll");
            if (propValue.equals("true")) {
                autoScrollCB.setSelected(true);
            } else {
                autoScrollCB.setSelected(false);
            }
            propValue = properties.getValue("confirmClose");
            if (propValue.equals("true")) {
                confirmCloseCB.setSelected(true);
            } else {
                confirmCloseCB.setSelected(false);
            }
            propValue = properties.getValue("automaticupdate");
            if (propValue.equals("true")) {
                checkUpdatesCB.setSelected(true);
            } else {
                checkUpdatesCB.setSelected(false);
            }
            propValue = properties.getValue("openLastDocument");
            if (propValue.equals("true")) {
                openDocCB.setSelected(true);
            } else {
                openDocCB.setSelected(false);
            }
            propValue = properties.getValue("enhancedViewerMode");
            if (!propValue.isEmpty() && propValue.equals("true")) {
                enhancedViewerCB.setSelected(true);
            } else {
                enhancedViewerCB.setSelected(false);
            }
            propValue = properties.getValue("borderType");
            if (!propValue.isEmpty()) {
                if (Integer.parseInt(propValue) == 1) {
                    showBorderCB.setSelected(true);
                } else {
                    showBorderCB.setSelected(false);
                }
            }
            if ((propValue = properties.getValue("pageInsets")) != null && !propValue.isEmpty()) {
                pageInsetsTF.setText(propValue);
            } else {
                pageInsetsTF.setText("25");
            }
            propValue = properties.getValue("startView");
            if (!propValue.isEmpty()) {
                int mode = Integer.parseInt(propValue);
                if (mode < 1 || mode > 5) {
                    mode = 1;
                }
                displayCombo.setValue(displayCombo.getItems().get(mode - 1));
            }
            if (!(propValue = properties.getValue("enhancedFacingMode")).isEmpty() && propValue.equals("true")) {
                enablePageFlipCB.setSelected(true);
            } else {
                enablePageFlipCB.setSelected(false);
            }
            propValue = properties.getValue("previewOnSingleScroll");
            if (!propValue.isEmpty() && propValue.equals("true")) {
                scrollableThumbsCB.setSelected(true);
            } else {
                scrollableThumbsCB.setSelected(false);
            }
            propValue = properties.getValue("windowTitle");
            if (propValue != null && !propValue.isEmpty()) {
                winTitleTF.setText(propValue);
            }
            if ((propValue = properties.getValue("iconLocation")) != null && !propValue.isEmpty()) {
                iconLocTF.setText(propValue);
            } else {
                iconLocTF.setText("/org/jpedal/examples/viewer/res/");
            }
            propValue = properties.getValue("searchWindowType");
            if (!propValue.isEmpty()) {
                int index = Integer.parseInt(propValue);
                if (index < searchStyle.getItems().size()) {
                    searchStyle.setValue(searchStyle.getItems().get(Integer.parseInt(propValue)));
                } else {
                    searchStyle.setValue(searchStyle.getItems().get(0));
                }
            } else {
                searchStyle.setValue(searchStyle.getItems().get(0));
            }
            propValue = properties.getValue("maxmultiviewers");
            if (!propValue.isEmpty()) {
                maxViewerTF.setText(propValue);
            } else {
                maxViewerTF.setText("20");
            }
            propValue = properties.getValue("sideTabBarCollapseLength");
            if (propValue != null && !propValue.isEmpty()) {
                sideTabTF.setText(propValue);
            } else {
                sideTabTF.setText("30");
            }
            propValue = properties.getValue("consistentTabBar");
            if (!propValue.isEmpty() && propValue.equals("true")) {
                consistentSideTabCB.setSelected(true);
            } else {
                consistentSideTabCB.setSelected(false);
            }
            propValue = properties.getValue("allowRightClick");
            if (!propValue.isEmpty() && propValue.equals("true")) {
                rightClickCB.setSelected(true);
            } else {
                rightClickCB.setSelected(false);
            }
            propValue = properties.getValue("allowScrollwheelZoom");
            if (!propValue.isEmpty() && propValue.equals("true")) {
                wheelZoomCB.setSelected(true);
            } else {
                wheelZoomCB.setSelected(false);
            }
            propValue = properties.getValue("showMouseSelectionBox");
            if (!propValue.isEmpty() && propValue.equalsIgnoreCase("true")) {
                mouseSelectCB.setSelected(true);
            } else {
                mouseSelectCB.setSelected(false);
            }
            voiceSelect.setValue((Object)properties.getValue("voice"));
            propValue = properties.getValue("transitionType");
            if (!propValue.isEmpty()) {
                transitionSelect.getSelectionModel().select((Object)propValue);
            }
            if (!(propValue = properties.getValue("useHiResPrinting")).isEmpty() && propValue.equals("true")) {
                hiResPrintingCB.setSelected(true);
            } else {
                hiResPrintingCB.setSelected(false);
            }
            propValue = properties.getValue("defaultPrinter");
            if (propValue != null && !propValue.isEmpty()) {
                printerCombo.setValue((Object)propValue);
            } else {
                PrintService defaultPrintService = PrintServiceLookup.lookupDefaultPrintService();
                if (defaultPrintService != null) {
                    printerCombo.setValue((Object)("System Default (" + defaultPrintService.getName() + ')'));
                } else {
                    printerCombo.setValue((Object)"System Default");
                }
            }
            propValue = properties.getValue("defaultDPI");
            if (propValue != null && !propValue.isEmpty()) {
                try {
                    propValue = propValue.replaceAll("[^0-9]", "");
                    defaultDPITF.setText(Integer.parseInt(propValue) + "dpi");
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block69;
                    LogWriter.writeLog("Exception attempting Load Printing Settings: " + e);
                }
            }
        }
        if ((propValue = properties.getValue("printerBlacklist")) != null && !propValue.isEmpty()) {
            blackListTF.setText(propValue);
        }
        int hBoxColor = !(propValue = properties.getValue("highlightBoxColor")).isEmpty() ? Integer.parseInt(propValue) : DecoderOptions.highlightColor.getRGB();
        highlightsPicker = new ColorPicker(JavaFXPreferences.shiftColorSpaceToFX(hBoxColor));
        highlightTF = new TextField();
        String hComposite = properties.getValue("highlightComposite");
        if (!hComposite.isEmpty()) {
            highlightTF.setText(hComposite);
        }
        invertHighlightsCB = new CheckBox(Messages.getMessage("PdfPreferences.InvertHighlight"));
        String invertHighlights = properties.getValue("invertHighlights");
        if (!invertHighlights.isEmpty() && invertHighlights.equalsIgnoreCase("true")) {
            invertHighlightsCB.setSelected(true);
        } else {
            invertHighlightsCB.setSelected(false);
        }
        propValue = properties.getValue("vbgColor");
        if (!propValue.isEmpty()) {
            hBoxColor = Integer.parseInt(propValue);
        } else if (DecoderOptions.backgroundColor != null) {
            hBoxColor = DecoderOptions.backgroundColor.getRGB();
        }
        pageColorPicker = new ColorPicker(JavaFXPreferences.shiftColorSpaceToFX(hBoxColor));
        replaceTextColorCB = new CheckBox("Replace Document Text Colors");
        String replaceTextCol = properties.getValue("replaceDocumentTextColors");
        if (!replaceTextCol.isEmpty() && replaceTextCol.equalsIgnoreCase("true")) {
            replaceTextColorCB.setSelected(true);
        } else {
            replaceTextColorCB.setSelected(false);
        }
        propValue = properties.getValue("vfgColor");
        if (!propValue.isEmpty()) {
            hBoxColor = Integer.parseInt(propValue);
        }
        textColorPicker = new ColorPicker(JavaFXPreferences.shiftColorSpaceToFX(hBoxColor));
        changeLineArtColorCB = new CheckBox("Change Color of Text and Line Art");
        String changeTextAndLineart = properties.getValue("changeTextAndLineart");
        if (!changeTextAndLineart.isEmpty() && changeTextAndLineart.equalsIgnoreCase("true")) {
            changeLineArtColorCB.setSelected(true);
        } else {
            changeLineArtColorCB.setSelected(false);
        }
        replaceDisplayCB = new CheckBox("Replace Display Background Color");
        String replaceDisplayCol = properties.getValue("replacePdfDisplayBackground");
        if (!replaceDisplayCol.isEmpty() && replaceDisplayCol.equalsIgnoreCase("true")) {
            replaceDisplayCB.setSelected(true);
        } else {
            replaceDisplayCB.setSelected(false);
        }
        propValue = properties.getValue("pdfDisplayBackground");
        if (!propValue.isEmpty()) {
            hBoxColor = Integer.parseInt(propValue);
        }
        displayBGColorPicker = new ColorPicker(JavaFXPreferences.shiftColorSpaceToFX(hBoxColor));
    }

    static {
        borderPane = new BorderPane();
        titleFont = Font.font((String)"SansSerif", (FontWeight)FontWeight.BOLD, (double)14.0);
        title = new Text(Messages.getMessage("PdfPreferences.GeneralSection"));
        printerCombo = new ComboBox();
        paperSizesCombo = new ComboBox();
    }
}

