/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.commands.javafx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXDialog;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.gui.GUIFactory;

public class JavaFXTipOfTheDay {
    private static FXDialog tipOfDayPopup;
    private static final List urls;
    private static final BorderPane border;
    private static WebEngine webEngine;
    private static int currentTip;
    private static final CheckBox show;

    public static void execute(Object[] args, GUIFactory currentGUI, PropertiesFile properties) {
        if (args == null) {
            try {
                JavaFXTipOfTheDay.populateTipsList("/org/jpedal/examples/viewer/res/tips");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            JavaFXTipOfTheDay.getTip(properties);
        }
    }

    private static void getTip(final PropertiesFile properties) {
        JavaFXTipOfTheDay.setupStage();
        JavaFXTipOfTheDay.bottomButtons();
        String propValue = properties.getValue("displaytipsonstartup");
        if (!propValue.isEmpty()) {
            show.setSelected(propValue.equals("true"));
        }
        show.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                properties.setValue("displaytipsonstartup", String.valueOf(show.isSelected()));
            }
        });
        tipOfDayPopup.show();
    }

    private static void setupStage() {
        tipOfDayPopup = new FXDialog(null, Modality.APPLICATION_MODAL, (Parent)border, 500.0, 400.0);
        tipOfDayPopup.setTitle("Tip Of The Day");
        HBox titleBar = new HBox();
        Label title = new Label("Did you know...?", (Node)new ImageView(new Image("/org/jpedal/examples/viewer/res/tip.png")));
        titleBar.getChildren().addAll((Object[])new Node[]{title});
        titleBar.setPadding(new Insets(10.0, 0.0, 20.0, 10.0));
        border.setTop((Node)titleBar);
        VBox middle = new VBox();
        Random r = new Random();
        currentTip = r.nextInt(urls.size());
        WebView centerTip = new WebView();
        webEngine = centerTip.getEngine();
        URL tip = JavaFXTipOfTheDay.class.getResource("/org/jpedal/examples/viewer/res/tips/apps/javabean.html");
        webEngine.load(tip.toExternalForm());
        middle.getChildren().addAll((Object[])new Node[]{centerTip});
        middle.setAlignment(Pos.CENTER);
        middle.setPadding(new Insets(0.0, 10.0, 20.0, 10.0));
        border.setCenter((Node)middle);
    }

    private static void bottomButtons() {
        HBox bottomButtons = new HBox();
        Button nextTip = new Button("Next Tip");
        nextTip.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                if (currentTip < urls.size() - 1) {
                    currentTip++;
                } else {
                    currentTip = 0;
                }
                URL urlNext = JavaFXTipOfTheDay.class.getResource(urls.get(currentTip).toString());
                webEngine.load(urlNext.toExternalForm());
            }
        });
        Button prevTip = new Button("Previous Tip");
        prevTip.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                if (currentTip < urls.size() && currentTip > 0) {
                    currentTip--;
                } else {
                    currentTip = urls.size() - 1;
                }
                URL urlPrev = JavaFXTipOfTheDay.class.getResource(urls.get(currentTip).toString());
                webEngine.load(urlPrev.toExternalForm());
            }
        });
        show.setAlignment(Pos.BOTTOM_LEFT);
        show.setPadding(new Insets(0.0, 0.0, 10.0, 10.0));
        Region space = new Region();
        HBox.setHgrow((Node)space, (Priority)Priority.ALWAYS);
        bottomButtons.getChildren().addAll((Object[])new Node[]{show, space, prevTip, nextTip});
        bottomButtons.setAlignment(Pos.BOTTOM_RIGHT);
        bottomButtons.setPadding(new Insets(0.0, 10.0, 10.0, 0.0));
        bottomButtons.setSpacing(10.0);
        border.setBottom((Node)bottomButtons);
    }

    private static void populateTipsList(String tipRoot) throws IOException {
        URL url = JavaFXTipOfTheDay.class.getResource(tipRoot);
        if (url.toString().startsWith("jar")) {
            JarURLConnection conn = (JarURLConnection)url.openConnection();
            JarFile jar = conn.getJarFile();
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !name.contains("/res/tips/") || !name.endsWith(".html")) continue;
                urls.add('/' + name);
            }
        } else {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((inputLine = in.readLine()) != null) {
                if (inputLine.indexOf(46) == -1) {
                    JavaFXTipOfTheDay.populateTipsList(tipRoot + '/' + inputLine);
                    continue;
                }
                if (!inputLine.endsWith(".htm") && !inputLine.endsWith(".html")) continue;
                urls.add(tipRoot + '/' + inputLine);
            }
            in.close();
        }
    }

    static {
        urls = new ArrayList();
        border = new BorderPane();
        show = new CheckBox("Show Tips On Start Up");
    }
}

