/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.util.Duration;
import javax.imageio.ImageIO;
import org.jpedal.FileAccess;
import org.jpedal.PdfDecoderFX;
import org.jpedal.PdfDecoderInt;
import org.jpedal.display.Display;
import org.jpedal.display.GUIModes;
import org.jpedal.display.GUIThumbnailPanel;
import org.jpedal.display.PageOffsets;
import org.jpedal.display.javafx.SingleDisplayFX;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.JavaFXRecentDocuments;
import org.jpedal.examples.viewer.RecentDocumentsFactory;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.OpenFile;
import org.jpedal.examples.viewer.commands.javafx.JavaFXOpenFile;
import org.jpedal.examples.viewer.gui.FXAdditionalData;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.GUIModifier;
import org.jpedal.examples.viewer.gui.PageMoveTracker;
import org.jpedal.examples.viewer.gui.SwingCursor;
import org.jpedal.examples.viewer.gui.generic.GUIButtons;
import org.jpedal.examples.viewer.gui.generic.GUICombo;
import org.jpedal.examples.viewer.gui.generic.GUIMenuItems;
import org.jpedal.examples.viewer.gui.generic.GUIMouseHandler;
import org.jpedal.examples.viewer.gui.generic.GUISearchList;
import org.jpedal.examples.viewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.viewer.gui.javafx.FXProgressBarWithText;
import org.jpedal.examples.viewer.gui.javafx.FXViewerTransitions;
import org.jpedal.examples.viewer.gui.javafx.JavaFXButtons;
import org.jpedal.examples.viewer.gui.javafx.JavaFXCombo;
import org.jpedal.examples.viewer.gui.javafx.JavaFXLayersPanel;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMenuItems;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMouseListener;
import org.jpedal.examples.viewer.gui.javafx.JavaFXOutline;
import org.jpedal.examples.viewer.gui.javafx.JavaFXPageChanger;
import org.jpedal.examples.viewer.gui.javafx.JavaFXSearchWindow;
import org.jpedal.examples.viewer.gui.javafx.JavaFXSignaturesPanel;
import org.jpedal.examples.viewer.gui.javafx.JavaFXThumbnailPanel;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXInputDialog;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXMessageDialog;
import org.jpedal.examples.viewer.gui.javafx.dialog.FXOptionDialog;
import org.jpedal.examples.viewer.gui.popups.PrintPanelFX;
import org.jpedal.examples.viewer.paper.PaperSizes;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.StatusBarFX;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.w3c.dom.Document;

public class JavaFxGUI
extends GUI
implements GUIFactory {
    private RefreshLayout viewListener;
    private static final int bottomPaneHeight = 40;
    protected final JavaFXButtons fxButtons;
    private final SwingCursor guiCursor = new SwingCursor();
    private GUIMouseHandler mouseHandler;
    private Timeline memoryMonitor;
    private boolean debugThumbnail;
    private boolean sideTabBarOpenByDefault;
    private String startSelectedTab = "Pages";
    public static String windowTitle;
    private boolean hasListener;
    private boolean isSetup;
    private int lastTabSelected = -1;
    private boolean tabsExpanded;
    private PaperSizes paperSizes;
    private HBox multiboxfx;
    private FXProgressBarWithText memoryBarFX;
    private TextField coordsFX;
    private static final boolean pageTurnScalingAppropriate = true;
    private HBox navButtons;
    private TabPane navOptionsPanel;
    private static final boolean firstTimeFormMessage = true;
    private boolean isSingle = true;
    private Label pageCounter1;
    public TextField pageCounter2;
    private Label pageCounter3;
    private final JavaFXSignaturesPanel signaturesPanel;
    private final JavaFXLayersPanel layersPanel;
    private boolean tabsNotInitialised = true;
    private boolean hasPageChanged;
    private ToolBar navToolBar;
    private ToolBar pagesToolBar;
    private final Stage stage;
    private Scene scene;
    private final BorderPane root;
    private static final int dropshadowDepth = 40;
    private Group group;
    private ScrollPane pageContainer;
    private SplitPane center;
    private final VBox topPane;
    private StatusBarFX downloadBar;
    private boolean searchInMenu;
    private TextField searchText;
    private GUISearchList results;
    private MenuBar options;
    private boolean cursorOverPage;
    private PrintPanelFX printPanel;
    private FXViewerTransitions.TransitionType transitionType = FXViewerTransitions.TransitionType.None;
    private ScrollBar pageScroll;
    private ChangeListener<Bounds> fxChangeListener;

    public JavaFxGUI(Stage stage, PdfDecoderInt decode_pdf, Values commonValues, GUIThumbnailPanel thumbnails, PropertiesFile properties) {
        super(decode_pdf, commonValues, thumbnails, properties);
        this.isJavaFX = true;
        this.stage = stage;
        this.root = new BorderPane();
        this.topPane = new VBox();
        this.pageCounter2 = new TextField();
        this.navButtons = new HBox();
        this.fxButtons = new JavaFXButtons();
        this.pageCounter3 = new Label();
        this.navToolBar = new ToolBar();
        this.pagesToolBar = new ToolBar();
        this.tree = new JavaFXOutline();
        this.layersPanel = new JavaFXLayersPanel();
        this.signaturesPanel = new JavaFXSignaturesPanel();
        this.setLookAndFeel();
        this.setupDisplay();
    }

    @Override
    public Object getThumbnailScrollBar() {
        return this.pageScroll;
    }

    @Override
    public void setThumbnailScrollBarVisibility(boolean isVisible) {
        this.pageScroll.setVisible(isVisible);
        if (isVisible) {
            this.pageScroll.setStyle("-fx-padding:0px");
        } else {
            this.pageScroll.setStyle("-fx-padding:-10px");
        }
    }

    @Override
    public void setThumbnailScrollBarValue(int pageNum) {
        this.pageScroll.setValue((double)pageNum);
    }

    private void setLookAndFeel() {
        this.root.getStylesheets().clear();
        this.root.getStylesheets().add((Object)this.getClass().getResource("/org/jpedal/examples/viewer/res/css/JavaFXForms.css").toExternalForm());
        this.root.getStylesheets().add((Object)this.getClass().getResource("/org/jpedal/examples/viewer/res/css/JavaFXPages.css").toExternalForm());
    }

    private void setupDisplay() {
        this.setDisplayView(1, 2);
        this.decode_pdf.addExternalHandler(this, 11);
        this.menuItems = new JavaFXMenuItems(this.properties);
    }

    public SplitPane getDisplayPane() {
        return this.center;
    }

    @Override
    public Object getMultiViewerFrames() {
        return null;
    }

    @Override
    public String getPropertiesFileLocation() {
        return this.properties.getConfigFile();
    }

    @Override
    public String getBookmark(String bookmark) {
        return this.tree.getPage(bookmark);
    }

    @Override
    public void reinitialiseTabs(boolean showVisible) {
        if (this.commonValues.getModeOfOperation() == 4) {
            return;
        }
        if (this.properties.getValue("ShowSidetabbar").equalsIgnoreCase("true")) {
            if (!this.isSingle) {
                return;
            }
            if (!showVisible && !this.properties.getValue("consistentTabBar").equalsIgnoreCase("true")) {
                if (this.sideTabBarOpenByDefault) {
                    this.setSplitDividerLocation(expandedSize);
                    this.tabsExpanded = true;
                } else {
                    this.setSplitDividerLocation(collapsedSize);
                    this.tabsExpanded = false;
                }
            }
            this.lastTabSelected = -1;
            if (!this.commonValues.isPDF()) {
                this.navOptionsPanel.setVisible(false);
            } else {
                int jj;
                int outlineTab;
                this.navOptionsPanel.setVisible(true);
                if (!this.decode_pdf.hasOutline()) {
                    outlineTab = -1;
                    if (DecoderOptions.isRunningOnMac) {
                        for (jj = 0; jj < this.navOptionsPanel.getTabs().size(); ++jj) {
                            if (!((Tab)this.navOptionsPanel.getTabs().get(jj)).getText().equals(this.bookmarksTitle)) continue;
                            outlineTab = jj;
                        }
                    } else {
                        for (jj = 0; jj < this.navOptionsPanel.getTabs().size(); ++jj) {
                            if (!((Tab)this.navOptionsPanel.getTabs().get(jj)).getText().equals(this.bookmarksTitle)) continue;
                            outlineTab = jj;
                        }
                    }
                    if (outlineTab != -1) {
                        this.navOptionsPanel.getTabs().remove(outlineTab);
                    }
                } else if (this.properties.getValue("Bookmarkstab").equalsIgnoreCase("true")) {
                    outlineTab = -1;
                    if (DecoderOptions.isRunningOnMac) {
                        for (jj = 0; jj < this.navOptionsPanel.getTabs().size(); ++jj) {
                            if (!((Tab)this.navOptionsPanel.getTabs().get(jj)).getText().equals(this.bookmarksTitle)) continue;
                            outlineTab = jj;
                        }
                        if (outlineTab == -1) {
                            this.navOptionsPanel.getTabs().add(this.navOptionsPanel.getTabs().size() - 1, (Object)((JavaFXOutline)this.tree));
                        }
                    } else {
                        for (jj = 0; jj < this.navOptionsPanel.getTabs().size(); ++jj) {
                            if (!((Tab)this.navOptionsPanel.getTabs().get(jj)).getText().equals(this.bookmarksTitle)) continue;
                            outlineTab = jj;
                        }
                        if (outlineTab == -1) {
                            this.navOptionsPanel.getTabs().add(this.navOptionsPanel.getTabs().size() - 1, (Object)((JavaFXOutline)this.tree));
                        }
                    }
                }
                AcroRenderer currentFormRenderer = this.decode_pdf.getFormRenderer();
                Iterator<FormObject> signatureObjects = null;
                if (currentFormRenderer != null) {
                    signatureObjects = currentFormRenderer.getSignatureObjects();
                }
                if (signatureObjects != null) {
                    this.signaturesPanel.reinitialise(this.decode_pdf, signatureObjects);
                    this.checkTabShown(this.signaturesTitle);
                } else {
                    this.removeTab(this.signaturesTitle);
                }
                this.layersObject = (PdfLayerList)this.decode_pdf.getJPedalObject(826881374);
                if (this.layersObject != null && this.layersObject.getLayersCount() > 0) {
                    this.checkTabShown(this.layersTitle);
                    this.layersPanel.reinitialise(this.layersObject, this.decode_pdf, null, this.commonValues.getCurrentPage());
                } else {
                    this.removeTab(this.layersTitle);
                }
                this.setBookmarks(false);
            }
            if (this.tabsNotInitialised) {
                for (int i = 0; i != this.navOptionsPanel.getTabs().size(); ++i) {
                    if (DecoderOptions.isRunningOnMac) {
                        if (!((Tab)this.navOptionsPanel.getTabs().get(i)).getText().equals(this.startSelectedTab)) continue;
                        this.navOptionsPanel.getSelectionModel().select(i);
                        break;
                    }
                    if (!((Tab)this.navOptionsPanel.getTabs().get(i)).getGraphic().toString().equals(this.startSelectedTab)) continue;
                    this.navOptionsPanel.getSelectionModel().select(i);
                    break;
                }
            }
        }
    }

    private void checkTabShown(String title) {
        int outlineTab = -1;
        if (DecoderOptions.isRunningOnMac) {
            for (int jj = 0; jj < this.navOptionsPanel.getTabs().size(); ++jj) {
                if (!((Tab)this.navOptionsPanel.getTabs().get(jj)).getText().equals(title)) continue;
                outlineTab = jj;
            }
            if (outlineTab == -1) {
                if (title.equals(this.signaturesTitle) && this.properties.getValue("Signaturestab").equalsIgnoreCase("true")) {
                    this.navOptionsPanel.getTabs().add(this.navOptionsPanel.getTabs().size() - 1, (Object)this.signaturesPanel);
                } else if (title.equals(this.layersTitle) && this.properties.getValue("Layerstab").equalsIgnoreCase("true")) {
                    this.navOptionsPanel.getTabs().add(this.navOptionsPanel.getTabs().size() - 1, (Object)this.layersPanel);
                }
            }
        } else {
            for (int jj = 0; jj < this.navOptionsPanel.getTabs().size(); ++jj) {
                if (!((Tab)this.navOptionsPanel.getTabs().get(jj)).getText().equals(title)) continue;
                outlineTab = jj;
            }
            if (outlineTab == -1) {
                if (title.equals(this.signaturesTitle) && this.properties.getValue("Signaturestab").equalsIgnoreCase("true")) {
                    this.navOptionsPanel.getTabs().add(this.navOptionsPanel.getTabs().size() - 1, (Object)this.signaturesPanel);
                } else if (title.equals(this.layersTitle) && this.properties.getValue("Layerstab").equalsIgnoreCase("true")) {
                    this.navOptionsPanel.getTabs().add(this.navOptionsPanel.getTabs().size() - 1, (Object)this.layersPanel);
                }
            }
        }
    }

    private void removeTab(String title) {
        int outlineTab = -1;
        if (DecoderOptions.isRunningOnMac) {
            for (int jj = 0; jj < this.navOptionsPanel.getTabs().size(); ++jj) {
                if (!((Tab)this.navOptionsPanel.getTabs().get(jj)).getText().equals(title)) continue;
                outlineTab = jj;
            }
        } else {
            for (int jj = 0; jj < this.navOptionsPanel.getTabs().size(); ++jj) {
                if (!((Tab)this.navOptionsPanel.getTabs().get(jj)).getText().equals(title)) continue;
                outlineTab = jj;
            }
        }
        if (outlineTab != -1) {
            this.navOptionsPanel.getTabs().remove(outlineTab);
        }
    }

    @Override
    public void stopThumbnails() {
        if (!this.isSingle) {
            return;
        }
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.terminateDrawing();
            this.thumbnails.removeAllListeners();
        }
    }

    @Override
    public void reinitThumbnails() {
        this.isSetup = false;
    }

    @Override
    public void resetNavBar() {
        if (!this.isSingle) {
            return;
        }
        if (!this.properties.getValue("consistentTabBar").equalsIgnoreCase("true")) {
            this.setSplitDividerLocation(collapsedSize);
            this.tabsExpanded = false;
            this.tabsNotInitialised = true;
        }
        this.fxButtons.setPageLayoutButtonsEnabled(false);
    }

    @Override
    public void setNoPagesDecoded() {
        this.bookmarksGenerated = false;
        this.resetNavBar();
    }

    @Override
    public void setDisplayMode(Integer mode) {
        if (mode.equals(GUIFactory.MULTIPAGE)) {
            this.isSingle = false;
        }
    }

    @Override
    public boolean isSingle() {
        return this.isSingle;
    }

    @Override
    public Object getThumbnailPanel() {
        return this.thumbnails;
    }

    @Override
    public Object getOutlinePanel() {
        return this.tree;
    }

    @Override
    public Object getVerticalScrollBar() {
        if (this.pageScroll.isVisible()) {
            return this.pageScroll;
        }
        return null;
    }

    @Override
    public void setRootContainer(Object rawValue) {
        String customWindowSize;
        if (rawValue == null) {
            throw new RuntimeException("Null containers not allowed.");
        }
        Parent parentPane = (Parent)rawValue;
        if (parentPane instanceof Pane) {
            ((Pane)parentPane).getChildren().add((Object)this.root);
        } else if (parentPane instanceof ScrollPane) {
            ((ScrollPane)parentPane).setContent((Node)this.root);
        }
        int width = Integer.parseInt(this.properties.getValue("startViewerWidth"));
        int height = Integer.parseInt(this.properties.getValue("startViewerHeight"));
        Rectangle2D d = Screen.getPrimary().getVisualBounds();
        if (width < 0) {
            width = (int)(d.getWidth() / 2.0);
            if (width < 700) {
                width = 700;
            }
            this.properties.setValue("startViewerWidth", String.valueOf(width));
        }
        if (height < 0) {
            height = (int)(d.getHeight() / 2.0);
            this.properties.setValue("startViewerHeight", String.valueOf(height));
        }
        if ((customWindowSize = System.getProperty("org.jpedal.startWindowSize")) != null) {
            StringTokenizer values = new StringTokenizer(customWindowSize, "x");
            System.out.println(values.countTokens());
            if (values.countTokens() != 2) {
                throw new RuntimeException("Unable to use value for org.jpedal.startWindowSize=" + customWindowSize + "\nValue should be in format org.jpedal.startWindowSize=200x300");
            }
        }
    }

    @Override
    public void resetRotationBox() {
        PdfPageData currentPageData = this.decode_pdf.getPdfPageData();
        if (this.decode_pdf.getDisplayView() == 1) {
            this.rotation = currentPageData.getRotation(this.commonValues.getCurrentPage());
        }
        if (this.getSelectedComboIndex(251) != this.rotation / 90) {
            this.setSelectedComboIndex(251, this.rotation / 90);
        } else if (!Values.isProcessing()) {
            // empty if block
        }
    }

    @Override
    public PropertiesFile getProperties() {
        return this.properties;
    }

    @Override
    public void searchInTab(GUISearchWindow searchFrame) {
        this.searchFrame = searchFrame;
        this.searchFrame.init(this.decode_pdf, this.commonValues);
        if (!DecoderOptions.isRunningOnMac || this.thumbnails.isShownOnscreen()) {
            // empty if block
        }
    }

    private MenuBar createMenuBarSearchOptions() {
        final CheckMenuItem cb1 = new CheckMenuItem(Messages.getMessage("PdfViewerSearch.WholeWords"));
        final CheckMenuItem cb2 = new CheckMenuItem(Messages.getMessage("PdfViewerSearch.CaseSense"));
        final CheckMenuItem cb3 = new CheckMenuItem(Messages.getMessage("PdfViewerSearch.MultiLine"));
        cb1.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue ov, Boolean old_val, Boolean new_val) {
                JavaFxGUI.this.searchFrame.setWholeWords(cb1.isSelected());
            }
        });
        cb2.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue ov, Boolean old_val, Boolean new_val) {
                JavaFxGUI.this.searchFrame.setCaseSensitive(cb2.isSelected());
            }
        });
        cb3.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue ov, Boolean old_val, Boolean new_val) {
                JavaFxGUI.this.searchFrame.setMultiLine(cb3.isSelected());
            }
        });
        Menu menu = new Menu();
        Image image = new Image(this.guiCursor.getURLForImage("menuSearchOptions.png").toString());
        menu.setGraphic((Node)new ImageView(image));
        menu.getItems().addAll((Object[])new MenuItem[]{cb1, cb2, cb3});
        this.options = new MenuBar();
        this.options.setBackground(Background.EMPTY);
        this.options.setFocusTraversable(false);
        this.options.setTooltip(new Tooltip(Messages.getMessage("PdfViewerSearch.Options")));
        this.options.getMenus().add((Object)menu);
        return this.options;
    }

    private void searchInMenu(GUISearchWindow searchFrame) {
        this.searchFrame = searchFrame;
        this.searchInMenu = true;
        searchFrame.find(this.decode_pdf, this.commonValues);
        this.fxButtons.getTopButtons().getItems().add((Object)this.searchText);
        this.fxButtons.getTopButtons().getItems().add((Object)this.createMenuBarSearchOptions());
        this.fxButtons.addButton(0, Messages.getMessage("PdfViewerSearch.Previous"), "search_previous.gif", 18, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.fxButtons.addButton(0, Messages.getMessage("PdfViewerSearch.Next"), "search_next.gif", 19, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.fxButtons.getButton(19).setEnabled(false);
        this.fxButtons.getButton(18).setEnabled(false);
        this.fxButtons.getButton(19).setVisible(true);
        this.fxButtons.getButton(18).setVisible(true);
    }

    @Override
    public void setPropertiesFileLocation(String file) {
        this.properties.loadProperties(file);
    }

    @Override
    public Commands getCommand() {
        return this.currentCommands;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void init(Commands currentCommands, Object currentPrinter) {
        this.updateTransitionType();
        this.mouseHandler = new JavaFXMouseListener((PdfDecoderFX)this.decode_pdf, this, this.commonValues, currentCommands);
        this.mouseHandler.setupMouse();
        super.init(currentCommands);
        try {
            this.propValue = this.properties.getValue("useHinting");
            this.propValue2 = System.getProperty("org.jpedal.useTTFontHinting");
            if (this.propValue2 != null) {
                if (!this.propValue.isEmpty() && !this.propValue2.equalsIgnoreCase(this.propValue.toLowerCase())) {
                    this.showMessageDialog(Messages.getMessage("PdfCustomGui.hintingFlagFileConflict"));
                }
                TTGlyph.useHinting = this.propValue2.equalsIgnoreCase("true");
            } else {
                TTGlyph.useHinting = !this.propValue.isEmpty() && this.propValue.equalsIgnoreCase("true");
            }
            this.propValue = this.properties.getValue("iconLocation");
            if (this.propValue.isEmpty()) {
                // empty if block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setupComboBoxes();
        this.fxButtons.init(this.isSingle);
        this.createTopMenuBar();
        this.createOtherToolBars();
        this.setupBottomToolBarItems();
        this.fxButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.openFile"), "open.gif", 10, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.fxButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.print"), "print.gif", 6, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        if (this.searchFrame != null && (this.searchFrame.getViewStyle() == 0 || this.searchFrame.getViewStyle() == 2 && !this.isSingle)) {
            this.searchFrame.setViewStyle(0);
            this.fxButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.search"), "find.gif", 12, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        }
        this.fxButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.properties"), "properties.gif", 9, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        if (this.commonValues.getModeOfOperation() == 4) {
            this.fxButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.about"), "about.gif", 1, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        }
        this.fxButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.snapshot"), "snapshot.gif", 13, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        Separator sep = new Separator();
        sep.setPrefSize(5.0, 32.0);
        this.addCombo(Messages.getMessage("PdfViewerToolbarScaling.text"), Messages.getMessage("PdfViewerToolbarTooltip.zoomin"), 252);
        this.addCombo(Messages.getMessage("PdfViewerToolbarRotation.text"), Messages.getMessage("PdfViewerToolbarTooltip.rotation"), 251);
        this.fxButtons.addButton(0, Messages.getMessage("PdfViewerToolbarTooltip.mouseMode"), "mouse_select.png", 29, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.fxButtons.getTopButtons().getItems().add((Object)sep);
        this.initMultiBox();
        this.createNavbar();
        if (this.searchFrame != null && this.searchFrame.getViewStyle() == 2 && this.isSingle) {
            this.searchInMenu(this.searchFrame);
        }
        this.initStatus();
        if (this.commonValues.getModeOfOperation() != 1) {
            String customWindowSize;
            int width = Integer.parseInt(this.properties.getValue("startViewerWidth"));
            int height = Integer.parseInt(this.properties.getValue("startViewerHeight"));
            Rectangle2D d = Screen.getPrimary().getVisualBounds();
            if (width < 0) {
                width = (int)d.getWidth() / 2;
                if (width < 700) {
                    width = 700;
                }
                this.properties.setValue("startViewerWidth", String.valueOf(width));
            }
            if (height < 0) {
                height = (int)d.getHeight() / 2;
                this.properties.setValue("startViewerHeight", String.valueOf(height));
            }
            if ((customWindowSize = System.getProperty("org.jpedal.startWindowSize")) != null) {
                StringTokenizer values = new StringTokenizer(customWindowSize, "x");
                System.out.println(values.countTokens());
                if (values.countTokens() != 2) {
                    throw new RuntimeException("Unable to use value for org.jpedal.startWindowSize=" + customWindowSize + "\nValue should be in format org.jpedal.startWindowSize=200x300");
                }
                try {
                    width = Integer.parseInt(values.nextToken().trim());
                    height = Integer.parseInt(values.nextToken().trim());
                }
                catch (Exception ee) {
                    throw new RuntimeException("Unable to use value for org.jpedal.startWindowSize=" + customWindowSize + "\nValue should be in format org.jpedal.startWindowSize=200x300 " + ee);
                }
            }
            this.setupPDFDisplayPane(width, height);
            this.setupBorderPanes();
            this.createMainViewerWindow(width, height);
        }
        this.setupCenterPanelBackground();
        this.setupPDFBorder();
        if (this.sideTabBarOpenByDefault) {
            this.setSplitDividerLocation(expandedSize);
            this.tabsExpanded = true;
        } else {
            this.setSplitDividerLocation(collapsedSize);
            this.tabsExpanded = false;
        }
        try {
            GUIModifier.load(this.properties, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int ALL = -10;
        ((JavaFXMenuItems)this.menuItems).disableUnimplementedItems(-10, false);
        this.fxButtons.disableUnimplementedItems(-10);
    }

    @Override
    protected void createOtherToolBars() {
        this.menuItems.createMainMenu(true, this.currentCommandListener, this.isSingle, this.commonValues, this.currentCommands, this.fxButtons);
        this.topPane.getChildren().add((Object)((JavaFXMenuItems)this.menuItems).getCurrentMenuFX());
        this.topPane.getChildren().add((Object)this.fxButtons.getTopButtons());
    }

    private void handleTabbedPanes() {
        if (this.tabsNotInitialised) {
            return;
        }
        int tabSelected = this.navOptionsPanel.getSelectionModel().getSelectedIndex();
        if (tabSelected == -1) {
            return;
        }
        if (!this.tabsExpanded) {
            String tabName = ((Tab)this.navOptionsPanel.getTabs().get(tabSelected)).getText();
            if (tabName != null && tabName.equals(this.pageTitle)) {
                this.thumbnails.setIsDisplayedOnscreen(true);
            } else {
                this.thumbnails.setIsDisplayedOnscreen(false);
            }
            if (!((Tab)this.navOptionsPanel.getSelectionModel().getSelectedItem()).isDisable()) {
                this.setSplitDividerLocation(expandedSize);
                this.tabsExpanded = true;
            }
        } else if (this.lastTabSelected == tabSelected && !this.hasPageChanged) {
            this.setSplitDividerLocation(collapsedSize);
            this.tabsExpanded = false;
            this.thumbnails.setIsDisplayedOnscreen(false);
        }
        this.lastTabSelected = tabSelected;
        this.hasPageChanged = false;
    }

    private void initMultiBox() {
        this.multiboxfx = new HBox();
        this.initCoordBox();
        this.initMemoryBar();
        this.initDownloadBar();
    }

    @Override
    public void setMultibox(int[] flags) {
        if (flags.length > 1 && flags[0] == 1) {
            if (this.cursorOverPage != (flags[1] == 1)) {
                this.cursorOverPage = flags[1] == 1;
            } else {
                return;
            }
        }
        if (this.cursorOverPage && this.decode_pdf.isOpen()) {
            this.multiboxfx.getChildren().clear();
            this.multiboxfx.getChildren().add((Object)this.coordsFX);
            return;
        }
        if (!(this.downloadBar.isDisable() || !this.downloadBar.isVisible() || this.downloadBar.isDone() || !this.decode_pdf.isLoadingLinearizedPDF() && this.decode_pdf.isOpen())) {
            this.multiboxfx.getChildren().clear();
            this.multiboxfx.getChildren().add((Object)this.downloadBar.getStatusObject());
            return;
        }
        if (this.memoryBarFX.isVisible()) {
            this.multiboxfx.getChildren().clear();
            this.multiboxfx.getChildren().add((Object)this.memoryBarFX);
        }
    }

    private void initDownloadBar() {
        this.downloadBar = new StatusBarFX(new Color(0.7254901960784313, 0.8196078431372549, 0.0, 1.0));
        this.downloadBar.getStatusObject().prefHeightProperty().bind((ObservableValue)this.multiboxfx.heightProperty());
        this.downloadBar.getStatusObject().prefWidthProperty().bind((ObservableValue)this.multiboxfx.widthProperty());
        this.downloadBar.setVisible(false);
    }

    private void initMemoryBar() {
        this.memoryBarFX = new FXProgressBarWithText();
        this.memoryBarFX.prefHeightProperty().bind((ObservableValue)this.multiboxfx.heightProperty());
        this.memoryBarFX.prefWidthProperty().bind((ObservableValue)this.multiboxfx.widthProperty());
        if (this.memoryMonitor == null) {
            this.memoryMonitor = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.5), (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    final int free = (int)(Runtime.getRuntime().freeMemory() / 0x100000L);
                    final int total = (int)(Runtime.getRuntime().totalMemory() / 0x100000L);
                    final double used = (double)(total - free) / (double)total;
                    if (JavaFxGUI.this.finishedDecoding) {
                        JavaFxGUI.this.finishedDecoding = false;
                    }
                    if (Platform.isFxApplicationThread()) {
                        JavaFxGUI.this.memoryBarFX.setProgress(used);
                        JavaFxGUI.this.memoryBarFX.setText(total - free + "M of " + total + 'M');
                    } else {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                JavaFxGUI.this.memoryBarFX.setProgress(used);
                                JavaFxGUI.this.memoryBarFX.setText(total - free + "M of " + total + 'M');
                            }
                        });
                    }
                }
            }, new KeyValue[0])});
            this.memoryMonitor.setCycleCount(-1);
            this.memoryMonitor.play();
        }
    }

    @Override
    protected void setViewerIcon() {
        block3: {
            URL path = this.guiCursor.getURLForImage("icon.png");
            if (this.stage != null && path != null) {
                try {
                    BufferedImage bi = ImageIO.read(path);
                    WritableImage fontIcon = new WritableImage(bi.getWidth(), bi.getHeight());
                    fontIcon = SwingFXUtils.toFXImage((BufferedImage)bi, (WritableImage)fontIcon);
                    this.stage.getIcons().add((Object)fontIcon);
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception attempting to set Icon " + e);
                }
            }
        }
    }

    private boolean setDisplayView2(int displayView, int orientation) {
        DynamicVectorRenderer currentDisplay;
        boolean needsReset;
        DecoderOptions options = this.decode_pdf.getDecoderOptions();
        Display pages = this.decode_pdf.getPages();
        int lastDisplayView = this.decode_pdf.getDisplayView();
        FileAccess fileAccess = (FileAccess)this.decode_pdf.getExternalHandler(35);
        int pageNumber = this.decode_pdf.getPageNumber();
        ExternalHandlers externalHandlers = this.decode_pdf.getExternalHandler();
        PdfDecoderFX comp = (PdfDecoderFX)this.decode_pdf;
        final Pane highlightsPane = comp.highlightsPane;
        options.setPageAlignment(orientation);
        if (pages != null) {
            pages.stopGeneratingPage();
        }
        if (Platform.isFxApplicationThread()) {
            if (highlightsPane != null && highlightsPane.getParent() != null) {
                ((Group)highlightsPane.getParent()).getChildren().remove((Object)highlightsPane);
            }
        } else {
            Runnable doPaintComponent = new Runnable(){

                @Override
                public void run() {
                    if (highlightsPane != null && highlightsPane.getParent() != null) {
                        ((Group)highlightsPane.getParent()).getChildren().remove((Object)highlightsPane);
                    }
                }
            };
            Platform.runLater((Runnable)doPaintComponent);
        }
        boolean bl = needsReset = displayView != 1 || lastDisplayView != 1;
        if (needsReset && (lastDisplayView == 4 || displayView == 4)) {
            needsReset = false;
        }
        boolean hasChanged = displayView != lastDisplayView;
        options.setDisplayView(displayView);
        if (lastDisplayView != displayView && lastDisplayView == 5) {
            pages.dispose();
        }
        Object customFXHandle = externalHandlers.getExternalHandler(4);
        switch (displayView) {
            case 1: {
                if (pages != null && !hasChanged) break;
                currentDisplay = this.decode_pdf.getDynamicRenderer();
                pages = new SingleDisplayFX(pageNumber, currentDisplay, comp, options);
                break;
            }
        }
        if (lastDisplayView != 5 || displayView != 5) {
            // empty if block
        }
        if (fileAccess.getOffset() == null) {
            fileAccess.setOffset(new PageOffsets(this.decode_pdf.getPageCount(), this.decode_pdf.getPdfPageData()));
        }
        pages.setup(options.useHardwareAcceleration(), fileAccess.getOffset());
        currentDisplay = this.decode_pdf.getDynamicRenderer();
        if (this.decode_pdf.isOpen()) {
            pages.init(this.scaling, this.decode_pdf.getDisplayRotation(), pageNumber, currentDisplay, true);
        }
        pages.forceRedraw();
        pages.refreshDisplay();
        comp.pages = pages;
        return hasChanged;
    }

    @Override
    public void setDisplayView(int displayView, int orientation) {
        block12: {
            if (this.viewListener != null) {
                this.removeComponentListener(this.viewListener);
                this.viewListener.dispose();
                this.viewListener = null;
            }
            boolean hasChanged = this.setDisplayView2(displayView, orientation);
            int pageNumber = this.decode_pdf.getPageNumber();
            if (pageNumber > 0) {
                if (hasChanged && displayView == 1 && this.decode_pdf.isOpen()) {
                    try {
                        this.decode_pdf.getPages().getYCordForPage(pageNumber, this.scaling);
                        this.decode_pdf.setPageParameters(this.scaling, pageNumber, this.decode_pdf.getDisplayRotation());
                        this.decode_pdf.decodePage(pageNumber);
                    }
                    catch (Exception e) {
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("Exception: " + e.getMessage());
                        }
                        break block12;
                    }
                }
                if (displayView == 2 || displayView == 3) {
                    try {
                        this.decode_pdf.getPages().getYCordForPage(pageNumber, this.scaling);
                        this.decode_pdf.setPageParameters(this.scaling, pageNumber, this.decode_pdf.getDisplayRotation());
                        this.decode_pdf.decodePage(pageNumber);
                        this.scrollToPage(pageNumber);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        if (displayView != 1 && displayView != 2 && displayView != 3) {
            this.enableSearchItems(false);
        } else {
            this.enableSearchItems(true);
        }
        if (this.viewListener == null) {
            this.viewListener = new RefreshLayout(this.decode_pdf);
            this.addComponentListener(this.viewListener);
        }
    }

    @Override
    protected void setTitle(String title) {
        if (this.stage != null) {
            this.stage.setTitle(title);
        }
    }

    @Override
    public void resetComboBoxes(boolean value) {
        if (this.properties.getValue("Imageopdisplay").equalsIgnoreCase("true")) {
            this.qualityBox.setEnabled(value);
        }
        this.scalingBox.setEnabled(value);
        this.rotationBox.setEnabled(value);
    }

    @Override
    public GUICombo getCombo(int ID2) {
        switch (ID2) {
            case 250: {
                return this.qualityBox;
            }
            case 252: {
                return this.scalingBox;
            }
            case 251: {
                return this.rotationBox;
            }
        }
        return null;
    }

    @Override
    public void scaleAndRotate() {
        if (this.decode_pdf.getDisplayView() == 5) {
            this.decode_pdf.setPageParameters(this.scaling, this.commonValues.getCurrentPage(), this.rotation);
            return;
        }
        if (!this.decode_pdf.isOpen() && OpenFile.isPDf) {
            return;
        }
        double width = this.pageContainer.getViewportBounds().getWidth() * 0.95;
        double height = this.pageContainer.getViewportBounds().getHeight() * 0.95;
        float tempScaling = 1.5f;
        if (this.decode_pdf != null) {
            for (int i = 0; i < this.group.getChildren().size(); ++i) {
                if (((Node)this.group.getChildren().get(i)).equals(this.decode_pdf)) continue;
                this.group.getChildren().remove(this.group.getChildren().get(i));
            }
            int index = this.getSelectedComboIndex(252);
            if (this.decode_pdf.getDisplayView() == 5) {
                this.setSelectedComboIndex(252, 0);
                index = 0;
                this.scalingBox.setEnabled(false);
            } else if (this.decode_pdf.getDisplayView() != 5) {
                this.scalingBox.setEnabled(true);
            }
            int page = this.commonValues.getCurrentPage();
            if (this.commonValues.isMultiTiff()) {
                page = 1;
            }
            if (index != -1) {
                int tw = 0;
                int th = 0;
                PdfPageData pData = this.decode_pdf.getPdfPageData();
                int curPW = pData.getCropBoxWidth(page);
                int curPH = pData.getCropBoxHeight(page);
                switch (this.rotation) {
                    case 0: {
                        tw = curPW;
                        th = curPH;
                        break;
                    }
                    case 90: {
                        tw = curPH;
                        th = curPW;
                        break;
                    }
                    case 180: {
                        tw = curPW;
                        th = curPH;
                        break;
                    }
                    case 270: {
                        tw = curPH;
                        th = curPW;
                    }
                }
                switch (this.decode_pdf.getDisplayView()) {
                    case 1: {
                        switch (index) {
                            case 0: {
                                tempScaling = (float)JavaFxGUI.getScalingRatio(tw, th, width, height);
                                break;
                            }
                            case 1: {
                                tempScaling = (float)(height / (double)th);
                                break;
                            }
                            case 2: {
                                tempScaling = (float)(width / (double)tw);
                                break;
                            }
                            default: {
                                tempScaling = this.decode_pdf.getDPIFactory().adjustScaling(this.scalingFloatValues[index]);
                            }
                        }
                        double sw = (int)(tempScaling * (float)tw);
                        double sh = (int)(tempScaling * (float)th);
                        if (sw < width) {
                            this.group.setTranslateX((width - sw) / 2.0);
                        } else {
                            this.group.setTranslateX(0.0);
                        }
                        if (!(sh < height) || sw < width) {
                            // empty if block
                        }
                        this.group.setTranslateY(0.0);
                        break;
                    }
                    case 2: {
                        switch (index) {
                            case 0: {
                                tempScaling = (float)JavaFxGUI.getScalingRatio(tw, th, width, height);
                                break;
                            }
                            case 1: {
                                tempScaling = (float)(height / (double)th);
                                break;
                            }
                            case 2: {
                                tempScaling = (float)(width / (double)tw);
                                break;
                            }
                            default: {
                                tempScaling = this.decode_pdf.getDPIFactory().adjustScaling(this.scalingFloatValues[index]);
                            }
                        }
                        double sw = (int)(tempScaling * (float)tw);
                        if (sw < width) {
                            this.group.setTranslateX((width - sw) / 2.0);
                        } else {
                            this.group.setTranslateX(0.0);
                        }
                        this.group.setTranslateY(0.0);
                        break;
                    }
                    case 3: {
                        tw *= 2;
                        switch (index) {
                            case 0: {
                                tempScaling = (float)JavaFxGUI.getScalingRatio(tw, th, width, height);
                                break;
                            }
                            case 1: {
                                tempScaling = (float)(height / (double)th);
                                break;
                            }
                            case 2: {
                                tempScaling = (float)(width / (double)tw);
                                break;
                            }
                            default: {
                                tempScaling = this.decode_pdf.getDPIFactory().adjustScaling(this.scalingFloatValues[index]);
                            }
                        }
                        double sw = (int)(tempScaling * (float)tw);
                        if (sw < width) {
                            this.group.setTranslateX((width - sw) / 2.0);
                        } else {
                            this.group.setTranslateX(0.0);
                        }
                        this.group.setTranslateY(0.0);
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    default: {
                        System.err.println("unsupported page display ");
                    }
                }
            }
            this.scaling = tempScaling;
            if (Float.isInfinite(this.scaling)) {
                this.scaling = 1.0f;
            }
            this.decode_pdf.setPageParameters(this.scaling, page, this.rotation);
        }
    }

    public static double getScalingRatio(double actualW, double actualH, double maxW, double maxH) {
        return Math.min(maxW / actualW, maxH / actualH);
    }

    @Override
    public void snapScalingToDefaults(float newScaling) {
        float window_factor;
        int ch;
        int cw;
        newScaling = this.decode_pdf.getDPIFactory().adjustScaling(newScaling / 100.0f);
        float width = (float)this.pageContainer.getWidth() * 0.95f;
        float height = (float)this.pageContainer.getHeight() * 0.95f;
        PdfPageData pageData = this.decode_pdf.getPdfPageData();
        int raw_rotation = 0;
        if (this.decode_pdf.getDisplayView() == 4) {
            raw_rotation = pageData.getRotation(this.commonValues.getCurrentPage());
        }
        boolean isRotated = (this.rotation + raw_rotation) % 180 == 90;
        PageOffsets offsets = (PageOffsets)this.decode_pdf.getExternalHandler(17);
        switch (this.decode_pdf.getDisplayView()) {
            case 3: {
                if (isRotated) {
                    cw = offsets.getMaxH() * 2;
                    ch = offsets.getMaxW();
                    break;
                }
                cw = offsets.getMaxW() * 2;
                ch = offsets.getMaxH();
                break;
            }
            case 2: {
                if (isRotated) {
                    cw = offsets.getMaxH();
                    ch = offsets.getMaxW();
                    break;
                }
                cw = offsets.getMaxW();
                ch = offsets.getMaxH();
                break;
            }
            case 4: {
                int leftPage;
                if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER)) {
                    leftPage = this.commonValues.getCurrentPage() / 2 * 2;
                    if (this.commonValues.getPageCount() == 2) {
                        leftPage = 1;
                    }
                } else {
                    leftPage = this.commonValues.getCurrentPage();
                    if ((leftPage & 1) == 0) {
                        --leftPage;
                    }
                }
                if (isRotated) {
                    cw = pageData.getCropBoxHeight(leftPage);
                    cw = leftPage + 1 > this.commonValues.getPageCount() || leftPage == 1 ? (cw *= 2) : (cw += pageData.getCropBoxHeight(leftPage + 1));
                    ch = pageData.getCropBoxWidth(leftPage);
                    if (leftPage + 1 > this.commonValues.getPageCount() || ch >= pageData.getCropBoxWidth(leftPage + 1)) break;
                    ch = pageData.getCropBoxWidth(leftPage + 1);
                    break;
                }
                cw = pageData.getCropBoxWidth(leftPage);
                cw = leftPage + 1 > this.commonValues.getPageCount() ? (cw *= 2) : (cw += pageData.getCropBoxWidth(leftPage + 1));
                ch = pageData.getCropBoxHeight(leftPage);
                if (leftPage + 1 > this.commonValues.getPageCount() || ch >= pageData.getCropBoxHeight(leftPage + 1)) break;
                ch = pageData.getCropBoxHeight(leftPage + 1);
                break;
            }
            default: {
                if (isRotated) {
                    cw = pageData.getCropBoxHeight(this.commonValues.getCurrentPage());
                    ch = pageData.getCropBoxWidth(this.commonValues.getCurrentPage());
                    break;
                }
                cw = pageData.getCropBoxWidth(this.commonValues.getCurrentPage());
                ch = pageData.getCropBoxHeight(this.commonValues.getCurrentPage());
            }
        }
        float x_factor = width / (float)cw;
        float y_factor = height / (float)ch;
        if (x_factor < y_factor) {
            window_factor = x_factor;
            x_factor = -1.0f;
        } else {
            window_factor = y_factor;
            y_factor = -1.0f;
        }
        if (this.getSelectedComboIndex(252) != 0 && ((double)newScaling < (double)window_factor * 1.1 && (double)newScaling > (double)window_factor * 0.91 || window_factor > this.scaling && window_factor < newScaling || window_factor < this.scaling && window_factor > newScaling)) {
            this.setSelectedComboIndex(252, 0);
            this.scaling = window_factor;
        } else if (y_factor != -1.0f && this.getSelectedComboIndex(252) != 1 && ((double)newScaling < (double)y_factor * 1.1 && (double)newScaling > (double)y_factor * 0.91 || y_factor > this.scaling && y_factor < newScaling || y_factor < this.scaling && y_factor > newScaling)) {
            this.setSelectedComboIndex(252, 1);
            this.scaling = y_factor;
        } else if (x_factor != -1.0f && this.getSelectedComboIndex(252) != 2 && ((double)newScaling < (double)x_factor * 1.1 && (double)newScaling > (double)x_factor * 0.91 || x_factor > this.scaling && x_factor < newScaling || x_factor < this.scaling && x_factor > newScaling)) {
            this.setSelectedComboIndex(252, 2);
            this.scaling = x_factor;
        } else {
            this.setSelectedComboItem(252, String.valueOf((int)this.decode_pdf.getDPIFactory().removeScaling(newScaling * 100.0f)));
            this.scaling = newScaling;
        }
    }

    @Override
    public void rotate() {
        this.rotation = Integer.parseInt((String)this.getSelectedComboItem(251));
        this.scaleAndRotate();
    }

    @Override
    public void scrollToPage(int page) {
        this.commonValues.setCurrentPage(page);
        if (this.commonValues.getCurrentPage() > 0) {
            int pageCount = this.decode_pdf.getPageCount();
            this.decode_pdf.getPages().getYCordForPage(page, this.scaling);
            PdfPageData pageData = this.decode_pdf.getPdfPageData();
            double totalHeight = 0.0;
            switch (this.decode_pdf.getDisplayView()) {
                case 1: {
                    break;
                }
                case 2: {
                    int i;
                    double yCord = 0.0;
                    for (i = 1; i < pageCount; ++i) {
                        totalHeight += (double)pageData.getScaledCropBoxHeight(i);
                    }
                    for (i = 1; i < page; ++i) {
                        yCord += (double)pageData.getScaledCropBoxHeight(i);
                    }
                    double vv = yCord / totalHeight;
                    this.pageContainer.setVvalue(vv);
                    break;
                }
                case 3: {
                    int i;
                    double yCord = 0.0;
                    for (i = 1; i < pageCount; i += 2) {
                        totalHeight += (double)pageData.getScaledCropBoxHeight(i);
                    }
                    for (i = 1; i < page; i += 2) {
                        yCord += (double)pageData.getScaledCropBoxHeight(i);
                    }
                    double vv = yCord / totalHeight;
                    this.pageContainer.setVvalue(vv);
                }
            }
        }
        if (this.decode_pdf.getPageCount() > 1) {
            this.fxButtons.setPageLayoutButtonsEnabled(true);
        }
    }

    @Override
    public void setupThumbnailPanel() {
        this.decode_pdf.addExternalHandler(this.thumbnails, 8);
        if (this.isSetup) {
            return;
        }
        this.isSetup = true;
        if (this.thumbnails.isShownOnscreen()) {
            this.thumbnails.setupThumbnails(this.decode_pdf.getPageCount(), null, Messages.getMessage("PdfViewerPageLabel.text"), this.decode_pdf.getPdfPageData());
            Button[] buttons = (Button[])this.thumbnails.getButtons();
            for (int i = 0; i < this.commonValues.getPageCount(); ++i) {
                buttons[i].setOnAction((EventHandler)new JavaFXPageChanger(this, this.commonValues, i));
            }
            this.thumbnails.addComponentListener();
        }
    }

    @Override
    public void setBookmarks(boolean alwaysGenerate) {
        if (this.bookmarksGenerated) {
            return;
        }
        this.bookmarksGenerated = true;
        Document doc = this.decode_pdf.getOutlineAsXML();
        org.w3c.dom.Node rootNode = null;
        if (doc != null) {
            rootNode = doc.getFirstChild();
        }
        if (rootNode != null) {
            this.tree.reset(rootNode);
            EventHandler<MouseEvent> reselectionListener = new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    String ref = ((JavaFXOutline.OutlineNode)((Object)((Labeled)event.getSource()).getUserData())).getObjectRef();
                    JavaFxGUI.this.gotoPageByRef(ref);
                }
            };
            ((TreeView)this.tree.getTree()).getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<Label>>((EventHandler)reselectionListener){
                final /* synthetic */ EventHandler val$reselectionListener;
                {
                    this.val$reselectionListener = eventHandler;
                }

                public void changed(ObservableValue<? extends TreeItem<Label>> ov, TreeItem<Label> t, TreeItem<Label> t1) {
                    if (t1 == null) {
                        return;
                    }
                    if (t != null) {
                        ((Label)t.getValue()).setOnMouseClicked(null);
                    }
                    ((Label)t1.getValue()).setOnMouseClicked(this.val$reselectionListener);
                    String ref = ((JavaFXOutline.OutlineNode)t1).getObjectRef();
                    JavaFxGUI.this.gotoPageByRef(ref);
                }
            });
        } else {
            this.tree.reset(null);
        }
    }

    private void gotoPageByRef(String ref) {
        PdfObject Aobj = this.decode_pdf.getOutlineData().getAobj(ref);
        if (Aobj != null) {
            this.decode_pdf.getFormRenderer().getActionHandler().gotoDest(Aobj, 3, 339034948);
        }
    }

    @Override
    public void selectBookmark() {
        if (this.decode_pdf.hasOutline() && this.tree != null) {
            this.tree.selectBookmark();
        }
    }

    private void initStatus() {
        this.setMultibox(new int[0]);
    }

    @Override
    public void setCoordText(String string) {
        this.coordsFX.setText(string);
    }

    private void initCoordBox() {
        this.coordsFX = new TextField();
        this.coordsFX.prefWidthProperty().bind((ObservableValue)this.multiboxfx.prefWidthProperty());
        this.coordsFX.prefHeightProperty().bind((ObservableValue)this.multiboxfx.heightProperty());
        this.coordsFX.setAlignment(Pos.CENTER);
        this.coordsFX.setEditable(false);
        this.coordsFX.setVisible(false);
        this.coordsFX.setText("  X:  Y:   ");
    }

    @Override
    public void setPageNumber() {
        if (Platform.isFxApplicationThread()) {
            this.setPageNumberWorker();
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    JavaFxGUI.this.setPageNumberWorker();
                }
            });
        }
        if (this.isSetup) {
            this.setThumbnails();
        }
    }

    private void setPageNumberWorker() {
        if (this.pageCounter2 == null) {
            return;
        }
        if (!this.decode_pdf.isOpen() && !this.commonValues.isMultiTiff()) {
            this.pageCounter2.setText("0");
            this.pageCounter3.setText(Messages.getMessage("PdfViewerOfLabel.text") + " 0");
        } else {
            if (this.previewOnSingleScroll && this.pageScroll != null) {
                this.pageScroll.setMax((double)(this.decode_pdf.getPageCount() - 1));
                this.pageScroll.setValue((double)(this.commonValues.getCurrentPage() - 1));
                if (this.debugThumbnail) {
                    System.out.println("setpage=" + this.commonValues.getCurrentPage());
                }
            }
            int currentPage = this.commonValues.getCurrentPage();
            if (this.decode_pdf.getDisplayView() == 4 || this.decode_pdf.getDisplayView() == 3) {
                if (this.decode_pdf.getPageCount() == 2) {
                    this.pageCounter2.setText("1/2");
                } else if (this.decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || this.decode_pdf.getDisplayView() == 3) {
                    int base = currentPage & 0xFFFFFFFE;
                    if (base != this.decode_pdf.getPageCount() && base != 0) {
                        this.pageCounter2.setText(base + "/" + (base + 1));
                    } else {
                        this.pageCounter2.setText(String.valueOf(currentPage));
                    }
                } else {
                    int base = currentPage - (1 - (currentPage & 1));
                    if (base != this.decode_pdf.getPageCount()) {
                        this.pageCounter2.setText(base + "/" + (base + 1));
                    } else {
                        this.pageCounter2.setText(String.valueOf(currentPage));
                    }
                }
            } else {
                this.pageCounter2.setText(String.valueOf(currentPage));
            }
            this.pageCounter3.setText(Messages.getMessage("PdfViewerOfLabel.text") + ' ' + this.decode_pdf.getPageCount());
            this.fxButtons.hideRedundentNavButtons(this);
        }
    }

    private void createNavbar() {
        this.navButtons.getChildren().add((Object)this.multiboxfx);
        Region multiboxSpacer = new Region();
        HBox.setHgrow((Node)multiboxSpacer, (Priority)Priority.ALWAYS);
        this.navButtons.getChildren().add((Object)multiboxSpacer);
        this.fxButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.RewindToStart"), "start.gif", 50, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.fxButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.Rewind10"), "fback.gif", 51, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.fxButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.Rewind1"), "back.gif", 52, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.pageCounter1 = new Label(Messages.getMessage("PdfViewerPageLabel.text"));
        this.navToolBar.getItems().add((Object)this.pageCounter1);
        this.navToolBar.getItems().add((Object)this.pageCounter2);
        this.navToolBar.getItems().add((Object)this.pageCounter3);
        this.fxButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.Forward1"), "forward.gif", 53, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.fxButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.Forward10"), "fforward.gif", 54, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        this.fxButtons.addButton(1, Messages.getMessage("PdfViewerNavBar.ForwardLast"), "end.gif", 55, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        if (this.isSingle) {
            this.fxButtons.addButton(2, Messages.getMessage("PageLayoutButton.SinglePage"), "single.gif", 57, this.menuItems, this, this.currentCommandListener, this.pagesToolBar, this.navToolBar);
        }
        if (this.commonValues.getModeOfOperation() == 4) {
            this.fxButtons.getTopButtons().getItems().add((Object)this.pagesToolBar);
        } else {
            this.navButtons.getChildren().add((Object)this.navToolBar);
        }
        Region navToolBarSpacer = new Region();
        HBox.setHgrow((Node)navToolBarSpacer, (Priority)Priority.ALWAYS);
        this.navButtons.getChildren().add((Object)navToolBarSpacer);
        if (this.commonValues.getModeOfOperation() == 4) {
            this.fxButtons.getTopButtons().getItems().add((Object)this.pagesToolBar);
        } else {
            this.navButtons.getChildren().add((Object)this.pagesToolBar);
        }
        this.multiboxfx.prefWidthProperty().bind((ObservableValue)this.pagesToolBar.widthProperty());
    }

    @Override
    public void setPage(int page) {
        if ((this.decode_pdf.getDisplayView() == 4 && this.decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) || this.decode_pdf.getDisplayView() == 3) && (page & 1) == 1 && page != 1) {
            --page;
        } else if (this.decode_pdf.getDisplayView() == 4 && !this.decode_pdf.getPages().getBoolean(Display.BoolValue.SEPARATE_COVER) && (page & 1) == 0) {
            --page;
        }
        this.commonValues.setCurrentPage(page);
        this.setPageNumber();
    }

    @Override
    public Enum getType() {
        return GUIModes.JAVAFX;
    }

    @Override
    public void resetPageNav() {
        this.pageCounter2.setText("");
        this.pageCounter3.setText("");
    }

    @Override
    public void setRotationFromExternal(int rot) {
        this.rotation = rot;
        this.rotationBox.setSelectedIndex(this.rotation / 90);
    }

    @Override
    public void setScalingFromExternal(String scale) {
        if (scale.startsWith("Fit ")) {
            this.scalingBox.setSelectedItem(scale);
        } else {
            this.scaling = Float.parseFloat(scale);
            this.scalingBox.setSelectedItem(scale + '%');
        }
        if (!Values.isProcessing()) {
            // empty if block
        }
    }

    public Stage getFrame() {
        return this.stage;
    }

    @Override
    public int showMessageDialog(Object message1, Object[] options, int selectedChoice) {
        int n = 0;
        boolean showMessage = true;
        if (this.customMessageHandler != null) {
            showMessage = this.customMessageHandler.showMessage(message1);
        }
        if (showMessage) {
            FXOptionDialog optionsDialog = new FXOptionDialog(this.stage, message1.toString(), "Message", 1, options, options[selectedChoice]);
            n = optionsDialog.showOptionDialog();
        }
        return n;
    }

    @Override
    public void showMessageDialog(Object message, String title, int type) {
        boolean showMessage = true;
        if (this.customMessageHandler != null) {
            showMessage = this.customMessageHandler.showMessage(message);
        }
        if (showMessage) {
            FXMessageDialog dialog = new FXMessageDialog(this.stage, Modality.APPLICATION_MODAL, message.toString());
            dialog.setTitle(title);
            dialog.show();
        }
    }

    @Override
    public String showInputDialog(Object message, String title, int type) {
        String returnMessage = null;
        if (this.customMessageHandler != null) {
            returnMessage = this.customMessageHandler.requestInput(new Object[]{message, title, title});
        }
        if (returnMessage == null) {
            FXInputDialog input = new FXInputDialog(this.stage, message.toString());
            input.setTitle(title);
            return input.showInputDialog();
        }
        return returnMessage;
    }

    @Override
    public String showInputDialog(String message) {
        String returnMessage = null;
        if (this.customMessageHandler != null) {
            returnMessage = this.customMessageHandler.requestInput(new String[]{message});
        }
        if (returnMessage == null) {
            FXInputDialog input = new FXInputDialog(this.stage, message);
            return input.showInputDialog();
        }
        return returnMessage;
    }

    @Override
    public int showConfirmDialog(String message, String message2, int option) {
        int returnMessage = -1;
        if (this.customMessageHandler != null) {
            returnMessage = this.customMessageHandler.requestConfirm(new Object[]{message, message2, String.valueOf(option)});
        }
        if (returnMessage == -1) {
            FXOptionDialog optionsDialog = new FXOptionDialog(this.stage, message, message2, option, null, null);
            return optionsDialog.showOptionDialog();
        }
        return returnMessage;
    }

    @Override
    public int showOverwriteDialog(String file, boolean yesToAllPresent) {
        int n;
        int returnMessage = -1;
        if (this.customMessageHandler != null) {
            returnMessage = this.customMessageHandler.requestConfirm(new Object[]{file, String.valueOf(yesToAllPresent)});
        }
        if (returnMessage != -1) {
            return returnMessage;
        }
        String message = file + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave");
        if (yesToAllPresent) {
            Object[] buttonRowObjects = new Object[]{Messages.getMessage("PdfViewerConfirmButton.Yes"), Messages.getMessage("PdfViewerConfirmButton.YesToAll"), Messages.getMessage("PdfViewerConfirmButton.No"), Messages.getMessage("PdfViewerConfirmButton.Cancel")};
            FXOptionDialog dialog = new FXOptionDialog(this.stage, message, Messages.getMessage("PdfViewerMessage.Overwrite"), -1, 3, buttonRowObjects, buttonRowObjects[0]);
            n = dialog.showOptionDialog();
        } else {
            FXOptionDialog dialog = new FXOptionDialog(this.stage, message, Messages.getMessage("PdfViewerMessage.Overwrite"), -1, 3, null, null);
            n = dialog.showOptionDialog();
        }
        return n;
    }

    @Override
    public void showMessageDialog(final String message) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FXMessageDialog dialog = new FXMessageDialog(JavaFxGUI.this.stage, Modality.APPLICATION_MODAL, message);
                dialog.show();
            }
        });
    }

    public void showMessageDialog(String message, String hstitle) {
        FXMessageDialog dialog = new FXMessageDialog(this.stage, Modality.APPLICATION_MODAL, message);
        dialog.showAndWait();
    }

    @Override
    public void showMessageDialog(Object info) {
        boolean showMessage = true;
        if (this.customMessageHandler != null) {
            showMessage = this.customMessageHandler.showMessage(info);
        }
        if (showMessage) {
            FXMessageDialog dialog = new FXMessageDialog(this.stage, Modality.APPLICATION_MODAL, (Parent)info);
            dialog.show();
        }
    }

    @Override
    public void showFirstTimePopup() {
        boolean showMessage;
        boolean bl = showMessage = this.customMessageHandler != null && this.customMessageHandler.showMessage("first time popup") || this.customMessageHandler == null;
        if (!showMessage || this.commonValues.getModeOfOperation() == 1) {
            return;
        }
        try {
            VBox supportLink = new VBox();
            supportLink.setAlignment(Pos.CENTER);
            Hyperlink supportImg = new Hyperlink("", (Node)new ImageView(this.getClass().getResource("/org/jpedal/examples/viewer/res/supportScreenshot.png").toExternalForm()));
            supportImg.setBorder(Border.EMPTY);
            Hyperlink supportText = new Hyperlink(Messages.getMessage("PdfViewer.SupportLink.Text1") + ' ' + Messages.getMessage("PdfViewer.SupportLink.Text2"));
            supportText.setBorder(Border.EMPTY);
            supportText.setTextAlignment(TextAlignment.CENTER);
            supportText.setWrapText(true);
            EventHandler<ActionEvent> supportEvent = new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    try {
                        BrowserLauncher.openURL(Messages.getMessage("PdfViewer.SupportLink.Link"));
                    }
                    catch (Exception ex) {
                        JavaFxGUI.this.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                    }
                }
            };
            supportImg.setOnAction((EventHandler)supportEvent);
            supportText.setOnAction((EventHandler)supportEvent);
            supportLink.getChildren().addAll((Object[])new Node[]{supportImg, supportText});
            FXMessageDialog supportDialog = new FXMessageDialog(this.stage, Modality.APPLICATION_MODAL, (Parent)supportLink);
            supportDialog.setResizeable(true);
            supportDialog.setWidth(280.0);
            supportDialog.setHeight(220.0);
            supportDialog.setTitle(Messages.getMessage("PdfViewerTitle.RunningFirstTime"));
            supportDialog.show();
        }
        catch (Exception e) {
            System.err.println(Messages.getMessage("PdfViewerFirstRunDialog.Error") + ' ' + e);
        }
        catch (Error e) {
            System.err.println(Messages.getMessage("PdfViewerFirstRunDialog.Error") + ' ' + e);
        }
    }

    @Override
    public int showConfirmDialog(Object message, String title, int optionType, int messageType) {
        int returnMessage = -1;
        if (this.customMessageHandler != null) {
            returnMessage = this.customMessageHandler.requestConfirm(new Object[]{message, title, String.valueOf(optionType), String.valueOf(messageType)});
        }
        if (returnMessage == -1) {
            FXOptionDialog dialog = new FXOptionDialog(this.stage, message, title, optionType, messageType, null, null);
            return dialog.showOptionDialog();
        }
        return returnMessage;
    }

    @Override
    public void setDownloadProgress(String message, int percentage) {
        this.downloadBar.setProgress(message, percentage);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JavaFxGUI.this.setMultibox(new int[0]);
            }
        });
    }

    @Override
    public void updateStatusMessage(String message) {
    }

    @Override
    public void resetStatusMessage(String message) {
    }

    @Override
    public void setStatusProgress(int size) {
        this.setMultibox(new int[0]);
    }

    private void setSplitDividerLocation(int size) {
        double w = this.center.getWidth();
        if (w == 0.0) {
            w = 1.0;
        }
        this.center.setDividerPosition(0, (double)size / w);
    }

    @Override
    public int getSplitDividerLocation() {
        return 0;
    }

    @Override
    public Object printDialog(String[] printersList, String defaultPrinter) {
        int defaultDPI;
        block5: {
            String propValue = this.properties.getValue("defaultDPI");
            defaultDPI = -1;
            if (propValue != null && !propValue.isEmpty()) {
                try {
                    propValue = propValue.replaceAll("[^0-9]", "");
                    defaultDPI = Integer.parseInt(propValue);
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block5;
                    LogWriter.writeLog("Exception attempting get properties value" + e);
                }
            }
        }
        if (this.printPanel == null) {
            this.printPanel = new PrintPanelFX(printersList, defaultPrinter, this.getPaperSizes(), defaultDPI, this.commonValues.getCurrentPage(), this.decode_pdf);
        } else {
            this.printPanel.resetDefaults(printersList, defaultPrinter, this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
        }
        this.printPanel.setVisible(true);
        return this.printPanel;
    }

    @Override
    public PaperSizes getPaperSizes() {
        if (this.paperSizes == null) {
            this.paperSizes = new PaperSizes(this.properties.getValue("defaultPagesize"));
        }
        return this.paperSizes;
    }

    @Override
    public void setQualityBoxVisible(boolean visible) {
        if (this.properties.getValue("Imageopdisplay").equalsIgnoreCase("true") && this.qualityBox != null) {
            this.qualityBox.setVisibility(visible);
        }
    }

    private void setThumbnails() {
        Task<Void> worker = new Task<Void>(){

            protected Void call() throws Exception {
                if (JavaFxGUI.this.thumbnails.isShownOnscreen()) {
                    JavaFxGUI.this.setupThumbnailPanel();
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            JavaFxGUI.this.thumbnails.generateOtherVisibleThumbnails(JavaFxGUI.this.commonValues.getCurrentPage());
                        }
                    });
                }
                return null;
            }
        };
        new Thread((Runnable)worker).start();
    }

    @Override
    public void setSearchText(Object searchText) {
        this.searchText = (TextField)searchText;
    }

    @Override
    public void setResults(GUISearchList results) {
        this.results = results;
        if (this.searchInMenu && this.results.getResultCount() == 0) {
            this.showMessageDialog((Object)(Messages.getMessage("PdfViewerFileMenuFind.noResultText") + " \"" + results.getSearchTerm() + '\"'), Messages.getMessage("PdfViewerFileMenuFind.noResultTitle"), 1);
        }
    }

    @Override
    public Object getSideTabBar() {
        return this.navOptionsPanel;
    }

    @Override
    public void enableSearchItems(boolean enabled) {
        if (this.searchInMenu) {
            this.searchText.setDisable(!enabled);
            this.options.setDisable(!enabled);
            this.fxButtons.getButton(19).setEnabled(false);
            this.fxButtons.getButton(18).setEnabled(false);
        } else if (this.fxButtons.getButton(12) != null) {
            this.fxButtons.getButton(12).setEnabled(enabled);
        }
    }

    @Override
    public void removeSearchWindow(boolean justHide) {
        this.searchFrame.removeSearchWindow(justHide);
    }

    @Override
    public void alterProperty(String value, boolean set) {
    }

    @Override
    public void dispose() {
        if (this.pageContainer != null) {
            if (this.fxChangeListener != null) {
                this.pageContainer.viewportBoundsProperty().removeListener(this.fxChangeListener);
                this.fxChangeListener = null;
            }
            this.pageContainer = null;
        }
        this.fxButtons.dispose();
        super.dispose();
        this.mouseHandler = null;
        this.pageTitle = null;
        this.bookmarksTitle = null;
        this.signaturesTitle = null;
        this.layersTitle = null;
        this.currentCommandListener = null;
        if (this.navButtons != null) {
            this.navButtons.getChildren().removeAll((Collection)this.navButtons.getChildren());
        }
        this.navButtons = null;
        this.menuItems.dispose();
        if (this.navOptionsPanel != null) {
            this.navOptionsPanel.getTabs().removeAll((Object[])new Tab[0]);
        }
        this.navOptionsPanel = null;
        this.headFont = null;
        this.textFont = null;
        this.pageCounter2 = null;
        this.pageCounter3 = null;
        if (this.navToolBar != null) {
            this.navToolBar.getItems().removeAll((Collection)this.navToolBar.getItems());
        }
        this.navToolBar = null;
        if (this.pagesToolBar != null) {
            this.pagesToolBar = null;
        }
        this.layersObject = null;
        if (this.memoryMonitor != null) {
            this.memoryMonitor.stop();
        }
    }

    @Override
    public boolean getPageTurnScalingAppropriate() {
        return true;
    }

    @Override
    public SwingCursor getGUICursor() {
        return this.guiCursor;
    }

    @Override
    public void rescanPdfLayers() {
    }

    @Override
    public String getTitles(String title) {
        if (title.equals(this.pageTitle)) {
            return this.pageTitle;
        }
        if (title.equals(this.bookmarksTitle)) {
            return this.bookmarksTitle;
        }
        if (title.equals(this.signaturesTitle)) {
            return this.signaturesTitle;
        }
        if (title.equals(this.layersTitle)) {
            return this.layersTitle;
        }
        return null;
    }

    @Override
    public Object getStatusBar() {
        return null;
    }

    @Override
    public GUIButtons getButtons() {
        return this.fxButtons;
    }

    @Override
    public GUIMenuItems getMenuItems() {
        return this.menuItems;
    }

    @Override
    public void setTabsNotInitialised(boolean b) {
        this.tabsNotInitialised = b;
    }

    @Override
    public void decodePage() {
        Object exitTransition = null;
        if (this.decode_pdf.getDisplayView() == 1) {
            // empty if block
        }
        if (exitTransition != null) {
            this.decode_pdf.addExternalHandler(new FXAdditionalData(), 33);
            final JavaFxGUI gui = this;
            this.resetPDFBorder(Color.TRANSPARENT);
            final Transition entryTransition = FXViewerTransitions.entryTransition((PdfDecoderFX)this.decode_pdf, this.transitionType, FXViewerTransitions.TransitionDirection.NONE);
            entryTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    JavaFxGUI.this.resetPDFBorder(Color.DARKGOLDENROD);
                }
            });
            exitTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            JavaFxGUI.this.decodeGUIPage(gui);
                        }
                    });
                    entryTransition.play();
                }
            });
            exitTransition.play();
        } else {
            if (this.getThumbnailScrollBar() != null) {
                this.setThumbnailScrollBarValue(this.commonValues.getCurrentPage() - 1);
            }
            ((PdfDecoderFX)this.decode_pdf).setOpacity(1.0);
            this.resetPDFBorder(Color.DARKGOLDENROD);
            this.decodeGUIPage(this);
        }
    }

    public void updateTransitionType() {
        this.transitionType = FXViewerTransitions.TransitionType.valueOf(this.properties.getValue("transitionType").replace(" ", "_"));
    }

    public ScrollPane getPageContainer() {
        return this.pageContainer;
    }

    @Override
    public PdfDecoderFX getPdfDecoder() {
        return (PdfDecoderFX)this.decode_pdf;
    }

    @Override
    protected void addComboListenerAndLabel(GUICombo combo, String title) {
        ((JavaFXCombo)combo).setOnAction((EventHandler)this.currentCommandListener.getCommandListener());
    }

    @Override
    protected void addGUIComboBoxes(GUICombo combo) {
        this.fxButtons.getTopButtons().getItems().add((Object)((JavaFXCombo)combo));
    }

    @Override
    protected void setupCenterPanelBackground() {
        String propValue = this.properties.getValue("replacePdfDisplayBackground");
        if (!propValue.isEmpty() && propValue.equalsIgnoreCase("true")) {
            propValue = this.properties.getValue("pdfDisplayBackground");
            if (!propValue.isEmpty()) {
                this.currentCommands.executeCommand(714, new Object[]{Integer.parseInt(propValue)});
            }
            int col = Integer.parseInt(propValue);
            int r = col >> 16 & 0xFF;
            int g = col >> 8 & 0xFF;
            int b = col & 0xFF;
            this.pageContainer.setStyle("-fx-background:rgb(" + r + ',' + g + ',' + b + ");");
        } else if (this.decode_pdf.getDecoderOptions().getDisplayBackgroundColor() != null) {
            int col = this.decode_pdf.getDecoderOptions().getDisplayBackgroundColor().getRGB();
            int r = col >> 16 & 0xFF;
            int g = col >> 8 & 0xFF;
            int b = col & 0xFF;
            this.pageContainer.setStyle("-fx-background:rgb(" + r + ',' + g + ',' + b + ");");
        } else if (this.decode_pdf.useNewGraphicsMode()) {
            this.pageContainer.setStyle("-fx-background:#555565;");
        } else {
            this.pageContainer.setStyle("-fx-background:#190190190;");
        }
    }

    @Override
    protected void setupComboBoxes() {
        String[] qualityValues = new String[]{Messages.getMessage("PdfViewerToolbarComboBox.imageQual")};
        String[] rotationValues = new String[]{"0", "90", "180", "270"};
        String[] scalingValues = new String[]{Messages.getMessage("PdfViewerScaleWindow.text"), Messages.getMessage("PdfViewerScaleHeight.text"), Messages.getMessage("PdfViewerScaleWidth.text"), "25%", "50%", "75%", "100%", "125%", "150%", "200%", "250%", "500%", "750%", "1000%"};
        this.qualityBox = new JavaFXCombo(qualityValues);
        ((JavaFXCombo)this.qualityBox).setStyle("-fx-background-color: #FFFFFF;");
        this.qualityBox.setSelectedIndex(0);
        String choosenScaling = System.getProperty("org.jpedal.defaultViewerScaling");
        if (choosenScaling == null) {
            choosenScaling = this.properties.getValue("startScaling");
        }
        if (choosenScaling != null) {
            int total = scalingValues.length;
            for (int aa = 0; aa < total; ++aa) {
                if (!scalingValues[aa].equals(choosenScaling)) continue;
                defaultSelection = aa;
                aa = total;
            }
        }
        this.scalingBox = new JavaFXCombo(scalingValues);
        ((JavaFXCombo)this.scalingBox).setStyle("-fx-background-color: #FFFFFF;");
        this.scalingBox.setEditable(true);
        this.scalingBox.setSelectedIndex(defaultSelection);
        this.rotationBox = new JavaFXCombo(rotationValues);
        ((JavaFXCombo)this.rotationBox).setStyle("-fx-background-color: #FFFFFF;");
        this.rotationBox.setSelectedIndex(0);
    }

    @Override
    protected void setupKeyboardControl() {
    }

    private void setupPDFDisplayPane(int width, int height) {
        if (this.isSingle) {
            this.previewOnSingleScroll = this.properties.getValue("previewOnSingleScroll").equalsIgnoreCase("true");
            if (this.previewOnSingleScroll) {
                // empty if block
            }
            this.pageContainer = new ScrollPane();
            this.pageContainer.setPannable(true);
            this.pageContainer.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            this.pageContainer.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            this.decode_pdf.setInset(0, 0);
            this.group = new Group();
            this.group.getChildren().add((Object)((PdfDecoderFX)this.decode_pdf));
            this.pageContainer.setContent((Node)this.group);
            this.fxChangeListener = new ChangeListener<Bounds>(){

                public void changed(ObservableValue<? extends Bounds> ov, Bounds ob, Bounds nb) {
                    if (JavaFxGUI.this.decode_pdf.getDisplayView() == 1) {
                        JavaFxGUI.this.scaleAndRotate();
                    }
                }
            };
            this.pageContainer.viewportBoundsProperty().addListener(this.fxChangeListener);
            this.setupKeyboardControl();
        }
    }

    @Override
    protected void setupBorderPanes() {
        if (this.isSingle) {
            this.setupSidebarTitles();
            this.center = new SplitPane();
            this.setupTabPane();
            this.center.getItems().addAll((Object[])new Node[]{this.navOptionsPanel, this.pageContainer});
            if (this.pageScroll != null) {
                this.center.getItems().add((Object)this.pageScroll);
            }
            this.setSplitDividerLocation(collapsedSize);
            this.tabsExpanded = false;
            ((SplitPane.Divider)this.center.getDividers().get(0)).positionProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> ov, Number oldN, Number newN) {
                    if (JavaFxGUI.this.tabsExpanded) {
                        GUI.expandedSize = (int)JavaFxGUI.this.navOptionsPanel.getWidth();
                    }
                }
            });
            this.propValue = this.properties.getValue("startSideTabOpen");
            if (!this.propValue.isEmpty()) {
                this.sideTabBarOpenByDefault = this.propValue.equalsIgnoreCase("true");
            }
            this.propValue = this.properties.getValue("startSelectedSideTab");
            if (!this.propValue.isEmpty()) {
                this.startSelectedTab = this.propValue;
            }
            if (!this.hasListener) {
                this.navOptionsPanel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent t) {
                        if (t.getX() < 30.0) {
                            JavaFxGUI.this.handleTabbedPanes();
                        }
                    }
                });
                this.hasListener = true;
            }
        }
    }

    @Override
    protected void setupBottomToolBarItems() {
        this.pageCounter2.setEditable(true);
        this.pageCounter2.setTooltip(new Tooltip(Messages.getMessage("PdfViewerTooltip.goto")));
        this.pageCounter2.setPrefColumnCount(2);
        this.pageCounter2.setMaxSize(this.pageCounter2.getPrefWidth(), this.pageCounter2.getPrefHeight());
        this.pageCounter2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                JavaFxGUI.this.commonValues.setSelectedFile(JavaFxGUI.this.decode_pdf.getFileName());
                JavaFxGUI.this.commonValues.setPageCount(JavaFxGUI.this.decode_pdf.getPageCount());
                JavaFxGUI.this.commonValues.setCurrentPage(JavaFxGUI.this.decode_pdf.getPageNumber());
                String value = JavaFxGUI.this.pageCounter2.getText().trim();
                JavaFxGUI.this.currentCommands.executeCommand(56, new Object[]{value});
            }
        });
        this.pageCounter2.setAlignment(Pos.CENTER);
        this.setPageNumber();
        this.navButtons.setPrefSize(5.0, 24.0);
    }

    @Override
    protected void setupPDFBorder() {
        this.resetPDFBorder(Color.DARKGOLDENROD);
    }

    private void resetPDFBorder(final Color color) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DropShadow pdfBorder = new DropShadow();
                pdfBorder.setOffsetY(0.0);
                pdfBorder.setOffsetX(0.0);
                pdfBorder.setColor(color);
                pdfBorder.setWidth(40.0);
                pdfBorder.setHeight(40.0);
                ((PdfDecoderFX)JavaFxGUI.this.decode_pdf).setEffect((Effect)pdfBorder);
            }
        });
    }

    @Override
    protected void createTopMenuBar() {
        this.topPane.setStyle("-fx-background-color: #F5F6F7;");
    }

    @Override
    protected void createMainViewerWindow(int width, int height) {
        this.root.setTop((Node)this.topPane);
        this.root.setCenter((Node)this.center);
        this.root.setBottom((Node)this.navButtons);
        if (this.stage != null) {
            this.scene = new Scene((Parent)this.root, (double)width, (double)height);
            this.stage.setScene(this.scene);
            this.stage.show();
        }
    }

    @Override
    public void setScrollBarPolicy(GUI.ScrollPolicy pol) {
        switch (pol) {
            case VERTICAL_NEVER: {
                this.pageContainer.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
                break;
            }
            case VERTICAL_AS_NEEDED: {
                this.pageContainer.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
                break;
            }
            case HORIZONTAL_NEVER: {
                this.pageContainer.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
                break;
            }
            case HORIZONTAL_AS_NEEDED: {
                this.pageContainer.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            }
        }
    }

    private void setupTabPane() {
        this.navOptionsPanel = new TabPane();
        this.navOptionsPanel.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.navOptionsPanel.setSide(Side.LEFT);
        final Tab dummy = new Tab("");
        dummy.setDisable(true);
        dummy.setStyle("-fx-opacity:0;");
        final Tab search = new Tab("Search");
        ((JavaFXThumbnailPanel)this.thumbnails).setText(this.pageTitle);
        ((JavaFXOutline)this.tree).setText(this.bookmarksTitle);
        this.layersPanel.setText(this.layersTitle);
        this.signaturesPanel.setText(this.signaturesTitle);
        this.navOptionsPanel.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){

            public void changed(ObservableValue<? extends Tab> ov, Tab t, Tab t1) {
                if (JavaFxGUI.this.navOptionsPanel.getSelectionModel().getSelectedItem() == search) {
                    search.setContent((Node)((JavaFXSearchWindow)JavaFxGUI.this.searchFrame).getContentVB());
                }
                if (!JavaFxGUI.this.tabsExpanded && !dummy.isSelected()) {
                    JavaFxGUI.this.setSplitDividerLocation(GUI.expandedSize);
                    JavaFxGUI.this.tabsExpanded = true;
                } else if (JavaFxGUI.this.tabsExpanded && t1.equals(t)) {
                    JavaFxGUI.this.setSplitDividerLocation(GUI.collapsedSize);
                    JavaFxGUI.this.tabsExpanded = false;
                }
            }
        });
        SplitPane.setResizableWithParent((Node)this.navOptionsPanel, (Boolean)Boolean.FALSE);
        if (this.searchFrame.getViewStyle() == 1) {
            this.navOptionsPanel.getTabs().addAll((Object[])new Tab[]{(JavaFXThumbnailPanel)this.thumbnails, search, dummy});
        } else {
            this.navOptionsPanel.getTabs().addAll((Object[])new Tab[]{(JavaFXThumbnailPanel)this.thumbnails, dummy});
        }
        this.navOptionsPanel.getSelectionModel().select((Object)dummy);
        this.tabsNotInitialised = false;
    }

    @Override
    public RecentDocumentsFactory getRecentDocument() {
        if (this.recent != null) {
            return this.recent;
        }
        this.recent = new JavaFXRecentDocuments(PropertiesFile.getNoRecentDocumentsToDisplay());
        return this.recent;
    }

    @Override
    public void setRecentDocument() {
        this.recent = new JavaFXRecentDocuments(PropertiesFile.getNoRecentDocumentsToDisplay());
    }

    @Override
    public void openFile(String fileToOpen) {
        if (fileToOpen != null) {
            JavaFXOpenFile.open(fileToOpen, this.commonValues, this.searchFrame, this, this.decode_pdf, this.properties, this.thumbnails);
        }
    }

    @Override
    public void open(String fileName) {
        JavaFXOpenFile.open(fileName, this.commonValues, this.searchFrame, this, this.decode_pdf, this.properties, this.thumbnails);
    }

    @Override
    public void enablePageCounter(GUI.PageCounter value, boolean enabled, boolean visibility) {
        switch (value) {
            case PAGECOUNTER1: {
                this.pageCounter1.setVisible(visibility);
                this.pageCounter1.setDisable(!enabled);
                break;
            }
            case PAGECOUNTER2: {
                this.pageCounter2.setVisible(visibility);
                this.pageCounter2.setDisable(!enabled);
                break;
            }
            case PAGECOUNTER3: {
                this.pageCounter3.setVisible(visibility);
                this.pageCounter3.setDisable(!enabled);
                break;
            }
            case ALL: {
                this.pageCounter1.setVisible(visibility);
                this.pageCounter1.setDisable(!enabled);
                this.pageCounter2.setVisible(visibility);
                this.pageCounter2.setDisable(!enabled);
                this.pageCounter3.setVisible(visibility);
                this.pageCounter3.setDisable(!enabled);
                break;
            }
            default: {
                System.out.println("No Value detected, please choose from Enum PageCounter in GUI.java");
            }
        }
    }

    @Override
    public void removePageListener() {
        if (this.viewListener != null) {
            this.decode_pdf.getPages().flushPageCaches();
            this.removeComponentListener(this.viewListener);
            this.viewListener.dispose();
            this.viewListener = null;
        }
    }

    @Override
    public void setPageCounterText(GUI.PageCounter value, String text) {
        switch (value) {
            case PAGECOUNTER1: {
                this.pageCounter1.setText(text);
                break;
            }
            case PAGECOUNTER2: {
                this.pageCounter2.setText(text);
                break;
            }
            case PAGECOUNTER3: {
                this.pageCounter3.setText(text);
                break;
            }
            default: {
                System.out.println("No Value detected, please choose from Enum PageCounter in GUI.java");
            }
        }
    }

    @Override
    public Object getPageCounter(GUI.PageCounter value) {
        switch (value) {
            case PAGECOUNTER1: {
                return this.pageCounter1;
            }
            case PAGECOUNTER2: {
                return this.pageCounter2;
            }
            case PAGECOUNTER3: {
                return this.pageCounter3;
            }
        }
        System.out.println("No Value detected, please choose from Enum PageCounter in GUI.java");
        return 0;
    }

    @Override
    public void updateTextBoxSize() {
        int col = String.valueOf(this.commonValues.getPageCount()).length();
        if (this.decode_pdf.getDisplayView() == 4 || this.decode_pdf.getDisplayView() == 3) {
            col *= 2;
        }
        if (col < 2) {
            col = 2;
        }
        if (col > 10) {
            col = 10;
        }
        this.pageCounter2.setPrefColumnCount(col);
        this.pageCounter2.setMaxSize(this.pageCounter2.getPrefWidth(), this.pageCounter2.getPrefHeight());
    }

    @Override
    public void enableCursor(boolean enabled, boolean visible) {
        this.coordsFX.setDisable(!enabled);
        this.coordsFX.setVisible(visible);
    }

    @Override
    public void enableMemoryBar(boolean enabled, boolean visible) {
        this.memoryBarFX.setDisable(!enabled);
        this.memoryBarFX.setVisible(visible);
    }

    @Override
    public void enableNavigationBar(boolean enabled, boolean visible) {
        this.navButtons.setDisable(!enabled);
        this.navButtons.setVisible(enabled);
    }

    @Override
    public void enableDownloadBar(boolean enabled, boolean visible) {
        this.downloadBar.setDisable(!enabled);
        this.downloadBar.setVisible(visible);
    }

    @Override
    public int getSidebarTabCount() {
        return this.navOptionsPanel.getTabs().size();
    }

    @Override
    public String getSidebarTabTitleAt(int pos) {
        return ((Tab)this.navOptionsPanel.getTabs().get(pos)).getText();
    }

    @Override
    public void removeSidebarTabAt(int pos) {
        this.navOptionsPanel.getTabs().remove(pos);
    }

    @Override
    public double getDividerLocation() {
        double w = this.center.getWidth();
        if (w == 0.0) {
            w = 1.0;
        }
        return w * ((SplitPane.Divider)this.center.getDividers().get(0)).getPosition();
    }

    @Override
    public double getStartSize() {
        return collapsedSize;
    }

    @Override
    public void setStartSize(int size) {
        collapsedSize = size;
    }

    @Override
    public float scaleToVisible(float left, float right, float top, float bottom) {
        float height;
        float heightScaling;
        float width = (float)this.pageContainer.getWidth() * 0.95f;
        float widthScaling = (right - left) / width;
        float scaling = widthScaling > (heightScaling = (top - bottom) / (height = (float)this.pageContainer.getHeight() * 0.95f)) ? widthScaling : heightScaling;
        scaling = this.decode_pdf.getDPIFactory().adjustScaling(scaling);
        return scaling;
    }

    @Override
    public int getDropShadowDepth() {
        return 40;
    }

    public BorderPane getRoot() {
        return this.root;
    }

    @Override
    public void setPannable(boolean pan) {
        this.pageContainer.setPannable(pan);
    }

    @Override
    public void setupSplitPaneDivider(int size, boolean visibility) {
        this.center.setDisable(!visibility);
        this.center.setVisible(visibility);
    }

    @Override
    public void enableStatusBar(boolean enabled, boolean visible) {
    }

    private void removeComponentListener(RefreshLayout viewListener) {
        ScrollPane customFXHandle = this.pageContainer;
        customFXHandle.viewportBoundsProperty().removeListener((ChangeListener)viewListener);
        customFXHandle.vvalueProperty().removeListener((ChangeListener)viewListener);
        customFXHandle.hvalueProperty().removeListener((ChangeListener)viewListener);
    }

    private void addComponentListener(RefreshLayout viewListener) {
        ScrollPane customFXHandle = this.pageContainer;
        if (customFXHandle != null) {
            customFXHandle.viewportBoundsProperty().addListener((ChangeListener)viewListener);
            customFXHandle.vvalueProperty().addListener((ChangeListener)viewListener);
            customFXHandle.hvalueProperty().addListener((ChangeListener)viewListener);
        }
    }

    class RefreshLayout
    implements ChangeListener {
        final PageMoveTracker tracker = new PageMoveTracker();
        final PdfDecoderInt decode_pdf;

        RefreshLayout(PdfDecoderInt pdf) {
            this.decode_pdf = pdf;
        }

        public void dispose() {
            this.tracker.dispose();
        }

        public void changed(ObservableValue ov, Object t, Object t1) {
            this.tracker.startTimer(this.decode_pdf.getPages(), this.decode_pdf.getPageNumber(), (FileAccess)this.decode_pdf.getExternalHandler(35));
        }
    }
}

