/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.generic;

import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.GUI;

public abstract class GUIPageChanger {
    private final GUI gui;
    private final Values commonValues;
    private final int page;

    public GUIPageChanger(GUI gui, Values values, int page) {
        this.gui = gui;
        this.commonValues = values;
        this.page = page + 1;
    }

    protected void handlePageChange() {
        if (!Values.isProcessing() && this.commonValues.getCurrentPage() != this.page) {
            if (!this.gui.getPdfDecoder().isPageAvailable(this.page)) {
                this.gui.showMessageDialog("Page " + this.page + " is not yet loaded");
                return;
            }
            this.gui.resetStatusMessage("");
            this.gui.getCommand().executeCommand(56, new Object[]{Integer.toString(this.page)});
        }
    }
}

