/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.animation.RotateTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.Transition;
import javafx.animation.TranslateTransition;
import javafx.scene.Node;
import javafx.util.Duration;
import org.jpedal.PdfDecoderFX;

public class FXViewerTransitions {
    public static Transition entryTransition(PdfDecoderFX pdf, TransitionType transitionType, TransitionDirection direction) {
        Transition transition = null;
        switch (transitionType) {
            case Fade: {
                transition = FXViewerTransitions.fadeIn(pdf);
                break;
            }
            case Scale: {
                transition = FXViewerTransitions.scaleIn(pdf, direction);
                break;
            }
            case CardStack: {
                transition = FXViewerTransitions.cardStackIn(pdf, direction);
                break;
            }
            case Rotate: {
                transition = FXViewerTransitions.rotateIn(pdf, direction);
            }
        }
        return transition;
    }

    public static Transition exitTransition(PdfDecoderFX pdf, TransitionType transitionType, TransitionDirection direction) {
        Transition transition = null;
        switch (transitionType) {
            case Fade: {
                transition = FXViewerTransitions.fadeOut(pdf);
                break;
            }
            case Scale: {
                transition = FXViewerTransitions.scaleOut(pdf, direction);
                break;
            }
            case CardStack: {
                transition = FXViewerTransitions.cardStackOut(pdf, direction);
                break;
            }
            case Rotate: {
                transition = FXViewerTransitions.rotateOut(pdf, direction);
            }
        }
        return transition;
    }

    private static Transition fadeIn(PdfDecoderFX pdf) {
        FadeTransition fadeIn = new FadeTransition(Duration.seconds((double)1.0), (Node)pdf);
        fadeIn.setFromValue(0.0);
        fadeIn.setToValue(1.0);
        return fadeIn;
    }

    private static Transition fadeOut(PdfDecoderFX pdf) {
        FadeTransition fadeOut = new FadeTransition(Duration.seconds((double)1.0), (Node)pdf);
        fadeOut.setFromValue(1.0);
        fadeOut.setToValue(0.0);
        return fadeOut;
    }

    private static Transition rotateIn(PdfDecoderFX pdf, TransitionDirection direction) {
        if (direction == TransitionDirection.RIGHT) {
            ScaleTransition st = new ScaleTransition(Duration.seconds((double)1.0));
            st.setByX(1.0);
            st.setByY(1.0);
            RotateTransition rotateIn = new RotateTransition(Duration.seconds((double)1.0), (Node)pdf);
            rotateIn.setFromAngle(0.0);
            rotateIn.setToAngle(360.0);
            return new ParallelTransition((Node)pdf, new Animation[]{st, rotateIn});
        }
        if (direction == TransitionDirection.LEFT) {
            ScaleTransition st = new ScaleTransition(Duration.seconds((double)1.0));
            st.setByX(1.0);
            st.setByY(1.0);
            RotateTransition rotateIn = new RotateTransition(Duration.seconds((double)1.0), (Node)pdf);
            rotateIn.setFromAngle(360.0);
            rotateIn.setToAngle(0.0);
            return new ParallelTransition((Node)pdf, new Animation[]{st, rotateIn});
        }
        return null;
    }

    private static Transition rotateOut(PdfDecoderFX pdf, TransitionDirection direction) {
        if (direction == TransitionDirection.RIGHT) {
            ScaleTransition st = new ScaleTransition(Duration.seconds((double)1.0));
            st.setToX(0.0);
            st.setToY(0.0);
            RotateTransition rotateIn = new RotateTransition(Duration.seconds((double)1.0), (Node)pdf);
            rotateIn.setFromAngle(0.0);
            rotateIn.setToAngle(360.0);
            return new ParallelTransition((Node)pdf, new Animation[]{st, rotateIn});
        }
        if (direction == TransitionDirection.LEFT) {
            ScaleTransition st = new ScaleTransition(Duration.seconds((double)1.0));
            st.setToX(0.0);
            st.setToY(0.0);
            RotateTransition rotateIn = new RotateTransition(Duration.seconds((double)1.0), (Node)pdf);
            rotateIn.setFromAngle(360.0);
            rotateIn.setToAngle(0.0);
            return new ParallelTransition((Node)pdf, new Animation[]{st, rotateIn});
        }
        return null;
    }

    private static Transition scaleIn(PdfDecoderFX pdf, TransitionDirection direction) {
        if (direction == TransitionDirection.RIGHT) {
            pdf.getParent().setScaleX(0.0);
            pdf.getParent().setScaleY(0.0);
            ScaleTransition st = new ScaleTransition(Duration.seconds((double)1.0));
            st.setByX(1.0);
            st.setByY(1.0);
            return new ParallelTransition((Node)pdf.getParent(), new Animation[]{st});
        }
        if (direction == TransitionDirection.LEFT) {
            pdf.getParent().setScaleX(0.0);
            pdf.getParent().setScaleY(0.0);
            ScaleTransition st = new ScaleTransition(Duration.seconds((double)1.0));
            st.setToX(1.0);
            st.setToY(1.0);
            return new ParallelTransition((Node)pdf.getParent(), new Animation[]{st});
        }
        return null;
    }

    private static Transition scaleOut(PdfDecoderFX pdf, TransitionDirection direction) {
        if (direction == TransitionDirection.RIGHT) {
            ScaleTransition st = new ScaleTransition(Duration.seconds((double)1.0));
            st.setToX(0.0);
            st.setToY(0.0);
            return new ParallelTransition((Node)pdf.getParent(), new Animation[]{st});
        }
        if (direction == TransitionDirection.LEFT) {
            ScaleTransition st = new ScaleTransition(Duration.seconds((double)1.0));
            st.setToX(0.0);
            st.setToY(0.0);
            return new ParallelTransition((Node)pdf.getParent(), new Animation[]{st});
        }
        return null;
    }

    private static Transition cardStackIn(PdfDecoderFX pdf, TransitionDirection direction) {
        if (direction == TransitionDirection.RIGHT) {
            pdf.getParent().setScaleX(0.0);
            pdf.getParent().setScaleY(0.0);
            ScaleTransition st = new ScaleTransition(Duration.seconds((double)1.0), (Node)pdf.getParent());
            st.setToX(1.0);
            st.setToY(1.0);
            FadeTransition fadeIn = new FadeTransition(Duration.seconds((double)1.0), (Node)pdf.getParent());
            fadeIn.setFromValue(0.0);
            fadeIn.setToValue(1.0);
            return new ParallelTransition((Node)pdf.getParent(), new Animation[]{st, fadeIn});
        }
        if (direction == TransitionDirection.LEFT) {
            double xPos = pdf.getParent() != null ? pdf.getParent().getTranslateX() : 0.0;
            ScaleTransition st = new ScaleTransition(Duration.seconds((double)1.0), (Node)pdf.getParent());
            st.setToX(1.0);
            st.setToY(1.0);
            TranslateTransition cardStackOut = new TranslateTransition(Duration.seconds((double)1.0), (Node)pdf.getParent());
            cardStackOut.setFromX(-pdf.getWidth());
            cardStackOut.setByX(pdf.getWidth());
            cardStackOut.setToX(xPos);
            FadeTransition fadeOut = new FadeTransition(Duration.seconds((double)1.0), (Node)pdf.getParent());
            fadeOut.setFromValue(0.0);
            fadeOut.setToValue(1.0);
            return new ParallelTransition((Node)pdf.getParent(), new Animation[]{fadeOut, st, cardStackOut});
        }
        return null;
    }

    private static Transition cardStackOut(PdfDecoderFX pdf, TransitionDirection direction) {
        if (direction == TransitionDirection.RIGHT) {
            ScaleTransition st = new ScaleTransition(Duration.seconds((double)1.0), (Node)pdf.getParent());
            st.setToX(0.0);
            st.setToY(0.0);
            FadeTransition fadeIn = new FadeTransition(Duration.seconds((double)1.0), (Node)pdf.getParent());
            fadeIn.setFromValue(1.0);
            fadeIn.setToValue(0.0);
            return new ParallelTransition((Node)pdf.getParent(), new Animation[]{st, fadeIn});
        }
        if (direction == TransitionDirection.LEFT) {
            TranslateTransition cardStackOut = new TranslateTransition(Duration.seconds((double)1.0), (Node)pdf.getParent());
            cardStackOut.setByX(-pdf.getWidth());
            FadeTransition fadeOut = new FadeTransition(Duration.seconds((double)1.0), (Node)pdf.getParent());
            fadeOut.setFromValue(1.0);
            fadeOut.setToValue(0.0);
            return new ParallelTransition((Node)pdf.getParent(), new Animation[]{fadeOut, cardStackOut});
        }
        return null;
    }

    public static enum TransitionDirection {
        NONE,
        LEFT,
        RIGHT;

    }

    public static enum TransitionType {
        None,
        Fade,
        Scale,
        Rotate,
        CardStack;

    }
}

