/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.util.Collection;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCombination;
import org.jpedal.display.GUIDisplay;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.CommandListener;
import org.jpedal.examples.viewer.gui.generic.GUIButtons;
import org.jpedal.examples.viewer.gui.generic.GUIMenuItems;
import org.jpedal.examples.viewer.gui.javafx.JavaFXButtons;
import org.jpedal.examples.viewer.gui.javafx.JavaFXCheckBoxMenuItem;
import org.jpedal.examples.viewer.gui.javafx.JavaFXID;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMenuItem;
import org.jpedal.examples.viewer.utils.PropertiesFile;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.Messages;

public class JavaFXMenuItems
extends GUIMenuItems {
    private MenuBar currentMenu = new MenuBar();
    private Menu fileMenu;
    private Menu openMenu;
    private MenuItem open;
    private MenuItem openUrl;
    private MenuItem save;
    private MenuItem reSaveAsForms;
    private MenuItem find;
    private MenuItem documentProperties;
    private MenuItem signPDF;
    private MenuItem print;
    private MenuItem exit;
    private Menu editMenu;
    private MenuItem copy;
    private MenuItem selectAll;
    private MenuItem deselectAll;
    private MenuItem preferences;
    private Menu viewMenu;
    private Menu goToMenu;
    private MenuItem firstPage;
    private MenuItem backPage;
    private MenuItem forwardPage;
    private MenuItem lastPage;
    private MenuItem goTo;
    private MenuItem previousDocument;
    private MenuItem nextDocument;
    private Menu pageLayoutMenu;
    private MenuItem single;
    private MenuItem continuous;
    private MenuItem facing;
    private MenuItem continuousFacing;
    private MenuItem pageFlow;
    private CheckMenuItem textSelect;
    private CheckMenuItem separateCover;
    private CheckMenuItem panMode;
    private MenuItem fullscreen;
    private Menu windowMenu;
    private MenuItem cascade;
    private MenuItem tile;
    private Menu helpMenu;
    private MenuItem visitWebsite;
    private MenuItem tipOfTheDay;
    private MenuItem about;
    private Menu exportMenu;
    private Menu pdfMenu;
    private Menu contentMenu;
    private Menu pageToolsMenu;
    private MenuItem onePerPage;
    private MenuItem nup;
    private MenuItem handouts;
    private MenuItem images;
    private MenuItem text;
    private MenuItem bitmap;
    private MenuItem rotatePages;
    private MenuItem deletePages;
    private MenuItem addPage;
    private MenuItem addHeaderFooter;
    private MenuItem stampText;
    private MenuItem stampImage;
    private MenuItem crop;

    public JavaFXMenuItems(PropertiesFile properties) {
        super(properties);
    }

    private Menu getMenu(int ID2) {
        switch (ID2) {
            case 317: {
                return this.fileMenu;
            }
            case 310: {
                return this.editMenu;
            }
            case 316: {
                return this.openMenu;
            }
            case 312: {
                return this.viewMenu;
            }
            case 311: {
                return this.goToMenu;
            }
            case 309: {
                return this.pageLayoutMenu;
            }
            case 998: {
                return this.helpMenu;
            }
            case 308: {
                return this.windowMenu;
            }
        }
        return null;
    }

    private MenuItem getMenuItem(int ID2) {
        switch (ID2) {
            case 317: {
                return this.fileMenu;
            }
            case 316: {
                return this.openMenu;
            }
            case 10: {
                return this.open;
            }
            case 14: {
                return this.openUrl;
            }
            case 5: {
                return this.save;
            }
            case 315: {
                return this.reSaveAsForms;
            }
            case 12: {
                return this.find;
            }
            case 9: {
                return this.documentProperties;
            }
            case 512: {
                return this.signPDF;
            }
            case 6: {
                return this.print;
            }
            case 7: {
                return this.exit;
            }
            case 310: {
                return this.editMenu;
            }
            case 25: {
                return this.copy;
            }
            case 26: {
                return this.selectAll;
            }
            case 27: {
                return this.deselectAll;
            }
            case 24: {
                return this.preferences;
            }
            case 312: {
                return this.viewMenu;
            }
            case 311: {
                return this.goToMenu;
            }
            case 50: {
                return this.firstPage;
            }
            case 52: {
                return this.backPage;
            }
            case 53: {
                return this.forwardPage;
            }
            case 55: {
                return this.lastPage;
            }
            case 56: {
                return this.goTo;
            }
            case 16: {
                return this.previousDocument;
            }
            case 17: {
                return this.nextDocument;
            }
            case 309: {
                return this.pageLayoutMenu;
            }
            case 57: {
                return this.single;
            }
            case 58: {
                return this.continuous;
            }
            case 60: {
                return this.facing;
            }
            case 59: {
                return this.continuousFacing;
            }
            case 61: {
                return this.pageFlow;
            }
            case 31: {
                return this.textSelect;
            }
            case 32: {
                return this.separateCover;
            }
            case 30: {
                return this.panMode;
            }
            case 62: {
                return this.fullscreen;
            }
            case 308: {
                return this.windowMenu;
            }
            case 21: {
                return this.cascade;
            }
            case 22: {
                return this.tile;
            }
            case 307: {
                return this.exportMenu;
            }
            case 306: {
                return this.pdfMenu;
            }
            case 305: {
                return this.onePerPage;
            }
            case 510: {
                return this.nup;
            }
            case 304: {
                return this.contentMenu;
            }
            case 3: {
                return this.images;
            }
            case 4: {
                return this.text;
            }
            case 2: {
                return this.bitmap;
            }
            case 511: {
                return this.handouts;
            }
            case 303: {
                return this.pageToolsMenu;
            }
            case 502: {
                return this.rotatePages;
            }
            case 503: {
                return this.deletePages;
            }
            case 504: {
                return this.addPage;
            }
            case 506: {
                return this.addHeaderFooter;
            }
            case 507: {
                return this.stampText;
            }
            case 508: {
                return this.stampImage;
            }
            case 301: {
                return this.crop;
            }
            case 998: {
                return this.helpMenu;
            }
            case 15: {
                return this.visitWebsite;
            }
            case 20: {
                return this.tipOfTheDay;
            }
            case 1: {
                return this.about;
            }
        }
        return null;
    }

    public MenuBar getCurrentMenuFX() {
        return this.currentMenu;
    }

    @Override
    public void dispose() {
        if (this.currentMenu != null) {
            this.currentMenu.getMenus().removeAll((Collection)this.currentMenu.getMenus());
        }
        this.currentMenu = null;
    }

    @Override
    public void setCheckMenuItemSelected(int ID2, boolean b) {
        switch (ID2) {
            case 31: {
                this.textSelect.setSelected(b);
                break;
            }
            case 30: {
                this.panMode.setSelected(b);
                break;
            }
            case 32: {
                this.separateCover.setSelected(b);
                break;
            }
        }
    }

    @Override
    public void setBackNavigationItemsEnabled(boolean enabled) {
        this.backPage.setDisable(!enabled);
        this.firstPage.setDisable(!enabled);
    }

    @Override
    public void setForwardNavigationItemsEnabled(boolean enabled) {
        this.forwardPage.setDisable(!enabled);
        this.lastPage.setDisable(!enabled);
    }

    @Override
    public void setGoToNavigationItemEnabled(boolean enabled) {
        this.goTo.setDisable(!enabled);
    }

    protected void addMenuItem(Menu parentMenu, String text, String toolTip, int ID2) {
        JavaFXID menuItem;
        boolean isCheckBox = false;
        if (ID2 == 32 || ID2 == 30 || ID2 == 31) {
            isCheckBox = true;
        }
        if (isCheckBox) {
            menuItem = new JavaFXCheckBoxMenuItem(text);
            parentMenu.getItems().add((Object)((CheckMenuItem)menuItem));
        } else {
            menuItem = new JavaFXMenuItem(text);
            parentMenu.getItems().add((Object)((MenuItem)menuItem));
        }
        if (!toolTip.isEmpty()) {
            menuItem.setToolTipText(toolTip);
        }
        menuItem.setID(ID2);
        JavaFXMenuItems.setKeyAccelerators(ID2, (MenuItem)menuItem);
        menuItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)this.currentCommandListener.getCommandListener()));
        switch (ID2) {
            case 10: {
                this.open = (MenuItem)menuItem;
                break;
            }
            case 14: {
                this.openUrl = (MenuItem)menuItem;
                break;
            }
            case 5: {
                this.save = (MenuItem)menuItem;
                break;
            }
            case 500: {
                this.reSaveAsForms = (MenuItem)menuItem;
                this.reSaveAsForms.setId("resaveForms");
                break;
            }
            case 12: {
                this.find = (MenuItem)menuItem;
                break;
            }
            case 9: {
                this.documentProperties = (MenuItem)menuItem;
                break;
            }
            case 512: {
                this.signPDF = (MenuItem)menuItem;
                break;
            }
            case 6: {
                this.print = (MenuItem)menuItem;
                break;
            }
            case 7: {
                this.exit = (MenuItem)menuItem;
                this.exit.setId("exit");
                break;
            }
            case 25: {
                this.copy = (MenuItem)menuItem;
                break;
            }
            case 26: {
                this.selectAll = (MenuItem)menuItem;
                break;
            }
            case 27: {
                this.deselectAll = (MenuItem)menuItem;
                break;
            }
            case 24: {
                this.preferences = (MenuItem)menuItem;
                break;
            }
            case 50: {
                this.firstPage = (MenuItem)menuItem;
                break;
            }
            case 52: {
                this.backPage = (MenuItem)menuItem;
                break;
            }
            case 53: {
                this.forwardPage = (MenuItem)menuItem;
                break;
            }
            case 55: {
                this.lastPage = (MenuItem)menuItem;
                break;
            }
            case 56: {
                this.goTo = (MenuItem)menuItem;
                break;
            }
            case 16: {
                this.previousDocument = (MenuItem)menuItem;
                break;
            }
            case 17: {
                this.nextDocument = (MenuItem)menuItem;
                break;
            }
            case 62: {
                this.fullscreen = (MenuItem)menuItem;
                break;
            }
            case 29: {
                this.fullscreen = (MenuItem)menuItem;
                break;
            }
            case 30: {
                this.panMode = (CheckMenuItem)menuItem;
                this.panMode.setSelected(false);
                break;
            }
            case 31: {
                this.textSelect = (CheckMenuItem)menuItem;
                this.textSelect.setSelected(true);
                break;
            }
            case 32: {
                this.separateCover = (CheckMenuItem)menuItem;
                boolean separateCoverOn = this.properties.getValue("separateCoverOn").equalsIgnoreCase("true");
                this.separateCover.setSelected(true);
                GUIDisplay.default_separateCover = separateCoverOn;
                break;
            }
            case 21: {
                this.cascade = (MenuItem)menuItem;
                break;
            }
            case 22: {
                this.tile = (MenuItem)menuItem;
                break;
            }
            case 501: {
                this.onePerPage = (MenuItem)menuItem;
                break;
            }
            case 510: {
                this.nup = (MenuItem)menuItem;
                break;
            }
            case 511: {
                this.handouts = (MenuItem)menuItem;
                break;
            }
            case 3: {
                this.images = (MenuItem)menuItem;
                break;
            }
            case 4: {
                this.text = (MenuItem)menuItem;
                break;
            }
            case 2: {
                this.bitmap = (MenuItem)menuItem;
                break;
            }
            case 502: {
                this.rotatePages = (MenuItem)menuItem;
                break;
            }
            case 503: {
                this.deletePages = (MenuItem)menuItem;
                break;
            }
            case 504: {
                this.addPage = (MenuItem)menuItem;
                break;
            }
            case 506: {
                this.addHeaderFooter = (MenuItem)menuItem;
                break;
            }
            case 507: {
                this.stampText = (MenuItem)menuItem;
                break;
            }
            case 508: {
                this.stampImage = (MenuItem)menuItem;
                break;
            }
            case 509: {
                this.crop = (MenuItem)menuItem;
                break;
            }
            case 15: {
                this.visitWebsite = (MenuItem)menuItem;
                break;
            }
            case 20: {
                this.tipOfTheDay = (MenuItem)menuItem;
                break;
            }
            case 1: {
                this.about = (MenuItem)menuItem;
                break;
            }
        }
        this.disableUnimplementedItems(ID2, false);
    }

    protected void initLayoutMenus(Menu pageLayout, String[] descriptions, int[] value, GUIButtons buttons, final Commands currentCommands, boolean isSingle) {
        int count = value.length;
        for (int i = 0; i < count; ++i) {
            CheckMenuItem pageView = new CheckMenuItem(descriptions[i]);
            if (i == 0) {
                pageView.setSelected(true);
            }
            if (pageLayout != null) {
                switch (value[i]) {
                    case 1: {
                        ((JavaFXButtons)buttons).getLayoutGroup().add(pageView);
                        this.single = pageView;
                        this.single.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                            public void handle(ActionEvent t) {
                                currentCommands.executeCommand(57, null);
                            }
                        });
                        pageLayout.getItems().add((Object)this.single);
                    }
                }
            }
            this.disableUnimplementedItems(value[i], true);
        }
        if (!isSingle) {
            return;
        }
        buttons.setPageLayoutButtonsEnabled(false);
    }

    @Override
    public void setMenusForDisplayMode(int commandIDForDislayMode, int mouseMode) {
        block0 : switch (commandIDForDislayMode) {
            case 57: {
                this.textSelect.setDisable(true);
                this.panMode.setDisable(true);
                this.textSelect.setSelected(true);
                this.panMode.setSelected(false);
                break;
            }
            case 61: {
                this.textSelect.setDisable(false);
                this.panMode.setDisable(false);
                this.textSelect.setSelected(false);
                this.panMode.setSelected(true);
                break;
            }
            case 58: {
                this.textSelect.setDisable(false);
                this.panMode.setDisable(true);
                this.textSelect.setSelected(false);
                this.panMode.setSelected(true);
                break;
            }
            case 59: {
                this.textSelect.setDisable(false);
                this.panMode.setDisable(true);
                this.textSelect.setSelected(false);
                this.panMode.setSelected(true);
                break;
            }
            case 60: {
                this.textSelect.setDisable(false);
                this.panMode.setDisable(true);
                this.textSelect.setSelected(false);
                this.panMode.setSelected(true);
                break;
            }
            case 29: {
                switch (mouseMode) {
                    case 0: {
                        this.textSelect.setSelected(true);
                        this.panMode.setSelected(false);
                        break block0;
                    }
                    case 1: {
                        this.textSelect.setSelected(false);
                        this.panMode.setSelected(true);
                    }
                }
            }
        }
    }

    protected void addToMainMenu(Menu fileMenuList) {
        this.currentMenu.getMenus().add((Object)fileMenuList);
        this.currentMenu.setUseSystemMenuBar(true);
    }

    @Override
    public void createMainMenu(boolean includeAll, CommandListener currentCommandListener, boolean isSingle, Values commonValues, Commands currentCommands, GUIButtons buttons) {
        this.currentCommandListener = currentCommandListener;
        this.fileMenu = new Menu(Messages.getMessage("PdfViewerFileMenu.text"));
        this.addToMainMenu(this.fileMenu);
        this.openMenu = new Menu(Messages.getMessage("PdfViewerFileMenuOpen.text"));
        this.fileMenu.getItems().add((Object)this.openMenu);
        this.addMenuItem(this.openMenu, Messages.getMessage("PdfViewerFileMenuOpen.text"), Messages.getMessage("PdfViewerFileMenuTooltip.open"), 10);
        this.addMenuItem(this.openMenu, Messages.getMessage("PdfViewerFileMenuOpenurl.text"), Messages.getMessage("PdfViewerFileMenuTooltip.openurl"), 14);
        String addSeparator = this.properties.getValue("Save") + this.properties.getValue("Resaveasforms") + this.properties.getValue("Find");
        if (!addSeparator.isEmpty() && addSeparator.equalsIgnoreCase("true")) {
            this.fileMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuSave.text"), Messages.getMessage("PdfViewerFileMenuTooltip.save"), 5);
        if (includeAll) {
            this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuResaveForms.text"), Messages.getMessage("PdfViewerFileMenuTooltip.saveForms"), 500);
        }
        this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuFind.text"), Messages.getMessage("PdfViewerFileMenuTooltip.find"), 12);
        addSeparator = this.properties.getValue("Documentproperties");
        if (!addSeparator.isEmpty() && addSeparator.equalsIgnoreCase("true")) {
            this.fileMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuDocProperties.text"), Messages.getMessage("PdfViewerFileMenuTooltip.props"), 9);
        if (commonValues.isEncrypOnClasspath()) {
            this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuSignPDF.text"), Messages.getMessage("PdfViewerFileMenuTooltip.sign"), 512);
        } else {
            this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuSignPDF.text"), Messages.getMessage("PdfViewerFileMenuSignPDF.NotPath"), 512);
        }
        addSeparator = this.properties.getValue("Print");
        if (!addSeparator.isEmpty() && addSeparator.equalsIgnoreCase("true")) {
            this.fileMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuPrint.text"), Messages.getMessage("PdfViewerFileMenuTooltip.print"), 6);
        addSeparator = this.properties.getValue("Recentdocuments");
        if (!addSeparator.isEmpty() && addSeparator.equalsIgnoreCase("true")) {
            this.fileMenu.getItems().add((Object)new SeparatorMenuItem());
            currentCommands.recentDocumentsOption();
        }
        if (!(addSeparator = this.properties.getValue("Exit")).isEmpty() && addSeparator.equalsIgnoreCase("true")) {
            this.fileMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        this.addMenuItem(this.fileMenu, Messages.getMessage("PdfViewerFileMenuExit.text"), Messages.getMessage("PdfViewerFileMenuTooltip.exit"), 7);
        this.editMenu = new Menu(Messages.getMessage("PdfViewerEditMenu.text"));
        this.addToMainMenu(this.editMenu);
        this.addMenuItem(this.editMenu, Messages.getMessage("PdfViewerEditMenuCopy.text"), Messages.getMessage("PdfViewerEditMenuTooltip.Copy"), 25);
        this.addMenuItem(this.editMenu, Messages.getMessage("PdfViewerEditMenuSelectall.text"), Messages.getMessage("PdfViewerEditMenuTooltip.Selectall"), 26);
        this.addMenuItem(this.editMenu, Messages.getMessage("PdfViewerEditMenuDeselectall.text"), Messages.getMessage("PdfViewerEditMenuTooltip.Deselectall"), 27);
        addSeparator = this.properties.getValue("Preferences");
        if (!addSeparator.isEmpty() && addSeparator.equalsIgnoreCase("true")) {
            this.editMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        this.addMenuItem(this.editMenu, Messages.getMessage("PdfViewerEditMenuPreferences.text"), Messages.getMessage("PdfViewerEditMenuTooltip.Preferences"), 24);
        this.viewMenu = new Menu(Messages.getMessage("PdfViewerViewMenu.text"));
        this.addToMainMenu(this.viewMenu);
        this.goToMenu = new Menu(Messages.getMessage("GoToViewMenuGoto.text"));
        this.viewMenu.getItems().add((Object)this.goToMenu);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.FirstPage"), "", 50);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.BackPage"), "", 52);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.ForwardPage"), "", 53);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.LastPage"), "", 55);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.GoTo"), "", 56);
        addSeparator = this.properties.getValue("Previousdocument") + this.properties.getValue("Nextdocument");
        if (!addSeparator.isEmpty() && addSeparator.equalsIgnoreCase("true")) {
            this.goToMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.PreviousDoucment"), "", 16);
        this.addMenuItem(this.goToMenu, Messages.getMessage("GoToViewMenuGoto.NextDoucment"), "", 17);
        if (isSingle) {
            this.pageLayoutMenu = new Menu(Messages.getMessage("PageLayoutViewMenu.PageLayout"));
            this.viewMenu.getItems().add((Object)this.pageLayoutMenu);
        }
        String[] descriptions = new String[]{Messages.getMessage("PageLayoutViewMenu.SinglePage"), Messages.getMessage("PageLayoutViewMenu.Continuous"), Messages.getMessage("PageLayoutViewMenu.ContinousFacing"), Messages.getMessage("PageLayoutViewMenu.Facing"), Messages.getMessage("PageLayoutViewMenu.PageFlow")};
        int[] value = new int[]{1, 2, 3, 4, 5};
        if (isSingle) {
            this.initLayoutMenus(this.pageLayoutMenu, descriptions, value, buttons, currentCommands, isSingle);
        }
        if (this.properties.getValue("separateCover").equals("true")) {
            this.addMenuItem(this.viewMenu, Messages.getMessage("PdfViewerViewMenuSeparateCover.text"), Messages.getMessage("PdfViewerViewMenuTooltip.separateCover"), 32);
        }
        if (this.properties.getValue("panMode").equals("true") || this.properties.getValue("textSelect").equals("true")) {
            this.viewMenu.getItems().add((Object)new SeparatorMenuItem());
            if (this.properties.getValue("panMode").equals("true")) {
                this.addMenuItem(this.viewMenu, Messages.getMessage("PdfViewerViewMenuPanMode.text"), Messages.getMessage("PdfViewerViewMenuTooltip.panMode"), 30);
            }
            if (this.properties.getValue("textSelect").equals("true")) {
                this.addMenuItem(this.viewMenu, Messages.getMessage("PdfViewerViewMenuTextSelectMode.text"), Messages.getMessage("PdfViewerViewMenuTooltip.textSelect"), 31);
            }
            this.viewMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        if (!(addSeparator = this.properties.getValue("Fullscreen")).isEmpty() && addSeparator.equalsIgnoreCase("true")) {
            this.goToMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        this.addMenuItem(this.viewMenu, Messages.getMessage("PdfViewerViewMenuFullScreenMode.text"), Messages.getMessage("PdfViewerViewMenuTooltip.fullScreenMode"), 62);
        if (!isSingle) {
            this.windowMenu = new Menu(Messages.getMessage("PdfViewerWindowMenu.text"));
            this.addToMainMenu(this.windowMenu);
            this.addMenuItem(this.windowMenu, Messages.getMessage("PdfViewerWindowMenuCascade.text"), "", 21);
            this.addMenuItem(this.windowMenu, Messages.getMessage("PdfViewerWindowMenuTile.text"), "", 22);
        }
        this.exportMenu = new Menu(Messages.getMessage("PdfViewerExportMenu.text"));
        this.addToMainMenu(this.exportMenu);
        this.pdfMenu = new Menu(Messages.getMessage("PdfViewerExportMenuPDF.text"));
        this.exportMenu.getItems().add((Object)this.pdfMenu);
        this.addMenuItem(this.pdfMenu, Messages.getMessage("PdfViewerExportMenuOnePerPage.text"), "", 501);
        this.addMenuItem(this.pdfMenu, Messages.getMessage("PdfViewerExportMenuNUp.text"), "", 510);
        this.addMenuItem(this.pdfMenu, Messages.getMessage("PdfViewerExportMenuHandouts.text"), "", 511);
        this.contentMenu = new Menu(Messages.getMessage("PdfViewerExportMenuContent.text"));
        this.exportMenu.getItems().add((Object)this.contentMenu);
        this.addMenuItem(this.contentMenu, Messages.getMessage("PdfViewerExportMenuImages.text"), "", 3);
        this.addMenuItem(this.contentMenu, Messages.getMessage("PdfViewerExportMenuText.text"), "", 4);
        this.addMenuItem(this.exportMenu, Messages.getMessage("PdfViewerExportMenuBitmap.text"), "", 2);
        this.pageToolsMenu = new Menu(Messages.getMessage("PdfViewerPageToolsMenu.text"));
        this.addToMainMenu(this.pageToolsMenu);
        this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuRotate.text"), "", 502);
        this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuDelete.text"), "", 503);
        this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuAddPage.text"), "", 504);
        this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuAddHeaderFooter.text"), "", 506);
        this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuStampText.text"), "", 507);
        this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuStampImage.text"), "", 508);
        this.addMenuItem(this.pageToolsMenu, Messages.getMessage("PdfViewerPageToolsMenuSetCrop.text"), "", 509);
        this.helpMenu = new Menu(Messages.getMessage("PdfViewerHelpMenu.text"));
        this.addToMainMenu(this.helpMenu);
        this.addMenuItem(this.helpMenu, Messages.getMessage("PdfViewerHelpMenu.VisitWebsite"), "", 15);
        this.addMenuItem(this.helpMenu, Messages.getMessage("PdfViewerHelpMenuTip.text"), "", 20);
        this.addMenuItem(this.helpMenu, Messages.getMessage("PdfViewerHelpMenuabout.text"), Messages.getMessage("PdfViewerHelpMenuTooltip.about"), 1);
    }

    static void setKeyAccelerators(int ID2, MenuItem menuItem) {
        switch (ID2) {
            case 12: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+F"));
                break;
            }
            case 5: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+S"));
                break;
            }
            case 6: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+P"));
                break;
            }
            case 7: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+Q"));
                break;
            }
            case 9: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+D"));
                break;
            }
            case 10: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+O"));
                break;
            }
            case 14: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+U"));
                break;
            }
            case 16: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+LEFT+SHIFT"));
                break;
            }
            case 17: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+RIGHT+SHIFT"));
                break;
            }
            case 50: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+HOME"));
                break;
            }
            case 52: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+UP"));
                break;
            }
            case 53: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+DOWN"));
                break;
            }
            case 55: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+END"));
                break;
            }
            case 56: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+N+SHIFT"));
                break;
            }
            case 2: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+B"));
                break;
            }
            case 25: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+C"));
                break;
            }
            case 26: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+A"));
                break;
            }
            case 27: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+A+SHIFT"));
                break;
            }
            case 24: {
                menuItem.setAccelerator(KeyCombination.keyCombination((String)"Shortcut+K"));
            }
        }
    }

    @Override
    public void ensureNoSeperators() {
        this.ensureNoSeperators(317);
        this.ensureNoSeperators(310);
        this.ensureNoSeperators(312);
        this.ensureNoSeperators(311);
    }

    @Override
    public void ensureNoSeperators(int type) {
        for (int k = 0; k != ((Menu)this.getMenuItem(type)).getItems().size(); ++k) {
            if (!((MenuItem)((Menu)this.getMenuItem(type)).getItems().get(k)).isVisible()) continue;
            if (!(((Menu)this.getMenuItem(type)).getItems().get(k) instanceof SeparatorMenuItem)) break;
            ((Menu)this.getMenuItem(type)).getItems().remove(k);
            break;
        }
    }

    @Override
    public boolean isMenuItemExist(int ID2) {
        return this.getMenuItem(ID2) != null;
    }

    @Override
    public void setMenuItem(int ID2, boolean enabled, boolean visible) {
        if (ID2 == 300 && this.currentMenu != null) {
            this.currentMenu.setDisable(!enabled);
            this.currentMenu.setVisible(visible);
        } else if (this.getMenuItem(ID2) != null) {
            this.getMenuItem(ID2).setDisable(!enabled);
            this.getMenuItem(ID2).setVisible(visible);
        }
        if (ID2 == 62 && DecoderOptions.isRunningOnMac) {
            this.fullscreen.setDisable(true);
        }
    }

    @Override
    public void addToMenu(Object menuItem, int parentMenuID) {
        this.getMenu(parentMenuID).getItems().add((Object)((MenuItem)menuItem));
    }

    public void disableUnimplementedItems(int ID2, boolean disableViewModes) {
        boolean debug = true;
        int ALL = -10;
        if (ID2 != -10) {
            if (!disableViewModes) {
                switch (ID2) {
                    case 32: {
                        this.separateCover.setDisable(true);
                        break;
                    }
                    case 12: {
                        this.find.setDisable(true);
                        break;
                    }
                    case 500: {
                        this.reSaveAsForms.setDisable(true);
                        break;
                    }
                    case 512: {
                        this.signPDF.setDisable(true);
                        break;
                    }
                    case 6: {
                        this.print.setDisable(true);
                    }
                }
            }
        } else {
            this.separateCover.setDisable(true);
            this.reSaveAsForms.setDisable(true);
            this.signPDF.setDisable(true);
            this.print.setDisable(true);
        }
    }
}

