/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.io.File;
import java.util.Date;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.effect.Light;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.jpedal.PdfDecoderFX;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.commands.generic.GUICopy;
import org.jpedal.examples.viewer.gui.GUI;
import org.jpedal.examples.viewer.gui.JavaFxGUI;
import org.jpedal.examples.viewer.gui.MouseSelector;
import org.jpedal.examples.viewer.gui.javafx.JavaFXMouseFunctionality;
import org.jpedal.exception.PdfException;
import org.jpedal.gui.GUIFactory;
import org.jpedal.io.Speech;
import org.jpedal.objects.PdfPageData;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.text.TextLines;
import org.jpedal.utils.Messages;

public class JavaFXMouseSelector
extends MouseSelector
implements JavaFXMouseFunctionality {
    private final PdfDecoderFX decode_pdf;
    private final GUIFactory currentGUI;
    private final Values commonValues;
    private final Commands currentCommands;
    private PdfPageData page_data;
    public static final boolean activateMultipageHighlight = true;
    private int clickCount;
    private long lastTime = -1L;
    private boolean startHighlighting;
    public int id = -1;
    public int lastId = -1;
    private int old_m_x2 = -1;
    private int old_m_y2 = -1;
    MenuItem copy;
    MenuItem selectAll;
    MenuItem deselectall;
    Menu extract;
    MenuItem extractText;
    MenuItem extractImage;
    Image snapshotIcon;
    MenuItem snapShot;
    MenuItem find;
    MenuItem speakHighlighted;
    ContextMenu cm;

    public JavaFXMouseSelector(PdfDecoderFX decode_pdf, GUIFactory currentGUI, Values commonValues, Commands currentCommands) {
        this.decode_pdf = decode_pdf;
        this.currentGUI = currentGUI;
        this.commonValues = commonValues;
        this.currentCommands = currentCommands;
        this.page_data = decode_pdf.getPdfPageData();
    }

    private void createRightClickMenu() {
        boolean useSpeech;
        this.cm = new ContextMenu();
        this.copy = new MenuItem(Messages.getMessage("PdfRightClick.copy"));
        this.selectAll = new MenuItem(Messages.getMessage("PdfRightClick.selectAll"));
        this.deselectall = new MenuItem(Messages.getMessage("PdfRightClick.deselectAll"));
        this.extract = new Menu(Messages.getMessage("PdfRightClick.extract"));
        this.extractText = new MenuItem(Messages.getMessage("PdfRightClick.extractText"));
        this.extractImage = new MenuItem(Messages.getMessage("PdfRightClick.extractImage"));
        this.snapshotIcon = new Image("/org/jpedal/examples/viewer/res/snapshot_menu.gif");
        this.snapShot = new MenuItem(Messages.getMessage("PdfRightClick.snapshot"), (Node)new ImageView(this.snapshotIcon));
        this.extract.getItems().addAll((Object[])new MenuItem[]{this.extractText, this.extractImage});
        this.find = new MenuItem(Messages.getMessage("PdfRightClick.find"));
        this.speakHighlighted = new MenuItem("Speak Highlighted text");
        this.copy.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                if (JavaFXMouseSelector.this.decode_pdf.getDisplayView() == 1) {
                    JavaFXMouseSelector.this.currentCommands.executeCommand(25, null);
                } else if (GUI.showMessages) {
                    JavaFXMouseSelector.this.currentGUI.showMessageDialog("Copy is only avalible in single page display mode");
                }
            }
        });
        this.selectAll.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                JavaFXMouseSelector.this.currentCommands.executeCommand(26, null);
            }
        });
        this.deselectall.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                JavaFXMouseSelector.this.currentCommands.executeCommand(27, null);
            }
        });
        this.extractText.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                if (JavaFXMouseSelector.this.decode_pdf.getDisplayView() == 1) {
                    JavaFXMouseSelector.this.currentCommands.executeCommand(33, null);
                } else if (GUI.showMessages) {
                    JavaFXMouseSelector.this.currentGUI.showMessageDialog("Text Extraction is only avalible in single page display mode");
                }
            }
        });
        this.extractImage.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                if (JavaFXMouseSelector.this.decode_pdf.getPages().getHighlightedImage() != null && JavaFXMouseSelector.this.decode_pdf.getDisplayView() == 1) {
                    FileChooser jf = new FileChooser();
                    FileChooser.ExtensionFilter extFilterJPG = new FileChooser.ExtensionFilter("JPG (*jpg)", new String[]{"*.jpg"});
                    FileChooser.ExtensionFilter extFilterPNG = new FileChooser.ExtensionFilter("PNG (*PNG)", new String[]{"*.png"});
                    FileChooser.ExtensionFilter extFilterTIFF = new FileChooser.ExtensionFilter("Tiff (*TIFF)", new String[]{"*.tiff"});
                    jf.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{extFilterJPG, extFilterPNG, extFilterTIFF});
                    File file = jf.showSaveDialog((Window)((Stage)JavaFXMouseSelector.this.currentGUI.getFrame()));
                    String fileExt = file.getName();
                    fileExt = fileExt.substring(fileExt.indexOf(46) + 1, fileExt.length());
                    JavaFXMouseSelector.this.decode_pdf.getDynamicRenderer().saveImage(JavaFXMouseSelector.this.id, file.getAbsolutePath(), fileExt);
                }
            }
        });
        this.snapShot.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                JavaFXMouseSelector.this.currentCommands.executeCommand(13, null);
            }
        });
        this.find.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                int hyphenOption;
                int findAllOption;
                int temp;
                int[] coords = JavaFXMouseSelector.this.decode_pdf.getPages().getCursorBoxOnScreenAsArray();
                if (coords == null) {
                    if (GUI.showMessages) {
                        JavaFXMouseSelector.this.currentGUI.showMessageDialog((Object)"There is no text selected.\nPlease highlight the text you wish to search.", "No Text selected", 0);
                    }
                    return;
                }
                String textToFind = JavaFXMouseSelector.this.currentGUI.showInputDialog(Messages.getMessage("PdfViewerMessage.GetUserInput"));
                if (textToFind == null || textToFind.length() < 1) {
                    return;
                }
                int yMod = 2;
                int t_x1 = coords[0];
                int t_x2 = coords[0] + coords[2];
                int t_y1 = coords[1] - 2;
                int t_y2 = coords[1] + coords[3] + 2;
                if (t_y1 < t_y2) {
                    temp = t_y2;
                    t_y2 = t_y1;
                    t_y1 = temp;
                }
                if (t_x1 > t_x2) {
                    temp = t_x2;
                    t_x2 = t_x1;
                    t_x1 = temp;
                }
                JavaFXMouseSelector.this.page_data = JavaFXMouseSelector.this.decode_pdf.getPdfPageData();
                int cropX = JavaFXMouseSelector.this.page_data.getCropBoxX(JavaFXMouseSelector.this.commonValues.getCurrentPage());
                int cropY = JavaFXMouseSelector.this.page_data.getCropBoxY(JavaFXMouseSelector.this.commonValues.getCurrentPage());
                int mediaW = JavaFXMouseSelector.this.page_data.getMediaBoxWidth(JavaFXMouseSelector.this.commonValues.getCurrentPage());
                int mediaH = JavaFXMouseSelector.this.page_data.getMediaBoxHeight(JavaFXMouseSelector.this.commonValues.getCurrentPage());
                if (t_x1 < cropX) {
                    t_x1 = cropX;
                }
                if (t_x1 > mediaW - cropX) {
                    t_x1 = mediaW - cropX;
                }
                if (t_x2 < cropX) {
                    t_x2 = cropX;
                }
                if (t_x2 > mediaW - cropX) {
                    t_x2 = mediaW - cropX;
                }
                if (t_y1 < cropY) {
                    t_y1 = cropY;
                }
                if (t_y1 > mediaH - cropY) {
                    t_y1 = mediaH - cropY;
                }
                if (t_y2 < cropY) {
                    t_y2 = cropY;
                }
                if (t_y2 > mediaH - cropY) {
                    t_y2 = mediaH - cropY;
                }
                int searchType = 0;
                int caseSensitiveOption = JavaFXMouseSelector.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewercase.message"), null, 0);
                if (caseSensitiveOption == 0) {
                    searchType |= 2;
                }
                if ((findAllOption = JavaFXMouseSelector.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerfindAll.message"), null, 0)) == 1) {
                    searchType |= 4;
                }
                if ((hyphenOption = JavaFXMouseSelector.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerfindHyphen.message"), null, 0)) == 0) {
                    searchType |= 8;
                }
                if (textToFind != null) {
                    try {
                        float[] co_ords = JavaFXMouseSelector.this.decode_pdf.getGroupingObject().findText(t_x1, t_y1, t_x2, t_y2, new String[]{textToFind}, searchType);
                        if (co_ords.length >= 2) {
                            if (co_ords.length < 3) {
                                JavaFXMouseSelector.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.Found") + ' ' + co_ords[0] + ',' + co_ords[1]);
                            } else {
                                StringBuilder displayCoords = new StringBuilder();
                                String coordsMessage = Messages.getMessage("PdfViewerMessage.FoundAt");
                                for (int i = 0; i < co_ords.length; i += 5) {
                                    displayCoords.append(coordsMessage).append(' ');
                                    displayCoords.append(co_ords[i]);
                                    displayCoords.append(',');
                                    displayCoords.append(co_ords[i + 1]);
                                    displayCoords.append('\n');
                                    coordsMessage = co_ords[i + 4] == -101.0f ? Messages.getMessage("PdfViewerMessage.FoundAtHyphen") : Messages.getMessage("PdfViewerMessage.FoundAt");
                                }
                                JavaFXMouseSelector.this.currentGUI.showMessageDialog(displayCoords.toString());
                            }
                        } else {
                            JavaFXMouseSelector.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NotFound"));
                        }
                    }
                    catch (PdfException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        final Speech speech = (Speech)this.decode_pdf.getExternalHandler(32);
        boolean bl = useSpeech = speech != null;
        if (useSpeech) {
            speech.setVoice(this.currentGUI.getProperties().getValue("voice"));
        }
        this.speakHighlighted.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                if (useSpeech) {
                    if (JavaFXMouseSelector.this.decode_pdf.getDisplayView() == 1) {
                        Thread speak = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                String text = GUICopy.copySelectedText(JavaFXMouseSelector.this.decode_pdf, JavaFXMouseSelector.this.currentGUI, JavaFXMouseSelector.this.commonValues);
                                speech.speakText(text);
                            }
                        });
                        speak.setDaemon(true);
                        speak.start();
                    } else if (GUI.showMessages) {
                        JavaFXMouseSelector.this.currentGUI.showMessageDialog("Speak text is only avalible in single page display mode");
                    }
                }
            }
        });
        if (this.decode_pdf != null && this.decode_pdf.isOpen()) {
            this.cm.getItems().add((Object)this.copy);
            this.cm.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), this.selectAll, this.deselectall});
            this.cm.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), this.extract});
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.decode_pdf.getDisplayView() == 1 || this.decode_pdf.getDisplayView() == 2 && this.decode_pdf.getDisplayView() == 3) {
            long currentTime = new Date().getTime();
            if (this.lastTime + 500L < currentTime) {
                this.clickCount = 0;
            }
            this.lastTime = currentTime;
            if (JavaFXMouseSelector.isOtherKey(e)) {
                if (this.clickCount != 4) {
                    ++this.clickCount;
                }
                int pagenumber = this.decode_pdf.getPageNumber();
                int crx = this.page_data.getCropBoxX(pagenumber);
                int cry = this.page_data.getCropBoxY(pagenumber);
                this.commonValues.m_x1 = (int)e.getX() + crx;
                this.commonValues.m_y1 = (int)e.getY() + cry;
                this.id = this.decode_pdf.getDisplayView() == 1 ? this.decode_pdf.getDynamicRenderer().isInsideImage(this.commonValues.m_x1, this.commonValues.m_y1) : -1;
                if (this.lastId != this.id && this.id != -1) {
                    int[] imageArea = this.decode_pdf.getDynamicRenderer().getAreaAsArray(this.id);
                    if (imageArea != null) {
                        int h = imageArea[3];
                        int w = imageArea[2];
                        int x = imageArea[0];
                        int y = imageArea[1];
                        this.decode_pdf.getDynamicRenderer().setneedsHorizontalInvert(false);
                        this.decode_pdf.getDynamicRenderer().setneedsVerticalInvert(false);
                        if (w < 0) {
                            this.decode_pdf.getDynamicRenderer().setneedsHorizontalInvert(true);
                            w = -w;
                            x -= w;
                        }
                        if (h < 0) {
                            this.decode_pdf.getDynamicRenderer().setneedsVerticalInvert(true);
                            h = -h;
                            y -= h;
                        }
                        this.decode_pdf.getPages().setHighlightedImage(new int[]{x, y, w, h});
                    }
                    this.lastId = this.id;
                } else {
                    this.decode_pdf.getPages().setHighlightedImage(null);
                    this.lastId = -1;
                }
                if (this.id == -1 && this.clickCount > 1) {
                    switch (this.clickCount) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            int[][] lineAreas = this.decode_pdf.getTextLines().getLineAreasAs2DArray(this.commonValues.getCurrentPage());
                            if (lineAreas == null) break;
                            int[] point = new int[]{this.commonValues.m_x1, this.commonValues.m_y1, 1, 1};
                            for (int i = 0; i != lineAreas.length; ++i) {
                                if (!TextLines.intersects(point, lineAreas[i])) continue;
                                this.decode_pdf.updateCursorBoxOnScreen(lineAreas[i], DecoderOptions.highlightColor.getRGB());
                                this.decode_pdf.getTextLines().addHighlights(new int[][]{lineAreas[i]}, false, this.commonValues.getCurrentPage());
                            }
                            break;
                        }
                        case 3: {
                            int[] para = this.decode_pdf.getTextLines().setFoundParagraphAsArray(this.commonValues.m_x1, this.commonValues.m_y1, this.commonValues.getCurrentPage());
                            if (para == null) break;
                            this.decode_pdf.updateCursorBoxOnScreen(para, DecoderOptions.highlightColor.getRGB());
                            break;
                        }
                        case 4: {
                            this.currentCommands.executeCommand(26, null);
                        }
                    }
                }
                this.decode_pdf.repaintPane(this.commonValues.getCurrentPage());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if ((this.decode_pdf.getDisplayView() == 1 || this.decode_pdf.getDisplayView() == 2 && this.decode_pdf.getDisplayView() == 3) && JavaFXMouseSelector.isOtherKey(e)) {
            this.decode_pdf.updateCursorBoxOnScreen(null, 0);
            this.decode_pdf.getPages().setHighlightedImage(null);
            this.decode_pdf.getTextLines().clearHighlights();
            this.decode_pdf.requestFocus();
            int pagenumber = this.decode_pdf.getPageNumber();
            int crx = this.page_data.getCropBoxX(pagenumber);
            int cry = this.page_data.getCropBoxY(pagenumber);
            this.commonValues.m_x1 = (int)e.getX() + crx;
            this.commonValues.m_y1 = (int)e.getY() + cry;
            int[][] rectParams = this.decode_pdf.getTextLines().getHighlightedAreasAs2DArray(this.commonValues.getCurrentPage());
            if (rectParams != null && rectParams.length > 0) {
                this.decode_pdf.getPages().refreshDisplay();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.decode_pdf.getDisplayView() == 1 || this.decode_pdf.getDisplayView() == 2 && this.decode_pdf.getDisplayView() == 3) {
            if (this.cm != null && this.cm.isShowing()) {
                this.cm.hide();
            }
            if (JavaFXMouseSelector.isOtherKey(e)) {
                if (this.startHighlighting) {
                    this.decode_pdf.setCursor(Cursor.DEFAULT);
                    this.startHighlighting = false;
                }
                this.page_data = this.decode_pdf.getPdfPageData();
                if (this.currentCommands.extractingAsImage) {
                    this.decode_pdf.updateCursorBoxOnScreen(null, 0);
                    this.decode_pdf.getTextLines().clearHighlights();
                    this.decode_pdf.getPages().setHighlightedImage(null);
                    this.decode_pdf.setCursor(Cursor.DEFAULT);
                    this.currentCommands.executeCommand(34, null);
                    this.currentCommands.extractingAsImage = false;
                    DecoderOptions.showMouseBox = false;
                }
            } else if (e.getButton().equals((Object)MouseButton.SECONDARY) && this.currentGUI.getProperties().getValue("allowRightClick").toLowerCase().equals("true")) {
                if (this.cm == null) {
                    this.createRightClickMenu();
                }
                this.cm.show((Node)((JavaFxGUI)this.currentGUI).getRoot(), e.getScreenX(), e.getScreenY());
                if (this.decode_pdf.getPages().getHighlightedImage() == null) {
                    this.extractImage.setDisable(true);
                } else {
                    this.extractImage.setDisable(false);
                }
                if (this.decode_pdf.getTextLines().getHighlightedAreasAs2DArray(this.commonValues.getCurrentPage()) == null) {
                    this.extractText.setDisable(true);
                    this.find.setDisable(true);
                    this.speakHighlighted.setDisable(true);
                    this.copy.setDisable(true);
                } else {
                    this.extractText.setDisable(false);
                    this.find.setDisable(false);
                    this.speakHighlighted.setDisable(false);
                    this.copy.setDisable(false);
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (JavaFXMouseSelector.isOtherKey(e)) {
            if (!this.startHighlighting) {
                this.startHighlighting = true;
            }
            int pagenumber = this.decode_pdf.getPageNumber();
            int crx = this.decode_pdf.getPdfPageData().getCropBoxX(pagenumber);
            int cry = this.decode_pdf.getPdfPageData().getCropBoxY(pagenumber);
            this.commonValues.m_x2 = (int)e.getX() + crx;
            this.commonValues.m_y2 = (int)e.getY() + cry;
            if (this.commonValues.isPDF()) {
                this.decode_pdf.setCursor(Cursor.TEXT);
                this.generateNewCursorBox();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public Light.Point getCoordsOnPage(double x, double y, int page) {
        throw new UnsupportedOperationException("We do not currently use this method for JavaFX as it appears the X and Y coords\n can be retrieved from the bottom left in JavaFX compared to the top left in Swing");
    }

    private static boolean isOtherKey(MouseEvent e) {
        return e.getButton().equals((Object)MouseButton.PRIMARY) || e.getButton().equals((Object)MouseButton.NONE);
    }

    protected void generateNewCursorBox() {
        if (this.old_m_x2 != -1 || this.old_m_y2 != -1 || Math.abs(this.commonValues.m_x2 - this.old_m_x2) > 5 || Math.abs(this.commonValues.m_y2 - this.old_m_y2) > 5) {
            int top_x = this.commonValues.m_x1;
            if (this.commonValues.m_x1 > this.commonValues.m_x2) {
                top_x = this.commonValues.m_x2;
            }
            int top_y = this.commonValues.m_y1;
            if (this.commonValues.m_y1 > this.commonValues.m_y2) {
                top_y = this.commonValues.m_y2;
            }
            int w = Math.abs(this.commonValues.m_x2 - this.commonValues.m_x1);
            int h = Math.abs(this.commonValues.m_y2 - this.commonValues.m_y1);
            int[] currentRectangle = new int[]{top_x, top_y, w, h};
            this.decode_pdf.updateCursorBoxOnScreen(currentRectangle, DecoderOptions.highlightColor.getRGB());
            if (!this.currentCommands.extractingAsImage) {
                int[] r = new int[]{this.commonValues.m_x1, this.commonValues.m_y1, this.commonValues.m_x2 - this.commonValues.m_x1, this.commonValues.m_y2 - this.commonValues.m_y1};
                this.decode_pdf.getTextLines().addHighlights(new int[][]{r}, false, this.commonValues.getCurrentPage());
            }
            this.old_m_x2 = this.commonValues.m_x2;
            this.old_m_y2 = this.commonValues.m_y2;
        }
        this.decode_pdf.repaintPane(this.commonValues.getCurrentPage());
    }
}

