/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx;

import java.util.Iterator;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.jpedal.PdfDecoderInt;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;

public class JavaFXSignaturesPanel
extends Tab {
    final TreeView<String> signatureTree;
    final Image unlock;
    final Image lock;
    static final String signedText = "The following have digitally counter-signed this document";
    static final String blankText = "The following signature fields are not signed";

    public JavaFXSignaturesPanel() {
        VBox content = new VBox();
        this.signatureTree = new TreeView();
        this.unlock = new Image(((Object)((Object)this)).getClass().getResource("/org/jpedal/examples/viewer/res/unlock.png").toExternalForm());
        this.lock = new Image(((Object)((Object)this)).getClass().getResource("/org/jpedal/examples/viewer/res/lock.gif").toExternalForm());
        this.signatureTree.setCellFactory((Callback)new Callback<TreeView<String>, TreeCell<String>>(){

            public TreeCell<String> call(TreeView<String> p) {
                return new SignaturesCell();
            }
        });
        content.getChildren().add(this.signatureTree);
        this.setContent((Node)content);
    }

    public void reinitialise(PdfDecoderInt decode_pdf, Iterator<FormObject> signatureObjects) {
        this.signatureTree.setRoot(null);
        TreeItem root = new TreeItem((Object)"Signatures");
        TreeItem signed = new TreeItem((Object)signedText);
        TreeItem blank = new TreeItem((Object)blankText);
        boolean addedSigned = false;
        boolean addedBlank = false;
        while (signatureObjects.hasNext()) {
            FormObject formObj = signatureObjects.next();
            PdfObject sigObject = formObj.getDictionary(38);
            decode_pdf.getIO().checkResolved(sigObject);
            if (sigObject == null) {
                if (!addedBlank) {
                    addedBlank = true;
                    root.getChildren().add((Object)blank);
                }
                TreeItem blankNode = new TreeItem((Object)(formObj.getTextStreamValue(36) + " on page " + formObj.getPageNumber()));
                blank.getChildren().add((Object)blankNode);
                continue;
            }
            if (!addedSigned) {
                addedSigned = true;
                root.getChildren().add((Object)signed);
            }
            String name = sigObject.getTextStreamValue(506543413);
            TreeItem owner = new TreeItem((Object)("Signed by " + name));
            signed.getChildren().add((Object)owner);
            TreeItem type = new TreeItem((Object)"Type");
            owner.getChildren().add((Object)type);
            String filter = null;
            PdfArrayIterator filters = sigObject.getMixedArray(1011108731);
            if (filters != null && filters.hasMoreTokens()) {
                filter = filters.getNextValueAsString(true);
            }
            TreeItem filterNode = new TreeItem((Object)("Filter " + filter));
            type.getChildren().add((Object)filterNode);
            String subFilter = sigObject.getName(-2122953826);
            TreeItem subFilterNode = new TreeItem((Object)("Sub Filter: " + subFilter));
            type.getChildren().add((Object)subFilterNode);
            TreeItem details = new TreeItem((Object)"Details");
            owner.getChildren().add((Object)details);
            String rawDate = sigObject.getTextStreamValue(29);
            if (rawDate != null) {
                StringBuilder date = new StringBuilder(rawDate);
                date.delete(0, 2);
                date.insert(4, '/');
                date.insert(7, '/');
                date.insert(10, ' ');
                date.insert(13, ':');
                date.insert(16, ':');
                date.insert(19, ' ');
                TreeItem time = new TreeItem((Object)("Time: " + date));
                details.getChildren().add((Object)time);
            } else {
                TreeItem time = new TreeItem((Object)"Time: unset");
                details.getChildren().add((Object)time);
            }
            String reason = sigObject.getTextStreamValue(826499443);
            TreeItem reasonNode = new TreeItem((Object)("Reason: " + reason));
            details.getChildren().add((Object)reasonNode);
            String location = sigObject.getTextStreamValue(1618506351);
            TreeItem locationNode = new TreeItem((Object)("Location: " + location));
            details.getChildren().add((Object)locationNode);
            TreeItem field = new TreeItem((Object)("Field: " + formObj.getTextStreamValue(36) + " on page " + formObj.getPageNumber()));
            details.getChildren().add((Object)field);
        }
        this.signatureTree.setRoot(root);
    }

    private class SignaturesCell
    extends TreeCell<String> {
        private SignaturesCell() {
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                String parentText;
                TreeItem parent = this.getTreeItem().getParent();
                String string = parentText = parent != null ? (String)parent.getValue() : "";
                if (parentText.equals(JavaFXSignaturesPanel.signedText)) {
                    this.setGraphic((Node)new ImageView(JavaFXSignaturesPanel.this.lock));
                } else if (parentText.equals(JavaFXSignaturesPanel.blankText)) {
                    this.setGraphic((Node)new ImageView(JavaFXSignaturesPanel.this.unlock));
                }
                this.setText(item);
            }
        }
    }
}

