/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.javafx.dialog;

import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class FXDialog {
    protected Stage parent;
    protected Stage dialog;
    private Parent content;
    private final Group dummyPane = new Group();
    protected boolean isCancelled;
    private boolean disposeOnExit = true;

    protected FXDialog() {
    }

    public FXDialog(Stage parent, Modality modality, Pane content) {
        this.init(parent, modality, (Parent)content);
        Scene scene = new Scene((Parent)content);
        this.setScene(scene);
    }

    public FXDialog(Stage parent, Modality modality, Parent content, double width, double height) {
        this.init(parent, modality, content);
        this.dialog.setWidth(width);
        this.dialog.setHeight(height);
        Scene scene = new Scene(content, width, height);
        this.setScene(scene);
    }

    protected final void init(Stage parent, Modality modality, Parent content) {
        this.dialog = new Stage(StageStyle.UTILITY);
        this.parent = parent;
        this.content = content;
        this.dialog.initOwner((Window)parent);
        this.dialog.initModality(modality);
        this.dialog.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent t) {
                FXDialog.this.freeContent();
                FXDialog.this.isCancelled = true;
            }
        });
        this.dialog.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent t) {
                FXDialog.this.centerOnParent();
            }
        });
    }

    protected final void setScene(Scene scene) {
        this.dialog.setScene(scene);
        this.dialog.getScene().setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                KeyCode key = t.getCode();
                if (key == KeyCode.F4 && t.isAltDown() || key == KeyCode.ESCAPE) {
                    FXDialog.this.cancel();
                } else if (key == KeyCode.ENTER) {
                    FXDialog.this.positiveClose();
                    FXDialog.this.close();
                }
            }
        });
    }

    public void show() {
        this.dialog.show();
    }

    public void close() {
        this.freeContent();
        this.dialog.close();
    }

    public void showAndWait() {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FXDialog.this.dialog.showAndWait();
                }
            });
        } else {
            this.dialog.showAndWait();
        }
    }

    private void centerOnParent() {
        if (this.parent == null) {
            this.dialog.centerOnScreen();
            return;
        }
        double x = this.parent.getX();
        double y = this.parent.getY();
        double width = this.dialog.getWidth();
        double height = this.dialog.getHeight();
        double xPos = x + this.parent.getWidth() / 2.0 - width / 2.0;
        double yPos = y + this.parent.getHeight() / 2.0 - height / 2.0;
        this.dialog.setX(xPos);
        this.dialog.setY(yPos);
    }

    protected void cancel() {
        this.freeContent();
        this.isCancelled = true;
        this.dialog.close();
    }

    protected final void freeContent() {
        if (this.disposeOnExit) {
            this.dialog.getScene().setRoot((Parent)this.dummyPane);
        }
    }

    protected void positiveClose() {
        this.freeContent();
    }

    public Stage getDialog() {
        return this.dialog;
    }

    public void setWidth(double width) {
        this.dialog.setWidth(width);
    }

    public void setHeight(double height) {
        this.dialog.setHeight(height);
    }

    public double getWidth() {
        return this.dialog.getWidth();
    }

    public double getHeight() {
        return this.dialog.getHeight();
    }

    public void setResizeable(boolean isResizeable) {
        this.dialog.setResizable(isResizeable);
    }

    public boolean isResizeable() {
        return this.dialog.isResizable();
    }

    public Parent getContent() {
        return this.content;
    }

    public void setContent(Pane content) {
        this.content = content;
    }

    public void setTitle(String title) {
        this.dialog.setTitle(title);
    }

    public void setDisposeOnExit(boolean dispose) {
        this.disposeOnExit = dispose;
    }

    public boolean getDisposeOnExit() {
        return this.disposeOnExit;
    }
}

